/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package diagram.editparts;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import impl.diagram.editparts.LinkLabelEditPart;
import impl.diagram.editparts.NodeLabelEditPart;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExternalNodeLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.Common;
import xpt.Common_qvto;

@Singleton
@SuppressWarnings("all")
public class DiagramEditPart {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  @Inject
  private impl.diagram.editparts.DiagramEditPart xptDiagramEditPart;
  
  @Inject
  private NodeLabelEditPart xptNodeLabelEditPart;
  
  @Inject
  private LinkLabelEditPart xptLinkLabelEditPart;
  
  @Inject
  private xpt.diagram.editparts.Common xptEditpartsCommon;
  
  public CharSequence qualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.xptDiagramEditPart.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.xptDiagramEditPart.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence Main(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.xptDiagramEditPart.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.xptDiagramEditPart.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    _builder.append(" ");
    CharSequence _implementsList = this.implementsList(it);
    _builder.append(_implementsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _attributes = this.attributes(it);
    _builder.append(_attributes, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _constructor = this.xptDiagramEditPart.constructor(it);
    _builder.append(_constructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _createDefaultEditPolicies = this.createDefaultEditPolicies(it);
    _builder.append(_createDefaultEditPolicies, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _createFigure = this.xptDiagramEditPart.createFigure(it);
    _builder.append(_createFigure, "\t");
    _builder.newLineIfNotEmpty();
    {
      final Function1<GenNode, Boolean> _function = new Function1<GenNode, Boolean>() {
        @Override
        public Boolean apply(final GenNode n) {
          final Function1<GenNodeLabel, Boolean> _function = new Function1<GenNodeLabel, Boolean>() {
            @Override
            public Boolean apply(final GenNodeLabel l) {
              boolean _oclIsKindOf = DiagramEditPart.this._common_qvto.oclIsKindOf(l, GenExternalNodeLabel.class);
              return Boolean.valueOf((!_oclIsKindOf));
            }
          };
          return Boolean.valueOf(IterableExtensions.<GenNodeLabel>exists(n.getLabels(), _function));
        }
      };
      boolean _exists = IterableExtensions.<GenNode>exists(it.getAllNodes(), _function);
      if (_exists) {
        CharSequence _nodeLabelDragPolicyClass = this.xptNodeLabelEditPart.nodeLabelDragPolicyClass(it);
        _builder.append(_nodeLabelDragPolicyClass);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    {
      final Function1<GenLink, Boolean> _function_1 = new Function1<GenLink, Boolean>() {
        @Override
        public Boolean apply(final GenLink l) {
          return Boolean.valueOf(DiagramEditPart.this._common_qvto.<GenLinkLabel>notEmpty(l.getLabels()));
        }
      };
      boolean _exists_1 = IterableExtensions.<GenLink>exists(it.getLinks(), _function_1);
      if (_exists_1) {
        CharSequence _linkLabelDragPolicyClass = this.xptLinkLabelEditPart.linkLabelDragPolicyClass(it);
        _builder.append(_linkLabelDragPolicyClass);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence extendsList(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart");
    return _builder;
  }
  
  public CharSequence implementsList(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence attributes(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public final static String MODEL_ID = \"");
    String _modelID = it.getEditorGen().getModelID();
    _builder.append(_modelID);
    _builder.append("\"; ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _visualIDConstant = this.xptEditpartsCommon.visualIDConstant(it);
    _builder.append(_visualIDConstant);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence createDefaultEditPolicies(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void createDefaultEditPolicies() {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _createDefaultEditPoliciesBody = this.xptDiagramEditPart.createDefaultEditPoliciesBody(it);
    _builder.append(_createDefaultEditPoliciesBody, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence additions(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
}
