/**
 * Copyright (c) 2011 - 2013 Montages AG
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Svyatoslav Kovalsky (Montages) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package impl.diagram.editparts;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ModeledViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ParentAssignedViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.papyrus.gmf.gmfgraph.DiagramLabel;
import org.eclipse.papyrus.gmf.gmfgraph.VerticalLabel;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.Common_qvto;

@Singleton
@SuppressWarnings("all")
public class RuntimeLabelsSupport_qvto {
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  public boolean isVerticalLabel(final GenCommonBase commonBase) {
    boolean _xblockexpression = false;
    {
      Viewmap vm = commonBase.getViewmap();
      boolean _switchResult = false;
      boolean _matched = false;
      if (vm instanceof ParentAssignedViewmap) {
        _matched=true;
        String _figureQualifiedClassName = ((ParentAssignedViewmap)vm).getFigureQualifiedClassName();
        String _verticalLabelFQN = this.getVerticalLabelFQN();
        _switchResult = Objects.equal(_figureQualifiedClassName, _verticalLabelFQN);
      }
      if (!_matched) {
        if (vm instanceof ModeledViewmap) {
          _matched=true;
          _switchResult = (this._common_qvto.oclIsKindOf(((ModeledViewmap)vm).getFigureModel(), DiagramLabel.class) && 
            this.isVerticalDiagramLabel(((DiagramLabel) ((ModeledViewmap)vm).getFigureModel())));
        }
      }
      if (!_matched) {
        _switchResult = false;
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }
  
  public boolean isVerticalDiagramLabel(final DiagramLabel figureModel) {
    return ((!Objects.equal(figureModel.getAccessor(), null)) && this._common_qvto.oclIsKindOf(figureModel.getAccessor().getFigure(), VerticalLabel.class));
  }
  
  @MetaDef
  public String getSimpleLabelDelegateFQN() {
    String _runtimeLabelPackage = this.getRuntimeLabelPackage();
    String _plus = (_runtimeLabelPackage + ".");
    return (_plus + "SimpleLabelDelegate");
  }
  
  @MetaDef
  public String getVerticalLabelFQN() {
    String _runtimeLabelPackage = this.getRuntimeLabelPackage();
    String _plus = (_runtimeLabelPackage + ".");
    return (_plus + "VerticalLabel");
  }
  
  @MetaDef
  public String getVerticalLabelDelegateFQN() {
    String _runtimeLabelPackage = this.getRuntimeLabelPackage();
    String _plus = (_runtimeLabelPackage + ".");
    return (_plus + "VerticalLabelDelegate");
  }
  
  @MetaDef
  public String getVerticalLabelCellEditorLocatorFQN() {
    String _runtimeLabelPackage = this.getRuntimeLabelPackage();
    String _plus = (_runtimeLabelPackage + ".");
    return (_plus + "VerticalLabelCellEditorLocator");
  }
  
  @MetaDef
  public String getRuntimeLabelPackage() {
    return "org.eclipse.gmf.tooling.runtime.draw2d.labels";
  }
  
  public boolean supportsVerticalLabels(final GenDiagram diagram) {
    final Function1<GenNode, Boolean> _function = new Function1<GenNode, Boolean>() {
      @Override
      public Boolean apply(final GenNode n) {
        return Boolean.valueOf(RuntimeLabelsSupport_qvto.this.hasVerticalLabels(n));
      }
    };
    return IterableExtensions.<GenNode>exists(diagram.getAllNodes(), _function);
  }
  
  public boolean hasVerticalLabels(final GenNode node) {
    return (this.isVerticalLabel(node) || IterableExtensions.<GenNodeLabel>exists(node.getLabels(), new Function1<GenNodeLabel, Boolean>() {
      @Override
      public Boolean apply(final GenNodeLabel label) {
        return Boolean.valueOf(RuntimeLabelsSupport_qvto.this.isVerticalLabel(label));
      }
    }));
  }
}
