/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 * 	  Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.diagram.editparts;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildSideAffixedNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExternalNodeLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkEnd;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ModeledViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ParentAssignedViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ViewmapLayoutType;
import org.eclipse.papyrus.gmf.gmfgraph.Compartment;
import org.eclipse.papyrus.gmf.gmfgraph.DiagramElement;
import org.eclipse.papyrus.gmf.gmfgraph.DiagramLabel;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.Common_qvto;

@Singleton
@SuppressWarnings("all")
public class Utils_qvto {
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  private <T extends DiagramElement> EObject modeledDiagramElement(final GenCommonBase gc, final Class<? extends T> clazz) {
    final Viewmap viewmap = gc.getViewmap();
    boolean _matched = false;
    if (viewmap instanceof ModeledViewmap) {
      boolean _oclIsKindOf = this._common_qvto.oclIsKindOf(((ModeledViewmap)viewmap).getFigureModel(), clazz);
      if (_oclIsKindOf) {
        _matched=true;
        return ((ModeledViewmap)viewmap).getFigureModel();
      }
    }
    return null;
  }
  
  private DiagramLabel modeledDiagramLabel(final GenCommonBase gc) {
    EObject _modeledDiagramElement = this.<DiagramLabel>modeledDiagramElement(gc, DiagramLabel.class);
    return ((DiagramLabel) _modeledDiagramElement);
  }
  
  private Compartment modeledCompartment(final GenCommonBase gc) {
    EObject _modeledDiagramElement = this.<Compartment>modeledDiagramElement(gc, Compartment.class);
    return ((Compartment) _modeledDiagramElement);
  }
  
  public boolean isStoringChildPositions(final GenNode node) {
    ViewmapLayoutType _layoutType = node.getLayoutType();
    return Objects.equal(_layoutType, Integer.valueOf(ViewmapLayoutType.XY_LAYOUT));
  }
  
  public Iterable<GenExternalNodeLabel> getExternalLabels(final GenNode node) {
    return Iterables.<GenExternalNodeLabel>filter(node.getLabels(), GenExternalNodeLabel.class);
  }
  
  public Iterable<GenChildSideAffixedNode> getSideAffixedChildren(final GenNode node) {
    return Iterables.<GenChildSideAffixedNode>filter(node.getChildNodes(), GenChildSideAffixedNode.class);
  }
  
  private Iterable<? extends GenLabel> getInnerLabels(final GenNode node) {
    final Function1<GenNodeLabel, Boolean> _function = new Function1<GenNodeLabel, Boolean>() {
      @Override
      public Boolean apply(final GenNodeLabel i) {
        boolean _oclIsKindOf = Utils_qvto.this._common_qvto.oclIsKindOf(i, GenExternalNodeLabel.class);
        return Boolean.valueOf((!_oclIsKindOf));
      }
    };
    return IterableExtensions.<GenNodeLabel>filter(node.getLabels(), _function);
  }
  
  public Iterable<? extends GenLabel> getInnerFixedLabels(final GenNode node) {
    final Iterable<? extends GenLabel> innerLabels = this.getInnerLabels(node);
    final Function1<GenLabel, Boolean> _function = new Function1<GenLabel, Boolean>() {
      @Override
      public Boolean apply(final GenLabel e) {
        return Boolean.valueOf(Utils_qvto.this._common_qvto.oclIsKindOf(e.getViewmap(), ParentAssignedViewmap.class));
      }
    };
    return IterableExtensions.filter(innerLabels, _function);
  }
  
  public Iterable<? extends GenLabel> getInnerFixedLabelsWithModeledViewmaps(final GenNode node) {
    final Iterable<? extends GenLabel> innerLabels = this.getInnerLabels(node);
    final Function1<GenLabel, Boolean> _function = new Function1<GenLabel, Boolean>() {
      @Override
      public Boolean apply(final GenLabel e) {
        return Boolean.valueOf(((!Objects.equal(Utils_qvto.this.modeledDiagramLabel(e), null)) && 
          (!Objects.equal(Utils_qvto.this.modeledDiagramLabel(e).getAccessor(), null))));
      }
    };
    return IterableExtensions.filter(innerLabels, _function);
  }
  
  public Iterable<GenCompartment> getPinnedCompartments(final GenNode node) {
    final Function1<GenCompartment, Boolean> _function = new Function1<GenCompartment, Boolean>() {
      @Override
      public Boolean apply(final GenCompartment e) {
        return Boolean.valueOf(Utils_qvto.this._common_qvto.oclIsKindOf(e.getViewmap(), ParentAssignedViewmap.class));
      }
    };
    return IterableExtensions.<GenCompartment>filter(node.getCompartments(), _function);
  }
  
  public Iterable<GenCompartment> getPinnedCompartmentsWithModeledViewmaps(final GenNode node) {
    final Function1<GenCompartment, Boolean> _function = new Function1<GenCompartment, Boolean>() {
      @Override
      public Boolean apply(final GenCompartment c) {
        return Boolean.valueOf(((!Objects.equal(Utils_qvto.this.modeledCompartment(c), null)) && 
          (!Objects.equal(Utils_qvto.this.modeledCompartment(c).getAccessor(), null))));
      }
    };
    return IterableExtensions.<GenCompartment>filter(node.getCompartments(), _function);
  }
  
  public boolean hasFixedChildren(final GenNode node) {
    return ((((IterableExtensions.size(this.getInnerFixedLabels(node)) > 0) || 
      (IterableExtensions.size(this.getPinnedCompartments(node)) > 0)) || 
      (IterableExtensions.size(this.getInnerFixedLabelsWithModeledViewmaps(node)) > 0)) || 
      (IterableExtensions.size(this.getPinnedCompartmentsWithModeledViewmaps(node)) > 0));
  }
  
  public boolean listCompartmentHasChildren(final GenCompartment compartment) {
    return (compartment.isListLayout() && (compartment.getChildNodes().size() > 0));
  }
  
  public boolean hasChildrenInListCompartments(final GenNode node) {
    final Function1<GenCompartment, Boolean> _function = new Function1<GenCompartment, Boolean>() {
      @Override
      public Boolean apply(final GenCompartment e) {
        return Boolean.valueOf(Utils_qvto.this.listCompartmentHasChildren(e));
      }
    };
    return IterableExtensions.<GenCompartment>exists(node.getCompartments(), _function);
  }
  
  public boolean hasBorderItems(final GenNode node) {
    return ((IterableExtensions.size(this.getSideAffixedChildren(node)) > 0) || (IterableExtensions.size(this.getExternalLabels(node)) > 0));
  }
  
  public boolean needsGraphicalNodeEditPolicy(final GenNode node) {
    return ((!Objects.equal(node.getModelFacet(), null)) && (node.getReorientedIncomingLinks().size() > 0));
  }
  
  public boolean shouldGenerateDiagramViewmap(final GenDiagram genDiagram) {
    final HashSet<ViewmapLayoutType> typesWithoutViewmaps = CollectionLiterals.<ViewmapLayoutType>newHashSet(ViewmapLayoutType.UNKNOWN_LITERAL, ViewmapLayoutType.XY_LAYOUT_LITERAL);
    boolean _contains = typesWithoutViewmaps.contains(genDiagram.getViewmap().getLayoutType());
    return (!_contains);
  }
  
  public Iterable<GenLink> getAssistantOutgoingLinks(final GenNode node) {
    final Function1<GenLink, Boolean> _function = new Function1<GenLink, Boolean>() {
      @Override
      public Boolean apply(final GenLink link) {
        final Function1<GenLinkEnd, Boolean> _function = new Function1<GenLinkEnd, Boolean>() {
          @Override
          public Boolean apply(final GenLinkEnd t) {
            return Boolean.valueOf(Utils_qvto.this._common_qvto.oclIsKindOf(t, GenNode.class));
          }
        };
        return Boolean.valueOf(IterableExtensions.<GenLinkEnd>exists(link.getTargets(), _function));
      }
    };
    return IterableExtensions.<GenLink>filter(node.getGenOutgoingLinks(), _function);
  }
  
  public Iterable<GenLink> getAssistantIncomingLinks(final GenNode node) {
    final Function1<GenLink, Boolean> _function = new Function1<GenLink, Boolean>() {
      @Override
      public Boolean apply(final GenLink link) {
        final Function1<GenLinkEnd, Boolean> _function = new Function1<GenLinkEnd, Boolean>() {
          @Override
          public Boolean apply(final GenLinkEnd s) {
            return Boolean.valueOf(Utils_qvto.this._common_qvto.oclIsKindOf(s, GenNode.class));
          }
        };
        return Boolean.valueOf(IterableExtensions.<GenLinkEnd>exists(link.getSources(), _function));
      }
    };
    return IterableExtensions.<GenLink>filter(node.getGenIncomingLinks(), _function);
  }
  
  public Iterable<GenNode> selectGenNodes(final Iterable<GenLinkEnd> ends) {
    return Iterables.<GenNode>filter(ends, GenNode.class);
  }
  
  public boolean haveOneOfChildNodesIncomimgLinks(final GenCompartment it) {
    final Function1<GenChildNode, Boolean> _function = new Function1<GenChildNode, Boolean>() {
      @Override
      public Boolean apply(final GenChildNode n) {
        return Boolean.valueOf(Utils_qvto.this._common_qvto.<GenLink>notEmpty(Utils_qvto.this.getAssistantIncomingLinks(n)));
      }
    };
    return IterableExtensions.<GenChildNode>exists(it.getChildNodes(), _function);
  }
  
  public List<GenLink> collectIncomingLinks(final GenCompartment it) {
    Set<GenLink> incomingLinks = new HashSet<GenLink>();
    EList<GenChildNode> _childNodes = it.getChildNodes();
    for (final GenChildNode childNode : _childNodes) {
      boolean _notEmpty = this._common_qvto.<GenLink>notEmpty(this.getAssistantIncomingLinks(childNode));
      if (_notEmpty) {
        Iterables.<GenLink>addAll(incomingLinks, this.getAssistantIncomingLinks(childNode));
      }
    }
    final Function1<GenLink, Integer> _function = new Function1<GenLink, Integer>() {
      @Override
      public Integer apply(final GenLink l) {
        return Integer.valueOf(l.getVisualID());
      }
    };
    return IterableExtensions.<GenLink, Integer>sortBy(incomingLinks, _function);
  }
}
