/**
 * Copyright (c) 2013, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Svyatoslav Kovalsky (Montages) - initial API and implementation
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.diagram.editpolicies;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;

/**
 * FIXME: [MG] - reverse the calls? call common code from here and TextelectionEP and not vice versa
 */
@Singleton
@SuppressWarnings("all")
public class TextNonResizableEditPolicy {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  private TextSelectionEditPolicy xptTextSelection;
  
  public CharSequence className(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _textNonResizableEditPolicyClassName = it.getTextNonResizableEditPolicyClassName();
    _builder.append(_textNonResizableEditPolicyClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPoliciesPackageName = it.getEditPoliciesPackageName();
    _builder.append(_editPoliciesPackageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence TextNonResizableEditPolicyInvocation(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _TextNonResizableEditPolicy = this.TextNonResizableEditPolicy(it);
    _builder.append(_TextNonResizableEditPolicy);
    return _builder;
  }
  
  public CharSequence TextNonResizableEditPolicy(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _TextNonResizableEditPolicy_extendsClause = this.TextNonResizableEditPolicy_extendsClause(it);
    _builder.append(_TextNonResizableEditPolicy_extendsClause);
    _builder.append(" ");
    CharSequence _TextNonResizableEditPolicy_implementsClause = this.TextNonResizableEditPolicy_implementsClause(it);
    _builder.append(_TextNonResizableEditPolicy_implementsClause);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _textFeedback = this.xptTextSelection.textFeedback(it);
    _builder.append(_textFeedback, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _TextNonResizableEditPolicy_createSelectionHandles = this.TextNonResizableEditPolicy_createSelectionHandles(it);
    _builder.append(_TextNonResizableEditPolicy_createSelectionHandles, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _TextNonResizableEditPolicy_additions = this.TextNonResizableEditPolicy_additions(it);
    _builder.append(_TextNonResizableEditPolicy_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence TextNonResizableEditPolicy_extendsClause(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends org.eclipse.gmf.runtime.diagram.ui.editpolicies.NonResizableEditPolicyEx");
    return _builder;
  }
  
  public CharSequence TextNonResizableEditPolicy_implementsClause(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("implements org.eclipse.gmf.tooling.runtime.edit.policies.labels.IRefreshableFeedbackEditPolicy");
    return _builder;
  }
  
  public CharSequence TextNonResizableEditPolicy_createSelectionHandles(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected java.util.List createSelectionHandles() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gef.handles.MoveHandle moveHandle =");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("new org.eclipse.gef.handles.MoveHandle((org.eclipse.gef.GraphicalEditPart) getHost());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("moveHandle.setBorder(null);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("moveHandle.setDragTracker(new org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx(getHost()));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return java.util.Collections.singletonList(moveHandle);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence TextNonResizableEditPolicy_additions(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
}
