/**
 * Copyright (c) 2013, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Michael Golubev (Montages) - initial API and implementation
 *   Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.plugin;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenMetricContainer;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigator;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenPlugin;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenPropertySheet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ProviderPriority;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;
import xpt.GenEditorGenerator_qvto;
import xpt.editor.extensions;

@Singleton
@SuppressWarnings("all")
public class plugin {
  @Inject
  @Extension
  private GenEditorGenerator_qvto _genEditorGenerator_qvto;
  
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private pluginUtils _pluginUtils;
  
  @Inject
  private extensions xptEditorExtension;
  
  @Inject
  private xpt.diagram.preferences.extensions xptPreferencesExtension;
  
  @Inject
  private xpt.propsheet.extensions xptPropsheetExtension;
  
  @Inject
  private xpt.navigator.extensions xptNavigatorExtension;
  
  @Inject
  private xpt.application.extensions xptApplicationExtension;
  
  @Inject
  private xpt.diagram.updater.extensions xptUpdaterExtension;
  
  @Inject
  private impl.actions.extensions xptActionExtension;
  
  @Inject
  private xpt.providers.extensions xptProvidersExtension;
  
  public CharSequence qualifiedClassName(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("plugin.xml");
    return _builder;
  }
  
  public CharSequence fullPath(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence plugin(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    _builder.newLine();
    _builder.append("<?eclipse version=\"3.0\"?>");
    _builder.newLine();
    CharSequence _xcopyright = this._common.xcopyright(it.getEditorGen());
    _builder.append(_xcopyright);
    _builder.newLineIfNotEmpty();
    _builder.append("<plugin>");
    _builder.newLine();
    CharSequence _fileTypes = this.fileTypes(it);
    _builder.append(_fileTypes);
    _builder.newLineIfNotEmpty();
    CharSequence _extension_parser = this.extension_parser(it);
    _builder.append(_extension_parser);
    _builder.newLineIfNotEmpty();
    CharSequence _extensions = this.xptEditorExtension.extensions(it.getEditorGen());
    _builder.append(_extensions);
    _builder.newLineIfNotEmpty();
    CharSequence _pluginMenu = this.pluginMenu(it);
    _builder.append(_pluginMenu);
    _builder.newLineIfNotEmpty();
    CharSequence _validation = this.validation(it.getEditorGen().getDiagram());
    _builder.append(_validation);
    _builder.newLineIfNotEmpty();
    {
      GenMetricContainer _metrics = it.getEditorGen().getMetrics();
      boolean _notEquals = (!Objects.equal(_metrics, null));
      if (_notEquals) {
        CharSequence _metrics_1 = this.metrics(it.getEditorGen().getMetrics());
        _builder.append(_metrics_1);
      }
    }
    _builder.newLineIfNotEmpty();
    CharSequence _extensions_1 = this.xptPreferencesExtension.extensions(it.getEditorGen().getDiagram());
    _builder.append(_extensions_1);
    _builder.newLineIfNotEmpty();
    {
      GenPropertySheet _propertySheet = it.getEditorGen().getPropertySheet();
      boolean _notEquals_1 = (!Objects.equal(_propertySheet, null));
      if (_notEquals_1) {
        CharSequence _extensions_2 = this.xptPropsheetExtension.extensions(it.getEditorGen().getPropertySheet());
        _builder.append(_extensions_2);
      }
    }
    _builder.newLineIfNotEmpty();
    CharSequence _extensions_3 = this.xptProvidersExtension.extensions(it.getEditorGen().getDiagram());
    _builder.append(_extensions_3);
    _builder.newLineIfNotEmpty();
    {
      GenNavigator _navigator = it.getEditorGen().getNavigator();
      boolean _notEquals_2 = (!Objects.equal(_navigator, null));
      if (_notEquals_2) {
        CharSequence _extensions_4 = this.xptNavigatorExtension.extensions(it.getEditorGen().getNavigator());
        _builder.append(_extensions_4);
      }
    }
    _builder.newLineIfNotEmpty();
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _notEquals_3 = (!Objects.equal(_application, null));
      if (_notEquals_3) {
        CharSequence _extensions_5 = this.xptApplicationExtension.extensions(it.getEditorGen().getApplication());
        _builder.append(_extensions_5);
      }
    }
    _builder.newLineIfNotEmpty();
    CharSequence _extensionsConstraintProviders = this._pluginUtils.extensionsConstraintProviders(it.getEditorGen());
    _builder.append(_extensionsConstraintProviders);
    _builder.newLineIfNotEmpty();
    CharSequence _extensions_6 = this.xptUpdaterExtension.extensions(it.getEditorGen().getDiagramUpdater());
    _builder.append(_extensions_6);
    _builder.newLineIfNotEmpty();
    CharSequence _Main = this.xptActionExtension.Main(it.getEditorGen());
    _builder.append(_Main);
    _builder.newLineIfNotEmpty();
    CharSequence _additions = this.additions(it);
    _builder.append(_additions);
    _builder.newLineIfNotEmpty();
    _builder.append("</plugin>");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence fileTypes(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak);
    _builder.newLineIfNotEmpty();
    String _tripleSpace = this._common.tripleSpace(1);
    _builder.append(_tripleSpace);
    _builder.append("<extension point=\"org.eclipse.team.core.fileTypes\" id=\"repo-ftype\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_1 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_1);
    CharSequence _xmlGeneratedTag = this._common.xmlGeneratedTag();
    _builder.append(_xmlGeneratedTag);
    _builder.newLineIfNotEmpty();
    String _tripleSpace_2 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_2);
    _builder.append("<fileTypes type=\"text\" extension=\"");
    String _diagramFileExtension = it.getEditorGen().getDiagramFileExtension();
    _builder.append(_diagramFileExtension);
    _builder.append("\"/>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_3 = this._common.tripleSpace(1);
    _builder.append(_tripleSpace_3);
    _builder.append("</extension>");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence extension_parser(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak);
    _builder.newLineIfNotEmpty();
    String _tripleSpace = this._common.tripleSpace(1);
    _builder.append(_tripleSpace);
    _builder.append("<extension point=\"org.eclipse.emf.ecore.extension_parser\" id=\"resource-factory\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_1 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_1);
    CharSequence _xmlGeneratedTag = this._common.xmlGeneratedTag();
    _builder.append(_xmlGeneratedTag);
    _builder.newLineIfNotEmpty();
    String _tripleSpace_2 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_2);
    _builder.append("<parser");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_3 = this._common.tripleSpace(3);
    _builder.append(_tripleSpace_3);
    _builder.append("type=\"");
    String _diagramFileExtension = it.getEditorGen().getDiagramFileExtension();
    _builder.append(_diagramFileExtension);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_4 = this._common.tripleSpace(3);
    _builder.append(_tripleSpace_4);
    _builder.append("class=\"org.eclipse.gmf.runtime.emf.core.resources.GMFResourceFactory\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_5 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_5);
    _builder.append("</parser>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_6 = this._common.tripleSpace(1);
    _builder.append(_tripleSpace_6);
    _builder.append("</extension>");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence pluginMenu(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    String _outTab = this.outTab();
    _builder.append(_outTab);
    _builder.newLineIfNotEmpty();
    String _tripleSpace = this._common.tripleSpace(1);
    _builder.append(_tripleSpace);
    _builder.append("<extension point=\"org.eclipse.gmf.runtime.common.ui.services.action.globalActionHandlerProviders\" id=\"global-actions\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_1 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_1);
    CharSequence _xmlGeneratedTag = this._common.xmlGeneratedTag();
    _builder.append(_xmlGeneratedTag);
    _builder.newLineIfNotEmpty();
    String _tripleSpace_2 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_2);
    _builder.append("<GlobalActionHandlerProvider");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_3 = this._common.tripleSpace(3);
    _builder.append(_tripleSpace_3);
    _builder.append("class=\"org.eclipse.gmf.runtime.diagram.ui.providers.DiagramGlobalActionHandlerProvider\"");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_4 = this._common.tripleSpace(3);
    _builder.append(_tripleSpace_4);
    _builder.append("id=\"");
    String _modelID = it.getEditorGen().getModelID();
    _builder.append(_modelID);
    _builder.append("Presentation\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_5 = this._common.tripleSpace(3);
    _builder.append(_tripleSpace_5);
    _builder.append("<Priority name=\"Lowest\"/>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_6 = this._common.tripleSpace(3);
    _builder.append(_tripleSpace_6);
    _builder.append("<ViewId id=\"");
    String _iD = it.getEditorGen().getEditor().getID();
    _builder.append(_iD);
    _builder.append("\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_7 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_7);
    _builder.append("<ElementType class=\"org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_8 = this._common.tripleSpace(5);
    _builder.append(_tripleSpace_8);
    _builder.append("<GlobalActionId actionId=\"delete\"/>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_9 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_9);
    _builder.append("</ElementType>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_10 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_10);
    _builder.append("<ElementType class=\"org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_11 = this._common.tripleSpace(5);
    _builder.append(_tripleSpace_11);
    _builder.append("<GlobalActionId actionId=\"save\"/>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_12 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_12);
    _builder.append("</ElementType>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_13 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_13);
    _builder.append("<ElementType class=\"org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_14 = this._common.tripleSpace(5);
    _builder.append(_tripleSpace_14);
    _builder.append("<GlobalActionId actionId=\"save\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_15 = this._common.tripleSpace(5);
    _builder.append(_tripleSpace_15);
    _builder.append("</GlobalActionId>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_16 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_16);
    _builder.append("</ElementType>        ");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_17 = this._common.tripleSpace(3);
    _builder.append(_tripleSpace_17);
    _builder.append("</ViewId>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_18 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_18);
    _builder.append("</GlobalActionHandlerProvider>");
    _builder.newLineIfNotEmpty();
    {
      boolean _isPrintingEnabled = it.isPrintingEnabled();
      if (_isPrintingEnabled) {
        String _tripleSpace_19 = this._common.tripleSpace(2);
        _builder.append(_tripleSpace_19);
        _builder.append("<GlobalActionHandlerProvider");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_20 = this._common.tripleSpace(3);
        _builder.append(_tripleSpace_20);
        _builder.append("class=\"org.eclipse.gmf.runtime.diagram.ui.printing.render.providers.DiagramWithPrintGlobalActionHandlerProvider\"");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_21 = this._common.tripleSpace(3);
        _builder.append(_tripleSpace_21);
        _builder.append("id=\"");
        String _modelID_1 = it.getEditorGen().getModelID();
        _builder.append(_modelID_1);
        _builder.append("PresentationPrint\">");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_22 = this._common.tripleSpace(3);
        _builder.append(_tripleSpace_22);
        _builder.append("<Priority name=\"Lowest\"/>");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_23 = this._common.tripleSpace(3);
        _builder.append(_tripleSpace_23);
        _builder.append("<ViewId id=\"");
        String _iD_1 = it.getEditorGen().getEditor().getID();
        _builder.append(_iD_1);
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_24 = this._common.tripleSpace(4);
        _builder.append(_tripleSpace_24);
        _builder.append("<ElementType class=\"org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart\">");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_25 = this._common.tripleSpace(5);
        _builder.append(_tripleSpace_25);
        _builder.append("<GlobalActionId actionId=\"print\"/>");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_26 = this._common.tripleSpace(4);
        _builder.append(_tripleSpace_26);
        _builder.append("</ElementType>");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_27 = this._common.tripleSpace(3);
        _builder.append(_tripleSpace_27);
        _builder.append("</ViewId>");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_28 = this._common.tripleSpace(2);
        _builder.append(_tripleSpace_28);
        _builder.append("</GlobalActionHandlerProvider>");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _equals = Objects.equal(null, _application);
      if (_equals) {
        String _tripleSpace_29 = this._common.tripleSpace(2);
        _builder.append(_tripleSpace_29);
        _builder.append("<GlobalActionHandlerProvider");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_30 = this._common.tripleSpace(3);
        _builder.append(_tripleSpace_30);
        _builder.append("class=\"org.eclipse.gmf.runtime.diagram.ui.providers.ide.providers.DiagramIDEGlobalActionHandlerProvider\"");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_31 = this._common.tripleSpace(3);
        _builder.append(_tripleSpace_31);
        _builder.append("id=\"");
        String _modelID_2 = it.getEditorGen().getModelID();
        _builder.append(_modelID_2);
        _builder.append("PresentationIDE\">");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_32 = this._common.tripleSpace(3);
        _builder.append(_tripleSpace_32);
        _builder.append("<Priority name=\"Lowest\"/>");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_33 = this._common.tripleSpace(3);
        _builder.append(_tripleSpace_33);
        _builder.append("<ViewId id=\"");
        String _iD_2 = it.getEditorGen().getEditor().getID();
        _builder.append(_iD_2);
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_34 = this._common.tripleSpace(4);
        _builder.append(_tripleSpace_34);
        _builder.append("<ElementType class=\"org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart\">");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_35 = this._common.tripleSpace(5);
        _builder.append(_tripleSpace_35);
        _builder.append("<GlobalActionId actionId=\"bookmark\"/>");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_36 = this._common.tripleSpace(4);
        _builder.append(_tripleSpace_36);
        _builder.append("</ElementType>");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_37 = this._common.tripleSpace(3);
        _builder.append(_tripleSpace_37);
        _builder.append("</ViewId>");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_38 = this._common.tripleSpace(2);
        _builder.append(_tripleSpace_38);
        _builder.append("</GlobalActionHandlerProvider>");
        _builder.newLineIfNotEmpty();
      }
    }
    String _tripleSpace_39 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_39);
    _builder.append("<GlobalActionHandlerProvider");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_40 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_40);
    _builder.append("class=\"org.eclipse.gmf.runtime.diagram.ui.render.providers.DiagramUIRenderGlobalActionHandlerProvider\"");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_41 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_41);
    _builder.append("id=\"");
    String _modelID_3 = it.getEditorGen().getModelID();
    _builder.append(_modelID_3);
    _builder.append("Render\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_42 = this._common.tripleSpace(3);
    _builder.append(_tripleSpace_42);
    _builder.append("<Priority name=\"Lowest\"/>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_43 = this._common.tripleSpace(3);
    _builder.append(_tripleSpace_43);
    _builder.append("<ViewId id=\"");
    String _iD_3 = it.getEditorGen().getEditor().getID();
    _builder.append(_iD_3);
    _builder.append("\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_44 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_44);
    _builder.append("<ElementType class=\"org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_45 = this._common.tripleSpace(5);
    _builder.append(_tripleSpace_45);
    _builder.append("<GlobalActionId actionId=\"cut\"/>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_46 = this._common.tripleSpace(5);
    _builder.append(_tripleSpace_46);
    _builder.append("<GlobalActionId actionId=\"copy\"/>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_47 = this._common.tripleSpace(5);
    _builder.append(_tripleSpace_47);
    _builder.append("<GlobalActionId actionId=\"paste\"/>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_48 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_48);
    _builder.append("</ElementType>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_49 = this._common.tripleSpace(3);
    _builder.append(_tripleSpace_49);
    _builder.append("</ViewId>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_50 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_50);
    _builder.append("</GlobalActionHandlerProvider>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_51 = this._common.tripleSpace(1);
    _builder.append(_tripleSpace_51);
    _builder.append("</extension>");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence metrics(final GenMetricContainer it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      int _size = it.getMetrics().size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        _builder.newLine();
        String _tripleSpace = this._common.tripleSpace(1);
        _builder.append(_tripleSpace);
        _builder.append("<extension id=\"metrics-view\" point=\"org.eclipse.ui.views\">");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_1 = this._common.tripleSpace(2);
        _builder.append(_tripleSpace_1);
        CharSequence _xmlGeneratedTag = this._common.xmlGeneratedTag();
        _builder.append(_xmlGeneratedTag);
        _builder.newLineIfNotEmpty();
        String _tripleSpace_2 = this._common.tripleSpace(2);
        _builder.append(_tripleSpace_2);
        _builder.append("<view class=\"");
        String _metricProviderQualifiedClassName = it.getEditorGen().getDiagram().getMetricProviderQualifiedClassName();
        _builder.append(_metricProviderQualifiedClassName);
        _builder.append("$ResultView\"");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_3 = this._common.tripleSpace(4);
        _builder.append(_tripleSpace_3);
        _builder.append("id=\"");
        String _metricViewID = it.getEditorGen().getDiagram().getMetricViewID();
        _builder.append(_metricViewID);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_4 = this._common.tripleSpace(4);
        _builder.append(_tripleSpace_4);
        _builder.append("name=\"");
        String _modelID = it.getEditorGen().getModelID();
        _builder.append(_modelID);
        _builder.append(" Diagram Metrics\"/>");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_5 = this._common.tripleSpace(1);
        _builder.append(_tripleSpace_5);
        _builder.append("</extension>");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence validation(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if ((it.isValidationEnabled() || this._genEditorGenerator_qvto.hasAudits(it.getEditorGen()))) {
        {
          GenApplication _application = it.getEditorGen().getApplication();
          boolean _equals = Objects.equal(null, _application);
          if (_equals) {
            _builder.newLine();
            String _tripleSpace = this._common.tripleSpace(1);
            _builder.append(_tripleSpace);
            _builder.append("<extension point=\"org.eclipse.gmf.runtime.common.ui.services.markerNavigationProviders\" id=\"markers-navigation\">");
            _builder.newLineIfNotEmpty();
            String _tripleSpace_1 = this._common.tripleSpace(2);
            _builder.append(_tripleSpace_1);
            CharSequence _xmlGeneratedTag = this._common.xmlGeneratedTag();
            _builder.append(_xmlGeneratedTag);
            _builder.newLineIfNotEmpty();
            String _tripleSpace_2 = this._common.tripleSpace(2);
            _builder.append(_tripleSpace_2);
            _builder.append("<MarkerNavigationProvider class=\"");
            String _markerNavigationProviderQualifiedClassName = it.getMarkerNavigationProviderQualifiedClassName();
            _builder.append(_markerNavigationProviderQualifiedClassName);
            _builder.append("\">");
            _builder.newLineIfNotEmpty();
            String _tripleSpace_3 = this._common.tripleSpace(3);
            _builder.append(_tripleSpace_3);
            _builder.append("<MarkerType name=\"");
            String _iD = it.getEditorGen().getPlugin().getID();
            String _plus = (_iD + ".");
            String _validationDiagnosticMarkerType = it.getValidationDiagnosticMarkerType();
            String _plus_1 = (_plus + _validationDiagnosticMarkerType);
            _builder.append(_plus_1);
            _builder.append("\"/>");
            _builder.newLineIfNotEmpty();
            String _tripleSpace_4 = this._common.tripleSpace(3);
            _builder.append(_tripleSpace_4);
            _builder.append("<Priority name=\"");
            ProviderPriority _markerNavigationProviderPriority = it.getMarkerNavigationProviderPriority();
            _builder.append(_markerNavigationProviderPriority);
            _builder.append("\"/>");
            _builder.newLineIfNotEmpty();
            String _tripleSpace_5 = this._common.tripleSpace(2);
            _builder.append(_tripleSpace_5);
            _builder.append("</MarkerNavigationProvider>");
            _builder.newLineIfNotEmpty();
            String _tripleSpace_6 = this._common.tripleSpace(1);
            _builder.append(_tripleSpace_6);
            _builder.append("</extension>");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            String _tripleSpace_7 = this._common.tripleSpace(1);
            _builder.append(_tripleSpace_7);
            _builder.append("<extension id=\"");
            String _validationDiagnosticMarkerType_1 = it.getValidationDiagnosticMarkerType();
            _builder.append(_validationDiagnosticMarkerType_1);
            _builder.append("\" name=\"");
            String _name = it.getEditorGen().getPlugin().getName();
            _builder.append(_name);
            _builder.append(" problems\" point=\"org.eclipse.core.resources.markers\">");
            _builder.newLineIfNotEmpty();
            String _tripleSpace_8 = this._common.tripleSpace(2);
            _builder.append(_tripleSpace_8);
            CharSequence _xmlGeneratedTag_1 = this._common.xmlGeneratedTag();
            _builder.append(_xmlGeneratedTag_1);
            _builder.newLineIfNotEmpty();
            String _tripleSpace_9 = this._common.tripleSpace(2);
            _builder.append(_tripleSpace_9);
            _builder.append("<super type=\"org.eclipse.core.resources.problemmarker\"/>");
            _builder.newLineIfNotEmpty();
            String _tripleSpace_10 = this._common.tripleSpace(2);
            _builder.append(_tripleSpace_10);
            _builder.append("<super type=\"org.eclipse.gmf.runtime.common.ui.services.marker\"/>");
            _builder.newLineIfNotEmpty();
            String _tripleSpace_11 = this._common.tripleSpace(2);
            _builder.append(_tripleSpace_11);
            _builder.append("<persistent value=\"true\"/>");
            _builder.newLineIfNotEmpty();
            String _tripleSpace_12 = this._common.tripleSpace(1);
            _builder.append(_tripleSpace_12);
            _builder.append("</extension>   ");
            _builder.newLineIfNotEmpty();
          }
        }
        {
          boolean _isValidationDecorators = it.isValidationDecorators();
          if (_isValidationDecorators) {
            _builder.newLine();
            String _tripleSpace_13 = this._common.tripleSpace(1);
            _builder.append(_tripleSpace_13);
            _builder.append("<extension id=\"validationDecoratorProvider\" name=\"ValidationDecorations\" point=\"org.eclipse.gmf.runtime.diagram.ui.decoratorProviders\">");
            _builder.newLineIfNotEmpty();
            String _tripleSpace_14 = this._common.tripleSpace(2);
            _builder.append(_tripleSpace_14);
            CharSequence _xmlGeneratedTag_2 = this._common.xmlGeneratedTag();
            _builder.append(_xmlGeneratedTag_2);
            _builder.newLineIfNotEmpty();
            String _tripleSpace_15 = this._common.tripleSpace(2);
            _builder.append(_tripleSpace_15);
            _builder.append("<decoratorProvider class=\"");
            String _validationDecoratorProviderQualifiedClassName = it.getValidationDecoratorProviderQualifiedClassName();
            _builder.append(_validationDecoratorProviderQualifiedClassName);
            _builder.append("\">");
            _builder.newLineIfNotEmpty();
            String _tripleSpace_16 = this._common.tripleSpace(3);
            _builder.append(_tripleSpace_16);
            _builder.append("<Priority name=\"");
            ProviderPriority _validationDecoratorProviderPriority = it.getValidationDecoratorProviderPriority();
            _builder.append(_validationDecoratorProviderPriority);
            _builder.append("\"/>");
            _builder.newLineIfNotEmpty();
            String _tripleSpace_17 = this._common.tripleSpace(3);
            _builder.append(_tripleSpace_17);
            _builder.append("<object class=\"org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart(org.eclipse.gmf.runtime.diagram.ui)\" id=\"PRIMARY_VIEW\"/>");
            _builder.newLineIfNotEmpty();
            String _tripleSpace_18 = this._common.tripleSpace(3);
            _builder.append(_tripleSpace_18);
            _builder.append("<context decoratorTargets=\"PRIMARY_VIEW\"/>");
            _builder.newLineIfNotEmpty();
            String _tripleSpace_19 = this._common.tripleSpace(2);
            _builder.append(_tripleSpace_19);
            _builder.append("</decoratorProvider>");
            _builder.newLineIfNotEmpty();
            String _tripleSpace_20 = this._common.tripleSpace(1);
            _builder.append(_tripleSpace_20);
            _builder.append("</extension>");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }
  
  public CharSequence additions(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public String outTab() {
    return "\t";
  }
}
