/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 */
package xpt.providers;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.List;
import metamodel.MetaModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ElementType;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import plugin.Activator;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Common_qvto;
import xpt.diagram.Utils_qvto;
import xpt.editor.VisualIDRegistry;

@Singleton
@SuppressWarnings("all")
public class ElementTypes {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  @Inject
  private Activator xptActivator;
  
  @Inject
  private CodeStyle xptCodeStyle;
  
  @Inject
  private MetaModel xptMetaModel;
  
  @Inject
  private VisualIDRegistry xptVisualIDRegistry;
  
  @MetaDef
  public CharSequence accessElementType(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    String _elementTypesQualifiedClassName = it.getDiagram().getElementTypesQualifiedClassName();
    _builder.append(_elementTypesQualifiedClassName);
    _builder.append(".");
    String _uniqueIdentifier = it.getUniqueIdentifier();
    _builder.append(_uniqueIdentifier);
    return _builder;
  }
  
  public CharSequence className(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _elementTypesClassName = it.getElementTypesClassName();
    _builder.append(_elementTypesClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _providersPackageName = it.getProvidersPackageName();
    _builder.append(_providersPackageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence ElementTypes(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _constructor = this.constructor(it);
    _builder.append(_constructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _attributes = this.attributes(it);
    _builder.append(_attributes, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    {
      List<GenCommonBase> _allTypedElements = this._utils_qvto.getAllTypedElements(it);
      for(final GenCommonBase e : _allTypedElements) {
        _builder.append("\t");
        CharSequence _elementTypeField = this.elementTypeField(e);
        _builder.append(_elementTypeField, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _namedElementImageDescriptor = this.getNamedElementImageDescriptor(it);
    _builder.append(_namedElementImageDescriptor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _namedElementImage = this.getNamedElementImage(it);
    _builder.append(_namedElementImage, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _adaptableImageDescriptor = this.getAdaptableImageDescriptor(it);
    _builder.append(_adaptableImageDescriptor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _adaptableImage = this.getAdaptableImage(it);
    _builder.append(_adaptableImage, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _element = this.getElement(it);
    _builder.append(_element, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _elementType = this.getElementType(it);
    _builder.append(_elementType, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _isKnownElementType = this.isKnownElementType(it);
    _builder.append(_isKnownElementType, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _elementTypeByVisualID = this.getElementTypeByVisualID(it);
    _builder.append(_elementTypeByVisualID, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _typedInstance = this.typedInstance(it);
    _builder.append(_typedInstance, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence constructor(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence attributes(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private static java.util.Map<org.eclipse.gmf.runtime.emf.type.core.IElementType, org.eclipse.emf.ecore.ENamedElement> elements;");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("private static org.eclipse.gmf.tooling.runtime.providers.DiagramElementTypeImages elementTypeImages = new org.eclipse.gmf.tooling.runtime.providers.DiagramElementTypeImages(");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName);
    _builder.append(".getInstance().getItemProvidersAdapterFactory());");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2);
    _builder.newLineIfNotEmpty();
    _builder.append("private static java.util.Set<org.eclipse.gmf.runtime.emf.type.core.IElementType> KNOWN_ELEMENT_TYPES;");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * Since 3.1, GMFT delegates ImageRegistry-related code to non-generated DiagramElementTypeImages, so methods below are not generated anymore.
   * If you still need one, you always can get it from 'elementTypeImages.getXXX()' call.
   * The only exception is 'DEFINE loadProvidedImageDescriptor FOR gmfgen::GenDiagram', which is not compatible with the delegation and removed completely.
   * 
   * def getImageRegistry(GenDiagram it) ''''''
   * def getImageRegistryKey(GenDiagram it) ''''''
   * def getProvidedImageDescriptor(GenDiagram it) ''''''
   */
  public CharSequence getNamedElementImageDescriptor(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static org.eclipse.jface.resource.ImageDescriptor getImageDescriptor(org.eclipse.emf.ecore.ENamedElement element) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return elementTypeImages.getImageDescriptor(element);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getNamedElementImage(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static org.eclipse.swt.graphics.Image getImage(org.eclipse.emf.ecore.ENamedElement element) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return elementTypeImages.getImage(element);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getAdaptableImageDescriptor(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static org.eclipse.jface.resource.ImageDescriptor getImageDescriptor(org.eclipse.core.runtime.IAdaptable hint) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return getImageDescriptor(getElement(hint));");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getAdaptableImage(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static org.eclipse.swt.graphics.Image getImage(org.eclipse.core.runtime.IAdaptable hint) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return getImage(getElement(hint));");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getElement(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment("Returns \'type\' of the ecore object associated with the hint.\n");
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static org.eclipse.emf.ecore.ENamedElement getElement(org.eclipse.core.runtime.IAdaptable hint) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("Object type = hint.getAdapter(org.eclipse.gmf.runtime.emf.type.core.IElementType.class);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (elements == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("elements = new java.util.IdentityHashMap<org.eclipse.gmf.runtime.emf.type.core.IElementType, org.eclipse.emf.ecore.ENamedElement>();");
    _builder.newLine();
    _builder.append("\t\t");
    {
      GenClass _domainDiagramElement = it.getDomainDiagramElement();
      boolean _notEquals = (!Objects.equal(_domainDiagramElement, null));
      if (_notEquals) {
        CharSequence _bindUniqueIdentifierToNamedElement = this.bindUniqueIdentifierToNamedElement(it.getDomainDiagramElement(), it.getUniqueIdentifier());
        _builder.append(_bindUniqueIdentifierToNamedElement, "\t\t");
      }
    }
    _builder.newLineIfNotEmpty();
    {
      EList<GenNode> _allNodes = it.getAllNodes();
      for(final GenNode node : _allNodes) {
        _builder.append("\t\t");
        {
          TypeModelFacet _modelFacet = node.getModelFacet();
          boolean _notEquals_1 = (!Objects.equal(_modelFacet, null));
          if (_notEquals_1) {
            CharSequence _bindUniqueIdentifierToNamedElement_1 = this.bindUniqueIdentifierToNamedElement(node.getModelFacet(), node.getUniqueIdentifier());
            _builder.append(_bindUniqueIdentifierToNamedElement_1, "\t\t");
          }
        }
        _builder.newLineIfNotEmpty();
      }
    }
    {
      EList<GenLink> _links = it.getLinks();
      for(final GenLink link : _links) {
        _builder.append("\t\t");
        {
          LinkModelFacet _modelFacet_1 = link.getModelFacet();
          boolean _notEquals_2 = (!Objects.equal(_modelFacet_1, null));
          if (_notEquals_2) {
            CharSequence _bindUniqueIdentifierToNamedElement_2 = this.bindUniqueIdentifierToNamedElement(link.getModelFacet(), link.getUniqueIdentifier());
            _builder.append(_bindUniqueIdentifierToNamedElement_2, "\t\t");
          }
        }
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return (org.eclipse.emf.ecore.ENamedElement) elements.get(type);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _bindUniqueIdentifierToNamedElement(final GenClass it, final String id) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak);
    _builder.newLineIfNotEmpty();
    _builder.append("elements.put(");
    _builder.append(id);
    _builder.append(", ");
    CharSequence _MetaClass = this.xptMetaModel.MetaClass(it);
    _builder.append(_MetaClass);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _bindUniqueIdentifierToNamedElement(final ModelFacet it, final String id) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(((("Unsupported model facet: " + it) + " for: ") + id));
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _bindUniqueIdentifierToNamedElement(final TypeModelFacet it, final String id) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak);
    _builder.newLineIfNotEmpty();
    CharSequence _bindUniqueIdentifierToNamedElement = this.bindUniqueIdentifierToNamedElement(it.getMetaClass(), id);
    _builder.append(_bindUniqueIdentifierToNamedElement);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _bindUniqueIdentifierToNamedElement(final FeatureLinkModelFacet it, final String id) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak);
    _builder.newLineIfNotEmpty();
    _builder.append("elements.put(");
    _builder.append(id);
    _builder.append(", ");
    CharSequence _MetaFeature = this.xptMetaModel.MetaFeature(it.getMetaFeature());
    _builder.append(_MetaFeature);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence elementTypeField(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      ElementType _elementType = it.getElementType();
      boolean _notEquals = (!Objects.equal(null, _elementType));
      if (_notEquals) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static final org.eclipse.gmf.runtime.emf.type.core.IElementType ");
        String _uniqueIdentifier = it.getUniqueIdentifier();
        _builder.append(_uniqueIdentifier);
        _builder.append(" = getElementType(\"");
        String _uniqueIdentifier_1 = it.getElementType().getUniqueIdentifier();
        _builder.append(_uniqueIdentifier_1);
        _builder.append("\"); ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append(_nonNLS);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence getElementType(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private static org.eclipse.gmf.runtime.emf.type.core.IElementType getElementType(String id) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry.getInstance().getType(id);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence isKnownElementType(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static boolean isKnownElementType(org.eclipse.gmf.runtime.emf.type.core.IElementType elementType) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (KNOWN_ELEMENT_TYPES == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("KNOWN_ELEMENT_TYPES = new java.util.HashSet<org.eclipse.gmf.runtime.emf.type.core.IElementType>();");
    _builder.newLine();
    {
      List<GenCommonBase> _allTypedElements = this._utils_qvto.getAllTypedElements(it);
      for(final GenCommonBase e : _allTypedElements) {
        _builder.append("\t\t");
        CharSequence _addKnownElementType = this.addKnownElementType(e);
        _builder.append(_addKnownElementType, "\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return KNOWN_ELEMENT_TYPES.contains(elementType);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence addKnownElementType(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      ElementType _elementType = it.getElementType();
      boolean _notEquals = (!Objects.equal(null, _elementType));
      if (_notEquals) {
        _builder.append("KNOWN_ELEMENT_TYPES.add(");
        String _uniqueIdentifier = it.getUniqueIdentifier();
        _builder.append(_uniqueIdentifier);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence getElementTypeByVisualID(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static org.eclipse.gmf.runtime.emf.type.core.IElementType getElementType(int visualID) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("switch (visualID) {");
    _builder.newLine();
    {
      final Function1<GenCommonBase, Boolean> _function = new Function1<GenCommonBase, Boolean>() {
        @Override
        public Boolean apply(final GenCommonBase el) {
          ElementType _elementType = el.getElementType();
          return Boolean.valueOf((!Objects.equal(_elementType, null)));
        }
      };
      Iterable<GenCommonBase> _filter = IterableExtensions.<GenCommonBase>filter(this._utils_qvto.getAllTypedElements(it), _function);
      for(final GenCommonBase e : _filter) {
        _builder.append("\t\t");
        CharSequence _caseElementType = this.caseElementType(e);
        _builder.append(_caseElementType, "\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence caseElementType(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _caseVisualID = this.xptVisualIDRegistry.caseVisualID(it);
    _builder.append(_caseVisualID);
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return ");
    String _uniqueIdentifier = it.getUniqueIdentifier();
    _builder.append(_uniqueIdentifier, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  @MetaDef
  public CharSequence typedInstanceName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("TYPED_INSTANCE");
    return _builder;
  }
  
  @MetaDef
  public CharSequence typedInstanceCall(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    _builder.append(".");
    CharSequence _typedInstanceName = this.typedInstanceName(it);
    _builder.append(_typedInstanceName);
    return _builder;
  }
  
  public CharSequence typedInstance(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static final org.eclipse.gmf.tooling.runtime.providers.DiagramElementTypes TYPED_INSTANCE ");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("= new org.eclipse.gmf.tooling.runtime.providers.DiagramElementTypes(elementTypeImages) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _overrideC = this.xptCodeStyle.overrideC(it);
    _builder.append(_overrideC, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public boolean isKnownElementType(org.eclipse.gmf.runtime.emf.type.core.IElementType elementType) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ");
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName, "\t\t");
    _builder.append(".isKnownElementType(elementType);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _overrideC_1 = this.xptCodeStyle.overrideC(it);
    _builder.append(_overrideC_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public org.eclipse.gmf.runtime.emf.type.core.IElementType getElementTypeForVisualId(int visualID) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ");
    CharSequence _qualifiedClassName_1 = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_1, "\t\t");
    _builder.append(".getElementType(visualID);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _overrideC_2 = this.xptCodeStyle.overrideC(it);
    _builder.append(_overrideC_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public org.eclipse.emf.ecore.ENamedElement getDefiningNamedElement(org.eclipse.core.runtime.IAdaptable elementTypeAdapter) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ");
    CharSequence _qualifiedClassName_2 = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_2, "\t\t");
    _builder.append(".getElement(elementTypeAdapter);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}; ");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence additions(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence bindUniqueIdentifierToNamedElement(final EObject it, final String id) {
    if (it instanceof GenClass) {
      return _bindUniqueIdentifierToNamedElement((GenClass)it, id);
    } else if (it instanceof FeatureLinkModelFacet) {
      return _bindUniqueIdentifierToNamedElement((FeatureLinkModelFacet)it, id);
    } else if (it instanceof TypeModelFacet) {
      return _bindUniqueIdentifierToNamedElement((TypeModelFacet)it, id);
    } else if (it instanceof ModelFacet) {
      return _bindUniqueIdentifierToNamedElement((ModelFacet)it, id);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, id).toString());
    }
  }
}
