/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Artem Tikhomirov (Borland) - [257119] Create views directly, not through ViewFactories
 * 	  Michael Golubev (Montages) - #386838 - migrate to Xtend2
 */
package xpt.providers;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.LineStyle;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ColorAttributes;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ElementType;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildLabelNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExternalNodeLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.MetamodelType;
import org.eclipse.papyrus.gmf.codegen.gmfgen.NotationType;
import org.eclipse.papyrus.gmf.codegen.gmfgen.SpecializationType;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import xpt.Common;
import xpt.Common_qvto;
import xpt.diagram.Utils_qvto;
import xpt.diagram.ViewmapAttributesUtils_qvto;
import xpt.diagram.editpolicies.LinkUtils_qvto;
import xpt.diagram.views.ViewStyles;
import xpt.editor.VisualIDRegistry;

@Singleton
@SuppressWarnings("all")
public class ViewProvider {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  @Inject
  @Extension
  private LinkUtils_qvto _linkUtils_qvto;
  
  @Inject
  @Extension
  private ViewmapAttributesUtils_qvto _viewmapAttributesUtils_qvto;
  
  @Inject
  private ElementTypes xptElementTypes;
  
  @Inject
  private VisualIDRegistry xptVisualIDRegistry;
  
  @Inject
  private ViewStyles xptViewStyles;
  
  public CharSequence className(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _notationViewProviderClassName = it.getNotationViewProviderClassName();
    _builder.append(_notationViewProviderClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _providersPackageName = it.getProvidersPackageName();
    _builder.append(_providersPackageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence extendsList(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(" ");
    _builder.append("extends org.eclipse.gmf.runtime.common.core.service.AbstractProvider");
    return _builder;
  }
  
  public CharSequence implementsList(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(" ");
    _builder.append("implements org.eclipse.gmf.runtime.diagram.core.providers.IViewProvider");
    return _builder;
  }
  
  public CharSequence ViewProvider(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    CharSequence _implementsList = this.implementsList(it);
    _builder.append(_implementsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public final boolean provides(org.eclipse.gmf.runtime.common.core.service.IOperation operation) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (operation instanceof org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewForKindOperation) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return provides((org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewForKindOperation) operation);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence __assert = this._common._assert("operation instanceof org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewOperation");
    _builder.append(__assert, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("if (operation instanceof org.eclipse.gmf.runtime.diagram.core.services.view.CreateDiagramViewOperation) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return provides((org.eclipse.gmf.runtime.diagram.core.services.view.CreateDiagramViewOperation) operation);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} else if (operation instanceof org.eclipse.gmf.runtime.diagram.core.services.view.CreateEdgeViewOperation) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return provides((org.eclipse.gmf.runtime.diagram.core.services.view.CreateEdgeViewOperation) operation);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} else if (operation instanceof org.eclipse.gmf.runtime.diagram.core.services.view.CreateNodeViewOperation) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return provides((org.eclipse.gmf.runtime.diagram.core.services.view.CreateNodeViewOperation) operation);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected boolean provides(org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewForKindOperation op) {");
    _builder.newLine();
    _builder.append("/*");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (op.getViewKind() == Node.class)");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return getNodeViewClass(op.getSemanticAdapter(), op.getContainerView(), op.getSemanticHint()) != null;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (op.getViewKind() == Edge.class)");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return getEdgeViewClass(op.getSemanticAdapter(), op.getContainerView(), op.getSemanticHint()) != null;");
    _builder.newLine();
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return true;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected boolean provides(org.eclipse.gmf.runtime.diagram.core.services.view.CreateDiagramViewOperation op) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ");
    CharSequence _modelID = VisualIDRegistry.modelID(it);
    _builder.append(_modelID, "\t\t");
    _builder.append(".equals(op.getSemanticHint())");
    {
      GenClass _domainDiagramElement = it.getDomainDiagramElement();
      boolean _notEquals = (!Objects.equal(_domainDiagramElement, null));
      if (_notEquals) {
        _builder.append(" && ");
        CharSequence _diagramVisualIDMethodCall = this.xptVisualIDRegistry.getDiagramVisualIDMethodCall(it);
        _builder.append(_diagramVisualIDMethodCall, "\t\t");
        _builder.append("(getSemanticElement(op.getSemanticAdapter())) != -1");
      }
    }
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_3, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected boolean provides(org.eclipse.gmf.runtime.diagram.core.services.view.CreateNodeViewOperation op) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (op.getContainerView() == null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.IElementType elementType = getSemanticElementType(op.getSemanticAdapter());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.emf.ecore.EObject domainElement = getSemanticElement(op.getSemanticAdapter());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("int visualID;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (op.getSemanticHint() == null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// Semantic hint is not specified. Can be a result of call from CanonicalEditPolicy.");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// In this situation there should be NO elementType, visualID will be determined");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// by VisualIDRegistry.getNodeVisualID() for domainElement.");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (elementType != null || domainElement == null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("visualID = ");
    CharSequence _nodeVisualIDMethodCall = this.xptVisualIDRegistry.getNodeVisualIDMethodCall(it);
    _builder.append(_nodeVisualIDMethodCall, "\t\t\t");
    _builder.append("(op.getContainerView(), domainElement);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("visualID = ");
    CharSequence _visualIDMethodCall = this.xptVisualIDRegistry.getVisualIDMethodCall(it);
    _builder.append(_visualIDMethodCall, "\t\t\t");
    _builder.append("(op.getSemanticHint());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("if (elementType != null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("if (!");
    CharSequence _qualifiedClassName = this.xptElementTypes.qualifiedClassName(it);
    _builder.append(_qualifiedClassName, "\t\t\t\t");
    _builder.append(".isKnownElementType(elementType) || (!(elementType instanceof org.eclipse.gmf.runtime.emf.type.core.IHintedType))) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t\t");
    _builder.append("return false; // foreign element type");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("String elementTypeHint = ((org.eclipse.gmf.runtime.emf.type.core.IHintedType) elementType).getSemanticHint();");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("if (!op.getSemanticHint().equals(elementTypeHint)) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("return false; // if semantic hint is specified it should be the same as in element type");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("if (domainElement != null && visualID != ");
    CharSequence _nodeVisualIDMethodCall_1 = this.xptVisualIDRegistry.getNodeVisualIDMethodCall(it);
    _builder.append(_nodeVisualIDMethodCall_1, "\t\t\t\t");
    _builder.append("(op.getContainerView(), domainElement)) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t\t");
    _builder.append("return false; // visual id for node EClass should match visual id from element type");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("} else {");
    _builder.newLine();
    {
      final Function1<GenCommonBase, Boolean> _function = new Function1<GenCommonBase, Boolean>() {
        @Override
        public Boolean apply(final GenCommonBase e) {
          ElementType _elementType = e.getElementType();
          return Boolean.valueOf((!Objects.equal(_elementType, null)));
        }
      };
      boolean _notEmpty = this._common_qvto.<GenCommonBase>notEmpty(IterableExtensions.<GenCommonBase>filter(this._utils_qvto.getAllTypedElements(it), _function));
      if (_notEmpty) {
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("if (!");
        CharSequence _modelID_1 = VisualIDRegistry.modelID(it);
        _builder.append(_modelID_1, "\t\t\t");
        _builder.append(".equals(");
        CharSequence _modelIDMethodCall = this.xptVisualIDRegistry.getModelIDMethodCall(it);
        _builder.append(_modelIDMethodCall, "\t\t\t");
        _builder.append("(op.getContainerView()))) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("\t\t");
        _builder.append("return false; // foreign diagram");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("switch (visualID) {");
        _builder.newLine();
        {
          final Function1<GenNode, Boolean> _function_1 = new Function1<GenNode, Boolean>() {
            @Override
            public Boolean apply(final GenNode e) {
              return Boolean.valueOf(ViewProvider.this._common_qvto.oclIsKindOf(e.getElementType(), NotationType.class));
            }
          };
          boolean _exists = IterableExtensions.<GenNode>exists(it.getAllNodes(), _function_1);
          if (_exists) {
            {
              final Function1<GenNode, ElementType> _function_2 = new Function1<GenNode, ElementType>() {
                @Override
                public ElementType apply(final GenNode e) {
                  return e.getElementType();
                }
              };
              Iterable<NotationType> _filter = Iterables.<NotationType>filter(ListExtensions.<GenNode, ElementType>map(it.getAllNodes(), _function_2), NotationType.class);
              for(final NotationType e : _filter) {
                _builder.append("\t\t");
                CharSequence _localCaseVisualID = this.localCaseVisualID(e);
                _builder.append(_localCaseVisualID, "\t\t");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("break; // pure design element");
            _builder.newLine();
          }
        }
        {
          final Function1<GenNode, Boolean> _function_3 = new Function1<GenNode, Boolean>() {
            @Override
            public Boolean apply(final GenNode e) {
              return Boolean.valueOf((ViewProvider.this._common_qvto.oclIsKindOf(e.getElementType(), MetamodelType.class) || ViewProvider.this._common_qvto.oclIsKindOf(e.getElementType(), SpecializationType.class)));
            }
          };
          boolean _exists_1 = IterableExtensions.<GenNode>exists(it.getAllNodes(), _function_3);
          if (_exists_1) {
            {
              final Function1<GenNode, ElementType> _function_4 = new Function1<GenNode, ElementType>() {
                @Override
                public ElementType apply(final GenNode e) {
                  return e.getElementType();
                }
              };
              Iterable<MetamodelType> _filter_1 = Iterables.<MetamodelType>filter(ListExtensions.<GenNode, ElementType>map(it.getAllNodes(), _function_4), MetamodelType.class);
              for(final MetamodelType e_1 : _filter_1) {
                _builder.append("\t\t");
                CharSequence _localCaseVisualID_1 = this.localCaseVisualID(e_1);
                _builder.append(_localCaseVisualID_1, "\t\t");
                _builder.newLineIfNotEmpty();
              }
            }
            {
              final Function1<GenNode, ElementType> _function_5 = new Function1<GenNode, ElementType>() {
                @Override
                public ElementType apply(final GenNode e) {
                  return e.getElementType();
                }
              };
              Iterable<SpecializationType> _filter_2 = Iterables.<SpecializationType>filter(ListExtensions.<GenNode, ElementType>map(it.getAllNodes(), _function_5), SpecializationType.class);
              for(final SpecializationType e_2 : _filter_2) {
                _builder.append("\t\t");
                CharSequence _localCaseVisualID_2 = this.localCaseVisualID(e_2);
                _builder.append(_localCaseVisualID_2, "\t\t");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("if (domainElement == null || visualID != ");
            CharSequence _nodeVisualIDMethodCall_2 = this.xptVisualIDRegistry.getNodeVisualIDMethodCall(it);
            _builder.append(_nodeVisualIDMethodCall_2, "\t\t\t");
            _builder.append("(op.getContainerView(), domainElement)) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("return false; // visual id in semantic hint should match visual id for domain element");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("break;");
            _builder.newLine();
          }
        }
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("default:");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\t\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      } else {
        _builder.append("\t\t");
        _builder.append("return false;");
        _builder.newLine();
      }
    }
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ");
    {
      EList<GenNode> _allNodes = it.getAllNodes();
      boolean _hasElements = false;
      for(final GenNode n : _allNodes) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate("||", "\t\t");
        }
        CharSequence _visualID = VisualIDRegistry.visualID(n);
        _builder.append(_visualID, "\t\t");
        _builder.append(" == visualID");
      }
    }
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_4, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected boolean provides(org.eclipse.gmf.runtime.diagram.core.services.view.CreateEdgeViewOperation op) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.IElementType elementType = getSemanticElementType(op.getSemanticAdapter());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (!");
    CharSequence _qualifiedClassName_1 = this.xptElementTypes.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_1, "\t\t");
    _builder.append(".isKnownElementType(elementType) || (!(elementType instanceof org.eclipse.gmf.runtime.emf.type.core.IHintedType))) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("return false; // foreign element type");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("String elementTypeHint = ((org.eclipse.gmf.runtime.emf.type.core.IHintedType) elementType).getSemanticHint();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (elementTypeHint == null || (op.getSemanticHint() != null && !elementTypeHint.equals(op.getSemanticHint()))) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return false; // our hint is visual id and must be specified, and it should be the same as in element type");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("int visualID = ");
    CharSequence _visualIDMethodCall_1 = this.xptVisualIDRegistry.getVisualIDMethodCall(it);
    _builder.append(_visualIDMethodCall_1, "\t\t");
    _builder.append("(elementTypeHint);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("org.eclipse.emf.ecore.EObject domainElement = getSemanticElement(op.getSemanticAdapter());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (domainElement != null && visualID != ");
    CharSequence _linkWithClassVisualIDMethodCall = this.xptVisualIDRegistry.getLinkWithClassVisualIDMethodCall(it);
    _builder.append(_linkWithClassVisualIDMethodCall, "\t\t");
    _builder.append("(domainElement)) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("return false; // visual id for link EClass should match visual id from element type");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return true; ");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_5, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public org.eclipse.gmf.runtime.notation.Diagram createDiagram(org.eclipse.core.runtime.IAdaptable semanticAdapter, String diagramKind, org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint preferencesHint) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.Diagram diagram = org.eclipse.gmf.runtime.notation.NotationFactory.eINSTANCE.createDiagram();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("diagram.getStyles().add(org.eclipse.gmf.runtime.notation.NotationFactory.eINSTANCE.createDiagramStyle());");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _addCustomStyles = this.xptViewStyles.addCustomStyles(it, "diagram.getStyles()");
    _builder.append(_addCustomStyles, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("diagram.setType(");
    CharSequence _modelID_2 = VisualIDRegistry.modelID(it);
    _builder.append(_modelID_2, "\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("diagram.setElement(");
    {
      GenClass _domainDiagramElement_1 = it.getDomainDiagramElement();
      boolean _notEquals_1 = (!Objects.equal(_domainDiagramElement_1, null));
      if (_notEquals_1) {
        _builder.append("getSemanticElement(semanticAdapter)");
      } else {
        _builder.append("null");
      }
    }
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    {
      String _units = it.getUnits();
      boolean _notEquals_2 = (!Objects.equal(_units, null));
      if (_notEquals_2) {
        _builder.append("\t");
        _builder.append("diagram.setMeasurementUnit(org.eclipse.gmf.runtime.notation.MeasurementUnit.");
        String _upperCase = it.getUnits().toUpperCase();
        _builder.append(_upperCase, "\t");
        _builder.append("_LITERAL);");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      boolean _notEmpty_1 = this._common_qvto.<GenClass>notEmpty(it.getStyles());
      if (_notEmpty_1) {
        _builder.append("\t");
        _builder.append("// initializeFromPreferences");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.jface.preferences.IPreferenceStore store = (org.eclipse.jface.preferences.IPreferenceStore) preferencesHint.getPreferenceStore();");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _initializeStyles = this.initializeStyles(it, "diagram", "store", false, false, false);
        _builder.append(_initializeStyles, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t");
    _builder.append("return diagram;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_6 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_6, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public org.eclipse.gmf.runtime.notation.Node createNode(org.eclipse.core.runtime.IAdaptable semanticAdapter, org.eclipse.gmf.runtime.notation.View containerView, String semanticHint, int index, boolean persisted, org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint preferencesHint) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("final org.eclipse.emf.ecore.EObject domainElement = getSemanticElement(semanticAdapter);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("final int visualID;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (semanticHint == null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("visualID = ");
    CharSequence _nodeVisualIDMethodCall_3 = this.xptVisualIDRegistry.getNodeVisualIDMethodCall(it);
    _builder.append(_nodeVisualIDMethodCall_3, "\t\t\t");
    _builder.append("(containerView, domainElement);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("visualID = ");
    CharSequence _visualIDMethodCall_2 = this.xptVisualIDRegistry.getVisualIDMethodCall(it);
    _builder.append(_visualIDMethodCall_2, "\t\t\t");
    _builder.append("(semanticHint);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("switch(visualID) {");
    _builder.newLine();
    {
      EList<GenNode> _allNodes_1 = it.getAllNodes();
      for(final GenNode n_1 : _allNodes_1) {
        _builder.append("\t\t");
        CharSequence _caseVisualID = this.xptVisualIDRegistry.caseVisualID(n_1);
        _builder.append(_caseVisualID, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("return create");
        String _uniqueIdentifier = n_1.getUniqueIdentifier();
        _builder.append(_uniqueIdentifier, "\t\t\t");
        _builder.append("(domainElement, containerView, index, persisted, preferencesHint);");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// can\'t happen, provided #provides(CreateNodeViewOperation) is correct");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_7 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_7, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public org.eclipse.gmf.runtime.notation.Edge createEdge(org.eclipse.core.runtime.IAdaptable semanticAdapter, org.eclipse.gmf.runtime.notation.View containerView, String semanticHint, int index, boolean persisted, org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint preferencesHint) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.IElementType elementType = getSemanticElementType(semanticAdapter);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("String elementTypeHint = ((org.eclipse.gmf.runtime.emf.type.core.IHintedType) elementType).getSemanticHint();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("switch (");
    CharSequence _visualIDMethodCall_3 = this.xptVisualIDRegistry.getVisualIDMethodCall(it);
    _builder.append(_visualIDMethodCall_3, "\t\t");
    _builder.append("(elementTypeHint)) {");
    _builder.newLineIfNotEmpty();
    {
      EList<GenLink> _links = it.getLinks();
      for(final GenLink link : _links) {
        _builder.append("\t\t");
        CharSequence _caseVisualID_1 = this.xptVisualIDRegistry.caseVisualID(link);
        _builder.append(_caseVisualID_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("return create");
        String _uniqueIdentifier_1 = link.getUniqueIdentifier();
        _builder.append(_uniqueIdentifier_1, "\t\t\t");
        _builder.append("(");
        {
          boolean _isTypeLink = this._linkUtils_qvto.isTypeLink(link);
          if (_isTypeLink) {
            _builder.append(" getSemanticElement(semanticAdapter), ");
          }
        }
        _builder.append("containerView, index, persisted, preferencesHint);");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// can never happen, provided #provides(CreateEdgeViewOperation) is correct");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    {
      EList<GenNode> _allNodes_2 = it.getAllNodes();
      for(final GenNode next : _allNodes_2) {
        _builder.append("\t");
        CharSequence _createNodeMethod = this.createNodeMethod(next);
        _builder.append(_createNodeMethod, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      EList<GenLink> _links_1 = it.getLinks();
      for(final GenLink next_1 : _links_1) {
        _builder.append("\t");
        CharSequence _createEdgeMethod = this.createEdgeMethod(next_1);
        _builder.append(_createEdgeMethod, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    {
      boolean _notEmpty_2 = this._common_qvto.<GenTopLevelNode>notEmpty(it.getTopLevelNodes());
      if (_notEmpty_2) {
        _builder.append("\t");
        CharSequence _generatedMemberComment_8 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_8, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private void stampShortcut(org.eclipse.gmf.runtime.notation.View containerView, org.eclipse.gmf.runtime.notation.Node target) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("if (!");
        CharSequence _modelID_3 = VisualIDRegistry.modelID(it);
        _builder.append(_modelID_3, "\t\t");
        _builder.append(".equals(");
        CharSequence _modelIDMethodCall_1 = this.xptVisualIDRegistry.getModelIDMethodCall(it);
        _builder.append(_modelIDMethodCall_1, "\t\t");
        _builder.append("(containerView))) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t");
        Object _addShortcutAnnotation = this._common.addShortcutAnnotation(it, "target");
        _builder.append(_addShortcutAnnotation, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.newLine();
    {
      if (((this._common_qvto.<GenLinkLabel>notEmpty(Iterables.<GenLinkLabel>concat(ListExtensions.<GenLink, EList<GenLinkLabel>>map(it.getLinks(), new Function1<GenLink, EList<GenLinkLabel>>() {
        @Override
        public EList<GenLinkLabel> apply(final GenLink l) {
          return l.getLabels();
        }
      }))) || this._common_qvto.<GenNodeLabel>notEmpty(Iterables.<GenNodeLabel>concat(ListExtensions.<GenTopLevelNode, EList<GenNodeLabel>>map(it.getTopLevelNodes(), new Function1<GenTopLevelNode, EList<GenNodeLabel>>() {
        @Override
        public EList<GenNodeLabel> apply(final GenTopLevelNode n) {
          return n.getLabels();
        }
      })))) || this._common_qvto.<GenNodeLabel>notEmpty(Iterables.<GenNodeLabel>concat(ListExtensions.<GenChildNode, EList<GenNodeLabel>>map(it.getChildNodes(), new Function1<GenChildNode, EList<GenNodeLabel>>() {
        @Override
        public EList<GenNodeLabel> apply(final GenChildNode n) {
          return n.getLabels();
        }
      }))))) {
        _builder.append("\t");
        CharSequence _generatedMemberComment_9 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_9, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private org.eclipse.gmf.runtime.notation.Node createLabel(org.eclipse.gmf.runtime.notation.View owner, String hint) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.notation.DecorationNode rv = org.eclipse.gmf.runtime.notation.NotationFactory.eINSTANCE.createDecorationNode();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("rv.setType(hint);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.diagram.core.util.ViewUtil.insertChildView(owner, rv, org.eclipse.gmf.runtime.diagram.core.util.ViewUtil.APPEND, true);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("return rv;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.newLine();
    {
      final Function1<GenNode, EList<GenCompartment>> _function_6 = new Function1<GenNode, EList<GenCompartment>>() {
        @Override
        public EList<GenCompartment> apply(final GenNode n) {
          return n.getCompartments();
        }
      };
      boolean _notEmpty_3 = this._common_qvto.<GenCompartment>notEmpty(Iterables.<GenCompartment>concat(ListExtensions.<GenNode, EList<GenCompartment>>map(it.getAllNodes(), _function_6)));
      if (_notEmpty_3) {
        _builder.append("\t");
        CharSequence _generatedMemberComment_10 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_10, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private org.eclipse.gmf.runtime.notation.Node createCompartment(org.eclipse.gmf.runtime.notation.View owner, String hint, boolean canCollapse, boolean hasTitle, boolean canSort, boolean canFilter) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("//SemanticListCompartment rv = NotationFactory.eINSTANCE.createSemanticListCompartment();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("//rv.setShowTitle(showTitle);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("//rv.setCollapsed(isCollapsed);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.notation.Node rv;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("if (canCollapse) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("rv = org.eclipse.gmf.runtime.notation.NotationFactory.eINSTANCE.createBasicCompartment();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("rv = org.eclipse.gmf.runtime.notation.NotationFactory.eINSTANCE.createDecorationNode();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("if (hasTitle) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("org.eclipse.gmf.runtime.notation.TitleStyle ts = org.eclipse.gmf.runtime.notation.NotationFactory.eINSTANCE.createTitleStyle();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("ts.setShowTitle(true);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("rv.getStyles().add(ts);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("if (canSort) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("rv.getStyles().add(org.eclipse.gmf.runtime.notation.NotationFactory.eINSTANCE.createSortingStyle());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("if (canFilter) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("rv.getStyles().add(org.eclipse.gmf.runtime.notation.NotationFactory.eINSTANCE.createFilteringStyle());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("rv.setType(hint);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.diagram.core.util.ViewUtil.insertChildView(owner, rv, org.eclipse.gmf.runtime.diagram.core.util.ViewUtil.APPEND, true);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("return rv;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("\t");
    CharSequence _semanticElementMethod = this.getSemanticElementMethod(it);
    _builder.append(_semanticElementMethod, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _semanticElementTypeMethod = this.getSemanticElementTypeMethod(it);
    _builder.append(_semanticElementTypeMethod, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _createNodeMethod(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.gmf.runtime.notation.Node create");
    String _uniqueIdentifier = it.getUniqueIdentifier();
    _builder.append(_uniqueIdentifier);
    _builder.append("(org.eclipse.emf.ecore.EObject domainElement, org.eclipse.gmf.runtime.notation.View containerView, int index, boolean persisted, org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint preferencesHint) {");
    _builder.newLineIfNotEmpty();
    {
      boolean _canUseShapeStyle = this._viewmapAttributesUtils_qvto.canUseShapeStyle(it.getViewmap());
      if (_canUseShapeStyle) {
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.notation.Shape node = org.eclipse.gmf.runtime.notation.NotationFactory.eINSTANCE.createShape();");
        _builder.newLine();
      } else {
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.notation.Node node = org.eclipse.gmf.runtime.notation.NotationFactory.eINSTANCE.createNode();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("node.getStyles().add(org.eclipse.gmf.runtime.notation.NotationFactory.eINSTANCE.createDescriptionStyle());");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _addFontLineFillStylesConditionally = this.xptViewStyles.addFontLineFillStylesConditionally(it.getViewmap(), "node.getStyles()");
        _builder.append(_addFontLineFillStylesConditionally, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    CharSequence _addLinkedDiagramStyle = this.xptViewStyles.addLinkedDiagramStyle(it, "node.getStyles()");
    _builder.append(_addLinkedDiagramStyle, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _addCustomStyles = this.xptViewStyles.addCustomStyles(it, "node.getStyles()");
    _builder.append(_addCustomStyles, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("node.setLayoutConstraint(org.eclipse.gmf.runtime.notation.NotationFactory.eINSTANCE.createBounds());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("node.setType(");
    CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall(it);
    _builder.append(_typeMethodCall, "\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.core.util.ViewUtil.insertChildView(containerView, node, index, persisted);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("node.setElement(domainElement);");
    _builder.newLine();
    {
      boolean _oclIsKindOf = this._common_qvto.oclIsKindOf(it, GenTopLevelNode.class);
      if (_oclIsKindOf) {
        _builder.append("\t");
        _builder.append("stampShortcut(containerView, node);");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("// initializeFromPreferences ");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("final org.eclipse.jface.preference.IPreferenceStore prefStore = (org.eclipse.jface.preference.IPreferenceStore) preferencesHint.getPreferenceStore();");
    _builder.newLine();
    _builder.append("\t");
    boolean _isFixedForeground = this._viewmapAttributesUtils_qvto.isFixedForeground(it.getViewmap());
    boolean _not = (!_isFixedForeground);
    boolean _isFixedBackground = this._viewmapAttributesUtils_qvto.isFixedBackground(it.getViewmap());
    boolean _not_1 = (!_isFixedBackground);
    boolean _isFixedFont = this._viewmapAttributesUtils_qvto.isFixedFont(it.getViewmap());
    boolean _not_2 = (!_isFixedFont);
    CharSequence _initializeStyles = this.initializeStyles(it, "node", "prefStore", _not, _not_1, _not_2);
    _builder.append(_initializeStyles, "\t");
    _builder.newLineIfNotEmpty();
    {
      EList<GenNodeLabel> _labels = it.getLabels();
      for(final GenNodeLabel label : _labels) {
        _builder.append("\t");
        CharSequence _initLabel = this.initLabel(label, "node", "prefStore");
        _builder.append(_initLabel, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      EList<GenCompartment> _compartments = it.getCompartments();
      for(final GenCompartment comp : _compartments) {
        _builder.append("\t");
        CharSequence _initCompartment = this.initCompartment(comp, "node", "prefStore");
        _builder.append(_initCompartment, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("return node;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _createNodeMethod(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.gmf.runtime.notation.Node create");
    String _uniqueIdentifier = it.getUniqueIdentifier();
    _builder.append(_uniqueIdentifier);
    _builder.append("(org.eclipse.emf.ecore.EObject domainElement, org.eclipse.gmf.runtime.notation.View containerView, int index, boolean persisted, org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint preferencesHint) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.notation.Node node = org.eclipse.gmf.runtime.notation.NotationFactory.eINSTANCE.createNode();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("node.setLayoutConstraint(org.eclipse.gmf.runtime.notation.NotationFactory.eINSTANCE.createLocation());");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _addLinkedDiagramStyle = this.xptViewStyles.addLinkedDiagramStyle(it, "node.getStyles()");
    _builder.append(_addLinkedDiagramStyle, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _addCustomStyles = this.xptViewStyles.addCustomStyles(it, "node.getStyles()");
    _builder.append(_addCustomStyles, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("node.setType(");
    CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall(it);
    _builder.append(_typeMethodCall, "\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.core.util.ViewUtil.insertChildView(containerView, node, index, persisted);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("node.setElement(domainElement);");
    _builder.newLine();
    {
      boolean _notEmpty = this._common_qvto.<GenClass>notEmpty(it.getStyles());
      if (_notEmpty) {
        _builder.append("\t");
        _builder.append("final org.eclipse.jface.preference.IPreferenceStore prefStore = (org.eclipse.jface.preference.IPreferenceStore) preferencesHint.getPreferenceStore();");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _initializeStyles = this.initializeStyles(it, "node", "prefStore", false, false, false);
        _builder.append(_initializeStyles, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("return node;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence initializeStyles(final GenCommonBase it, final String viewVar, final String prefStoreVar, final boolean hasLineStyle, final boolean hasFillStyle, final boolean hasFontStyle) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if ((hasLineStyle || this.hasLineStyleInCustom(it))) {
        _builder.newLine();
        {
          if ((this._viewmapAttributesUtils_qvto.isFixedForeground(it.getViewmap()) || this._common_qvto.<ColorAttributes>notEmpty(Iterables.<ColorAttributes>filter(it.getViewmap().getAttributes(), ColorAttributes.class)))) {
            CharSequence _foregroundColour = this.xptViewStyles.foregroundColour(it.getViewmap(), viewVar);
            _builder.append(_foregroundColour);
            _builder.newLineIfNotEmpty();
          } else {
            CharSequence _initForegroundFromPrefs = this.initForegroundFromPrefs(it, viewVar, prefStoreVar);
            _builder.append(_initForegroundFromPrefs);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    {
      if (((hasFontStyle || this.hasFontStyleInCustom(it)) && (!this._viewmapAttributesUtils_qvto.isFixedFont(it.getViewmap())))) {
        CharSequence _initFontFromPrefs = this.initFontFromPrefs(it, viewVar, prefStoreVar);
        _builder.append(_initFontFromPrefs);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      if ((hasFillStyle || this.hasFillStyleInCustom(it))) {
        {
          if ((this._viewmapAttributesUtils_qvto.isFixedBackground(it.getViewmap()) || this._common_qvto.<ColorAttributes>notEmpty(Iterables.<ColorAttributes>filter(it.getViewmap().getAttributes(), ColorAttributes.class)))) {
            CharSequence _backgroundColour = this.xptViewStyles.backgroundColour(it.getViewmap(), viewVar);
            _builder.append(_backgroundColour);
            _builder.newLineIfNotEmpty();
          } else {
            CharSequence _initBackgroundFromPrefs = this.initBackgroundFromPrefs(it, viewVar, prefStoreVar);
            _builder.append(_initBackgroundFromPrefs);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }
  
  /**
   * FIXME check if there's need for a variable name, see initCompartment for a hint
   */
  public CharSequence initLabel(final GenLabel it, final String nodeVar, final String prefStoreVar) {
    StringConcatenation _builder = new StringConcatenation();
    int _visualID = it.getVisualID();
    String labelVar = ("label" + Integer.valueOf(_visualID));
    _builder.newLineIfNotEmpty();
    _builder.append("org.eclipse.gmf.runtime.notation.Node ");
    _builder.append(labelVar);
    _builder.append(" = createLabel(");
    _builder.append(nodeVar);
    _builder.append(", ");
    CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall(it);
    _builder.append(_typeMethodCall);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    CharSequence _addTextStyle = this.xptViewStyles.addTextStyle(it.getModelFacet(), (labelVar + ".getStyles()"));
    _builder.append(_addTextStyle);
    _builder.newLineIfNotEmpty();
    CharSequence _addCustomStyles = this.xptViewStyles.addCustomStyles(it, (labelVar + ".getStyles()"));
    _builder.append(_addCustomStyles);
    _builder.newLineIfNotEmpty();
    {
      if ((this._common_qvto.oclIsKindOf(it, GenExternalNodeLabel.class) || this._common_qvto.oclIsKindOf(it, GenLinkLabel.class))) {
        _builder.append(labelVar);
        _builder.append(".setLayoutConstraint(org.eclipse.gmf.runtime.notation.NotationFactory.eINSTANCE.createLocation());");
        _builder.newLineIfNotEmpty();
        CharSequence _offset = this.xptViewStyles.offset(it, labelVar);
        _builder.append(_offset);
        _builder.newLineIfNotEmpty();
      }
    }
    CharSequence _initializeStyles = this.initializeStyles(it, labelVar, prefStoreVar, false, false, false);
    _builder.append(_initializeStyles);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence initCompartment(final GenCompartment it, final String nodeVar, final String prefStoreVar) {
    StringConcatenation _builder = new StringConcatenation();
    int _visualID = it.getVisualID();
    String compartmentVar = ("compartment" + Integer.valueOf(_visualID));
    _builder.newLineIfNotEmpty();
    {
      if ((this._common_qvto.<GenClass>notEmpty(it.getStyles()) || this._viewmapAttributesUtils_qvto.isStoringChildPositions(it.getLayoutType()))) {
        _builder.append("org.eclipse.gmf.runtime.notation.Node ");
        _builder.append(compartmentVar);
        _builder.append(" = ");
      }
    }
    _builder.append("createCompartment(");
    _builder.append(nodeVar);
    _builder.append(", ");
    CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall(it);
    _builder.append(_typeMethodCall);
    _builder.append(", ");
    boolean _isCanCollapse = it.isCanCollapse();
    _builder.append(_isCanCollapse);
    _builder.append(", ");
    boolean _isNeedsTitle = it.isNeedsTitle();
    _builder.append(_isNeedsTitle);
    _builder.append(", ");
    boolean _isListLayout = it.isListLayout();
    _builder.append(_isListLayout);
    _builder.append(", ");
    boolean _isListLayout_1 = it.isListLayout();
    _builder.append(_isListLayout_1);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    CharSequence _addCustomStyles = this.xptViewStyles.addCustomStyles(it, (compartmentVar + ".getStyles()"));
    _builder.append(_addCustomStyles);
    _builder.newLineIfNotEmpty();
    {
      boolean _isStoringChildPositions = this._viewmapAttributesUtils_qvto.isStoringChildPositions(it.getLayoutType());
      if (_isStoringChildPositions) {
        {
          boolean _canUseShapeStyle = this._viewmapAttributesUtils_qvto.canUseShapeStyle(it.getViewmap());
          if (_canUseShapeStyle) {
            _builder.append(compartmentVar);
            _builder.append(".add(org.eclipse.gmf.runtime.notation.NotationFactory.eINSTANCE.createShapeStyle());");
            _builder.newLineIfNotEmpty();
          } else {
            CharSequence _addFontLineFillStylesConditionally = this.xptViewStyles.addFontLineFillStylesConditionally(it.getViewmap(), (compartmentVar + ".getStyles()"));
            _builder.append(_addFontLineFillStylesConditionally);
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append(compartmentVar);
        _builder.append(".setLayoutConstraint(org.eclipse.gmf.runtime.notation.NotationFactory.eINSTANCE.createBounds());");
        _builder.newLineIfNotEmpty();
        boolean _isFixedForeground = this._viewmapAttributesUtils_qvto.isFixedForeground(it.getViewmap());
        boolean _not = (!_isFixedForeground);
        boolean _isFixedBackground = this._viewmapAttributesUtils_qvto.isFixedBackground(it.getViewmap());
        boolean _not_1 = (!_isFixedBackground);
        boolean _isFixedFont = this._viewmapAttributesUtils_qvto.isFixedFont(it.getViewmap());
        boolean _not_2 = (!_isFixedFont);
        CharSequence _initializeStyles = this.initializeStyles(it, compartmentVar, prefStoreVar, _not, _not_1, _not_2);
        _builder.append(_initializeStyles);
        _builder.newLineIfNotEmpty();
      } else {
        CharSequence _initializeStyles_1 = this.initializeStyles(it, compartmentVar, prefStoreVar, false, false, false);
        _builder.append(_initializeStyles_1);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence initForegroundFromPrefs(final GenCommonBase it, final String viewVar, final String prefStoreVar) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.swt.graphics.RGB lineRGB = org.eclipse.jface.preference.PreferenceConverter.getColor(");
    _builder.append(prefStoreVar);
    _builder.append(", org.eclipse.gmf.runtime.diagram.ui.preferences.IPreferenceConstants.PREF_LINE_COLOR);");
    _builder.newLineIfNotEmpty();
    _builder.append("org.eclipse.gmf.runtime.diagram.core.util.ViewUtil.setStructuralFeatureValue(");
    _builder.append(viewVar);
    _builder.append(", org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getLineStyle_LineColor(), org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities.RGBToInteger(lineRGB));");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence initBackgroundFromPrefs(final GenCommonBase it, final String viewVar, final String prefStoreVar) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.swt.graphics.RGB fillRGB = org.eclipse.jface.preference.PreferenceConverter.getColor(");
    _builder.append(prefStoreVar);
    _builder.append(", org.eclipse.gmf.runtime.diagram.ui.preferences.IPreferenceConstants.PREF_FILL_COLOR);");
    _builder.newLineIfNotEmpty();
    _builder.append("org.eclipse.gmf.runtime.diagram.core.util.ViewUtil.setStructuralFeatureValue(");
    _builder.append(viewVar);
    _builder.append(", org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getFillStyle_FillColor(), org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities.RGBToInteger(fillRGB));");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence initFontFromPrefs(final GenCommonBase it, final String viewVar, final String prefStoreVar) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.gmf.runtime.notation.FontStyle ");
    _builder.append(viewVar);
    _builder.append("FontStyle = (org.eclipse.gmf.runtime.notation.FontStyle) ");
    _builder.append(viewVar);
    _builder.append(".getStyle(org.eclipse.gmf.runtime.notation.NotationPackage.Literals.FONT_STYLE);");
    _builder.newLineIfNotEmpty();
    _builder.append("if (");
    _builder.append(viewVar);
    _builder.append("FontStyle != null) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("org.eclipse.swt.graphics.FontData fontData = org.eclipse.jface.preference.PreferenceConverter.getFontData(");
    _builder.append(prefStoreVar, "\t");
    _builder.append(", org.eclipse.gmf.runtime.diagram.ui.preferences.IPreferenceConstants.PREF_DEFAULT_FONT);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append(viewVar, "\t");
    _builder.append("FontStyle.setFontName(fontData.getName());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append(viewVar, "\t");
    _builder.append("FontStyle.setFontHeight(fontData.getHeight());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append(viewVar, "\t");
    _builder.append("FontStyle.setBold((fontData.getStyle() & org.eclipse.swt.SWT.BOLD) != 0);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append(viewVar, "\t");
    _builder.append("FontStyle.setItalic((fontData.getStyle() & org.eclipse.swt.SWT.ITALIC) != 0);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("org.eclipse.swt.graphics.RGB fontRGB = org.eclipse.jface.preference.PreferenceConverter.getColor(");
    _builder.append(prefStoreVar, "\t");
    _builder.append(", org.eclipse.gmf.runtime.diagram.ui.preferences.IPreferenceConstants.PREF_FONT_COLOR);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append(viewVar, "\t");
    _builder.append("FontStyle.setFontColor(org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities.RGBToInteger(fontRGB).intValue());");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createEdgeMethod(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.gmf.runtime.notation.Edge create");
    String _uniqueIdentifier = it.getUniqueIdentifier();
    _builder.append(_uniqueIdentifier);
    _builder.append("(");
    {
      boolean _isTypeLink = this._linkUtils_qvto.isTypeLink(it);
      if (_isTypeLink) {
        _builder.append("org.eclipse.emf.ecore.EObject domainElement, ");
      }
    }
    _builder.append("org.eclipse.gmf.runtime.notation.View containerView, int index, boolean persisted, org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint preferencesHint) {");
    _builder.newLineIfNotEmpty();
    {
      boolean _isFixedForeground = this._viewmapAttributesUtils_qvto.isFixedForeground(it.getViewmap());
      if (_isFixedForeground) {
        _builder.append("org.eclipse.gmf.runtime.notation.Edge edge = org.eclipse.gmf.runtime.notation.NotationFactory.eINSTANCE.createEdge();");
        _builder.newLine();
        _builder.append("edge.getStyles().add(org.eclipse.gmf.runtime.notation.NotationFactory.eINSTANCE.createRoutingStyle());");
        _builder.newLine();
      } else {
        _builder.append("org.eclipse.gmf.runtime.notation.Connector edge = org.eclipse.gmf.runtime.notation.NotationFactory.eINSTANCE.createConnector();");
        _builder.newLine();
      }
    }
    {
      boolean _isFixedFont = this._viewmapAttributesUtils_qvto.isFixedFont(it.getViewmap());
      boolean _not = (!_isFixedFont);
      if (_not) {
        _builder.append("edge.getStyles().add(org.eclipse.gmf.runtime.notation.NotationFactory.eINSTANCE.createFontStyle());");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    CharSequence _addCustomStyles = this.xptViewStyles.addCustomStyles(it, "edge.getStyles()");
    _builder.append(_addCustomStyles, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.notation.RelativeBendpoints bendpoints = org.eclipse.gmf.runtime.notation.NotationFactory.eINSTANCE.createRelativeBendpoints();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("java.util.ArrayList<org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint> points = new java.util.ArrayList<org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint>(2); ");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("points.add(new org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("points.add(new org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("bendpoints.setPoints(points);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("edge.setBendpoints(bendpoints);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.core.util.ViewUtil.insertChildView(containerView, edge, index, persisted);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("edge.setType(");
    CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall(it);
    _builder.append(_typeMethodCall, "\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("edge.setElement(");
    {
      boolean _isTypeLink_1 = this._linkUtils_qvto.isTypeLink(it);
      if (_isTypeLink_1) {
        _builder.append("domainElement");
      } else {
        _builder.append("null");
      }
    }
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("// initializePreferences");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("final org.eclipse.jface.preference.IPreferenceStore prefStore = (org.eclipse.jface.preference.IPreferenceStore) preferencesHint.getPreferenceStore();");
    _builder.newLine();
    _builder.append("\t");
    boolean _isFixedForeground_1 = this._viewmapAttributesUtils_qvto.isFixedForeground(it.getViewmap());
    boolean _not_1 = (!_isFixedForeground_1);
    boolean _isFixedFont_1 = this._viewmapAttributesUtils_qvto.isFixedFont(it.getViewmap());
    boolean _not_2 = (!_isFixedFont_1);
    CharSequence _initializeStyles = this.initializeStyles(it, "edge", "prefStore", _not_1, false, _not_2);
    _builder.append(_initializeStyles, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.notation.Routing routing = org.eclipse.gmf.runtime.notation.Routing.get(prefStore.getInt(org.eclipse.gmf.runtime.diagram.ui.preferences.IPreferenceConstants.PREF_LINE_STYLE));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (routing != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.core.util.ViewUtil.setStructuralFeatureValue(edge, org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getRoutingStyle_Routing(), routing);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    {
      EList<GenLinkLabel> _labels = it.getLabels();
      for(final GenLinkLabel label : _labels) {
        _builder.append("\t");
        CharSequence _initLabel = this.initLabel(label, "edge", "prefStore");
        _builder.append(_initLabel, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("return edge;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getSemanticElementMethod(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.emf.ecore.EObject getSemanticElement(org.eclipse.core.runtime.IAdaptable semanticAdapter) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (semanticAdapter == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.emf.ecore.EObject eObject = (org.eclipse.emf.ecore.EObject) semanticAdapter.getAdapter(org.eclipse.emf.ecore.EObject.class);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (eObject != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil.resolve(org.eclipse.emf.transaction.util.TransactionUtil.getEditingDomain(eObject), eObject);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getSemanticElementTypeMethod(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.gmf.runtime.emf.type.core.IElementType getSemanticElementType(org.eclipse.core.runtime.IAdaptable semanticAdapter) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (semanticAdapter == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return (org.eclipse.gmf.runtime.emf.type.core.IElementType) semanticAdapter.getAdapter(org.eclipse.gmf.runtime.emf.type.core.IElementType.class);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence localCaseVisualID(final ElementType elementType) {
    StringConcatenation _builder = new StringConcatenation();
    {
      GenCommonBase _diagramElement = elementType.getDiagramElement();
      boolean _notEquals = (!Objects.equal(_diagramElement, null));
      if (_notEquals) {
        _builder.append("case ");
        CharSequence _visualID = VisualIDRegistry.visualID(elementType.getDiagramElement());
        _builder.append(_visualID);
        _builder.append(":");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence additions(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public boolean hasFontStyleInCustom(final GenCommonBase it) {
    return this.hasNotationStyleInCustomStyles(it, FontStyle.class);
  }
  
  public boolean hasLineStyleInCustom(final GenCommonBase it) {
    return this.hasNotationStyleInCustomStyles(it, LineStyle.class);
  }
  
  public boolean hasFillStyleInCustom(final GenCommonBase it) {
    return this.hasNotationStyleInCustomStyles(it, FillStyle.class);
  }
  
  /**
   * check if there's notation::[styleType] among diagram element's custom styles
   */
  public boolean hasNotationStyleInCustomStyles(final GenCommonBase it, final Class<? extends Style> styleType) {
    final Function1<GenClass, Boolean> _function = new Function1<GenClass, Boolean>() {
      @Override
      public Boolean apply(final GenClass s) {
        return Boolean.valueOf(ViewProvider.this._common_qvto.oclIsKindOf(s.getEcoreClass(), styleType));
      }
    };
    return IterableExtensions.<GenClass>exists(it.getStyles(), _function);
  }
  
  public CharSequence createNodeMethod(final GenNode it) {
    if (it instanceof GenChildLabelNode) {
      return _createNodeMethod((GenChildLabelNode)it);
    } else if (it != null) {
      return _createNodeMethod(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
