/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.gmfgraph;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SVGPropertyType implements Enumerator
{
    STRING(0, "STRING", "STRING"),
    COLOR(1, "COLOR", "COLOR"),
    FLOAT(2, "FLOAT", "FLOAT");

    public static final int STRING_VALUE = 0;
    public static final int COLOR_VALUE = 1;
    public static final int FLOAT_VALUE = 2;
    private static final SVGPropertyType[] VALUES_ARRAY;
    public static final List<SVGPropertyType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SVGPropertyType[]{STRING, COLOR, FLOAT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SVGPropertyType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SVGPropertyType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SVGPropertyType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SVGPropertyType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SVGPropertyType get(int value) {
        switch (value) {
            case 0: {
                return STRING;
            }
            case 1: {
                return COLOR;
            }
            case 2: {
                return FLOAT;
            }
        }
        return null;
    }

    private SVGPropertyType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

