/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.xpand.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.QVTOCompiler;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;
import org.eclipse.papyrus.gmf.internal.xpand.Activator;
import org.eclipse.papyrus.gmf.internal.xpand.ResourceManager;
import org.eclipse.papyrus.gmf.internal.xpand.model.XpandResource;
import org.eclipse.papyrus.gmf.internal.xpand.util.CompositeXpandResource;
import org.eclipse.papyrus.gmf.internal.xpand.util.ParserException;
import org.eclipse.papyrus.gmf.internal.xpand.util.XpandResourceParser;
import org.eclipse.papyrus.gmf.internal.xpand.xtend.ast.QvtFile;
import org.eclipse.papyrus.gmf.internal.xpand.xtend.ast.QvtResource;

public abstract class ResourceManagerImpl
implements ResourceManager {
    private final Map<String, XpandResource> cachedXpand = new TreeMap<String, XpandResource>();
    private final Map<String, QvtResource> cachedQvt = new TreeMap<String, QvtResource>();
    private QVTOCompiler qvtCompiler;
    private QvtCompilerOptions qvtCompilerOptions;
    private static final String ASPECT_PREFIX = "aspects::";

    @Override
    public QvtResource loadQvtResource(String fullyQualifiedName) {
        try {
            return this.loadQvtResourceThroughCache(fullyQualifiedName);
        }
        catch (FileNotFoundException ex) {
            return null;
        }
        catch (IOException e) {
            Activator.logError(e);
        }
        catch (ParserException e) {
            this.handleParserException(e);
        }
        return null;
    }

    protected QvtResource loadQvtResourceThroughCache(String qualifiedName) throws IOException, ParserException {
        if (this.hasCachedQvt(qualifiedName)) {
            return this.cachedQvt.get(qualifiedName);
        }
        QvtResource loaded = this.doLoadQvtResource(qualifiedName);
        assert (loaded != null);
        if (this.shouldCache()) {
            this.cachedQvt.put(qualifiedName, loaded);
        }
        return loaded;
    }

    private QvtResource doLoadQvtResource(String fullyQualifiedName) throws IOException, ParserException {
        String compilationUnitQName = fullyQualifiedName.replace("::", ".");
        CompiledUnit compiledUnit = null;
        try {
            UnitProxy unitProxy = this.getQVTUnitResolver().resolveUnit(compilationUnitQName);
            if (unitProxy == null) {
                throw new FileNotFoundException("Failed to resolve: " + fullyQualifiedName);
            }
            compiledUnit = this.getQvtCompiler().compile(unitProxy, this.getQvtCompilerOptions(), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (MdaException e) {
            throw new FileNotFoundException(fullyQualifiedName);
        }
        if (compiledUnit == null) {
            throw new FileNotFoundException(fullyQualifiedName);
        }
        return new QvtFile(compiledUnit, fullyQualifiedName);
    }

    protected abstract String resolveCFileFullPath(String var1, String var2);

    private QVTOCompiler getQvtCompiler() {
        if (this.qvtCompiler == null) {
            this.qvtCompiler = QVTOCompiler.createCompilerWithHistory((ResourceSet)this.getMetamodelResourceSet());
        }
        return this.qvtCompiler;
    }

    protected ResourceSet getMetamodelResourceSet() {
        return Activator.getWorkspaceMetamodelsResourceSet();
    }

    private QvtCompilerOptions getQvtCompilerOptions() {
        if (this.qvtCompilerOptions == null) {
            this.qvtCompilerOptions = new QvtCompilerOptions();
            this.qvtCompilerOptions.setGenerateCompletionData(true);
            this.qvtCompilerOptions.setShowAnnotations(false);
        }
        return this.qvtCompilerOptions;
    }

    @Override
    public XpandResource loadXpandResource(String fullyQualifiedName) {
        try {
            return this.loadXpandThroughCache(fullyQualifiedName);
        }
        catch (FileNotFoundException ex) {
            return null;
        }
        catch (IOException ex) {
            Activator.logWarn(ex.getMessage());
        }
        catch (ParserException ex) {
            this.handleParserException(ex);
        }
        return null;
    }

    protected XpandResource loadXpandThroughCache(String qualifiedName) throws IOException, ParserException {
        if (this.hasCachedXpand(qualifiedName)) {
            return this.cachedXpand.get(qualifiedName);
        }
        XpandResource loaded = this.doLoadXpandResource(qualifiedName);
        if (this.shouldCache()) {
            this.cachedXpand.put(qualifiedName, loaded);
        }
        return loaded;
    }

    private XpandResource doLoadXpandResource(String fullyQualifiedName) throws IOException, ParserException {
        Reader[] rs1 = this.resolveMultiple(fullyQualifiedName, "xpt");
        assert (rs1 != null && rs1.length > 0);
        XpandResource[] unadvised = this.loadXpandResources(rs1, fullyQualifiedName);
        XpandResource[] advices = null;
        try {
            String aspectsTemplateName = this.getAspectsTemplateName(fullyQualifiedName);
            Reader[] rs2 = this.resolveMultiple(aspectsTemplateName, "xpt");
            advices = this.loadXpandResources(rs2, aspectsTemplateName);
        }
        catch (FileNotFoundException aspectsTemplateName) {
        }
        catch (IOException ex) {
            Activator.logWarn(ex.getMessage());
        }
        catch (ParserException ex) {
            this.handleParserException(ex);
        }
        if (advices == null && unadvised.length == 1) {
            return unadvised[0];
        }
        return new CompositeXpandResource(this, unadvised, advices);
    }

    protected String getAspectsTemplateName(String fullyQualifiedName) {
        return ASPECT_PREFIX + fullyQualifiedName;
    }

    protected String getNonAspectsTemplateName(String possiblyAspectedFullyQualifiedName) {
        if (possiblyAspectedFullyQualifiedName == null) {
            return null;
        }
        if (possiblyAspectedFullyQualifiedName.startsWith(ASPECT_PREFIX)) {
            return possiblyAspectedFullyQualifiedName.substring(ASPECT_PREFIX.length());
        }
        return possiblyAspectedFullyQualifiedName;
    }

    protected abstract void handleParserException(ParserException var1);

    protected abstract Reader[] resolveMultiple(String var1, String var2) throws IOException;

    protected XpandResource[] loadXpandResources(Reader[] readers, String fullyQualifiedName) throws IOException, ParserException {
        XpandResource[] result = new XpandResource[readers.length];
        int i = 0;
        while (i < readers.length) {
            assert (readers[i] != null);
            try {
                result[i] = new XpandResourceParser().parse(readers[i], fullyQualifiedName);
                assert (result[i] != null);
            }
            finally {
                try {
                    readers[i].close();
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        return result;
    }

    protected abstract boolean shouldCache();

    protected final boolean hasCachedXpand(String fullyQualifiedName) {
        return this.shouldCache() && this.cachedXpand.containsKey(fullyQualifiedName);
    }

    protected final boolean hasCachedQvt(String fullyQualifiedName) {
        return this.shouldCache() && this.cachedQvt.containsKey(fullyQualifiedName);
    }

    protected final void forgetCachedXpand(String fullyQualifiedName) {
        this.cachedXpand.remove(fullyQualifiedName);
    }

    protected final void forgetCachedQvt(String fullyQualifiedName) {
        this.cachedQvt.remove(fullyQualifiedName);
    }

    protected final void forgetAll() {
        this.cachedXpand.clear();
        this.cachedQvt.clear();
        this.qvtCompiler = null;
    }

    protected abstract UnitResolver getQVTUnitResolver();
}

