/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.plugin.builder.nature;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddPapyrusPluginNatureHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)currentSelection;
            Iterator iter = ss.iterator();
            IAdapterManager adapterManager = Platform.getAdapterManager();
            int nbUpdatedProject = 0;
            ArrayList<String> ignoredProject = new ArrayList<String>();
            ArrayList<String> projectInError = new ArrayList<String>();
            while (iter.hasNext()) {
                Object element = iter.next();
                IResource resourceAdapter = (IResource)adapterManager.getAdapter(element, IResource.class);
                if (resourceAdapter == null) continue;
                IResource resource = resourceAdapter;
                IProject project = resource.getProject();
                if (this.canSetPapyrusPluginNature(project)) {
                    if (this.checkPluginDocumentation(project)) {
                        try {
                            IProjectDescription description = project.getDescription();
                            String[] natures = description.getNatureIds();
                            String[] newNatures = new String[natures.length + 1];
                            System.arraycopy(natures, 0, newNatures, 0, natures.length);
                            newNatures[natures.length] = "org.eclipse.papyrus.plugin.nature";
                            IWorkspace workspace = ResourcesPlugin.getWorkspace();
                            IStatus status = workspace.validateNatureSet(newNatures);
                            if (status.getSeverity() == 0 || status.getSeverity() == 2) {
                                description.setNatureIds(newNatures);
                                project.setDescription(description, null);
                                ++nbUpdatedProject;
                                continue;
                            }
                            projectInError.add(project.getName());
                        }
                        catch (CoreException e) {
                            NLS.bind((String)"Project {0} has not been updated, due to an exception:\n {1}", (Object)project.getName(), (Object)((Object)e));
                            projectInError.add(project.getName());
                        }
                        continue;
                    }
                    ignoredProject.add(project.getName());
                    continue;
                }
                ignoredProject.add(project.getName());
            }
            StringBuilder message = new StringBuilder();
            message.append(NLS.bind((String)"{0} projects have been successfully updated.\n", (Object)nbUpdatedProject));
            StringBuilder ignoredProjectMessage = new StringBuilder();
            ignoredProjectMessage.append(NLS.bind((String)"{0} projects have been ignored:\n", (Object)ignoredProject.size()));
            Iterator ignoredProjectIter = ignoredProject.iterator();
            while (ignoredProjectIter.hasNext()) {
                ignoredProjectMessage.append("  ");
                ignoredProjectMessage.append((String)ignoredProjectIter.next());
                if (!ignoredProjectIter.hasNext()) continue;
                ignoredProjectMessage.append("\n");
            }
            StringBuilder errorProjectMessage = new StringBuilder();
            errorProjectMessage.append(NLS.bind((String)"{0} projects generate error :\n", (Object)projectInError.size()));
            Iterator errorProjectIter = projectInError.iterator();
            while (errorProjectIter.hasNext()) {
                errorProjectMessage.append("  ");
                errorProjectMessage.append((String)errorProjectIter.next());
                if (!errorProjectIter.hasNext()) continue;
                errorProjectMessage.append("\n");
            }
            message.append(ignoredProjectMessage.toString());
            message.append("\n");
            message.append(errorProjectMessage.toString());
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Apply Papyrus nature", (String)message.toString());
        }
        return Status.OK_STATUS;
    }

    public void setEnabled(Object evaluationContext) {
        boolean isEnable = false;
        Object tmpSelection = HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        if (tmpSelection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)tmpSelection;
            Iterator iter = ss.iterator();
            IAdapterManager adapterManager = Platform.getAdapterManager();
            while (iter.hasNext() && !isEnable) {
                Object current = iter.next();
                IResource resource = (IResource)adapterManager.getAdapter(current, IResource.class);
                IProject project = resource.getProject();
                isEnable = this.canSetPapyrusPluginNature(project);
            }
        }
        this.setBaseEnabled(isEnable);
    }

    private boolean canSetPapyrusPluginNature(IProject project) {
        boolean canSet = false;
        if (project.exists() && project.isOpen() && project.getName().startsWith("org.eclipse.papyrus")) {
            try {
                canSet = project.hasNature("org.eclipse.jdt.core.javanature") && project.hasNature("org.eclipse.pde.PluginNature") && !project.hasNature("org.eclipse.papyrus.plugin.nature");
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return canSet;
    }

    protected boolean checkPluginDocumentation(IProject project) {
        if (project.getName().endsWith(".doc")) {
            boolean result = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)"Apply Papyrus Plugin Project Nature", (String)NLS.bind((String)"Do you really want to apply the Papyrus Plugin Nature to ''{0}''? It seems to be a documentation plugin...", (Object)project.getName()));
            return result;
        }
        return true;
    }
}

