/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.quickfix;

import java.io.IOException;
import java.util.Optional;
import java.util.function.BiFunction;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.toolsmiths.validation.common.Activator;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.AbstractPapyrusWorkbenchMarkerResolution;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.CommonMarkerResolutionUtils;

public class SimpleModelEditMarkerResolution<T extends EObject>
extends AbstractPapyrusWorkbenchMarkerResolution {
    private final String label;
    private final String description;
    private final Class<T> type;
    private final BiFunction<? super EditingDomain, ? super T, ? extends Command> commandFunction;

    protected SimpleModelEditMarkerResolution(int problemID, String label, String description, Class<T> type, BiFunction<? super EditingDomain, ? super T, ? extends Command> commandFunction) {
        super(problemID);
        this.label = label;
        this.description = description;
        this.type = type;
        this.commandFunction = commandFunction;
    }

    public static <T extends EObject> SimpleModelEditMarkerResolution<T> create(int problemID, String label, String description, Class<T> type, BiFunction<? super EditingDomain, ? super T, ? extends Command> commandFunction) {
        return new SimpleModelEditMarkerResolution<T>(problemID, label, description, type, commandFunction);
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public void run(IMarker marker) {
        Optional<EditingDomain> openDomain = CommonMarkerResolutionUtils.getOpenEditingDomain(marker);
        EditingDomain domain = openDomain.orElseGet(() -> new AdapterFactoryEditingDomain((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE), (CommandStack)new BasicCommandStack()));
        try {
            CommonMarkerResolutionUtils.getModelObject(marker, this.type, domain).ifPresent(object -> {
                Command command = this.commandFunction.apply((EditingDomain)((EditingDomain)domain), (EditingDomain)object);
                if (command != null) {
                    domain.getCommandStack().execute(command);
                }
            });
        }
        finally {
            if (openDomain.isEmpty()) {
                ResourceSet rset = domain.getResourceSet();
                if (!rset.getResources().isEmpty()) {
                    try {
                        ((Resource)rset.getResources().get(0)).save(null);
                    }
                    catch (IOException e) {
                        Activator.log.error("Failed to save marker resolution.", (Throwable)e);
                    }
                }
                EMFHelper.unload((ResourceSet)domain.getResourceSet());
                ((ComposedAdapterFactory)((AdapterFactoryEditingDomain)domain).getAdapterFactory()).dispose();
            }
        }
    }
}

