/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.internal;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.infra.properties.internal.InfraPropertiesPlugin;

public class ContextExtensionPoint {
    private static final String IS_CUSTOMIZABLE = "isCustomizable";
    private static final String APPLIED_BY_DEFAULT = "appliedByDefault";
    private static final String CONTEXT_MODEL = "contextModel";
    private static final String CONTEXT = "context";
    private final String EXTENSION_ID = "org.eclipse.papyrus.infra.properties.contexts";

    public ContextExtensionPoint(ModelConsumer modelAcceptor) {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.properties.contexts");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                switch (e.getName()) {
                    case "context": {
                        this.processContext(e, modelAcceptor);
                    }
                }
            }
            catch (IOException ex) {
                InfraPropertiesPlugin.LOG.error("The plugin " + e.getContributor() + " contributed an invalid extension for " + "org.eclipse.papyrus.infra.properties.contexts", (Throwable)ex);
            }
            catch (Exception ex) {
                InfraPropertiesPlugin.LOG.error((Throwable)ex);
            }
            ++n2;
        }
    }

    private void processContext(IConfigurationElement e, ModelConsumer modelAcceptor) throws IOException {
        String contextResource = e.getAttribute(CONTEXT_MODEL);
        boolean isCustomizable = Arrays.asList(e.getAttributeNames()).contains(IS_CUSTOMIZABLE) ? Boolean.parseBoolean(e.getAttribute(IS_CUSTOMIZABLE)) : true;
        boolean appliedByDefault = Arrays.asList(e.getAttributeNames()).contains(APPLIED_BY_DEFAULT) ? Boolean.parseBoolean(e.getAttribute(APPLIED_BY_DEFAULT)) : true;
        URI uri = URI.createURI((String)("ppe:/context/" + e.getContributor().getName() + "/" + contextResource));
        modelAcceptor.accept(uri, appliedByDefault, isCustomizable);
    }

    @FunctionalInterface
    public static interface ModelConsumer {
        public void accept(URI var1, boolean var2, boolean var3) throws IOException;
    }
}

