/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.adt.barcode2;

import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.impl.adt.barcode2.BciiNode;
import ca.odell.glazedlists.impl.adt.barcode2.Element;
import ca.odell.glazedlists.impl.adt.barcode2.ListToByteCoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BciiTree<T0, T1> {
    private final ListToByteCoder coder;
    private BciiNode<T0, T1> root = null;
    private final List<BciiNode<T0, T1>> zeroQueue = new ArrayList<BciiNode<T0, T1>>();
    private final Comparator<? super T0> comparator;

    public BciiTree(ListToByteCoder coder, Comparator<? super T0> comparator) {
        if (coder == null) {
            throw new NullPointerException("Coder cannot be null.");
        }
        if (comparator == null) {
            throw new NullPointerException("Comparator cannot be null.");
        }
        this.coder = coder;
        this.comparator = comparator;
    }

    public BciiTree(ListToByteCoder coder) {
        this(coder, GlazedLists.comparableComparator());
    }

    public ListToByteCoder getCoder() {
        return this.coder;
    }

    public Comparator<? super T0> getComparator() {
        return this.comparator;
    }

    public Element<T0> get(int index, byte indexColors) {
        if (this.root == null) {
            throw new IndexOutOfBoundsException();
        }
        BciiNode<T0, T1> node = this.root;
        while (true) {
            int leftSize;
            assert (node != null);
            assert (index >= 0);
            BciiNode nodeLeft = node.left;
            int n = leftSize = nodeLeft != null ? nodeLeft.size(indexColors) : 0;
            if (index < leftSize) {
                node = nodeLeft;
                continue;
            }
            int size = node.nodeSize(indexColors);
            if ((index -= leftSize) < size) {
                return node;
            }
            index -= size;
            node = node.right;
        }
    }

    public Element<T0> add(int index, byte indexColors, byte color, T0 value, int size) {
        assert (index >= 0);
        assert (index <= this.size(indexColors));
        assert (size >= 0);
        if (this.root == null) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            this.root = new BciiNode(color, size, value, null);
            assert (this.valid());
            return this.root;
        }
        BciiNode<T0, T1> inserted = this.insertIntoSubtree(this.root, index, indexColors, color, value, size);
        assert (this.valid());
        return inserted;
    }

    private BciiNode<T0, T1> insertIntoSubtree(BciiNode<T0, T1> parent, int index, byte indexColors, byte color, T0 value, int size) {
        while (true) {
            assert (parent != null);
            assert (index >= 0);
            BciiNode parentLeft = parent.left;
            int parentLeftSize = parentLeft != null ? parentLeft.size(indexColors) : 0;
            int parentRightStartIndex = parentLeftSize + parent.nodeSize(indexColors);
            if (color == parent.color && value == parent.t0 && value != null && index >= parentLeftSize && index <= parentRightStartIndex) {
                parent.size += size;
                this.fixCountsThruRoot(parent, color, size);
                return parent;
            }
            if (index <= parentLeftSize) {
                if (parentLeft == null) {
                    BciiNode<T0, T1> inserted = new BciiNode<T0, T1>(color, size, value, parent);
                    parent.left = inserted;
                    this.fixCountsThruRoot(parent, color, size);
                    this.fixHeightPostChange(parent, false);
                    return inserted;
                }
                parent = parentLeft;
                continue;
            }
            if (index < parentRightStartIndex) {
                int parentRightHalfSize = parentRightStartIndex - index;
                parent.size -= parentRightHalfSize;
                this.fixCountsThruRoot(parent, parent.color, -parentRightHalfSize);
                BciiNode<Object, T1> inserted = this.insertIntoSubtree(parent, index, indexColors, parent.color, null, parentRightHalfSize);
                inserted.set(parent.t0);
                parentRightStartIndex = parentLeftSize + parent.nodeSize(indexColors);
            }
            int parentSize = parent.size(indexColors);
            assert (index <= parentSize);
            BciiNode parentRight = parent.right;
            if (parentRight == null) {
                BciiNode<T0, T1> inserted = new BciiNode<T0, T1>(color, size, value, parent);
                parent.right = inserted;
                this.fixCountsThruRoot(parent, color, size);
                this.fixHeightPostChange(parent, false);
                return inserted;
            }
            parent = parentRight;
            index -= parentRightStartIndex;
        }
    }

    public Element<T0> addInSortedOrder(byte color, T0 value, int size) {
        assert (size >= 0);
        if (this.root == null) {
            this.root = new BciiNode(color, size, value, null);
            assert (this.valid());
            return this.root;
        }
        BciiNode<T0, T1> inserted = this.insertIntoSubtreeInSortedOrder(this.root, color, value, size);
        assert (this.valid());
        return inserted;
    }

    private BciiNode<T0, T1> insertIntoSubtreeInSortedOrder(BciiNode<T0, T1> parent, byte color, T0 value, int size) {
        while (true) {
            int sortSide;
            assert (parent != null);
            BciiNode<T0, T1> currentFollower = parent;
            while (true) {
                if (currentFollower == null) {
                    sortSide = -1;
                    break;
                }
                if (currentFollower.sorted == 0) {
                    sortSide = this.comparator.compare(value, currentFollower.t0);
                    break;
                }
                currentFollower = BciiTree.next(currentFollower);
            }
            if (sortSide == 0 && color == parent.color && value == parent.t0 && value != null) {
                parent.size += size;
                this.fixCountsThruRoot(parent, color, size);
                return parent;
            }
            boolean insertOnLeft = false;
            insertOnLeft = insertOnLeft || sortSide < 0;
            insertOnLeft = insertOnLeft || sortSide == 0 && parent.left == null;
            boolean bl = insertOnLeft = insertOnLeft || sortSide == 0 && parent.right != null && parent.left.height < parent.right.height;
            if (insertOnLeft) {
                BciiNode parentLeft = parent.left;
                if (parentLeft == null) {
                    BciiNode<T0, T1> inserted = new BciiNode<T0, T1>(color, size, value, parent);
                    parent.left = inserted;
                    this.fixCountsThruRoot(parent, color, size);
                    this.fixHeightPostChange(parent, false);
                    return inserted;
                }
                parent = parentLeft;
                continue;
            }
            BciiNode parentRight = parent.right;
            if (parentRight == null) {
                BciiNode<T0, T1> inserted = new BciiNode<T0, T1>(color, size, value, parent);
                parent.right = inserted;
                this.fixCountsThruRoot(parent, color, size);
                this.fixHeightPostChange(parent, false);
                return inserted;
            }
            parent = parentRight;
        }
    }

    private final void fixCountsThruRoot(BciiNode<T0, T1> node, byte color, int delta) {
        if (color == 1) {
            while (node != null) {
                node.count1 += delta;
                node = node.parent;
            }
        }
        if (color == 2) {
            while (node != null) {
                node.count2 += delta;
                node = node.parent;
            }
        }
        if (color == 4) {
            while (node != null) {
                node.count4 += delta;
                node = node.parent;
            }
        }
    }

    public final void setColor(Element<T0> element, byte color) {
        BciiNode node = (BciiNode)element;
        byte oldColor = node.getColor();
        if (oldColor == color) {
            return;
        }
        this.fixCountsThruRoot(node, oldColor, -node.size);
        node.color = color;
        this.fixCountsThruRoot(node, color, node.size);
    }

    private final void fixHeightPostChange(BciiNode<T0, T1> node, boolean allTheWayToRoot) {
        while (node != null) {
            byte rightHeight;
            byte leftHeight = node.left != null ? node.left.height : (byte)0;
            byte by = rightHeight = node.right != null ? node.right.height : (byte)0;
            if (leftHeight > rightHeight && leftHeight - rightHeight == 2) {
                byte leftRightHeight;
                byte leftLeftHeight = node.left.left != null ? node.left.left.height : (byte)0;
                byte by2 = leftRightHeight = node.left.right != null ? node.left.right.height : (byte)0;
                if (leftRightHeight > leftLeftHeight) {
                    this.rotateRight(node.left);
                }
                node = this.rotateLeft(node);
            } else if (rightHeight > leftHeight && rightHeight - leftHeight == 2) {
                byte rightRightHeight;
                byte rightLeftHeight = node.right.left != null ? node.right.left.height : (byte)0;
                byte by3 = rightRightHeight = node.right.right != null ? node.right.right.height : (byte)0;
                if (rightLeftHeight > rightRightHeight) {
                    this.rotateLeft(node.right);
                }
                node = this.rotateRight(node);
            }
            leftHeight = node.left != null ? node.left.height : (byte)0;
            rightHeight = node.right != null ? node.right.height : (byte)0;
            byte newNodeHeight = (byte)(Math.max(leftHeight, rightHeight) + 1);
            if (!allTheWayToRoot && node.height == newNodeHeight) {
                return;
            }
            node.height = newNodeHeight;
            node = node.parent;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final BciiNode<T0, T1> rotateLeft(BciiNode<T0, T1> subtreeRoot) {
        assert (subtreeRoot.left != null);
        BciiNode newSubtreeRoot = subtreeRoot.left;
        subtreeRoot.left = newSubtreeRoot.right;
        if (newSubtreeRoot.right != null) {
            newSubtreeRoot.right.parent = subtreeRoot;
        }
        newSubtreeRoot.parent = subtreeRoot.parent;
        if (newSubtreeRoot.parent != null) {
            if (newSubtreeRoot.parent.left == subtreeRoot) {
                newSubtreeRoot.parent.left = newSubtreeRoot;
            } else {
                if (newSubtreeRoot.parent.right != subtreeRoot) throw new IllegalStateException();
                newSubtreeRoot.parent.right = newSubtreeRoot;
            }
        } else {
            this.root = newSubtreeRoot;
        }
        newSubtreeRoot.right = subtreeRoot;
        subtreeRoot.parent = newSubtreeRoot;
        byte subtreeRootLeftHeight = subtreeRoot.left != null ? subtreeRoot.left.height : (byte)0;
        byte subtreeRootRightHeight = subtreeRoot.right != null ? subtreeRoot.right.height : (byte)0;
        subtreeRoot.height = (byte)(Math.max(subtreeRootLeftHeight, subtreeRootRightHeight) + 1);
        subtreeRoot.refreshCounts();
        byte newSubtreeRootLeftHeight = newSubtreeRoot.left != null ? newSubtreeRoot.left.height : (byte)0;
        byte newSubtreeRootRightHeight = newSubtreeRoot.right != null ? newSubtreeRoot.right.height : (byte)0;
        newSubtreeRoot.height = (byte)(Math.max(newSubtreeRootLeftHeight, newSubtreeRootRightHeight) + 1);
        newSubtreeRoot.refreshCounts();
        return newSubtreeRoot;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final BciiNode<T0, T1> rotateRight(BciiNode<T0, T1> subtreeRoot) {
        assert (subtreeRoot.right != null);
        BciiNode newSubtreeRoot = subtreeRoot.right;
        subtreeRoot.right = newSubtreeRoot.left;
        if (newSubtreeRoot.left != null) {
            newSubtreeRoot.left.parent = subtreeRoot;
        }
        newSubtreeRoot.parent = subtreeRoot.parent;
        if (newSubtreeRoot.parent != null) {
            if (newSubtreeRoot.parent.left == subtreeRoot) {
                newSubtreeRoot.parent.left = newSubtreeRoot;
            } else {
                if (newSubtreeRoot.parent.right != subtreeRoot) throw new IllegalStateException();
                newSubtreeRoot.parent.right = newSubtreeRoot;
            }
        } else {
            this.root = newSubtreeRoot;
        }
        newSubtreeRoot.left = subtreeRoot;
        subtreeRoot.parent = newSubtreeRoot;
        byte subtreeRootLeftHeight = subtreeRoot.left != null ? subtreeRoot.left.height : (byte)0;
        byte subtreeRootRightHeight = subtreeRoot.right != null ? subtreeRoot.right.height : (byte)0;
        subtreeRoot.height = (byte)(Math.max(subtreeRootLeftHeight, subtreeRootRightHeight) + 1);
        subtreeRoot.refreshCounts();
        byte newSubtreeRootLeftHeight = newSubtreeRoot.left != null ? newSubtreeRoot.left.height : (byte)0;
        byte newSubtreeRootRightHeight = newSubtreeRoot.right != null ? newSubtreeRoot.right.height : (byte)0;
        newSubtreeRoot.height = (byte)(Math.max(newSubtreeRootLeftHeight, newSubtreeRootRightHeight) + 1);
        newSubtreeRoot.refreshCounts();
        return newSubtreeRoot;
    }

    public void remove(Element<T0> element) {
        BciiNode node = (BciiNode)element;
        assert (node.size > 0);
        assert (this.root != null);
        this.fixCountsThruRoot(node, node.color, -node.size);
        node.size = 0;
        this.zeroQueue.add(node);
        this.drainZeroQueue();
        assert (this.valid());
    }

    public void remove(int index, byte indexColors, int size) {
        if (size == 0) {
            return;
        }
        assert (index >= 0);
        assert (index + size <= this.size(indexColors));
        assert (this.root != null);
        this.removeFromSubtree(this.root, index, indexColors, size);
        this.drainZeroQueue();
        assert (this.valid());
    }

    private void drainZeroQueue() {
        int size = this.zeroQueue.size();
        for (int i = 0; i < size; ++i) {
            BciiNode<T0, T1> node = this.zeroQueue.get(i);
            assert (node.size == 0);
            if (node.right == null) {
                this.replaceChild(node, node.left);
                continue;
            }
            if (node.left == null) {
                this.replaceChild(node, node.right);
                continue;
            }
            BciiNode<T0, T1> bciiNode = this.replaceEmptyNodeWithChild(node);
        }
        this.zeroQueue.clear();
    }

    private void removeFromSubtree(BciiNode<T0, T1> node, int index, byte indexColors, int size) {
        while (size > 0) {
            int leftSize;
            assert (node != null);
            assert (index >= 0);
            BciiNode nodeLeft = node.left;
            int n = leftSize = nodeLeft != null ? nodeLeft.size(indexColors) : 0;
            if (index < leftSize) {
                if (index + size > leftSize) {
                    int toRemove = leftSize - index;
                    this.removeFromSubtree(nodeLeft, index, indexColors, toRemove);
                    size -= toRemove;
                    leftSize -= toRemove;
                } else {
                    node = nodeLeft;
                    continue;
                }
            }
            assert (index >= leftSize);
            int rightStartIndex = leftSize + node.nodeSize(indexColors);
            if (index < rightStartIndex) {
                int toRemove = Math.min(rightStartIndex - index, size);
                node.size -= toRemove;
                size -= toRemove;
                rightStartIndex -= toRemove;
                this.fixCountsThruRoot(node, node.color, -toRemove);
                if (node.size == 0) {
                    this.zeroQueue.add(node);
                }
                if (size == 0) {
                    return;
                }
            }
            assert (index >= rightStartIndex);
            index -= rightStartIndex;
            node = node.right;
        }
    }

    private void replaceChild(BciiNode<T0, T1> node, BciiNode<T0, T1> replacement) {
        BciiNode nodeParent = node.parent;
        if (nodeParent == null) {
            assert (node == this.root);
            this.root = replacement;
        } else if (nodeParent.left == node) {
            nodeParent.left = replacement;
        } else if (nodeParent.right == node) {
            nodeParent.right = replacement;
        }
        if (replacement != null) {
            replacement.parent = nodeParent;
        }
        this.fixHeightPostChange(nodeParent, true);
    }

    private BciiNode<T0, T1> replaceEmptyNodeWithChild(BciiNode<T0, T1> toReplace) {
        assert (toReplace.size == 0);
        assert (toReplace.left != null);
        assert (toReplace.right != null);
        BciiNode replacement = toReplace.left;
        while (replacement.right != null) {
            replacement = replacement.right;
        }
        assert (replacement.right == null);
        this.fixCountsThruRoot(replacement, replacement.color, -replacement.size);
        this.replaceChild(replacement, replacement.left);
        replacement.left = toReplace.left;
        if (replacement.left != null) {
            replacement.left.parent = replacement;
        }
        replacement.right = toReplace.right;
        if (replacement.right != null) {
            replacement.right.parent = replacement;
        }
        replacement.height = toReplace.height;
        replacement.refreshCounts();
        this.replaceChild(toReplace, replacement);
        this.fixCountsThruRoot(replacement.parent, replacement.color, replacement.size);
        return replacement;
    }

    public Element<T0> set(int index, byte indexColors, byte color, T0 value, int size) {
        this.remove(index, indexColors, size);
        return this.add(index, indexColors, color, value, size);
    }

    public void clear() {
        this.root = null;
    }

    public int indexOfNode(Element<T0> element, byte colorsOut) {
        int index;
        BciiNode node = (BciiNode)element;
        int n = index = node.left != null ? node.left.size(colorsOut) : 0;
        while (node.parent != null) {
            if (node.parent.right == node) {
                index += node.parent.left != null ? node.parent.left.size(colorsOut) : 0;
                index += node.parent.nodeSize(colorsOut);
            }
            node = node.parent;
        }
        return index;
    }

    public int indexOfValue(T0 element, boolean firstIndex, boolean simulated, byte colorsOut) {
        int result = 0;
        boolean found = false;
        BciiNode<T0, T1> node = this.root;
        while (true) {
            if (node == null) {
                if (found && !firstIndex) {
                    --result;
                }
                if (found || simulated) {
                    return result;
                }
                return -1;
            }
            int comparison = this.comparator.compare(element, node.get());
            if (comparison < 0) {
                node = node.left;
                continue;
            }
            BciiNode nodeLeft = node.left;
            if (comparison == 0) {
                found = true;
                if (firstIndex) {
                    node = nodeLeft;
                    continue;
                }
            }
            result += nodeLeft != null ? nodeLeft.size(colorsOut) : 0;
            result += node.nodeSize(colorsOut);
            node = node.right;
        }
    }

    public int convertIndexColor(int index, byte indexColors, byte colorsOut) {
        if (this.root == null) {
            if (index == 0) {
                return 0;
            }
            throw new IndexOutOfBoundsException();
        }
        int result = 0;
        BciiNode<T0, T1> node = this.root;
        while (true) {
            int size;
            int leftSize;
            assert (node != null);
            assert (index >= 0);
            BciiNode nodeLeft = node.left;
            int n = leftSize = nodeLeft != null ? nodeLeft.size(indexColors) : 0;
            if (index < leftSize) {
                node = nodeLeft;
                continue;
            }
            if (nodeLeft != null) {
                result += nodeLeft.size(colorsOut);
            }
            if ((index -= leftSize) < (size = node.nodeSize(indexColors))) {
                result = (colorsOut & node.color) > 0 ? (result += index) : --result;
                return result;
            }
            result += node.nodeSize(colorsOut);
            index -= size;
            node = node.right;
        }
    }

    public int size(byte colors) {
        if (this.root == null) {
            return 0;
        }
        return this.root.size(colors);
    }

    public String toString() {
        if (this.root == null) {
            return "";
        }
        return this.root.toString(this.coder.getColors());
    }

    public String asSequenceOfColors() {
        if (this.root == null) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        BciiNode<T0, T1> n = this.firstNode();
        while (n != null) {
            Object color = this.coder.getColors().get(BciiTree.colorAsIndex(n.color));
            for (int i = 0; i < n.size; ++i) {
                result.append(color);
            }
            n = BciiTree.next(n);
        }
        return result.toString();
    }

    public static <T0, T1> BciiNode<T0, T1> next(BciiNode<T0, T1> node) {
        if (node.right != null) {
            BciiNode child = node.right;
            while (child.left != null) {
                child = child.left;
            }
            return child;
        }
        BciiNode<T0, T1> ancestor = node;
        while (ancestor.parent != null && ancestor.parent.right == ancestor) {
            ancestor = ancestor.parent;
        }
        return ancestor.parent;
    }

    public static <T0, T1> BciiNode<T0, T1> previous(BciiNode<T0, T1> node) {
        if (node.left != null) {
            BciiNode child = node.left;
            while (child.right != null) {
                child = child.right;
            }
            return child;
        }
        BciiNode<T0, T1> ancestor = node;
        while (ancestor.parent != null && ancestor.parent.left == ancestor) {
            ancestor = ancestor.parent;
        }
        return ancestor.parent;
    }

    BciiNode<T0, T1> firstNode() {
        if (this.root == null) {
            return null;
        }
        BciiNode<T0, T1> result = this.root;
        while (result.left != null) {
            result = result.left;
        }
        return result;
    }

    private boolean valid() {
        BciiNode<T0, T1> node = this.firstNode();
        while (node != null) {
            byte rightHeight;
            int originalCount1 = node.count1;
            int originalCount2 = node.count2;
            int originalCount4 = node.count4;
            node.refreshCounts();
            assert (originalCount1 == node.count1) : "Incorrect count 1 on node: \n" + node + "\n Expected " + node.count1 + " but was " + originalCount1;
            assert (originalCount2 == node.count2) : "Incorrect count 2 on node: \n" + node + "\n Expected " + node.count2 + " but was " + originalCount2;
            assert (originalCount4 == node.count4) : "Incorrect count 4 on node: \n" + node + "\n Expected " + node.count4 + " but was " + originalCount4;
            byte leftHeight = node.left != null ? node.left.height : (byte)0;
            byte by = rightHeight = node.right != null ? node.right.height : (byte)0;
            assert (Math.max(leftHeight, rightHeight) + 1 == node.height);
            assert (node.left == null || node.left.parent == node);
            assert (node.right == null || node.right.parent == node);
            assert (Math.abs(leftHeight - rightHeight) < 2) : "Subtree is not AVL: \n" + node;
            node = BciiTree.next(node);
        }
        return true;
    }

    static final int colorAsIndex(byte color) {
        switch (color) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 3;
            }
            case 16: {
                return 4;
            }
            case 32: {
                return 5;
            }
            case 64: {
                return 6;
            }
        }
        throw new IllegalArgumentException();
    }
}

