/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.edit.internal.advice;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.papyrus.infra.services.markerlistener.providers.IMarkerProvider;
import org.eclipse.papyrus.infra.services.markerlistener.providers.IMarkerProvider2;
import org.eclipse.papyrus.infra.services.markerlistener.providers.MarkerProviderRegistry;

public class MarkerDeletionAdvice
extends AbstractEditHelperAdvice {
    private static final String EDIT_POLICY_COMMAND = "edit policy command";

    protected ICommand getBeforeDestroyElementCommand(DestroyElementRequest request) {
        EObject object;
        Resource context;
        DeleteMarkersCommand result = null;
        if (request.getParameter(EDIT_POLICY_COMMAND) == null && (context = (object = request.getElementToDestroy()).eResource()) != null) {
            for (IMarkerProvider provider : MarkerProviderRegistry.INSTANCE.getMarkerProviders(context)) {
                if (!IMarkerProvider2.Adapter.getExtendedProvider((IMarkerProvider)provider).hasMarkers(context, object)) continue;
                result = new DeleteMarkersCommand(object);
                break;
            }
        }
        return result;
    }

    private static class DeleteMarkersCommand
    extends AbstractCommand {
        private Resource context;
        private EObject object;
        private ICommand delegate;

        DeleteMarkersCommand(EObject object) {
            super("Delete markers");
            this.context = object.eResource();
            this.object = object;
        }

        public void dispose() {
            this.disposeDelegate();
            this.context = null;
            this.object = null;
            super.dispose();
        }

        void disposeDelegate() {
            if (this.delegate != null) {
                this.delegate.dispose();
                this.delegate = null;
            }
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            this.disposeDelegate();
            IdentityCommand command = null;
            for (IMarkerProvider provider : MarkerProviderRegistry.INSTANCE.getMarkerProviders(this.context)) {
                ICommand nextCommand = IMarkerProvider2.Adapter.getExtendedProvider((IMarkerProvider)provider).getMarkerDeletionCommand(this.context, this.object);
                if (command == null) {
                    command = nextCommand;
                    continue;
                }
                if (nextCommand == null) continue;
                command = command.compose((IUndoableOperation)nextCommand);
            }
            this.delegate = command != null ? command : IdentityCommand.INSTANCE;
            return this.convertResult(this.delegate.execute(progressMonitor, info));
        }

        public boolean canUndo() {
            return this.delegate == null || this.delegate.canUndo();
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            return this.delegate != null ? this.convertResult(this.delegate.undo(progressMonitor, info)) : CommandResult.newOKCommandResult();
        }

        public boolean canRedo() {
            return this.delegate == null || this.delegate.canRedo();
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            return this.delegate != null ? this.convertResult(this.delegate.redo(progressMonitor, info)) : CommandResult.newOKCommandResult();
        }

        CommandResult convertResult(IStatus status) {
            if (status == null) {
                return CommandResult.newOKCommandResult();
            }
            switch (status.getSeverity()) {
                case 0: 
                case 1: {
                    return CommandResult.newOKCommandResult();
                }
                case 2: {
                    return CommandResult.newWarningCommandResult((String)status.getMessage(), null);
                }
                case 8: {
                    return CommandResult.newCancelledCommandResult();
                }
            }
            return status.getException() == null ? CommandResult.newErrorCommandResult((String)status.getMessage()) : CommandResult.newErrorCommandResult((Throwable)status.getException());
        }
    }
}

