/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.editorsfactory.anytype;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IComponentModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.ui.extension.diagrameditor.AbstractEditorFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class AnyTypeEditorFactory
extends AbstractEditorFactory {
    public AnyTypeEditorFactory() {
        super(null, "AnyTypeHandler");
    }

    @Override
    public IPageModel createIPageModel(Object pageIdentifier) {
        AnyType anyTypeModel = (AnyType)pageIdentifier;
        return new IComponentModel(anyTypeModel){
            private AnyType anyType;
            {
                this.anyType = anyType;
            }

            public void dispose() {
            }

            public String getTabTitle() {
                EClass eClass = this.anyType.eClass();
                String label = eClass == null ? "component" : eClass.getName();
                return "Missing " + label;
            }

            private String getTypeLabel() {
                EClass eClass = this.anyType.eClass();
                String className = eClass == null ? "None" : eClass.getName();
                return className;
            }

            private String getNsURI() {
                EClass eClass = this.anyType.eClass();
                EPackage ePackage = eClass == null ? null : eClass.getEPackage();
                String ePackageName = ePackage == null ? "None" : ePackage.getNsURI();
                return ePackageName;
            }

            public Image getComponentIcon() {
                return Display.getDefault().getSystemImage(8);
            }

            public Image getTabIcon() {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
            }

            public Object getRawModel() {
                return this.anyType;
            }

            public String getErrorText() {
                String typeLabel = this.getTypeLabel();
                String packageURI = this.getNsURI();
                String message = "A component is missing. The following Model cannot be loaded: " + typeLabel + " (from " + packageURI + ")\n";
                message = String.valueOf(message) + "Changes to the model won't be reflected in this editor. This editor will be saved in the current state, i.e. without any data loss. ";
                message = String.valueOf(message) + "However, this may result in an inconsistent state of this editor when the missing component will be restored\n";
                return message;
            }

            public Composite createPartControl(Composite parent) {
                Composite tabComposite = new Composite(parent, 0);
                tabComposite.setLayout((Layout)new GridLayout(2, false));
                Image componentIcon = this.getComponentIcon();
                if (componentIcon != null) {
                    Label errorImageLabel = new Label(tabComposite, 0);
                    errorImageLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
                    errorImageLabel.setImage(componentIcon);
                }
                Label label = new Label(tabComposite, 64);
                label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                label.setText(this.getErrorText());
                return tabComposite;
            }
        };
    }

    @Override
    public boolean isPageModelFactoryFor(Object pageIdentifier) {
        return pageIdentifier instanceof AnyType;
    }
}

