/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForWorkbenchPage;
import org.eclipse.papyrus.infra.widgets.util.IRevealSemanticElement;
import org.eclipse.papyrus.infra.widgets.util.NavigationTarget;
import org.eclipse.papyrus.views.modelexplorer.Activator;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.navigator.ILinkHelper;

public class LinkHelper
implements ILinkHelper {
    public IStructuredSelection findSelection(IEditorInput anInput) {
        return null;
    }

    public void activateEditor(IWorkbenchPage aPage, IStructuredSelection aSelection) {
        if (aSelection == null || aSelection.isEmpty()) {
            return;
        }
        ISelectionService selectService = aPage.getWorkbenchWindow().getSelectionService();
        ISelection selection = selectService.getSelection();
        if (selection instanceof ITreeSelection) {
            try {
                ISashWindowsContainer windowsContainer = (ISashWindowsContainer)ServiceUtilsForWorkbenchPage.getInstance().getService(ISashWindowsContainer.class, (Object)aPage);
                for (IEditorPart diagramEditor : windowsContainer.getVisibleIEditorParts()) {
                    EObject semanticElement;
                    Object currentSelection;
                    ArrayList<EObject> semanticElementList;
                    Iterator selectionIterator;
                    if (diagramEditor instanceof IRevealSemanticElement && aSelection instanceof IStructuredSelection) {
                        selectionIterator = aSelection.iterator();
                        semanticElementList = new ArrayList<EObject>();
                        while (selectionIterator.hasNext()) {
                            currentSelection = selectionIterator.next();
                            semanticElement = EMFHelper.getEObject(currentSelection);
                            if (semanticElement == null) continue;
                            semanticElementList.add(semanticElement);
                        }
                        ((IRevealSemanticElement)diagramEditor).revealSemanticElement(semanticElementList);
                    }
                    if (!(diagramEditor instanceof NavigationTarget) || !(aSelection instanceof IStructuredSelection)) continue;
                    selectionIterator = aSelection.iterator();
                    semanticElementList = new ArrayList();
                    while (selectionIterator.hasNext()) {
                        currentSelection = selectionIterator.next();
                        semanticElement = EMFHelper.getEObject(currentSelection);
                        if (semanticElement == null) continue;
                        semanticElementList.add(semanticElement);
                    }
                    ((NavigationTarget)diagramEditor).revealElement(semanticElementList);
                }
            }
            catch (ServiceException windowsContainer) {
            }
            catch (Exception ex) {
                Activator.log.error("Impossible to acces to windows Container", (Throwable)ex);
            }
        }
    }
}

