/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.validation.internal;

import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.views.validation.internal.Activator;
import org.eclipse.papyrus.views.validation.internal.ModelValidationPage;
import org.eclipse.papyrus.views.validation.internal.ViewSettings;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public class ModelValidationView
extends PageBookView {
    public static final String VIEW_ID = "org.eclipse.papyrus.views.validation.ModelValidationView";
    private ViewSettings settings;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.settings = new ViewSettings(memento);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        this.settings.save(memento);
    }

    public void partActivated(IWorkbenchPart part) {
        IPage page;
        super.partActivated(part);
        PageBookView.PageRec rec = this.getPageRec(part);
        if (rec != null && (page = rec.page) instanceof ModelValidationPage) {
            ((ModelValidationPage)page).updateInput(this.getServicesRegistry(part));
        }
    }

    protected IPage createDefaultPage(PageBook book) {
        MessagePage result = new MessagePage("No model editor is currently active.");
        this.initPage((IPageBookViewPage)result);
        result.createControl((Composite)book);
        return result;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        Page result;
        ServicesRegistry services = this.getServicesRegistry(part);
        try {
            result = services == null ? new MessagePage("Invalid model editor selected.") : new ModelValidationPage(services, this.settings);
        }
        catch (ServiceException e) {
            String message = "Failed to obtain services required for Model Validation View.";
            Activator.log.error(message, (Throwable)e);
            result = new MessagePage(message);
        }
        this.initPage((IPageBookViewPage)result);
        result.createControl((Composite)this.getPageBook());
        return new PageBookView.PageRec(part, (IPage)result);
    }

    private ServicesRegistry getServicesRegistry(IWorkbenchPart part) {
        ServicesRegistry result = null;
        if (part instanceof IMultiDiagramEditor) {
            IMultiDiagramEditor editor = (IMultiDiagramEditor)part;
            result = editor.getServicesRegistry();
        }
        return result;
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        pageRecord.page.dispose();
    }

    protected IWorkbenchPart getBootstrapPart() {
        IEditorPart result = null;
        IEditorPart editor = this.getSite().getPage().getActiveEditor();
        if (editor != null && this.isImportant((IWorkbenchPart)editor)) {
            result = editor;
        }
        return result;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof IMultiDiagramEditor;
    }

    private static class MessagePage
    extends Page {
        private String message;
        private Label label;

        MessagePage(String message) {
            this.message = message;
        }

        public void createControl(Composite parent) {
            this.label = new Label(parent, 0x1000000);
            this.label.setText(this.message);
        }

        public Control getControl() {
            return this.label;
        }

        public void setFocus() {
        }
    }
}

