/*****************************************************************************
 * Copyright (c) 2023 CEA LIST and others.s
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *  Patrick Tessier (CEA LIST) Patrick.tessier@cea.fr - Initial API and implementation
 *
 *****************************************************************************/

package org.eclipse.papyrus.infra.emf.api;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;

/**
 * this class has all methods that implements use cases around model set.
 *
 * @since 4.3
 *
 */
public interface IModelSetService {

	/**
	 * get the current modelSet from a services registry
	 *
	 * @param servicesRegistry
	 *            the services registry see papyrus core
	 **/
	public ModelSet getModelSet(ServicesRegistry servicesRegistry);

	/**
	 * create a modelSet, a command is executed in the command stack, for info
	 *
	 * @param project
	 *            the project where we want to create a modelSet
	 **/
	public ModelSet createModelSet(IProject project);

	/**
	 * load a model set from a given uri and given services registry
	 *
	 * @param uri
	 * @param servicesRegistry
	 * @return the model set associate to the uri and services registry.
	 */
	public ModelSet loadModelSet(URI uri, ServicesRegistry servicesRegistry);
}
