/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands;

import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.LifelineUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.ViewUtils;
import org.eclipse.papyrus.uml.diagram.timing.providers.UMLViewProvider;
import org.eclipse.uml2.uml.Lifeline;

public abstract class AbstractChangeLifelineTypeCommand
extends AbstractTransactionalCommand {
    protected IGraphicalEditPart lifelineEditPart;

    public AbstractChangeLifelineTypeCommand(TransactionalEditingDomain domain, IGraphicalEditPart lifelineEditPart, String commandLabel) {
        super(domain, commandLabel, Collections.EMPTY_LIST);
        this.lifelineEditPart = lifelineEditPart;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        EditPart parentEditPart = this.lifelineEditPart.getParent();
        UMLViewProvider umlViewProvider = new UMLViewProvider();
        Lifeline lifeline = (Lifeline)this.lifelineEditPart.resolveSemanticElement();
        View view = this.lifelineEditPart.getNotationView();
        View containerView = (View)view.eContainer();
        int index = containerView.getChildren().indexOf((Object)view);
        Node lifelineNode = this.createTargetLifelineView(umlViewProvider, lifeline, containerView, index);
        lifelineNode.setLayoutConstraint(((Node)this.lifelineEditPart.getNotationView()).getLayoutConstraint());
        Iterator iter = this.lifelineEditPart.getNotationView().getEAnnotations().iterator();
        while (iter.hasNext()) {
            EAnnotation annotation = (EAnnotation)EcoreUtil.copy((EObject)((EAnnotation)iter.next()));
            lifelineNode.getEAnnotations().add((Object)annotation);
        }
        LifelineUtils.setLifelineType(lifeline, this.getTargetLifelineType());
        parentEditPart.refresh();
        ViewUtils.selectInViewer((View)lifelineNode, parentEditPart.getViewer());
        return CommandResult.newOKCommandResult((Object)lifelineNode);
    }

    protected abstract LifelineUtils.LifelineType getTargetLifelineType();

    protected abstract Node createTargetLifelineView(UMLViewProvider var1, Lifeline var2, View var3, int var4);
}

