/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.aggregator.impl;

import java.util.Collection;
import java.util.List;
import org.eclipse.cbi.p2repo.aggregator.AggregatorPackage;
import org.eclipse.cbi.p2repo.aggregator.AvailableVersion;
import org.eclipse.cbi.p2repo.aggregator.Configuration;
import org.eclipse.cbi.p2repo.aggregator.EnabledStatusProvider;
import org.eclipse.cbi.p2repo.aggregator.IdentificationProvider;
import org.eclipse.cbi.p2repo.aggregator.MappedUnit;
import org.eclipse.cbi.p2repo.aggregator.impl.InstallableUnitRequestImpl;
import org.eclipse.cbi.p2repo.aggregator.util.GeneralUtils;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;

public abstract class MappedUnitImpl
extends InstallableUnitRequestImpl
implements MappedUnit {
    protected static final boolean BRANCH_ENABLED_EDEFAULT = false;
    protected static final boolean ENABLED_EDEFAULT = true;
    protected static final int ENABLED_EFLAG = 1;
    protected EList<Configuration> validConfigurations;

    private static IMatchExpression<IInstallableUnit> createFilter(Collection<AvailableVersion> availableVersions, List<Configuration> configs) {
        StringBuilder configFilterBld = new StringBuilder();
        if (configs != null && !configs.isEmpty()) {
            if (configs.size() > 1) {
                configFilterBld.append("(|");
            }
            for (Configuration config : configs) {
                configFilterBld.append("(&(osgi.os=");
                configFilterBld.append(config.getOperatingSystem().getLiteral());
                configFilterBld.append(")(osgi.ws=");
                configFilterBld.append(config.getWindowSystem().getLiteral());
                configFilterBld.append(")(osgi.arch=");
                configFilterBld.append(config.getArchitecture().getLiteral());
                configFilterBld.append("))");
            }
            if (configs.size() > 1) {
                configFilterBld.append(')');
            }
        }
        IMatchExpression<IInstallableUnit> inheritedFilter = null;
        for (AvailableVersion version : availableVersions) {
            if (inheritedFilter == null) {
                inheritedFilter = version.getFilter();
                continue;
            }
            if (inheritedFilter.equals(version.getFilter())) continue;
            inheritedFilter = null;
            break;
        }
        StringBuilder filterBld = new StringBuilder(inheritedFilter != null ? inheritedFilter.toString() : "");
        Object[] parameters = new Object[(inheritedFilter != null ? inheritedFilter.getParameters().length : 0) + (configFilterBld.length() > 0 ? 1 : 0)];
        int paramIdx = 0;
        if (inheritedFilter != null) {
            Object[] objectArray = inheritedFilter.getParameters();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object param = objectArray[n2];
                parameters[paramIdx++] = param;
                ++n2;
            }
        }
        if (configFilterBld.length() > 0) {
            if (inheritedFilter != null) {
                filterBld.append(" && ");
            }
            filterBld.append("properties ~= $" + paramIdx);
            parameters[paramIdx] = ExpressionUtil.parseLDAP((String)configFilterBld.toString());
        }
        if (filterBld.length() > 0) {
            return ExpressionUtil.getFactory().matchExpression(ExpressionUtil.parse((String)filterBld.toString()), parameters);
        }
        return null;
    }

    protected MappedUnitImpl() {
        this.eFlags |= 1;
    }

    @Override
    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == EnabledStatusProvider.class) {
            switch (derivedFeatureID) {
                case 9: {
                    return 0;
                }
                case 10: {
                    return 1;
                }
            }
            return -1;
        }
        if (baseClass == IdentificationProvider.class) {
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    @Override
    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == EnabledStatusProvider.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 9;
                }
                case 1: {
                    return 10;
                }
            }
            return -1;
        }
        if (baseClass == IdentificationProvider.class) {
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                return this.isBranchEnabled();
            }
            case 10: {
                return this.isEnabled();
            }
            case 11: {
                return this.getValidConfigurations();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return this.isSetBranchEnabled();
            }
            case 10: {
                return (this.eFlags & 1) == 0;
            }
            case 11: {
                return this.validConfigurations != null && !this.validConfigurations.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setEnabled((Boolean)newValue);
                return;
            }
            case 11: {
                this.getValidConfigurations().clear();
                this.getValidConfigurations().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    protected EClass eStaticClass() {
        return AggregatorPackage.Literals.MAPPED_UNIT;
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setEnabled(true);
                return;
            }
            case 11: {
                this.getValidConfigurations().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public IMatchExpression<IInstallableUnit> getFilter() {
        return MappedUnitImpl.createFilter(this.getAvailableVersions(), this.getValidConfigurations());
    }

    @Override
    public String getIdentification() {
        StringBuilder bld = new StringBuilder();
        bld.append(this.getName());
        VersionRange range = this.getVersionRange();
        if (range != null && !VersionRange.emptyRange.equals((Object)range)) {
            bld.append(' ');
            bld.append(range);
        }
        return bld.toString();
    }

    @Override
    public IRequirement getRequirement() {
        return MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)this.getName(), (VersionRange)this.getVersionRange(), this.getFilter(), (boolean)false, (boolean)false);
    }

    @Override
    public EList<Configuration> getValidConfigurations() {
        if (this.validConfigurations == null) {
            this.validConfigurations = new EObjectResolvingEList(Configuration.class, (InternalEObject)this, 11);
        }
        return this.validConfigurations;
    }

    @Override
    public boolean isBranchEnabled() {
        return GeneralUtils.isBranchEnabled(this);
    }

    @Override
    public boolean isEnabled() {
        return (this.eFlags & 1) != 0;
    }

    @Override
    public boolean isMappedRepositoryBroken() {
        return this.isBranchEnabled() ? super.isMappedRepositoryBroken() : false;
    }

    @Override
    public boolean isSetBranchEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean newEnabled) {
        boolean oldEnabled;
        boolean bl = oldEnabled = (this.eFlags & 1) != 0;
        this.eFlags = newEnabled ? (this.eFlags |= 1) : (this.eFlags &= 0xFFFFFFFE);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldEnabled, newEnabled));
        }
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (enabled: ");
        result.append((this.eFlags & 1) != 0);
        result.append(')');
        return result.toString();
    }
}

