/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.internal;

import java.util.Arrays;
import java.util.Collections;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.papyrus.infra.core.log.LogHelper;
import org.eclipse.papyrus.infra.properties.spi.IPropertiesResolver;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class InfraPropertiesPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.papyrus.infra.properties";
    public static LogHelper LOG;
    private static final IPropertiesResolver[] NO_RESOLVERS;
    private static InfraPropertiesPlugin instance;
    private ServiceTracker<IPropertiesResolver, IPropertiesResolver> propertiesResolverTracker;

    static {
        NO_RESOLVERS = new IPropertiesResolver[0];
    }

    public static InfraPropertiesPlugin getInstance() {
        return instance;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        LOG = new LogHelper((Plugin)this);
        this.propertiesResolverTracker = new ServiceTracker(context, IPropertiesResolver.class, null);
        this.propertiesResolverTracker.open();
        instance = this;
    }

    public void stop(BundleContext context) throws Exception {
        instance = null;
        this.propertiesResolverTracker.close();
        this.propertiesResolverTracker = null;
        super.stop(context);
    }

    public Iterable<IPropertiesResolver> getPropertyResolvers() {
        IPropertiesResolver[] resolvers = (IPropertiesResolver[])this.propertiesResolverTracker.getServices((Object[])NO_RESOLVERS);
        return resolvers == null ? Collections.emptyList() : Arrays.asList(resolvers);
    }
}

