/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.resources.refactoring;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.papyrus.infra.ui.resources.refactoring.DirtyEditorChange;
import org.eclipse.papyrus.infra.ui.resources.refactoring.ModelParticipantHelpers;
import org.eclipse.papyrus.infra.ui.resources.refactoring.RenameModelChange;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RenameModelParticipant
extends RenameParticipant {
    private IFile fileToRename;
    private IFile newFile;
    private Collection<? extends IResource> impacted;
    private boolean cancelled;

    public Change createPreChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new DirtyEditorChange(this.fileToRename, this.newFile);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        Collection<IResource> conflictingFiles;
        if (this.cancelled) {
            throw new OperationCanceledException();
        }
        if (!this.isDiFile(this.fileToRename) || !"di".equals(this.newFile.getFileExtension()) || (conflictingFiles = this.findConflictingFiles()).isEmpty()) return new RefactoringStatus();
        Object[] fileNames = new String[conflictingFiles.size()];
        int i = 0;
        for (IResource resource : conflictingFiles) {
            fileNames[i++] = resource.getName();
        }
        String defaultMessage = fileNames.length == 1 ? "The file " + (String)fileNames[0] + " already exists. Delete it or choose another name" : "Some files alreay exist. Delete them or choose another name. Files: " + Arrays.deepToString(fileNames);
        Display display = Display.getDefault();
        if (display == null) return RefactoringStatus.createFatalErrorStatus((String)defaultMessage);
        RunnableWithResult.Impl<Boolean> runnable = new RunnableWithResult.Impl<Boolean>((String[])fileNames){
            private final /* synthetic */ String[] val$fileNames;
            {
                this.val$fileNames = stringArray;
            }

            public void run() {
                this.setResult(false);
                Shell shell = Display.getDefault().getActiveShell();
                if (shell != null) {
                    String message;
                    Object title;
                    if (this.val$fileNames.length == 1) {
                        title = "The file " + this.val$fileNames[0] + " already exists.";
                        message = "The file " + this.val$fileNames[0] + " already exists. Do you want to delete it? (Warning: This operation cannot be undone)";
                    } else {
                        title = "Some files already exist";
                        message = "The files " + Arrays.deepToString(this.val$fileNames) + " alreay exist. Do you want to delete them? (Warning: This operation cannot be undone)";
                    }
                    boolean result = MessageDialog.openQuestion((Shell)shell, (String)title, (String)message);
                    this.setResult(result);
                    this.setStatus(Status.OK_STATUS);
                }
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        if (((Boolean)runnable.getResult()).booleanValue()) {
            try {
                for (IResource resource : conflictingFiles) {
                    resource.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    this.impacted.remove(resource);
                }
                return new RefactoringStatus();
            }
            catch (CoreException ex) {
                return RefactoringStatus.createFatalErrorStatus((String)ex.getMessage());
            }
        } else {
            pm.setCanceled(true);
            return new RefactoringStatus();
        }
    }

    private Collection<IResource> findConflictingFiles() {
        LinkedList<IResource> conflictingFiles = new LinkedList<IResource>();
        if (this.isDiFile(this.fileToRename)) {
            Set<IResource> participants = ModelParticipantHelpers.getRelatedFiles(this.fileToRename);
            participants.add((IResource)this.fileToRename);
            for (IResource participant : participants) {
                String targetName;
                IContainer parent = participant.getParent();
                IFile targetFile = parent.getFile((IPath)new Path(targetName = this.newFile.getFullPath().removeFileExtension().addFileExtension(participant.getFileExtension()).lastSegment()));
                if (!targetFile.exists()) continue;
                conflictingFiles.add((IResource)targetFile);
            }
        }
        return conflictingFiles;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RenameModelChange(this.fileToRename, this.newFile, this.impacted);
    }

    public String getName() {
        return "Papyrus Model Renaming";
    }

    protected boolean initialize(Object element) {
        this.cancelled = false;
        if (!(element instanceof IFile)) {
            return false;
        }
        if (!this.isDiFile((IFile)element)) {
            return false;
        }
        this.fileToRename = (IFile)element;
        String ext = this.fileToRename.getFileExtension();
        IContainer parent = this.fileToRename.getParent();
        String newName = this.getArguments().getNewName();
        int idx = newName.lastIndexOf(46);
        if (idx > 0) {
            String extension = newName.substring(idx + 1);
            if (!"di".equals(extension)) {
                return false;
            }
        } else {
            return false;
        }
        newName = newName.substring(0, idx);
        boolean otherFiles = false;
        for (IResource file : ModelParticipantHelpers.getRelatedFiles(this.fileToRename)) {
            IPath path = file.getFullPath();
            IFile renFile = parent.getFile(path.makeRelativeTo(parent.getFullPath()));
            if (path.equals((Object)this.fileToRename.getFullPath()) || !renFile.exists()) continue;
            otherFiles = true;
            break;
        }
        if (otherFiles) {
            IPath newDiPath = this.fileToRename.getFullPath().removeLastSegments(1);
            newDiPath = newDiPath.append(newName).addFileExtension(ext);
            this.newFile = parent.getFile(newDiPath.makeRelativeTo(parent.getFullPath()));
            try {
                this.impacted = ModelParticipantHelpers.getResourceToFix(this.fileToRename);
            }
            catch (OperationCanceledException e) {
                this.cancelled = true;
            }
            return true;
        }
        return false;
    }

    private boolean isDiFile(IFile file) {
        return "di".equals(file.getFileExtension());
    }
}

