/**
 * Copyright (c) 2007, 2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Michael Golubev (Montages) - #368521 - migrate to Xtend2
 *    Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up providers
 */
package xpt.providers;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenContainerBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Common_qvto;
import xpt.diagram.editparts.Utils_qvto;

@Singleton
@SuppressWarnings("all")
public class EditPartModelingAssistantProvider {
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;

  @Inject
  @Extension
  private Common_qvto _common_qvto;

  @Inject
  @Extension
  private Common _common;

  @Inject
  @Extension
  private CodeStyle _codeStyle;

  @Inject
  private ModelingAssistantProvider xptModelingAssistantProvider;

  @Inject
  private CodeStyle xptCodeStyle;

  @Inject
  private ElementTypes xptElementTypes;

  public CharSequence className(final GenContainerBase it) {
    StringConcatenation _builder = new StringConcatenation();
    String _modelingAssistantProviderClassName = it.getDiagram().getModelingAssistantProviderClassName();
    _builder.append(_modelingAssistantProviderClassName);
    _builder.append("Of");
    String _editPartClassName = it.getEditPartClassName();
    _builder.append(_editPartClassName);
    return _builder;
  }

  public CharSequence packageName(final GenContainerBase it) {
    StringConcatenation _builder = new StringConcatenation();
    String _providersPackageName = it.getDiagram().getProvidersPackageName();
    _builder.append(_providersPackageName);
    _builder.append(".assistants");
    return _builder;
  }

  public CharSequence qualifiedClassName(final GenContainerBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }

  public CharSequence EditPartModelingAssistantProvider(final GenContainerBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getDiagram().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _typesForPopupBar = this.getTypesForPopupBar(it);
    _builder.append(_typesForPopupBar, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _linkAssistantMethods = this.linkAssistantMethods(it);
    _builder.append(_linkAssistantMethods, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence extendsList(final GenContainerBase it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends ");
    CharSequence _qualifiedClassName = this.xptModelingAssistantProvider.qualifiedClassName(it.getDiagram());
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  public CharSequence getTypesForPopupBar(final GenContainerBase it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _notEmpty = this._common_qvto.<GenNode>notEmpty(it.getAssistantNodes());
      if (_notEmpty) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this.xptCodeStyle.overrideC(it);
        _builder.append(_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("public java.util.List<org.eclipse.gmf.runtime.emf.type.core.IElementType> getTypesForPopupBar(org.eclipse.core.runtime.IAdaptable host) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("java.util.List<org.eclipse.gmf.runtime.emf.type.core.IElementType> types = new java.util.ArrayList<");
        String _diamondOp = this._codeStyle.diamondOp(it, "org.eclipse.gmf.runtime.emf.type.core.IElementType");
        _builder.append(_diamondOp, "\t");
        _builder.append(">(");
        int _size = it.getAssistantNodes().size();
        _builder.append(_size, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        {
          EList<GenNode> _assistantNodes = it.getAssistantNodes();
          for(final GenNode node : _assistantNodes) {
            _builder.append("\t");
            _builder.append("types.add(");
            CharSequence _accessElementType = this.xptElementTypes.accessElementType(node);
            _builder.append(_accessElementType, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("return types;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }

  protected CharSequence _linkAssistantMethods(final GenContainerBase it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _linkAssistantMethods(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _notEmpty = this._common_qvto.<GenLink>notEmpty(this._utils_qvto.getAssistantOutgoingLinks(it));
      if (_notEmpty) {
        CharSequence _relTypesOnSource = this.getRelTypesOnSource(it);
        _builder.append(_relTypesOnSource);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _doGetRelTypesOnSource = this.doGetRelTypesOnSource(it);
        _builder.append(_doGetRelTypesOnSource);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _relTypesOnSourceAndTarget = this.getRelTypesOnSourceAndTarget(it);
        _builder.append(_relTypesOnSourceAndTarget);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _doGetRelTypesOnSourceAndTarget = this.doGetRelTypesOnSourceAndTarget(it);
        _builder.append(_doGetRelTypesOnSourceAndTarget);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _typesForTarget = this.getTypesForTarget(it);
        _builder.append(_typesForTarget);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _doGetTypesForTarget = this.doGetTypesForTarget(it);
        _builder.append(_doGetTypesForTarget);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    {
      boolean _notEmpty_1 = this._common_qvto.<GenLink>notEmpty(this._utils_qvto.getAssistantIncomingLinks(it));
      if (_notEmpty_1) {
        CharSequence _relTypesOnTarget = this.getRelTypesOnTarget(it);
        _builder.append(_relTypesOnTarget);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _doGetRelTypesOnTarget = this.doGetRelTypesOnTarget(it);
        _builder.append(_doGetRelTypesOnTarget);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _typesForSource = this.getTypesForSource(it);
        _builder.append(_typesForSource);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _doGetTypesForSource = this.doGetTypesForSource(it);
        _builder.append(_doGetTypesForSource);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  public CharSequence getRelTypesOnSource(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this.xptCodeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public java.util.List<org.eclipse.gmf.runtime.emf.type.core.IElementType> getRelTypesOnSource(org.eclipse.core.runtime.IAdaptable source) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart sourceEditPart =");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("source.getAdapter(org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart.class);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return doGetRelTypesOnSource((");
    String _editPartQualifiedClassName = it.getEditPartQualifiedClassName();
    _builder.append(_editPartQualifiedClassName, "\t");
    _builder.append(") sourceEditPart);");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence getRelTypesOnTarget(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this.xptCodeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public java.util.List<org.eclipse.gmf.runtime.emf.type.core.IElementType> getRelTypesOnTarget(org.eclipse.core.runtime.IAdaptable target) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart targetEditPart =");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("target.getAdapter(org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart.class);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return doGetRelTypesOnTarget((");
    String _editPartQualifiedClassName = it.getEditPartQualifiedClassName();
    _builder.append(_editPartQualifiedClassName, "\t");
    _builder.append(") targetEditPart);");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence getRelTypesOnSourceAndTarget(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this.xptCodeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public java.util.List<org.eclipse.gmf.runtime.emf.type.core.IElementType> getRelTypesOnSourceAndTarget(org.eclipse.core.runtime.IAdaptable source, org.eclipse.core.runtime.IAdaptable target) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart sourceEditPart =");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("source.getAdapter(org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart.class);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart targetEditPart =");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("target.getAdapter(org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart.class);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return doGetRelTypesOnSourceAndTarget((");
    String _editPartQualifiedClassName = it.getEditPartQualifiedClassName();
    _builder.append(_editPartQualifiedClassName, "\t");
    _builder.append(") sourceEditPart, targetEditPart);");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence getTypesForSource(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this.xptCodeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public java.util.List<org.eclipse.gmf.runtime.emf.type.core.IElementType> getTypesForSource(org.eclipse.core.runtime.IAdaptable target, org.eclipse.gmf.runtime.emf.type.core.IElementType relationshipType) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart targetEditPart =");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("target.getAdapter(org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart.class);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return doGetTypesForSource((");
    String _editPartQualifiedClassName = it.getEditPartQualifiedClassName();
    _builder.append(_editPartQualifiedClassName, "\t");
    _builder.append(") targetEditPart, relationshipType);");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence getTypesForTarget(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _notEmpty = this._common_qvto.<GenLink>notEmpty(this._utils_qvto.getAssistantOutgoingLinks(it));
      if (_notEmpty) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this.xptCodeStyle.overrideC(it);
        _builder.append(_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("public java.util.List<org.eclipse.gmf.runtime.emf.type.core.IElementType> getTypesForTarget(org.eclipse.core.runtime.IAdaptable source, org.eclipse.gmf.runtime.emf.type.core.IElementType relationshipType) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart sourceEditPart =");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("source.getAdapter(org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart.class);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return doGetTypesForTarget((");
        String _editPartQualifiedClassName = it.getEditPartQualifiedClassName();
        _builder.append(_editPartQualifiedClassName, "\t");
        _builder.append(") sourceEditPart, relationshipType);");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }

  public CharSequence doGetRelTypesOnSource(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public java.util.List<org.eclipse.gmf.runtime.emf.type.core.IElementType> doGetRelTypesOnSource(");
    String _editPartQualifiedClassName = it.getEditPartQualifiedClassName();
    _builder.append(_editPartQualifiedClassName);
    _builder.append(" source) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("java.util.List<org.eclipse.gmf.runtime.emf.type.core.IElementType> types = new java.util.ArrayList<");
    String _diamondOp = this._codeStyle.diamondOp(it, "org.eclipse.gmf.runtime.emf.type.core.IElementType");
    _builder.append(_diamondOp, "\t");
    _builder.append(">(");
    int _size = IterableExtensions.size(this._utils_qvto.getAssistantOutgoingLinks(it));
    _builder.append(_size, "\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    {
      Iterable<GenLink> _assistantOutgoingLinks = this._utils_qvto.getAssistantOutgoingLinks(it);
      for(final GenLink link : _assistantOutgoingLinks) {
        _builder.append("\t");
        _builder.append("types.add(");
        CharSequence _accessElementType = this.xptElementTypes.accessElementType(link);
        _builder.append(_accessElementType, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("return types;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence doGetRelTypesOnTarget(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public java.util.List<org.eclipse.gmf.runtime.emf.type.core.IElementType> doGetRelTypesOnTarget(");
    String _editPartQualifiedClassName = it.getEditPartQualifiedClassName();
    _builder.append(_editPartQualifiedClassName);
    _builder.append(" target) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("java.util.List<org.eclipse.gmf.runtime.emf.type.core.IElementType> types = new java.util.ArrayList<");
    String _diamondOp = this._codeStyle.diamondOp(it, "org.eclipse.gmf.runtime.emf.type.core.IElementType");
    _builder.append(_diamondOp, "\t");
    _builder.append(">(");
    int _size = IterableExtensions.size(this._utils_qvto.getAssistantIncomingLinks(it));
    _builder.append(_size, "\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    {
      Iterable<GenLink> _assistantIncomingLinks = this._utils_qvto.getAssistantIncomingLinks(it);
      for(final GenLink link : _assistantIncomingLinks) {
        _builder.append("\t");
        _builder.append("types.add(");
        CharSequence _accessElementType = this.xptElementTypes.accessElementType(link);
        _builder.append(_accessElementType, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("return types;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence doGetRelTypesOnSourceAndTarget(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public java.util.List<org.eclipse.gmf.runtime.emf.type.core.IElementType> doGetRelTypesOnSourceAndTarget(");
    String _editPartQualifiedClassName = it.getEditPartQualifiedClassName();
    _builder.append(_editPartQualifiedClassName);
    _builder.append(" source, org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart targetEditPart) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("java.util.List<org.eclipse.gmf.runtime.emf.type.core.IElementType> types = new java.util.LinkedList<");
    String _diamondOp = this._codeStyle.diamondOp(it, "org.eclipse.gmf.runtime.emf.type.core.IElementType");
    _builder.append(_diamondOp, "\t");
    _builder.append(">();");
    _builder.newLineIfNotEmpty();
    {
      Iterable<GenLink> _assistantOutgoingLinks = this._utils_qvto.getAssistantOutgoingLinks(it);
      for(final GenLink link : _assistantOutgoingLinks) {
        {
          Iterable<GenNode> _selectGenNodes = this._utils_qvto.selectGenNodes(link.getTargets());
          for(final GenNode target : _selectGenNodes) {
            _builder.append("\t");
            _builder.append("if (targetEditPart instanceof ");
            String _editPartQualifiedClassName_1 = target.getEditPartQualifiedClassName();
            _builder.append(_editPartQualifiedClassName_1, "\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("types.add(");
            CharSequence _accessElementType = this.xptElementTypes.accessElementType(link);
            _builder.append(_accessElementType, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
          }
        }
      }
    }
    _builder.append("\t");
    _builder.append("return types;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence doGetTypesForSource(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public java.util.List<org.eclipse.gmf.runtime.emf.type.core.IElementType> doGetTypesForSource(");
    String _editPartQualifiedClassName = it.getEditPartQualifiedClassName();
    _builder.append(_editPartQualifiedClassName);
    _builder.append(" target, org.eclipse.gmf.runtime.emf.type.core.IElementType relationshipType) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("java.util.List<org.eclipse.gmf.runtime.emf.type.core.IElementType> types = new java.util.ArrayList<");
    String _diamondOp = this._codeStyle.diamondOp(it, "org.eclipse.gmf.runtime.emf.type.core.IElementType");
    _builder.append(_diamondOp, "\t");
    _builder.append(">();");
    _builder.newLineIfNotEmpty();
    {
      Iterable<GenLink> _assistantIncomingLinks = this._utils_qvto.getAssistantIncomingLinks(it);
      boolean _hasElements = false;
      for(final GenLink link : _assistantIncomingLinks) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(" else ", "\t");
        }
        _builder.append("\t");
        _builder.append("if (relationshipType == ");
        CharSequence _accessElementType = this.xptElementTypes.accessElementType(link);
        _builder.append(_accessElementType, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        {
          Iterable<GenNode> _selectGenNodes = this._utils_qvto.selectGenNodes(link.getSources());
          for(final GenNode source : _selectGenNodes) {
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("types.add(");
            CharSequence _accessElementType_1 = this.xptElementTypes.accessElementType(source);
            _builder.append(_accessElementType_1, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("return types;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence doGetTypesForTarget(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public java.util.List<org.eclipse.gmf.runtime.emf.type.core.IElementType> doGetTypesForTarget(");
    String _editPartQualifiedClassName = it.getEditPartQualifiedClassName();
    _builder.append(_editPartQualifiedClassName);
    _builder.append(" source, org.eclipse.gmf.runtime.emf.type.core.IElementType relationshipType) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("java.util.List<org.eclipse.gmf.runtime.emf.type.core.IElementType> types = new java.util.ArrayList<");
    String _diamondOp = this._codeStyle.diamondOp(it, "org.eclipse.gmf.runtime.emf.type.core.IElementType");
    _builder.append(_diamondOp, "\t");
    _builder.append(">();");
    _builder.newLineIfNotEmpty();
    {
      Iterable<GenLink> _assistantOutgoingLinks = this._utils_qvto.getAssistantOutgoingLinks(it);
      boolean _hasElements = false;
      for(final GenLink link : _assistantOutgoingLinks) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(" else ", "\t");
        }
        _builder.append("\t");
        _builder.append("if (relationshipType == ");
        CharSequence _accessElementType = this.xptElementTypes.accessElementType(link);
        _builder.append(_accessElementType, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        {
          Iterable<GenNode> _selectGenNodes = this._utils_qvto.selectGenNodes(link.getTargets());
          for(final GenNode target : _selectGenNodes) {
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("types.add(");
            CharSequence _accessElementType_1 = this.xptElementTypes.accessElementType(target);
            _builder.append(_accessElementType_1, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("return types;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence linkAssistantMethods(final GenContainerBase it) {
    if (it instanceof GenNode) {
      return _linkAssistantMethods((GenNode)it);
    } else if (it != null) {
      return _linkAssistantMethods(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
