/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.quickfix;

import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.AbstractPapyrusWorkbenchMarkerResolution;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IExtensions;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;

public abstract class AbstractMissingExtensionMarkerResolution
extends AbstractPapyrusWorkbenchMarkerResolution {
    public AbstractMissingExtensionMarkerResolution(int problemID) {
        super(problemID);
    }

    public void run(final IMarker marker) {
        if (!(marker.getResource() instanceof IFile)) {
            return;
        }
        ModelModification modification = new ModelModification((IFile)marker.getResource()){

            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                if (model instanceof IPluginModelBase) {
                    AbstractMissingExtensionMarkerResolution.this.addExtension((IPluginModelBase)model, marker);
                }
            }
        };
        PDEModelUtility.modifyModel((ModelModification)modification, null);
    }

    private void addExtension(IPluginModelBase model, IMarker marker) throws CoreException {
        try {
            String extensionPoint = this.getExtensionPoint(marker);
            IExtensions extensions = model.getExtensions(true);
            IPluginExtension extension = Stream.of(extensions.getExtensions()).filter(ext -> Objects.equals(extensionPoint, ext.getPoint())).filter(ext -> this.canAddToExtension((IPluginExtension)ext, marker)).findAny().orElseGet(() -> this.createNewExtension(extensions, extensionPoint));
            this.configureExtension(extension, marker);
            if (extension.getParent() == null) {
                extensions.add(extension);
            }
        }
        catch (WrappedException e) {
            if (e.exception() instanceof CoreException) {
                throw (CoreException)((Object)e.exception());
            }
            Status status = new Status(4, "org.eclipse.papyrus.toolsmiths.validation.common", "Uncaught exception in marker resolution.", (Throwable)e.exception());
            throw new CoreException((IStatus)status);
        }
    }

    private IPluginExtension createNewExtension(IExtensions extensions, String point) {
        IPluginExtension result = extensions.getModel().getFactory().createExtension();
        try {
            result.setPoint(point);
        }
        catch (CoreException e) {
            throw new WrappedException((Exception)((Object)e));
        }
        return result;
    }

    protected boolean canAddToExtension(IPluginExtension existingExtension, IMarker marker) {
        return true;
    }

    protected abstract String getExtensionPoint(IMarker var1) throws CoreException;

    protected abstract void configureExtension(IPluginExtension var1, IMarker var2) throws CoreException;

    protected final IPluginElement createElement(IPluginParent parent, String name) {
        IPluginElement result = parent.getModel().getFactory().createElement((IPluginObject)parent);
        try {
            result.setName(name);
            parent.add((IPluginObject)result);
        }
        catch (CoreException e) {
            throw new WrappedException((Exception)((Object)e));
        }
        return result;
    }

    protected final IPluginElement setAttribute(IPluginElement element, String name, String value) {
        try {
            element.setAttribute(name, value);
        }
        catch (CoreException e) {
            throw new WrappedException((Exception)((Object)e));
        }
        return element;
    }
}

