/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.providers;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.labelprovider.service.IFilteredLabelProvider;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.tools.Activator;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFLabelProvider;
import org.eclipse.papyrus.uml.tools.utils.DataTypeUtil;
import org.eclipse.swt.graphics.Image;

public class GenericDataTypeLabelProvider
extends EMFLabelProvider
implements IFilteredLabelProvider {
    public static final String SEPARATOR = ",";
    public static final String DATATYPE_START = "(";
    public static final String DATATYPE_END = ")";
    public static final String COLLECTION_START = "{";
    public static final String COLLECTION_END = "}";
    public static final String EQUALS = "=";

    public boolean accept(Object element) {
        if (element instanceof Collection) {
            for (Object item : (Collection)element) {
                if (this.accept(item)) continue;
                return false;
            }
            return !((Collection)element).isEmpty();
        }
        EObject eObject = EMFHelper.getEObject((Object)element);
        if (eObject == null) {
            return false;
        }
        return DataTypeUtil.isDataTypeInstance((EObject)eObject);
    }

    public String getText(Object element) {
        LabelProviderService serv = null;
        if (element instanceof Collection && !((Collection)element).isEmpty()) {
            Object first = ((Collection)element).iterator().next();
            if (first instanceof EObject) {
                serv = this.getLabelProviderService((EObject)first);
            }
        } else {
            serv = this.getLabelProviderService((EObject)element);
        }
        if (serv == null) {
            Activator.log.error("LabelProviderService not found for " + element, null);
        }
        StringBuilder builder = new StringBuilder(DATATYPE_START);
        if (element instanceof Collection && !((Collection)element).isEmpty()) {
            builder.append(this.getLabel(serv, element));
        } else {
            EObject dataTypeInstance = EMFHelper.getEObject((Object)element);
            if (dataTypeInstance != null) {
                EClass dataTypeDefinition = dataTypeInstance.eClass();
                Iterator iter = dataTypeDefinition.getEAllStructuralFeatures().iterator();
                while (iter.hasNext()) {
                    EStructuralFeature feature = (EStructuralFeature)iter.next();
                    builder.append(feature.getName());
                    builder.append(EQUALS);
                    Object value = dataTypeInstance.eGet(feature);
                    builder.append(this.getLabel(serv, value));
                    if (!iter.hasNext()) continue;
                    builder.append(SEPARATOR);
                    builder.append(" ");
                }
            }
        }
        builder.append(DATATYPE_END);
        return builder.toString();
    }

    protected String getLabel(LabelProviderService service, Object object) {
        StringBuilder builder = new StringBuilder();
        if (object instanceof Collection) {
            builder.append(COLLECTION_START);
            Collection coll = (Collection)object;
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                Object current = iter.next();
                String value = this.getLabel(service, current);
                if (value != null) {
                    builder.append(value);
                } else {
                    builder.append(" ");
                }
                if (!iter.hasNext()) continue;
                builder.append(SEPARATOR);
                builder.append(" ");
            }
            builder.append(COLLECTION_END);
        } else {
            String label = service.getLabelProvider(object).getText(object);
            if (label != null) {
                builder.append(label);
            }
        }
        return builder.toString();
    }

    protected LabelProviderService getLabelProviderService(EObject dataTypeInstance) {
        ServicesRegistry registry = null;
        LabelProviderService service = null;
        try {
            registry = ServiceUtilsForEObject.getInstance().getServiceRegistry(dataTypeInstance);
            service = (LabelProviderService)registry.getService(LabelProviderService.class);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        return service;
    }

    public Image getImage(Object element) {
        return null;
    }
}

