/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.dialogs;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.core.modelsetquery.ModelSetQuery;
import org.eclipse.papyrus.infra.ui.util.EditorUtils;
import org.eclipse.papyrus.uml.diagram.activity.part.CustomMessages;
import org.eclipse.papyrus.uml.diagram.activity.part.Messages;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.activity.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.common.actions.LabelHelper;
import org.eclipse.papyrus.uml.diagram.common.ui.helper.HelpComponentFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class CreateActivityParameterNodeDialog
extends FormDialog {
    private Button creationRadio;
    private Button selectionRadio;
    private Text selectionText;
    private Button selectionButton;
    private Text creationNameText;
    private Text creationTypeText;
    private Button creationTypeButton;
    private Parameter selectedParameter = null;
    private EObject selectedType = null;
    private Activity activityOwner;
    private String selectedName = null;
    private ParameterDirectionKind selectedDirection = null;
    private ComboViewer directionComboViewer = null;
    private Combo creationDirectionCombo = null;
    private ILabelProvider labelProvider;

    public CreateActivityParameterNodeDialog(Shell shell, Activity owner) {
        super(shell);
        this.activityOwner = owner;
        this.labelProvider = new AdapterFactoryLabelProvider(UMLDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory());
    }

    protected void createFormContent(IManagedForm pForm) {
        pForm.getForm().setText(CustomMessages.CreateActivityParameterNodeDialog_DialogTitle);
        ScrolledForm scrolledForm = pForm.getForm();
        FormToolkit toolkit = pForm.getToolkit();
        Composite parent = scrolledForm.getBody();
        parent.setLayout((Layout)new GridLayout());
        this.createInvocationCreationSection(scrolledForm.getBody(), toolkit);
        this.createInvocationSelectionSection(scrolledForm.getBody(), toolkit);
        this.refreshSectionsEnable(false);
        this.hookListeners();
        this.setInvokedName(null);
        scrolledForm.reflow(true);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.refreshOkButton();
    }

    private void createInvocationSelectionSection(Composite pParent, FormToolkit pToolkit) {
        String lSectionTitle = CustomMessages.CreateActivityParameterNodeDialog_ParameterSelectionTitle;
        Section lSection = pToolkit.createSection(pParent, 320);
        lSection.setLayoutData((Object)new GridData(768));
        if (lSectionTitle != null) {
            lSection.setText(lSectionTitle);
        }
        ImageHyperlink componentHelp = HelpComponentFactory.createHelpComponent((Composite)lSection, (FormToolkit)pToolkit, (String)CustomMessages.CreateActivityParameterNodeDialog_ParameterSelectionHelp);
        lSection.setTextClient((Control)componentHelp);
        ScrolledForm lInsideScrolledForm = pToolkit.createScrolledForm((Composite)lSection);
        lInsideScrolledForm.setExpandHorizontal(true);
        lInsideScrolledForm.setExpandVertical(true);
        Composite lBody = lInsideScrolledForm.getBody();
        GridLayout lLayout = new GridLayout();
        lLayout.numColumns = 3;
        lBody.setLayout((Layout)lLayout);
        this.selectionRadio = pToolkit.createButton(lBody, CustomMessages.CreateActivityParameterNodeDialog_ParameterSelectionLabel, 16);
        this.selectionRadio.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        pToolkit.createLabel(lBody, String.valueOf(this.getParameterFeature().getEReferenceType().getName()) + ":", 0);
        this.selectionText = pToolkit.createText(lBody, "", 2056);
        this.selectionText.setLayoutData((Object)new GridData(768));
        this.selectionButton = pToolkit.createButton(lBody, "...", 0x800000);
        Image image = UMLElementTypes.getImage((ENamedElement)this.getParameterFeature());
        this.selectionButton.setImage(image);
        this.selectionButton.setLayoutData((Object)new GridData(0));
        lInsideScrolledForm.reflow(true);
        lSection.setClient((Control)lInsideScrolledForm);
    }

    private void createInvocationCreationSection(Composite pParent, FormToolkit pToolkit) {
        String lSectionTitle = CustomMessages.CreateActivityParameterNodeDialog_ParameterCreationTitle;
        Section lSection = pToolkit.createSection(pParent, 320);
        lSection.setLayoutData((Object)new GridData(768));
        if (lSectionTitle != null) {
            lSection.setText(lSectionTitle);
        }
        ImageHyperlink componentHelp = HelpComponentFactory.createHelpComponent((Composite)lSection, (FormToolkit)pToolkit, (String)CustomMessages.CreateActivityParameterNodeDialog_ParameterCreationHelp);
        lSection.setTextClient((Control)componentHelp);
        ScrolledForm lInsideScrolledForm = pToolkit.createScrolledForm((Composite)lSection);
        lInsideScrolledForm.setExpandHorizontal(true);
        lInsideScrolledForm.setExpandVertical(true);
        Composite lBody = lInsideScrolledForm.getBody();
        GridLayout lLayout = new GridLayout();
        lLayout.numColumns = 3;
        lBody.setLayout((Layout)lLayout);
        this.creationRadio = pToolkit.createButton(lBody, CustomMessages.CreateActivityParameterNodeDialog_ParameterCreationLabel, 16);
        this.creationRadio.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        pToolkit.createLabel(lBody, CustomMessages.CreateActivityParameterNodeDialog_NameLabel, 0);
        this.creationNameText = pToolkit.createText(lBody, "", 2048);
        this.creationNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.creationNameText.setFocus();
        pToolkit.createLabel(lBody, CustomMessages.CreateActivityParameterNodeDialog_TypeLabel, 0);
        this.creationTypeText = pToolkit.createText(lBody, this.labelProvider.getText((Object)this.selectedType), 2056);
        this.creationTypeText.setLayoutData((Object)new GridData(768));
        this.creationTypeButton = pToolkit.createButton(lBody, "...", 0x800000);
        Image image = UMLElementTypes.getImage((ENamedElement)UMLPackage.eINSTANCE.getPackage_PackagedElement());
        this.creationTypeButton.setImage(image);
        this.creationTypeButton.setLayoutData((Object)new GridData(0));
        pToolkit.createLabel(lBody, CustomMessages.CreateActivityParameterNodeDialog_DirectionLabel, 0);
        this.creationDirectionCombo = new Combo(lBody, 12);
        this.directionComboViewer = new ComboViewer(this.creationDirectionCombo);
        pToolkit.adapt((Composite)this.creationDirectionCombo);
        this.creationDirectionCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.directionComboViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.directionComboViewer.add((Object[])this.getDirections());
        this.directionComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.getDirections()[0]));
        this.selectedDirection = ParameterDirectionKind.getByName((String)this.getDirections()[0]);
        lInsideScrolledForm.reflow(true);
        lSection.setClient((Control)lInsideScrolledForm);
    }

    protected void okPressed() {
        boolean isSelectionSelected = this.selectionRadio.getSelection();
        if (!isSelectionSelected) {
            this.selectedParameter = UMLFactory.eINSTANCE.createParameter();
            this.selectedParameter.setName(this.selectedName);
            this.selectedParameter.setType((Type)this.selectedType);
            this.selectedParameter.setDirection(this.selectedDirection);
            this.addParameter((EObject)this.selectedParameter);
        }
        super.okPressed();
    }

    public EObject getSelectedInvoked() {
        return this.selectedParameter;
    }

    private void hookListeners() {
        SelectionAdapter selectCreateListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateActivityParameterNodeDialog.this.creationRadio.equals(e.getSource())) {
                    CreateActivityParameterNodeDialog.this.refreshSectionsEnable(false);
                } else {
                    CreateActivityParameterNodeDialog.this.refreshSectionsEnable(true);
                }
                CreateActivityParameterNodeDialog.this.refreshOkButton();
            }
        };
        this.selectionRadio.addSelectionListener((SelectionListener)selectCreateListener);
        this.creationRadio.addSelectionListener((SelectionListener)selectCreateListener);
        SelectionAdapter selectBtnListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateActivityParameterNodeDialog.this.handleChooseParameter();
                CreateActivityParameterNodeDialog.this.refreshOkButton();
            }
        };
        this.selectionButton.addSelectionListener((SelectionListener)selectBtnListener);
        if (this.creationDirectionCombo != null && this.directionComboViewer != null) {
            ModifyListener lTypeListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ISelection sel = CreateActivityParameterNodeDialog.this.directionComboViewer.getSelection();
                    if (sel instanceof StructuredSelection) {
                        String firstElement = ((StructuredSelection)sel).getFirstElement().toString();
                        CreateActivityParameterNodeDialog.this.selectedDirection = ParameterDirectionKind.getByName((String)firstElement);
                    } else {
                        CreateActivityParameterNodeDialog.this.selectedDirection = null;
                    }
                    CreateActivityParameterNodeDialog.this.setInvokedName(null);
                    CreateActivityParameterNodeDialog.this.refreshOkButton();
                }
            };
            this.creationDirectionCombo.addModifyListener(lTypeListener);
        }
        ModifyListener lNameListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateActivityParameterNodeDialog.this.setInvokedName(CreateActivityParameterNodeDialog.this.creationNameText.getText());
            }
        };
        this.creationNameText.addModifyListener(lNameListener);
        SelectionAdapter selectTypeBtnListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateActivityParameterNodeDialog.this.handleChooseType();
                if (CreateActivityParameterNodeDialog.this.selectedName == null) {
                    CreateActivityParameterNodeDialog.this.setInvokedName(null);
                }
                CreateActivityParameterNodeDialog.this.refreshOkButton();
            }
        };
        this.creationTypeButton.addSelectionListener((SelectionListener)selectTypeBtnListener);
    }

    private void setInvokedName(String text) {
        String name = text;
        if (text == null) {
            name = LabelHelper.INSTANCE.findName((EObject)this.activityOwner, UMLPackage.eINSTANCE.getParameter());
            this.creationNameText.setText(name);
        } else if (name != null && !"".equals(name.trim())) {
            this.selectedName = name.trim();
            Color black = this.creationNameText.getDisplay().getSystemColor(2);
            this.creationNameText.setForeground(black);
            this.refreshOkButton();
        } else {
            this.selectedName = null;
            Color red = this.creationNameText.getDisplay().getSystemColor(3);
            this.creationNameText.setForeground(red);
            this.refreshOkButton();
        }
    }

    private void handleChooseParameter() {
        Collection elements = ModelSetQuery.getObjectsOfType((EObject)this.activityOwner, (EClassifier)this.getParameterFeature().getEType());
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            EObject eObject = (EObject)it.next();
            if (this.activityOwner.equals(((Parameter)eObject).getOwner())) continue;
            it.remove();
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), this.labelProvider);
        dialog.setMessage(Messages.UMLModelingAssistantProviderMessage);
        dialog.setTitle(Messages.UMLModelingAssistantProviderTitle);
        dialog.setFilter("*");
        dialog.setMultipleSelection(false);
        dialog.setElements((Object[])elements.toArray(new EObject[elements.size()]));
        if (dialog.open() == 0) {
            this.setParameterSelection((EObject)dialog.getFirstResult());
        }
    }

    private void setParameterSelection(EObject invokedElement) {
        if (invokedElement instanceof Parameter) {
            this.selectedParameter = (Parameter)invokedElement;
            this.selectionText.setText(this.labelProvider.getText((Object)this.selectedParameter));
        } else {
            this.selectionText.setText("");
        }
    }

    private void handleChooseType() {
        Set<Object> types = this.getAvailableTypes();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), this.labelProvider);
        dialog.setFilter("*");
        dialog.setMessage(Messages.UMLModelingAssistantProviderMessage);
        dialog.setTitle(Messages.UMLModelingAssistantProviderTitle);
        dialog.setMultipleSelection(false);
        dialog.setElements(types.toArray());
        if (dialog.open() == 0) {
            Object firstResult = dialog.getFirstResult();
            if (firstResult instanceof EObject) {
                this.setSelectedType((EObject)dialog.getFirstResult());
            } else {
                this.setSelectedType(null);
            }
        }
    }

    private void setSelectedType(EObject invokedType) {
        this.selectedType = invokedType;
        if (this.selectedType instanceof NamedElement) {
            this.creationTypeText.setText(this.labelProvider.getText((Object)this.selectedType));
        } else {
            this.creationTypeText.setText("");
        }
    }

    private void refreshSectionsEnable(boolean isSelectionSelected) {
        if (isSelectionSelected) {
            this.creationRadio.setSelection(false);
            if (!this.selectionRadio.getSelection()) {
                this.selectionRadio.setSelection(true);
            }
        } else {
            this.selectionRadio.setSelection(false);
            if (!this.creationRadio.getSelection()) {
                this.creationRadio.setSelection(true);
            }
        }
        this.selectionText.setEnabled(isSelectionSelected);
        this.selectionButton.setEnabled(isSelectionSelected);
        if (this.creationDirectionCombo != null) {
            this.creationDirectionCombo.setEnabled(!isSelectionSelected);
        }
        this.creationNameText.setEnabled(!isSelectionSelected);
        this.creationNameText.setFocus();
        this.creationTypeText.setEnabled(!isSelectionSelected);
        this.creationTypeButton.setEnabled(!isSelectionSelected);
    }

    private void refreshOkButton() {
        boolean isSelectionSelected = this.selectionRadio.getSelection();
        if (this.getButton(0) != null && !this.getButton(0).isDisposed()) {
            if (isSelectionSelected) {
                this.getButton(0).setEnabled(this.selectedParameter != null);
            } else {
                this.getButton(0).setEnabled(this.selectedDirection != null && this.selectedName != null);
            }
        }
    }

    private EReference getParameterFeature() {
        return UMLPackage.eINSTANCE.getBehavior_OwnedParameter();
    }

    protected void addParameter(EObject newEObject) {
        TransactionalEditingDomain editingdomain = EditorUtils.getTransactionalEditingDomain();
        Command addCmd = AddCommand.create((EditingDomain)editingdomain, (Object)this.activityOwner, null, Collections.singleton(newEObject));
        addCmd.execute();
    }

    private Set<Object> getAvailableTypes() {
        Collection types = ModelSetQuery.getObjectsOfType((EObject)this.activityOwner, (EClassifier)UMLPackage.eINSTANCE.getTypedElement_Type().getEType());
        HashSet<Object> result = new HashSet<Object>();
        result.add("");
        result.addAll(types);
        return result;
    }

    private String[] getDirections() {
        List values = ParameterDirectionKind.VALUES;
        String[] ret = new String[values.size()];
        int i = 0;
        while (i < values.size()) {
            ret[i] = ((ParameterDirectionKind)values.get(i)).getName();
            ++i;
        }
        return ret;
    }
}

