/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.papyrus.uml.diagram.common.editparts.RoundedCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.SenderRequestUtils;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.SequenceReferenceEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.UpdateWeakReferenceEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.util.LogOptions;

public class UpdateWeakReferenceForExecSpecEditPolicy
extends UpdateWeakReferenceEditPolicy {
    public static final String UDPATE_WEAK_REFERENCE_FOR_EXECSPEC = "UpdateWeakReferenceForExecSpecEditPolicy";

    public Command getCommand(Request request) {
        if (request instanceof ChangeBoundsRequest && !"autosize".equals(request.getType())) {
            Point nextLocation = ((ChangeBoundsRequest)request).getLocation();
            UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+ MOVE at " + nextLocation + " of " + this.getHost());
            PrecisionRectangle locationAndSize = new PrecisionRectangle(this.getHostFigure().getBounds());
            Point moveDelta = new Point(0, 0);
            if ("move".equals(request.getType())) {
                moveDelta = ((ChangeBoundsRequest)request).getMoveDelta();
            } else if ("resize".equals(request.getType())) {
                moveDelta = new Point(0, ((ChangeBoundsRequest)request).getSizeDelta().height + ((ChangeBoundsRequest)request).getMoveDelta().y);
            }
            if (moveDelta.y != 0 && this.mustMove) {
                if (this.getHost() instanceof AbstractExecutionSpecificationEditPart) {
                    this.getHostFigure().translateToAbsolute((Translatable)locationAndSize);
                    locationAndSize = ((ChangeBoundsRequest)request).getTransformedRectangle((Rectangle)locationAndSize);
                }
                if (this.getHost().getEditPolicy((Object)"SEQUENCE_REFERENCE") != null) {
                    SequenceReferenceEditPolicy references = (SequenceReferenceEditPolicy)this.getHost().getEditPolicy((Object)"SEQUENCE_REFERENCE");
                    if (!SenderRequestUtils.isASender(request, this.getHost())) {
                        CompoundCommand compoundCommand = new CompoundCommand();
                        HashMap<EditPart, String> weakReferences = new HashMap<EditPart, String>();
                        if (moveDelta.y > 0 && this.mustMoveBelowAtMovingDown || moveDelta.y < 0 && this.mustMoveBelowAtMovingUp) {
                            weakReferences.putAll(references.getWeakReferences());
                        }
                        for (EditPart editPart : weakReferences.keySet()) {
                            if (SenderRequestUtils.isASender(request, editPart)) continue;
                            UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+--> try to Move of " + moveDelta.y + " " + editPart);
                            ArrayList<EditPart> senderList = SenderRequestUtils.getSenders(request);
                            if (editPart instanceof ConnectionEditPart) {
                                ConnectionEditPart connectionEditPart = (ConnectionEditPart)editPart;
                                UpdateWeakReferenceEditPolicy.moveSourceConnectionEditPart(this.getHost(), moveDelta, compoundCommand, connectionEditPart, senderList);
                                UpdateWeakReferenceEditPolicy.moveTargetConnectionEditPart(this.getHost(), moveDelta, compoundCommand, connectionEditPart, senderList);
                            }
                            if (!(editPart instanceof RoundedCompartmentEditPart)) continue;
                            UpdateWeakReferenceEditPolicy.moveRoundedEditPart(this.getHost(), moveDelta, compoundCommand, editPart, senderList);
                        }
                        if (compoundCommand.size() == 0) {
                            return super.getCommand(request);
                        }
                        return compoundCommand;
                    }
                }
            }
        }
        return super.getCommand(request);
    }
}

