/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.service.palette;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.core.service.ProviderPriority;
import org.eclipse.gmf.runtime.common.ui.util.ActivityUtil;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.palette.ContributeToPaletteOperation;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditorWithFlyOutPalette;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.architecture.ArchitectureDescriptionUtils;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.ArchitectureExtendedPaletteProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PapyrusPaletteService;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.PaletteConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.representation.PapyrusDiagram;
import org.eclipse.papyrus.infra.gmfdiag.style.PapyrusDiagramStyle;
import org.eclipse.ui.IEditorPart;
import org.osgi.framework.Bundle;

public class ArchitectureExtendedProviderDescriptor
extends PapyrusPaletteService.ExtendedProviderDescriptor {
    public static final String ARCHITECTURE_PALETTE_NAME_SUFFIX = " Palette";
    public static final String ARCHITECTURE_PALETTE_ID_SUFFIX = "_Palette";
    private PapyrusDiagram diagram;
    private static final String BUNDLEENTRY_PROTOCOL = "bundleentry://";
    private static final String PLUGIN_PROTOCOL = "platform:/plugin/";

    public ArchitectureExtendedProviderDescriptor(PapyrusDiagram diagram) {
        super(null);
        Assert.isNotNull((Object)diagram);
        this.diagram = diagram;
    }

    @Override
    public IProvider getProvider() {
        if (this.provider == null) {
            this.provider = new ArchitectureExtendedPaletteProvider();
            ((ArchitectureExtendedPaletteProvider)this.provider).setContributions(this);
        }
        return this.provider;
    }

    @Override
    public boolean hasOnlyEntriesDefinition() {
        return false;
    }

    @Override
    public String getContributionName() {
        return String.valueOf(this.getDiagram().getName()) + ARCHITECTURE_PALETTE_NAME_SUFFIX;
    }

    @Override
    public String getContributionID() {
        return String.valueOf(this.getDiagram().getName()) + ARCHITECTURE_PALETTE_ID_SUFFIX;
    }

    @Override
    public ProviderPriority getPriority() {
        return ProviderPriority.MEDIUM;
    }

    @Override
    public boolean provides(IOperation operation) {
        String diagramName;
        ContributeToPaletteOperation o;
        IEditorPart part;
        Boolean provides = false;
        if (operation instanceof ContributeToPaletteOperation && (part = (o = (ContributeToPaletteOperation)operation).getEditor()) instanceof DiagramEditorWithFlyOutPalette && (diagramName = this.getDiagram().getName()) != null) {
            Diagram diagramPalette = ((DiagramEditorWithFlyOutPalette)part).getDiagram();
            String implementationID = this.getDiagram().getImplementationID();
            PapyrusDiagramStyle papyrusDiagramStyle = DiagramUtils.getPapyrusDiagramStyle(diagramPalette);
            boolean match = false;
            if (papyrusDiagramStyle != null) {
                ArchitectureDomainManager manager = ArchitectureDomainManager.getInstance();
                PapyrusDiagram repKind = (PapyrusDiagram)manager.getRepresentationKindById(papyrusDiagramStyle.getDiagramKindId());
                match = diagramName.equals(repKind.getName());
            } else if (implementationID != null) {
                boolean bl = match = diagramPalette != null && implementationID.equals(diagramPalette.getType());
            }
            if (match && !this.isHidden(o)) {
                ModelSet modelSet = null;
                try {
                    modelSet = ServiceUtils.getInstance().getModelSet((Object)((ServicesRegistry)part.getAdapter(ServicesRegistry.class)));
                    List collect = new ArchitectureDescriptionUtils(modelSet).getArchitectureViewpoints().stream().flatMap(p -> p.getRepresentationKinds().stream()).filter(PapyrusDiagram.class::isInstance).map(PapyrusDiagram.class::cast).filter(p -> this.getDiagram().getQualifiedName().equals(p.getQualifiedName())).flatMap(p -> p.getPalettes().stream()).distinct().collect(Collectors.toList());
                    provides = !collect.isEmpty();
                }
                catch (ServiceException e) {
                    Activator.log.error("Can't get model set", (Throwable)e);
                }
            }
        }
        return provides;
    }

    @Override
    public boolean providesWithVisibility(ContributeToPaletteOperation operation) {
        boolean isEnable = ActivityUtil.isEnabled((String)this.getContributionID(), (String)"org.eclipse.papyrus.infra.gmfdiag.common");
        if (!isEnable) {
            return false;
        }
        if (operation instanceof ContributeToPaletteOperation) {
            ContributeToPaletteOperation o = operation;
            IEditorPart part = o.getEditor();
            if (!(part instanceof DiagramEditorWithFlyOutPalette)) {
                return false;
            }
            return this.getDiagram().getImplementationID() == null || this.getDiagram().getImplementationID().equals(((DiagramEditorWithFlyOutPalette)part).getDiagram().getType());
        }
        return false;
    }

    @Override
    protected InputStream openConfigurationFile(Bundle bundle, String filePath) {
        block4: {
            int jarPathEndIndex;
            String path;
            block5: {
                URL urlFile = bundle.getEntry(filePath);
                urlFile = FileLocator.resolve((URL)urlFile);
                urlFile = FileLocator.toFileURL((URL)urlFile);
                if ("file".equals(urlFile.getProtocol())) {
                    return new FileInputStream(urlFile.getFile());
                }
                if (!"jar".equals(urlFile.getProtocol()) || !(path = urlFile.getPath()).startsWith("file:")) break block4;
                jarPathEndIndex = path.indexOf("!/");
                if (jarPathEndIndex >= 0) break block5;
                Activator.log.error("Impossible to find the jar path end", null);
                return null;
            }
            try {
                String jarPath = path.substring("file:".length(), jarPathEndIndex);
                ZipFile zipFile = new ZipFile(jarPath);
                filePath = filePath.substring(jarPathEndIndex + 2, path.length());
                ZipEntry entry = zipFile.getEntry(path);
                return zipFile.getInputStream(entry);
            }
            catch (IOException e) {
                Activator.log.error("Impossible to find initial file", (Throwable)e);
            }
        }
        return null;
    }

    private static String retrieveBundleId(String initialValue) {
        String result = null;
        if (initialValue.startsWith(PLUGIN_PROTOCOL)) {
            String tmp = initialValue.substring(PLUGIN_PROTOCOL.length());
            int bundleIdEndIndex = tmp.indexOf("/");
            result = tmp.substring(0, bundleIdEndIndex);
        } else if (initialValue.startsWith(BUNDLEENTRY_PROTOCOL)) {
            String absolutePath = null;
            try {
                URL url = new URL(initialValue);
                absolutePath = FileLocator.resolve((URL)url).getPath();
            }
            catch (MalformedURLException url) {
            }
            catch (IOException url) {
                // empty catch block
            }
            int bundleIdEndIndex = absolutePath.indexOf("/");
            result = absolutePath.substring(0, bundleIdEndIndex);
            if (-1 != result.indexOf("/")) {
                result = result.substring(result.lastIndexOf("/") + 1);
            }
        }
        return result;
    }

    @Override
    public String createLocalRedefinition() {
        PaletteConfiguration paletteConfiguration = (PaletteConfiguration)this.getDiagram().getPalettes().get(0);
        URI uri = EcoreUtil.getURI((EObject)paletteConfiguration).trimFragment();
        String localRedifinitionPath = uri.toPlatformString(true);
        InputStream stream = null;
        String filePath = localRedifinitionPath.substring(1, localRedifinitionPath.length());
        int indexOf = filePath.indexOf(47);
        String bundleId = filePath.substring(0, indexOf);
        filePath = filePath.substring(indexOf, filePath.length());
        String realId = bundleId;
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (Platform.isFragment((Bundle)bundle)) {
            stream = this.openConfigurationFile(bundle, filePath);
        } else {
            Bundle[] fragments = Platform.getFragments((Bundle)bundle);
            if (fragments == null) {
                stream = this.openConfigurationFile(bundle, filePath);
            } else {
                Bundle[] bundleArray = fragments;
                int n = fragments.length;
                int n2 = 0;
                while (n2 < n) {
                    Bundle fragment = bundleArray[n2];
                    if (stream == null) {
                        stream = this.openConfigurationFile(fragment, filePath);
                        realId = fragment.getSymbolicName();
                    }
                    ++n2;
                }
                if (stream == null) {
                    stream = this.openConfigurationFile(bundle, filePath);
                    realId = bundle.getSymbolicName();
                }
            }
        }
        if (stream == null) {
            Activator.log.error("Impossible to read initial file", null);
            return null;
        }
        File stateLocationRootFile = Activator.getInstance().getStateLocation().toFile();
        File bundleFolder = new File(stateLocationRootFile, realId);
        bundleFolder.mkdir();
        File root = bundleFolder;
        String[] folders = filePath.split("\\Q\\\\E|\\Q/\\E");
        int i = 0;
        while (i < folders.length - 1) {
            String folderName = folders[i];
            if (folderName != null && folderName.length() != 0) {
                File newFolder = new File(root, folders[i]);
                newFolder.mkdir();
                root = newFolder;
            }
            ++i;
        }
        File newFile = new File(root, folders[folders.length - 1]);
        boolean fileCreated = false;
        if (newFile.exists()) {
            fileCreated = true;
        } else {
            try {
                fileCreated = newFile.createNewFile();
            }
            catch (IOException e) {
                Activator.log.error("Impossible to create new file", (Throwable)e);
                return null;
            }
        }
        if (!fileCreated) {
            Activator.log.error("It was not possible to create the file", null);
            return null;
        }
        try {
            int len;
            FileOutputStream fileOutputStream = new FileOutputStream(newFile);
            byte[] buf = new byte[1024];
            while ((len = stream.read(buf)) > 0) {
                fileOutputStream.write(buf, 0, len);
            }
            stream.close();
            fileOutputStream.close();
        }
        catch (FileNotFoundException e) {
            Activator.log.error("It was not possible to write in the file", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            Activator.log.error("It was not possible to write in the file", (Throwable)e);
            return null;
        }
        if (!filePath.startsWith("/") || !filePath.startsWith("\\")) {
            filePath = String.valueOf('/') + filePath;
        }
        return localRedifinitionPath;
    }

    public PapyrusDiagram getDiagram() {
        return this.diagram;
    }
}

