/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.GridManagementEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.IComputeOwnerHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.LogOptions;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.UMLPackage;

public class ComputeOwnerHelper
implements IComputeOwnerHelper {
    protected static void fillHorizontalMatch(ArrayList<DecorationNode> columns, HashMap<Lifeline, ArrayList<InteractionOperand>> HorizontalLifeLinetoOperand) {
        ArrayList<InteractionOperand> interactionOperandStack = new ArrayList<InteractionOperand>();
        for (DecorationNode column : columns) {
            if (column.getElement() instanceof InteractionOperand) {
                if (interactionOperandStack.contains(column.getElement())) {
                    UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "update " + ((InteractionOperand)column.getElement()).getName());
                    interactionOperandStack.remove(column.getElement());
                } else {
                    interactionOperandStack.add((InteractionOperand)column.getElement());
                }
            }
            if (!(column.getElement() instanceof Lifeline)) continue;
            HorizontalLifeLinetoOperand.put((Lifeline)column.getElement(), (ArrayList)interactionOperandStack.clone());
        }
    }

    protected static void fillVerticalMatch(ArrayList<DecorationNode> rows, HashMap<Element, ArrayList<InteractionOperand>> verticalElementToOperand) {
        ArrayList<InteractionOperand> interactionOperandStack = new ArrayList<InteractionOperand>();
        for (DecorationNode row : rows) {
            if (row.getElement() instanceof InteractionOperand) {
                if (interactionOperandStack.contains(row.getElement())) {
                    UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "update " + ((InteractionOperand)row.getElement()).getName());
                    interactionOperandStack.remove(row.getElement());
                    continue;
                }
                interactionOperandStack.add((InteractionOperand)row.getElement());
                continue;
            }
            if (!(row.getElement() instanceof Element)) continue;
            verticalElementToOperand.put((Element)row.getElement(), (ArrayList)interactionOperandStack.clone());
        }
    }

    @Override
    public void updateOwnedByInteractionOperand(EditingDomain domain, ArrayList<DecorationNode> rows, ArrayList<DecorationNode> columns, Interaction interaction, GridManagementEditPolicy grid) {
        HashMap<Lifeline, ArrayList<InteractionOperand>> horizontalLifeLinetoOperand = new HashMap<Lifeline, ArrayList<InteractionOperand>>();
        HashMap<Element, ArrayList<InteractionOperand>> verticalElementToOperand = new HashMap<Element, ArrayList<InteractionOperand>>();
        ComputeOwnerHelper.fillHorizontalMatch(columns, horizontalLifeLinetoOperand);
        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "horizontal parsing done " + horizontalLifeLinetoOperand);
        ComputeOwnerHelper.fillVerticalMatch(rows, verticalElementToOperand);
        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "vertical parsing done " + verticalElementToOperand);
        ArrayList<InteractionFragment> elementForInteraction = new ArrayList<InteractionFragment>();
        HashMap elementForIneractionOp = new HashMap();
        TreeIterator elementInteraction = interaction.eAllContents();
        while (elementInteraction.hasNext()) {
            InteractionFragment aFragment;
            Element element = (Element)elementInteraction.next();
            if (!(element instanceof InteractionFragment) || !verticalElementToOperand.containsKey(aFragment = (InteractionFragment)element)) continue;
            for (Lifeline currentLifeline : horizontalLifeLinetoOperand.keySet()) {
                if (!currentLifeline.getCoveredBys().contains((Object)aFragment)) continue;
                ArrayList<InteractionOperand> potentialoperand = ComputeOwnerHelper.intersection((List)verticalElementToOperand.get(element), (List)horizontalLifeLinetoOperand.get(currentLifeline));
                if (potentialoperand.size() >= 1) {
                    ComputeOwnerHelper.simplifyOwnerInteractionOperand(potentialoperand);
                    if (potentialoperand.size() != 1) continue;
                    if (elementForIneractionOp.get(potentialoperand.get(0)) == null) {
                        elementForIneractionOp.put(potentialoperand.get(0), new ArrayList());
                    }
                    ((ArrayList)elementForIneractionOp.get(potentialoperand.get(0))).add(aFragment);
                    if (!(aFragment instanceof ExecutionOccurrenceSpecification)) continue;
                    ((ArrayList)elementForIneractionOp.get(potentialoperand.get(0))).add(((ExecutionOccurrenceSpecification)aFragment).getExecution());
                    continue;
                }
                if (aFragment instanceof InteractionOperand) continue;
                elementForInteraction.add(aFragment);
                if (!(aFragment instanceof ExecutionOccurrenceSpecification)) continue;
                elementForInteraction.add((InteractionFragment)((ExecutionOccurrenceSpecification)aFragment).getExecution());
            }
        }
        for (InteractionOperand interactionOperand : elementForIneractionOp.keySet()) {
            ArrayList elements = (ArrayList)elementForIneractionOp.get(interactionOperand);
            if (elements.size() == 0) continue;
            ArrayList<InteractionFragment> existedFragments = new ArrayList<InteractionFragment>();
            ArrayList<InteractionFragment> sorted = this.sortSemanticFromRows(elements, rows);
            existedFragments.addAll(sorted);
            existedFragments.addAll((Collection<InteractionFragment>)interactionOperand.getFragments());
            grid.execute((Command)new SetCommand(domain, (EObject)interactionOperand, (EStructuralFeature)UMLPackage.eINSTANCE.getInteractionOperand_Fragment(), existedFragments));
        }
        if (elementForInteraction.size() != 0) {
            ArrayList<InteractionFragment> existedFragments = new ArrayList<InteractionFragment>();
            ArrayList<InteractionFragment> sorted = this.sortSemanticFromRows(elementForInteraction, rows);
            existedFragments.addAll(sorted);
            for (InteractionFragment interactionFragment : interaction.getFragments()) {
                if (existedFragments.contains(interactionFragment)) continue;
                if (interactionFragment instanceof ExecutionSpecification) {
                    int indexOfStartOS = existedFragments.indexOf(((ExecutionSpecification)interactionFragment).getStart());
                    if (indexOfStartOS >= 0) {
                        existedFragments.add(indexOfStartOS + 1, interactionFragment);
                        continue;
                    }
                    existedFragments.add(interactionFragment);
                    continue;
                }
                existedFragments.add(interactionFragment);
            }
            grid.execute((Command)new SetCommand(domain, (EObject)interaction, (EStructuralFeature)UMLPackage.eINSTANCE.getInteraction_Fragment(), existedFragments));
        }
    }

    protected ArrayList<InteractionFragment> sortSemanticFromRows(ArrayList<InteractionFragment> fragments, ArrayList<DecorationNode> rows) {
        ArrayList<InteractionFragment> sortedList = new ArrayList<InteractionFragment>();
        for (DecorationNode row : rows) {
            if (!fragments.contains(row.getElement()) || sortedList.contains(row.getElement())) continue;
            sortedList.add((InteractionFragment)row.getElement());
        }
        return sortedList;
    }

    protected static void simplifyOwnerInteractionOperand(ArrayList<InteractionOperand> operandList) {
    }

    protected static <T> ArrayList<T> intersection(List<T> list1, List<T> list2) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : list1) {
            if (!list2.contains(t)) continue;
            list.add(t);
        }
        return list;
    }
}

