/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionUseEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageFoundEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageLostEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifelineFigure;
import org.eclipse.papyrus.uml.diagram.sequence.util.CommandHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineEditPartUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionUse;
import org.eclipse.uml2.uml.Lifeline;

public class LifelineHeadUtil {
    public static int computeLifelineVerticalPosition(EditPart parent) {
        if (parent instanceof GraphicalEditPart) {
            List children = parent.getChildren();
            int bottom = -1;
            for (Object object : children) {
                LifelineEditPart lifeline;
                if (!(object instanceof LifelineEditPart) || SequenceUtil.isCreateMessageEndLifeline(lifeline = (LifelineEditPart)((Object)object))) continue;
                LifelineFigure lifelineFigure = lifeline.getPrimaryShape();
            }
            if (bottom != -1) {
                RectangleFigure figure = new RectangleFigure();
                figure.setBorder((Border)new MarginBorder(7));
                ToolbarLayout layout = new ToolbarLayout();
                layout.setMinorAlignment(0);
                Label label = new Label("Lifeline");
                label.setFont(Display.getDefault().getSystemFont());
                figure.add((IFigure)label);
                figure.setLayoutManager((LayoutManager)layout);
                int height = figure.getPreferredSize().height;
                return bottom - height - 1;
            }
        }
        return 10;
    }

    public static void updateHead(LifelineEditPart lifeline, int resized) {
        if (lifeline == null || resized == 0) {
            return;
        }
        ArrayList<LifelineEditPart> toMovedLifelines = new ArrayList<LifelineEditPart>();
        LifelineHeadUtil.collectLifelines(toMovedLifelines, (GraphicalEditPart)lifeline);
        List<ShapeNodeEditPart> children = LifelineEditPartUtil.getChildShapeNodeEditPart(lifeline);
        for (ShapeNodeEditPart child : children) {
            LifelineHeadUtil.collectLifelines(toMovedLifelines, (GraphicalEditPart)child);
        }
        EditPart parent = lifeline.getParent();
        while (parent instanceof LifelineEditPart) {
            parent = parent.getParent();
        }
        if (!SequenceUtil.isCreateMessageEndLifeline(lifeline)) {
            List childrenList = parent.getChildren();
            for (Object object : childrenList) {
                if (toMovedLifelines.contains(object) || !(object instanceof LifelineEditPart)) continue;
                toMovedLifelines.add((LifelineEditPart)((Object)object));
            }
        }
        if (toMovedLifelines.isEmpty()) {
            return;
        }
        CompoundCommand command = new CompoundCommand();
        LifelineHeadUtil.computeUpdateHeadCommand(command, lifeline, false, resized, new ArrayList<EditPart>());
        if (command.canExecute()) {
            CommandHelper.executeCommandWithoutHistory(lifeline.getEditingDomain(), (Command)command, true);
        }
    }

    private static void computeUpdateHeadCommand(CompoundCommand commands, LifelineEditPart lifeline, boolean moveChildren, int moveDelta, List<EditPart> movedEditParts) {
        if (moveChildren) {
            LifelineEditPart nodeToMove = lifeline;
            EditPart parent = lifeline.getParent();
            while (parent instanceof LifelineEditPart) {
                nodeToMove = (ShapeNodeEditPart)parent;
                parent = parent.getParent();
            }
            Command cmd = LifelineHeadUtil.getVerticalMoveShapeCommand((GraphicalEditPart)nodeToMove, moveDelta, false);
            commands.appendIfCanExecute(cmd);
        } else {
            View view = lifeline.getNotationView();
            LayoutConstraint constraint = ((Shape)view).getLayoutConstraint();
            if (constraint instanceof Size) {
                int height = ((Size)constraint).getHeight();
                if (height == -1) {
                    height = lifeline.getFigure().getBounds().height;
                }
                commands.appendIfCanExecute(SetCommand.create((EditingDomain)lifeline.getEditingDomain(), (Object)constraint, (Object)NotationPackage.eINSTANCE.getSize_Height(), (Object)(height += moveDelta)));
            }
        }
        movedEditParts.add((EditPart)lifeline);
        EObject elt = lifeline.resolveSemanticElement();
        if (elt instanceof Lifeline) {
            EList coveredBys = ((Lifeline)elt).getCoveredBys();
            EditPartViewer viewer = lifeline.getViewer();
            for (InteractionFragment fragment : coveredBys) {
                Object views;
                if (!(fragment instanceof CombinedFragment) && !(fragment instanceof InteractionUse) || (views = DiagramEditPartsUtil.findViews((EObject)fragment, (EditPartViewer)viewer)).isEmpty()) continue;
                Iterator iterator = views.iterator();
                while (iterator.hasNext()) {
                    View view = (View)iterator.next();
                    EditPart ep = (EditPart)viewer.getEditPartRegistry().get(view);
                    if (ep == null || movedEditParts.contains(ep)) continue;
                    EditPart parent = ep.getParent();
                    boolean parentMoved = false;
                    while (parent != null) {
                        if (movedEditParts.contains(parent)) {
                            parentMoved = true;
                            break;
                        }
                        parent = parent.getParent();
                    }
                    if (parentMoved || !(ep instanceof CombinedFragmentEditPart) && !(ep instanceof InteractionUseEditPart)) continue;
                    Command cmd = LifelineHeadUtil.getVerticalMoveShapeCommand((GraphicalEditPart)((ShapeNodeEditPart)ep), moveDelta, false);
                    commands.appendIfCanExecute(cmd);
                    movedEditParts.add(ep);
                    List children = ep.getChildren();
                    for (Object object : children) {
                        if (!movedEditParts.contains(object)) continue;
                    }
                }
            }
        }
        LifelineHeadUtil.fillMoveDownMessageEnds(commands, (GraphicalEditPart)lifeline, moveDelta, movedEditParts);
        List<ShapeNodeEditPart> childShapeNodeEditParts = LifelineEditPartUtil.getChildShapeNodeEditPart(lifeline);
        for (ShapeNodeEditPart shapeNodeEditPart : childShapeNodeEditParts) {
            LifelineHeadUtil.fillMoveDownMessageEnds(commands, (GraphicalEditPart)shapeNodeEditPart, moveDelta, movedEditParts);
        }
        if (SequenceUtil.isCreateMessageEndLifeline(lifeline)) {
            return;
        }
        ArrayList<LifelineEditPart> toMovedLifelines = new ArrayList<LifelineEditPart>();
        LifelineHeadUtil.collectLifelines(toMovedLifelines, (GraphicalEditPart)lifeline);
        List<ShapeNodeEditPart> children = LifelineEditPartUtil.getChildShapeNodeEditPart(lifeline);
        for (ShapeNodeEditPart child : children) {
            LifelineHeadUtil.collectLifelines(toMovedLifelines, (GraphicalEditPart)child);
        }
        EditPart parent = lifeline.getParent();
        while (parent instanceof LifelineEditPart) {
            parent = parent.getParent();
        }
        List childrenList = parent.getChildren();
        for (Object object : childrenList) {
            if (toMovedLifelines.contains(object) || !(object instanceof LifelineEditPart)) continue;
            toMovedLifelines.add((LifelineEditPart)((Object)object));
        }
        for (LifelineEditPart editPart : toMovedLifelines) {
            if (movedEditParts.contains((Object)editPart)) continue;
            LifelineHeadUtil.computeUpdateHeadCommand(commands, editPart, true, moveDelta, movedEditParts);
        }
    }

    private static void fillMoveDownMessageEnds(CompoundCommand commands, GraphicalEditPart editPart, int moveDelta, List<EditPart> movedEditParts) {
        Command command;
        List sourceConnections = editPart.getSourceConnections();
        for (Object object : sourceConnections) {
            ConnectionEditPart conn = (ConnectionEditPart)object;
            EditPart target = conn.getTarget();
            if (!(object instanceof MessageLostEditPart)) continue;
            command = LifelineHeadUtil.getMoveAnchorCommand(conn, moveDelta, false);
            commands.appendIfCanExecute(command);
        }
        List targetConnections = editPart.getTargetConnections();
        for (Object object : targetConnections) {
            ConnectionEditPart conn = (ConnectionEditPart)object;
            if (!(conn instanceof MessageFoundEditPart)) continue;
            command = LifelineHeadUtil.getMoveAnchorCommand(conn, moveDelta, true);
            commands.appendIfCanExecute(command);
        }
    }

    private static Command getMoveAnchorCommand(ConnectionEditPart conn, int moveDelta, boolean moveSource) {
        Anchor anchor;
        EditPart editPart;
        EditPart editPart2 = editPart = moveSource ? conn.getSource() : conn.getTarget();
        if (!(editPart instanceof IGraphicalEditPart)) {
            return null;
        }
        Object model = conn.getModel();
        if (!(model instanceof Edge)) {
            return null;
        }
        Edge edge = (Edge)model;
        Anchor anchor2 = anchor = moveSource ? edge.getSourceAnchor() : edge.getTargetAnchor();
        if (!(anchor instanceof IdentityAnchor)) {
            return null;
        }
        String terminal = ((IdentityAnchor)anchor).getId();
        PrecisionPoint pt = BaseSlidableAnchor.parseTerminalString((String)terminal);
        PrecisionPoint p = null;
        if (pt.preciseX() > 1.0 || pt.preciseY() > 1.0) {
            p = new PrecisionPoint(pt.preciseX(), pt.preciseY() + (double)moveDelta);
        } else {
            Rectangle bounds = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)editPart);
            PrecisionPoint location = new PrecisionPoint(pt.preciseX() * bounds.preciseWidth() + bounds.preciseX(), pt.preciseY() * bounds.preciseHeight() + bounds.preciseY());
            location.translate(0, moveDelta);
            Dimension d = location.getDifference(bounds.getTopLeft());
            p = new PrecisionPoint(d.preciseWidth() / (double)bounds.width, d.preciseHeight() / (double)bounds.height);
        }
        StringBuffer s = new StringBuffer(24);
        s.append('(');
        s.append(p.preciseX());
        s.append(',');
        s.append(p.preciseY());
        s.append(')');
        return SetCommand.create((EditingDomain)LifelineHeadUtil.getEditingDomain((GraphicalEditPart)editPart), (Object)anchor, (Object)NotationPackage.eINSTANCE.getIdentityAnchor_Id(), (Object)s.toString());
    }

    private static void collectLifelines(List<LifelineEditPart> toMovedLifelines, GraphicalEditPart editPart) {
        if (editPart == null) {
            return;
        }
        List sourceConnections = editPart.getSourceConnections();
        for (Object object : sourceConnections) {
            ConnectionEditPart conn = (ConnectionEditPart)object;
            LifelineEditPart target = LifelineHeadUtil.getLifeline(conn.getTarget());
            if (target == null || toMovedLifelines.contains((Object)target) || editPart == target) continue;
            toMovedLifelines.add(target);
        }
        List targetConnections = editPart.getTargetConnections();
        for (Object object : targetConnections) {
            ConnectionEditPart conn = (ConnectionEditPart)object;
            LifelineEditPart source = LifelineHeadUtil.getLifeline(conn.getSource());
            if (source == null || toMovedLifelines.contains((Object)source) || editPart == source) continue;
            toMovedLifelines.add(source);
        }
    }

    private static Command getVerticalMoveShapeCommand(GraphicalEditPart shapeEditPart, int moveDelta, boolean increaseHeight) {
        if (shapeEditPart == null || moveDelta == 0) {
            return null;
        }
        Object view = shapeEditPart.getModel();
        if (!(view instanceof Shape)) {
            return null;
        }
        LayoutConstraint constraint = ((Shape)view).getLayoutConstraint();
        if (!(constraint instanceof Location)) {
            return null;
        }
        int y = ((Location)constraint).getY();
        int value = y + moveDelta;
        Command command = SetCommand.create((EditingDomain)LifelineHeadUtil.getEditingDomain(shapeEditPart), (Object)constraint, (Object)NotationPackage.eINSTANCE.getLocation_Y(), (Object)value);
        if (increaseHeight && constraint instanceof Size) {
            int height = ((Size)constraint).getHeight();
            if (height == -1) {
                height = shapeEditPart.getFigure().getBounds().height;
            }
            command = command.chain(SetCommand.create((EditingDomain)LifelineHeadUtil.getEditingDomain(shapeEditPart), (Object)constraint, (Object)NotationPackage.eINSTANCE.getSize_Height(), (Object)(height += moveDelta)));
        }
        return command;
    }

    private static EditingDomain getEditingDomain(GraphicalEditPart editPart) {
        if (editPart instanceof IGraphicalEditPart) {
            return ((IGraphicalEditPart)editPart).getEditingDomain();
        }
        return null;
    }

    private static LifelineEditPart getLifeline(EditPart editPart) {
        if (editPart == null) {
            return null;
        }
        if (editPart instanceof LifelineEditPart) {
            return (LifelineEditPart)editPart;
        }
        return LifelineHeadUtil.getLifeline(editPart.getParent());
    }
}

