/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.richtext.celleditor;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.nebula.widgets.nattable.extension.nebula.richtext.RichTextCellEditor;
import org.eclipse.nebula.widgets.richtext.RichTextEditor;
import org.eclipse.nebula.widgets.richtext.toolbar.ToolbarConfiguration;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.widgets.editors.richtext.GenericRichTextEditor;
import org.eclipse.papyrus.uml.ui.editors.UMLRichtextEditorWithReferences;
import org.eclipse.papyrus.uml.ui.editors.UMLToolbarConfiguration;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.uml2.uml.Element;

public class RichTextCellEditorWithUMLReferences
extends RichTextCellEditor {
    public RichTextCellEditorWithUMLReferences() {
        this(16);
    }

    public RichTextCellEditorWithUMLReferences(int style) {
        this(new UMLToolbarConfiguration(), style);
    }

    public RichTextCellEditorWithUMLReferences(UMLToolbarConfiguration toolbarConfiguration, int style) {
        super((ToolbarConfiguration)toolbarConfiguration, style);
    }

    public RichTextCellEditorWithUMLReferences(UMLToolbarConfiguration toolbarConfiguration) {
        this(toolbarConfiguration, 16);
    }

    protected RichTextEditor createRichTextEditor(Composite parent) {
        return new UMLRichtextEditorWithReferences(parent, this.style){

            protected int getMinimumHeight() {
                return RichTextCellEditorWithUMLReferences.this.getMinimumDimension().y;
            }

            protected int getMinimumWidth() {
                return RichTextCellEditorWithUMLReferences.this.getMinimumDimension().x;
            }
        };
    }

    protected Control activateCell(Composite parent, Object originalCanonicalValue) {
        Control ctrl = super.activateCell(parent, originalCanonicalValue);
        if (this.editor instanceof GenericRichTextEditor) {
            Element editedElement = this.getEditedElement();
            EStructuralFeature editedFeature = this.getEditedFeature();
            if (editedElement != null && editedFeature != null) {
                ((GenericRichTextEditor)this.editor).configureEdition((EObject)editedElement, editedFeature);
            }
        }
        return ctrl;
    }

    protected EStructuralFeature getEditedFeature() {
        INattableModelManager manager = (INattableModelManager)this.configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
        Object columnObject = AxisUtils.getRepresentedElement((Object)manager.getColumnElement(this.getColumnIndex()));
        EStructuralFeature editedFeature = null;
        if (columnObject instanceof EStructuralFeature) {
            editedFeature = (EStructuralFeature)columnObject;
        } else {
            Object rowObject = AxisUtils.getRepresentedElement((Object)manager.getRowElement(this.getRowIndex()));
            if (rowObject instanceof EStructuralFeature) {
                editedFeature = (EStructuralFeature)rowObject;
            }
        }
        return editedFeature;
    }

    protected Element getEditedElement() {
        INattableModelManager manager = (INattableModelManager)this.configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
        Object rowObject = AxisUtils.getRepresentedElement((Object)manager.getRowElement(this.getRowIndex()));
        Element editedElement = null;
        if (rowObject instanceof Element) {
            editedElement = (Element)rowObject;
        } else {
            Object columnObject = AxisUtils.getRepresentedElement((Object)manager.getColumnElement(this.getColumnIndex()));
            if (columnObject instanceof Element) {
                editedElement = (Element)rowObject;
            }
        }
        return editedElement;
    }

    protected Point getMinimumDimension() {
        return new Point(370, 400);
    }
}

