/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.util;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.AbstractRepresentation;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.DiagramExpansion;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.ExpansionModelPackage;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.GMFT_BasedRepresentation;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.GraphicalElementLibrary;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.InducedRepresentation;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.Representation;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.RepresentationKind;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.UseContext;

public class ExpansionModelValidator
extends EObjectValidator {
    public static final ExpansionModelValidator INSTANCE = new ExpansionModelValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel";
    public static final int ABSTRACT_REPRESENTATION__VALIDATE = 1;
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 1;
    protected static final int DIAGNOSTIC_CODE_COUNT = 1;

    protected EPackage getEPackage() {
        return ExpansionModelPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateRepresentation((Representation)value, diagnostics, context);
            }
            case 1: {
                return this.validateAbstractRepresentation((AbstractRepresentation)value, diagnostics, context);
            }
            case 2: {
                return this.validateRepresentationKind((RepresentationKind)value, diagnostics, context);
            }
            case 3: {
                return this.validateInducedRepresentation((InducedRepresentation)value, diagnostics, context);
            }
            case 4: {
                return this.validateGraphicalElementLibrary((GraphicalElementLibrary)value, diagnostics, context);
            }
            case 5: {
                return this.validateUseContext((UseContext)value, diagnostics, context);
            }
            case 6: {
                return this.validateGMFT_BasedRepresentation((GMFT_BasedRepresentation)value, diagnostics, context);
            }
            case 7: {
                return this.validateDiagramExpansion((DiagramExpansion)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateRepresentation(Representation representation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(representation, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(representation, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(representation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(representation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(representation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(representation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(representation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(representation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(representation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAbstractRepresentation_validate(representation, diagnostics, context);
        }
        return result;
    }

    public boolean validateAbstractRepresentation(AbstractRepresentation abstractRepresentation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(abstractRepresentation, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(abstractRepresentation, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(abstractRepresentation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(abstractRepresentation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(abstractRepresentation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(abstractRepresentation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(abstractRepresentation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(abstractRepresentation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(abstractRepresentation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAbstractRepresentation_validate(abstractRepresentation, diagnostics, context);
        }
        return result;
    }

    public boolean validateAbstractRepresentation_validate(AbstractRepresentation abstractRepresentation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return abstractRepresentation.validate(diagnostics, context);
    }

    public boolean validateRepresentationKind(RepresentationKind representationKind, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(representationKind, diagnostics, context);
    }

    public boolean validateInducedRepresentation(InducedRepresentation inducedRepresentation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(inducedRepresentation, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(inducedRepresentation, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(inducedRepresentation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(inducedRepresentation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(inducedRepresentation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(inducedRepresentation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(inducedRepresentation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(inducedRepresentation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(inducedRepresentation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAbstractRepresentation_validate(inducedRepresentation, diagnostics, context);
        }
        return result;
    }

    public boolean validateGraphicalElementLibrary(GraphicalElementLibrary graphicalElementLibrary, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(graphicalElementLibrary, diagnostics, context);
    }

    public boolean validateUseContext(UseContext useContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(useContext, diagnostics, context);
    }

    public boolean validateGMFT_BasedRepresentation(GMFT_BasedRepresentation gmfT_BasedRepresentation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(gmfT_BasedRepresentation, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(gmfT_BasedRepresentation, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(gmfT_BasedRepresentation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(gmfT_BasedRepresentation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(gmfT_BasedRepresentation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(gmfT_BasedRepresentation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(gmfT_BasedRepresentation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(gmfT_BasedRepresentation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(gmfT_BasedRepresentation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAbstractRepresentation_validate(gmfT_BasedRepresentation, diagnostics, context);
        }
        return result;
    }

    public boolean validateDiagramExpansion(DiagramExpansion diagramExpansion, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(diagramExpansion, diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

