/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.compartments;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class U2TCompartmentFigure
extends ResizableCompartmentFigure {
    private CenteredLine myTextPane;
    private boolean myTextPaneReplaced;
    private String myTitle;

    public U2TCompartmentFigure(String name, IMapMode mapMode) {
        super(name, mapMode);
        ConstrainedToolbarLayout withStrecthMinorAxis = new ConstrainedToolbarLayout();
        withStrecthMinorAxis.setStretchMinorAxis(true);
        this.setLayoutManager((LayoutManager)withStrecthMinorAxis);
        int oldTextPaneIndex = this.getChildren().indexOf(super.getTextPane());
        this.remove((IFigure)super.getTextPane());
        this.myTextPane = new CenteredLine(this);
        this.myTextPaneReplaced = true;
        this.add((IFigure)this.myTextPane, oldTextPaneIndex);
        this.setTitle(name);
        this.setBorder((Border)new MarginBorder(0, 0, 0, 0));
    }

    public void setFont(Font f) {
        this.getTextPane().setFont(f);
    }

    public void setFontColor(Color c) {
    }

    public Figure getTextPane() {
        if (!this.myTextPaneReplaced) {
            return super.getTextPane();
        }
        return this.myTextPane;
    }

    public void setSelected(boolean b) {
    }

    public void setTitle(String title) {
        this.myTitle = title;
    }

    public String getTitleNotNull() {
        return this.myTitle == null ? "" : this.myTitle;
    }

    public Rectangle getTextPaneBounds() {
        return this.myTextPane.getBounds();
    }

    private static class CenteredLine
    extends Shape {
        private static final int DEFAULT_HEIGHT = 10;
        private final U2TCompartmentFigure myHost;
        private int myLineBorderGap = 0;
        private Label myTextMeasure;

        public CenteredLine(U2TCompartmentFigure host) {
            this.myHost = host;
            this.myTextMeasure = new Label();
            this.setFill(true);
        }

        public void setFont(Font f) {
            super.setFont(f);
        }

        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, this.getPreferredSize().width);
        }

        public Dimension getPreferredSize(int wHint, int hHint) {
            Dimension result = new Dimension(wHint, 10);
            String title = this.myHost.getTitleNotNull();
            if (this.getFont() != null) {
                this.myTextMeasure.setFont(this.getFont());
                this.myTextMeasure.setText(title);
                Dimension textSize = this.myTextMeasure.getPreferredSize(wHint, hHint);
                result.height = textSize.height;
                if (wHint == -1) {
                    result.width = textSize.width;
                }
            }
            return result;
        }

        public Dimension getMinimumSize(int wHint, int hHint) {
            Dimension result = new Dimension(-1, -1);
            String title = this.myHost.getTitleNotNull();
            if (this.getFont() != null) {
                this.myTextMeasure.setFont(this.getFont());
                this.myTextMeasure.setText(title);
                Dimension textSize = this.myTextMeasure.getMinimumSize(wHint, hHint);
                result.setSize(textSize);
            }
            return result;
        }

        protected void outlineShape(Graphics graphics) {
            graphics.translate(this.getLocation());
            graphics.setLineWidth(this.getLineWidth());
            graphics.setLineStyle(this.getLineStyle());
            Rectangle localBounds = this.getBounds();
            if (localBounds.width > 2 * this.myLineBorderGap) {
                int lineY = localBounds.height / 2 - this.getLineWidth() / 2 + 1;
                graphics.drawLine(this.myLineBorderGap, lineY, localBounds.width - this.myLineBorderGap, lineY);
            }
        }

        protected void fillShape(Graphics graphics) {
        }

        public void setLineBorderGap(int lineBorderGap) {
            this.myLineBorderGap = lineBorderGap;
        }
    }
}

