/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.sheet.chooser;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;

public class FilteredListControl
extends Composite {
    private boolean fIgnoreCase = true;
    private boolean fIsMultipleSelection = false;
    private boolean fMatchEmptyString = true;
    private boolean fAllowDuplicates = true;
    private Text fFilterText;
    private List<Object> myInitialSelections = new ArrayList<Object>();
    private String fFilter = null;
    protected FilteredList fFilteredList;
    private final ILabelProvider fRenderer;
    private FilteredList myFilteredList;
    private TableViewer viewer;

    public FilteredListControl(Composite parent, ILabelProvider renderer) {
        super(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        this.fRenderer = renderer;
        this.createFilterText(this);
        this.myFilteredList = this.createFilteredList(this);
    }

    protected void setFilterMatcher(FilteredList.FilterMatcher filterMatcher) {
        this.myFilteredList.setFilterMatcher(filterMatcher);
    }

    public void setInitialSelections(Object[] selectedElements) {
        this.myInitialSelections = new ArrayList<Object>(selectedElements.length);
        int i = 0;
        while (i < selectedElements.length) {
            this.myInitialSelections.add(selectedElements[i]);
            ++i;
        }
    }

    public boolean setFocus() {
        if (this.myFilteredList != null) {
            return this.myFilteredList.setFocus();
        }
        return super.setFocus();
    }

    protected Text createFilterText(Composite parent) {
        Text text = new Text(parent, 2048);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        text.setLayoutData((Object)data);
        text.setFont(parent.getFont());
        text.setText(this.fFilter == null ? "" : this.fFilter);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                FilteredListControl.this.fFilteredList.setFilter(FilteredListControl.this.fFilterText.getText());
            }
        };
        text.addListener(24, listener);
        text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    FilteredListControl.this.fFilteredList.setFocus();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.fFilterText = text;
        return text;
    }

    private Table getTable(FilteredList list) {
        try {
            Field field = list.getClass().getDeclaredField("fList");
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            Object value = field.get(list);
            return (Table)value;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected FilteredList createFilteredList(Composite parent) {
        int flags = 0xB00 | (this.fIsMultipleSelection ? 2 : 4);
        FilteredList list = new FilteredList(parent, flags, this.fRenderer, this.fIgnoreCase, this.fAllowDuplicates, this.fMatchEmptyString);
        Table table = this.getTable(list);
        if (table != null) {
            this.viewer = new TableViewer(table);
        }
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        list.setLayoutData((Object)data);
        list.setFont(parent.getFont());
        list.setFilter(this.fFilter == null ? "" : this.fFilter);
        this.fFilteredList = list;
        return list;
    }

    protected void setListElements(Object[] elements) {
        Assert.isNotNull((Object)this.fFilteredList);
        this.fFilteredList.setElements(elements);
    }

    public void setFilter(String filter) {
        if (this.fFilterText == null) {
            this.fFilter = filter;
        } else {
            this.fFilterText.setText(filter);
        }
    }

    public String getFilter() {
        if (this.fFilteredList == null) {
            return this.fFilter;
        }
        return this.fFilteredList.getFilter();
    }

    protected int[] getSelectionIndices() {
        Assert.isNotNull((Object)this.fFilteredList);
        return this.fFilteredList.getSelectionIndices();
    }

    protected int getSelectionIndex() {
        Assert.isNotNull((Object)this.fFilteredList);
        return this.fFilteredList.getSelectionIndex();
    }

    protected void setSelection(Object[] selection) {
        Assert.isNotNull((Object)this.fFilteredList);
        this.fFilteredList.setSelection(selection);
    }

    protected Object[] getSelectedElements() {
        Assert.isNotNull((Object)this.fFilteredList);
        return this.fFilteredList.getSelection();
    }

    public Object[] getFoldedElements(int index) {
        Assert.isNotNull((Object)this.fFilteredList);
        return this.fFilteredList.getFoldedElements(index);
    }

    public void addDoubleClickListener(IDoubleClickListener l) {
        this.viewer.addDoubleClickListener(l);
    }

    public void addSelectionListener(ISelectionChangedListener l) {
        this.viewer.addSelectionChangedListener(l);
    }
}

