/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.editor.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.celleditor.FeatureEditorDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.editor.UMLEditorPlugin;
import org.eclipse.uml2.uml.editor.actions.UMLCommandAction;
import org.eclipse.uml2.uml.util.UMLSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyProfileAction
extends UMLCommandAction {
    protected Command createActionCommand(EditingDomain editingDomain, Collection<?> collection) {
        if (collection.size() == 1 && collection.iterator().next() instanceof Package) {
            return IdentityCommand.INSTANCE;
        }
        return UnexecutableCommand.INSTANCE;
    }

    public void run(IAction action) {
        if (this.command != UnexecutableCommand.INSTANCE) {
            final Package package_ = (Package)this.collection.iterator().next();
            final ArrayList choiceOfValues = new ArrayList();
            ResourceSet resourceSet = package_.eResource().getResourceSet();
            for (URI profileURI : UMLPlugin.getEPackageNsURIToProfileLocationMap().values()) {
                try {
                    resourceSet.getResource(profileURI.trimFragment(), true);
                }
                catch (Exception exception) {}
            }
            for (Resource resource : resourceSet.getResources()) {
                TreeIterator allContents = resource.getAllContents();
                while (allContents.hasNext()) {
                    new UMLSwitch<Object>(){

                        public Object caseProfile(Profile profile) {
                            ProfileApplication profileApplication;
                            if (profile.isDefined() && ((profileApplication = package_.getProfileApplication(profile)) == null || profileApplication.getAppliedDefinition() != profile.getDefinition())) {
                                choiceOfValues.add(profile);
                            }
                            return profile;
                        }
                    }.doSwitch((EObject)allContents.next());
                }
            }
            Collections.sort(choiceOfValues, new UMLCommandAction.TextComparator(this));
            String label = UMLEditorPlugin.INSTANCE.getString("_UI_ApplyProfileActionCommand_label");
            final FeatureEditorDialog dialog = new FeatureEditorDialog(this.workbenchPart.getSite().getShell(), this.getLabelProvider(), (Object)package_, (EClassifier)UMLPackage.Literals.PROFILE, Collections.EMPTY_LIST, label, choiceOfValues);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                this.editingDomain.getCommandStack().execute((Command)new UMLCommandAction.RefreshingChangeCommand(this, this.editingDomain, new Runnable(){

                    public void run() {
                        for (Object result : dialog.getResult()) {
                            package_.applyProfile((Profile)result);
                        }
                    }
                }, label));
            }
        }
    }
}

