/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.owl.reasoner.structural;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.eodm.owl.reasoner.structural.AllValueFrom;
import org.eclipse.eodm.owl.reasoner.structural.AllValueFromLink;
import org.eclipse.eodm.owl.reasoner.structural.CTNode;
import org.eclipse.eodm.owl.reasoner.structural.Concept;
import org.eclipse.eodm.owl.reasoner.structural.ConjunctionLink;
import org.eclipse.eodm.owl.reasoner.structural.ContainmentLink;
import org.eclipse.eodm.owl.reasoner.structural.DisjunctionLink;
import org.eclipse.eodm.owl.reasoner.structural.Intersection;
import org.eclipse.eodm.owl.reasoner.structural.NodeLink;
import org.eclipse.eodm.owl.reasoner.structural.RBox;
import org.eclipse.eodm.owl.reasoner.structural.ReasonerUtil;
import org.eclipse.eodm.owl.reasoner.structural.SomeValueFrom;
import org.eclipse.eodm.owl.reasoner.structural.SomeValueFromLink;
import org.eclipse.eodm.owl.reasoner.structural.TermFactory;
import org.eclipse.eodm.owl.reasoner.structural.Union;

public class TBox {
    RBox rbox = null;
    private int nextTargetID = 0;
    private int[] targetValue = new int[10];
    private int[] targetCounter = new int[10];
    ArrayList conceptList = new ArrayList();
    ArrayList nodeList = new ArrayList();
    CTNode thingNode;
    CTNode nothingNode;
    int[] flags = new int[10];
    HashMap cid2NodeMap = new HashMap();
    HashMap idString2IDMap = new HashMap();
    HashSet exprSet = new HashSet();

    public TBox(RBox rbox) {
        this.rbox = rbox;
        int thingID = this.getConceptID(ReasonerUtil.TOP, false, true);
        int nothingID = this.getConceptID(ReasonerUtil.BOTTOM, false, true);
        this.thingNode = new CTNode(this, thingID);
        this.nothingNode = new CTNode(this, nothingID);
        this.addNodeContainment(this.thingNode, this.nothingNode);
        new AllValueFromLink(this, this.thingNode, this.thingNode, rbox.getTopPropertyID());
        new SomeValueFromLink(this, this.nothingNode, this.nothingNode, rbox.getTopPropertyID());
    }

    public void addConcept(Concept c) {
        this.classify(c);
    }

    public void addSubOfAxiom(Concept child, Concept father) {
        CTNode childNode = this.classify(child);
        CTNode fatherNode = this.classify(father);
        this.addNodeContainment(fatherNode, childNode);
    }

    public void addEquivalentAxiom(Concept c1, Concept c2) {
        CTNode n1 = this.classify(c1);
        CTNode n2 = this.classify(c2);
        this.addNodeContainment(n1, n2);
        this.addNodeContainment(n2, n1);
    }

    public void addDisjoint(Concept c1, Concept c2) {
        Intersection in = TermFactory.instance().createIntersect(c1, c2);
        this.addSubOfAxiom(in, ReasonerUtil.BOTTOM);
    }

    public RBox getRBox() {
        return this.rbox;
    }

    CTNode classify(Concept c) {
        Concept[] forms = ReasonerUtil.getAllForms(c, this.rbox);
        CTNode n = this.getNodeByConcept(forms[0], false);
        if (n != null) {
            return n;
        }
        int cid = this.getConceptID(forms[0], false, true);
        int i = 0;
        while (i < forms.length) {
            if (!this.exprSet.contains(forms[i])) {
                this.exprSet.add(forms[i]);
                n = this.classify(forms[i], cid, n);
            }
            ++i;
        }
        return n;
    }

    CTNode classify(Concept c, int cID, CTNode node) {
        ArrayList<CTNode> superClassList = new ArrayList<CTNode>();
        superClassList.add(this.thingNode);
        ArrayList<CTNode> subClassList = new ArrayList<CTNode>();
        subClassList.add(this.nothingNode);
        if (node == null) {
            node = new CTNode(this, cID);
        } else {
            node.addConceptID(cID);
        }
        switch (c.getCType()) {
            case 12: {
                ArrayList<CTNode> inNodeList = new ArrayList<CTNode>();
                Iterator it = ((Intersection)c).getIntersectOf().iterator();
                while (it.hasNext()) {
                    CTNode v = this.classify((Concept)it.next());
                    inNodeList.add(v);
                }
                int i = inNodeList.size() - 1;
                while (i >= 0) {
                    CTNode v1 = (CTNode)inNodeList.get(i);
                    int j = i - 1;
                    while (j >= 0) {
                        CTNode v2 = (CTNode)inNodeList.get(j);
                        if (this.isSubNodeOf(v1, v2)) {
                            inNodeList.remove(j);
                            --i;
                        } else if (this.isSubNodeOf(v2, v1)) {
                            inNodeList.remove(i);
                            break;
                        }
                        --j;
                    }
                    --i;
                }
                superClassList.addAll(inNodeList);
                subClassList.addAll(this.getSubNodes(inNodeList));
                int targetID = this.getNextTargetID();
                int i2 = 0;
                while (i2 < inNodeList.size()) {
                    new ConjunctionLink(this, ((CTNode)inNodeList.get(i2)).getAlternativeNode(), node.getAlternativeNode(), targetID);
                    ++i2;
                }
                this.targetValue[targetID] = inNodeList.size();
                break;
            }
            case 13: {
                CTNode v;
                ArrayList<CTNode> unNodeList = new ArrayList<CTNode>();
                Iterator it = ((Union)c).getUnionOf().iterator();
                while (it.hasNext()) {
                    v = this.classify((Concept)it.next());
                    unNodeList.add(v);
                }
                int i = unNodeList.size() - 1;
                while (i >= 0) {
                    CTNode v1 = (CTNode)unNodeList.get(i);
                    int j = i - 1;
                    while (j >= 0) {
                        CTNode v2 = (CTNode)unNodeList.get(j);
                        if (this.isSubNodeOf(v2, v1)) {
                            unNodeList.remove(j);
                            --i;
                        } else if (this.isSubNodeOf(v1, v2)) {
                            unNodeList.remove(i);
                            break;
                        }
                        --j;
                    }
                    --i;
                }
                subClassList.addAll(unNodeList);
                superClassList.addAll(this.getSuperNodes(unNodeList));
                int targetID = this.getNextTargetID();
                i = 0;
                while (i < unNodeList.size()) {
                    new DisjunctionLink(this, ((CTNode)unNodeList.get(i)).getAlternativeNode(), node.getAlternativeNode(), targetID);
                    ++i;
                }
                this.targetValue[targetID] = unNodeList.size();
                break;
            }
            case 14: {
                NodeLink link;
                Iterator iter1;
                int pID = this.rbox.getCreatePropertyID(((SomeValueFrom)c).getOnProperty());
                CTNode v = this.classify(((SomeValueFrom)c).getRange());
                new SomeValueFromLink(this, node.getAlternativeNode(), v.getAlternativeNode(), pID);
                Iterator iter = this.getSuperNodes(v).iterator();
                while (iter.hasNext()) {
                    iter1 = ((CTNode)iter.next()).someValuesFromByLinks.iterator();
                    while (iter1.hasNext()) {
                        link = (SomeValueFromLink)iter1.next();
                        if (!this.rbox.isSubPropertyOf(pID, ((SomeValueFromLink)link).propertyID)) continue;
                        superClassList.add(link.getSource());
                    }
                }
                iter = this.getSubNodes(v).iterator();
                while (iter.hasNext()) {
                    iter1 = ((CTNode)iter.next()).someValuesFromByLinks.iterator();
                    while (iter1.hasNext()) {
                        link = (SomeValueFromLink)iter1.next();
                        if (!this.rbox.isSubPropertyOf(((SomeValueFromLink)link).propertyID, pID)) continue;
                        subClassList.add(link.getSource());
                    }
                }
                break;
            }
            case 15: {
                NodeLink link;
                Iterator iter1;
                int pID = this.rbox.getCreatePropertyID(((AllValueFrom)c).getOnProperty());
                CTNode v = this.classify(((AllValueFrom)c).getRange());
                new AllValueFromLink(this, node.getAlternativeNode(), v.getAlternativeNode(), pID);
                Iterator iter = this.getSuperNodes(v).iterator();
                while (iter.hasNext()) {
                    iter1 = ((CTNode)iter.next()).allValuesFromByLinks.iterator();
                    while (iter1.hasNext()) {
                        link = (AllValueFromLink)iter1.next();
                        if (!this.rbox.isSubPropertyOf(((AllValueFromLink)link).propertyID, pID)) continue;
                        superClassList.add(link.getSource());
                    }
                }
                iter = this.getSubNodes(v).iterator();
                while (iter.hasNext()) {
                    iter1 = ((CTNode)iter.next()).allValuesFromByLinks.iterator();
                    while (iter1.hasNext()) {
                        link = (AllValueFromLink)iter1.next();
                        if (!this.rbox.isSubPropertyOf(pID, ((AllValueFromLink)link).propertyID)) continue;
                        subClassList.add(link.getSource());
                    }
                }
                break;
            }
        }
        Iterator iter = superClassList.iterator();
        while (iter.hasNext()) {
            this.addNodeContainment((CTNode)iter.next(), node);
        }
        iter = subClassList.iterator();
        while (iter.hasNext()) {
            this.addNodeContainment(node, (CTNode)iter.next());
        }
        return node.getAlternativeNode();
    }

    public List getSubNodes(CTNode v) {
        ArrayList<CTNode> result = new ArrayList<CTNode>();
        int p = v.getAlternativeNode().topologicalPosition;
        int i = this.nodeList.size() - 1;
        while (i >= p) {
            this.flags[i] = 0;
            --i;
        }
        this.flags[p] = 1;
        i = p;
        while (i < this.nodeList.size()) {
            if (this.flags[i] == 1) {
                CTNode v1 = (CTNode)this.nodeList.get(i);
                result.add(v1);
                Iterator iter = v1.containmentLinks.iterator();
                while (iter.hasNext()) {
                    this.flags[((ContainmentLink)iter.next()).getTarget().topologicalPosition] = 1;
                }
            }
            ++i;
        }
        return result;
    }

    public List getSuperNodes(CTNode v) {
        ArrayList<CTNode> result = new ArrayList<CTNode>();
        int p = v.getAlternativeNode().topologicalPosition;
        int i = 0;
        while (i <= p) {
            this.flags[i] = 0;
            ++i;
        }
        this.flags[p] = 1;
        i = p;
        while (i >= 0) {
            if (this.flags[i] == 1) {
                CTNode v1 = (CTNode)this.nodeList.get(i);
                result.add(v1);
                Iterator iter = v1.containmentByLinks.iterator();
                while (iter.hasNext()) {
                    this.flags[((ContainmentLink)iter.next()).getSource().topologicalPosition] = 1;
                }
            }
            --i;
        }
        return result;
    }

    public List getSubNodes(Collection c) {
        ArrayList<CTNode> result = new ArrayList<CTNode>();
        if (c.size() <= 31) {
            int i = this.nodeList.size() - 1;
            while (i >= 0) {
                this.flags[i] = 0;
                --i;
            }
            Iterator iter = c.iterator();
            int index = 0;
            int min = this.nodeList.size();
            while (iter.hasNext()) {
                int p = ((CTNode)iter.next()).getAlternativeNode().topologicalPosition;
                int n = p < min ? p : p;
                this.flags[n] = this.flags[n] | 1 << index++;
            }
            int target = (1 << index) - 1;
            int i2 = min;
            while (i2 < this.nodeList.size()) {
                if (this.flags[i2] > 0) {
                    CTNode v1 = (CTNode)this.nodeList.get(i2);
                    if (this.flags[i2] == target) {
                        result.add(v1);
                    }
                    iter = v1.containmentLinks.iterator();
                    while (iter.hasNext()) {
                        int n = ((ContainmentLink)iter.next()).getTarget().topologicalPosition;
                        this.flags[n] = this.flags[n] | this.flags[i2];
                    }
                }
                ++i2;
            }
        } else {
            int i;
            int i3 = this.nodeList.size() - 1;
            while (i3 >= 0) {
                this.flags[i3] = 1;
                --i3;
            }
            Iterator iter = c.iterator();
            int[] flags1 = new int[this.nodeList.size()];
            while (iter.hasNext()) {
                i = 0;
                while (i < flags1.length) {
                    flags1[i] = 0;
                    ++i;
                }
                int p = ((CTNode)iter.next()).getAlternativeNode().topologicalPosition;
                flags1[p] = 1;
                int i4 = 0;
                while (i4 < flags1.length) {
                    if (flags1[i4] == 1) {
                        Iterator iter1 = ((CTNode)this.nodeList.get((int)i4)).containmentLinks.iterator();
                        while (iter1.hasNext()) {
                            flags1[((ContainmentLink)iter1.next()).getTarget().topologicalPosition] = 1;
                        }
                    } else {
                        this.flags[i4] = 0;
                    }
                    ++i4;
                }
            }
            i = 0;
            while (i < this.nodeList.size()) {
                if (this.flags[i] == 1) {
                    result.add((CTNode)this.nodeList.get(i));
                }
                ++i;
            }
        }
        return result;
    }

    public List getSuperNodes(Collection c) {
        ArrayList<CTNode> result = new ArrayList<CTNode>();
        if (c.size() <= 31) {
            int i = this.nodeList.size() - 1;
            while (i >= 0) {
                this.flags[i] = 0;
                --i;
            }
            Iterator iter = c.iterator();
            int index = 0;
            int max = -1;
            while (iter.hasNext()) {
                int p = ((CTNode)iter.next()).getAlternativeNode().topologicalPosition;
                int n = p > max ? p : p;
                this.flags[n] = this.flags[n] | 1 << index++;
            }
            int target = (1 << index) - 1;
            int i2 = max;
            while (i2 >= 0) {
                if (this.flags[i2] > 0) {
                    CTNode v1 = (CTNode)this.nodeList.get(i2);
                    if (this.flags[i2] == target) {
                        result.add(v1);
                    }
                    iter = v1.containmentByLinks.iterator();
                    while (iter.hasNext()) {
                        int n = ((ContainmentLink)iter.next()).getSource().topologicalPosition;
                        this.flags[n] = this.flags[n] | this.flags[i2];
                    }
                }
                --i2;
            }
        } else {
            int i;
            int i3 = this.nodeList.size() - 1;
            while (i3 >= 0) {
                this.flags[i3] = 1;
                --i3;
            }
            Iterator iter = c.iterator();
            int[] flags1 = new int[this.nodeList.size()];
            while (iter.hasNext()) {
                i = 0;
                while (i < flags1.length) {
                    flags1[i] = 0;
                    ++i;
                }
                int p = ((CTNode)iter.next()).getAlternativeNode().topologicalPosition;
                flags1[p] = 1;
                int i4 = flags1.length - 1;
                while (i4 >= 0) {
                    if (flags1[i4] == 1) {
                        Iterator iter1 = ((CTNode)this.nodeList.get((int)i4)).containmentByLinks.iterator();
                        while (iter1.hasNext()) {
                            flags1[((ContainmentLink)iter1.next()).getTarget().topologicalPosition] = 1;
                        }
                    } else {
                        this.flags[i4] = 0;
                    }
                    --i4;
                }
            }
            i = 0;
            while (i < this.nodeList.size()) {
                if (this.flags[i] == 1) {
                    result.add((CTNode)this.nodeList.get(i));
                }
                ++i;
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private List getSubClassNodesWithRemoveRedundancy(CTNode v) {
        result = new ArrayList<CTNode>();
        p = v.getAlternativeNode().topologicalPosition;
        i = this.nodeList.size() - 1;
        while (i >= p) {
            this.flags[i] = 0;
            --i;
        }
        this.flags[p] = 1;
        tempArray = new ContainmentLink[this.nodeList.size()];
        i = p;
        while (i < this.nodeList.size()) {
            block6: {
                if (this.flags[i] != 1) break block6;
                v1 = (CTNode)this.nodeList.get(i);
                result.add(v1);
                iter = v1.containmentLinks.iterator();
                if (i != p) ** GOTO lbl43
                removeList = new ArrayList<ContainmentLink>();
                while (iter.hasNext()) {
                    link = (ContainmentLink)iter.next();
                    target = link.getTarget().topologicalPosition;
                    if (this.flags[target] == 1) {
                        removeList.add(link);
                        continue;
                    }
                    this.flags[target] = 1;
                    tempArray[target] = link;
                }
                j = 0;
                while (j < removeList.size()) {
                    link = (ContainmentLink)removeList.get(j);
                    link.setSource(null);
                    link.setTarget(null);
                    ++j;
                }
                break block6;
lbl-1000:
                // 1 sources

                {
                    target = ((ContainmentLink)iter.next()).getTarget().topologicalPosition;
                    this.flags[target] = 1;
                    if (tempArray[target] == null) continue;
                    tempArray[target].setSource(null);
                    tempArray[target].setTarget(null);
                    tempArray[target] = null;
lbl43:
                    // 3 sources

                    ** while (iter.hasNext())
                }
            }
            ++i;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private List getSuperClassNodesWithRemoveRedundancy(CTNode v) {
        result = new ArrayList<CTNode>();
        p = v.getAlternativeNode().topologicalPosition;
        i = 0;
        while (i <= p) {
            this.flags[i] = 0;
            ++i;
        }
        this.flags[p] = 1;
        tempArray = new ContainmentLink[p + 1];
        i = p;
        while (i >= 0) {
            block6: {
                if (this.flags[i] != 1) break block6;
                v1 = (CTNode)this.nodeList.get(i);
                result.add(v1);
                iter = v1.containmentByLinks.iterator();
                if (i != p) ** GOTO lbl43
                removeList = new ArrayList<ContainmentLink>();
                while (iter.hasNext()) {
                    link = (ContainmentLink)iter.next();
                    source = link.getSource().topologicalPosition;
                    if (this.flags[source] == 1) {
                        removeList.add(link);
                        continue;
                    }
                    this.flags[source] = 1;
                    tempArray[source] = link;
                }
                j = 0;
                while (j < removeList.size()) {
                    link = (ContainmentLink)removeList.get(j);
                    link.setSource(null);
                    link.setTarget(null);
                    ++j;
                }
                break block6;
lbl-1000:
                // 1 sources

                {
                    source = ((ContainmentLink)iter.next()).getSource().topologicalPosition;
                    this.flags[source] = 1;
                    if (tempArray[source] == null) continue;
                    tempArray[source].setSource(null);
                    tempArray[source].setTarget(null);
                    tempArray[source] = null;
lbl43:
                    // 3 sources

                    ** while (iter.hasNext())
                }
            }
            --i;
        }
        return result;
    }

    public CTNode findNextSubClassDisjunction(CTNode v) {
        CTNode v1;
        int p = v.getAlternativeNode().topologicalPosition;
        int i = this.nodeList.size() - 1;
        while (i >= p) {
            this.flags[i] = 0;
            --i;
        }
        i = 0;
        while (i < this.targetCounter.length) {
            this.targetCounter[i] = 0;
            ++i;
        }
        ArrayList<CTNode> tempList = new ArrayList<CTNode>();
        this.flags[p] = 1;
        int i2 = p;
        while (i2 < this.nodeList.size()) {
            if (this.flags[i2] == 1) {
                v1 = (CTNode)this.nodeList.get(i2);
                Iterator iter = v1.containmentLinks.iterator();
                while (iter.hasNext()) {
                    this.flags[((ContainmentLink)iter.next()).getTarget().topologicalPosition] = 1;
                }
                iter = v1.disjunctionLinks.iterator();
                while (iter.hasNext()) {
                    DisjunctionLink link = (DisjunctionLink)iter.next();
                    int n = link.getTargetID();
                    if (this.targetValue[link.getTargetID()] != (this.targetCounter[n] = this.targetCounter[n] + 1) || this.flags[link.getTarget().topologicalPosition] != 0) continue;
                    tempList.add(link.getTarget());
                }
            }
            ++i2;
        }
        Iterator iter = tempList.iterator();
        while (iter.hasNext()) {
            v1 = (CTNode)iter.next();
            if (this.flags[v1.topologicalPosition] != 0) continue;
            return v1;
        }
        return null;
    }

    public CTNode findNextSuperClassConjunction(CTNode v) {
        CTNode v1;
        int p = v.getAlternativeNode().topologicalPosition;
        int i = 0;
        while (i <= p) {
            this.flags[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.targetCounter.length) {
            this.targetCounter[i] = 0;
            ++i;
        }
        ArrayList<CTNode> tempList = new ArrayList<CTNode>();
        this.flags[p] = 1;
        int i2 = p;
        while (i2 >= 0) {
            if (this.flags[i2] == 1) {
                v1 = (CTNode)this.nodeList.get(i2);
                Iterator iter = v1.containmentByLinks.iterator();
                while (iter.hasNext()) {
                    this.flags[((ContainmentLink)iter.next()).getSource().topologicalPosition] = 1;
                }
                iter = v1.conjunctionLinks.iterator();
                while (iter.hasNext()) {
                    ConjunctionLink link = (ConjunctionLink)iter.next();
                    int n = link.getTargetID();
                    if (this.targetValue[link.getTargetID()] != (this.targetCounter[n] = this.targetCounter[n] + 1) || this.flags[link.getTarget().topologicalPosition] != 0) continue;
                    tempList.add(link.getTarget());
                }
            }
            --i2;
        }
        Iterator iter = tempList.iterator();
        while (iter.hasNext()) {
            v1 = (CTNode)iter.next();
            if (this.flags[v1.topologicalPosition] != 0) continue;
            return v1;
        }
        return null;
    }

    void addNodeContainment(CTNode father, CTNode child) {
        CTNode vv;
        CTNode v;
        CTNode subV;
        Iterator iter1;
        CTNode superV;
        Iterator iter;
        Map.Entry subEntry;
        Iterator subIter;
        Map.Entry superEntry;
        Integer key;
        NodeLink link;
        Iterator iter12;
        ContainmentLink link2;
        Iterator iter13;
        Iterator iter2;
        List subClassList;
        List superClassList;
        if (this.isSubNodeOf(child, father)) {
            return;
        }
        this.adjustNodeList(father, child);
        father = father.getAlternativeNode();
        child = child.getAlternativeNode();
        ArrayList<ContainmentLink> tempList = new ArrayList<ContainmentLink>();
        if (father != child) {
            superClassList = this.getSuperNodes(father);
            subClassList = this.getSubNodes(child);
            int i = this.nodeList.size() - 1;
            while (i >= 0) {
                this.flags[i] = 0;
                --i;
            }
            iter2 = subClassList.iterator();
            while (iter2.hasNext()) {
                this.flags[((CTNode)iter2.next()).topologicalPosition] = 1;
            }
            iter2 = superClassList.iterator();
            while (iter2.hasNext()) {
                iter13 = ((CTNode)iter2.next()).containmentLinks.iterator();
                while (iter13.hasNext()) {
                    link2 = (ContainmentLink)iter13.next();
                    if (this.flags[link2.getTarget().topologicalPosition] != 1) continue;
                    tempList.add(link2);
                }
            }
            new ContainmentLink(this, father, child);
        } else {
            superClassList = this.getSuperClassNodesWithRemoveRedundancy(father);
            subClassList = this.getSubClassNodesWithRemoveRedundancy(child);
            int i = this.nodeList.size() - 1;
            while (i >= 0) {
                this.flags[i] = 0;
                --i;
            }
            iter2 = subClassList.iterator();
            while (iter2.hasNext()) {
                this.flags[((CTNode)iter2.next()).topologicalPosition] = 1;
            }
            iter2 = superClassList.iterator();
            while (iter2.hasNext()) {
                iter13 = ((CTNode)iter2.next()).containmentLinks.iterator();
                while (iter13.hasNext()) {
                    link2 = (ContainmentLink)iter13.next();
                    if (this.flags[link2.getTarget().topologicalPosition] != 1 || link2.getSource() == father || link2.getTarget() == child) continue;
                    tempList.add(link2);
                }
            }
        }
        iter2 = tempList.iterator();
        while (iter2.hasNext()) {
            ContainmentLink link3 = (ContainmentLink)iter2.next();
            link3.setSource(null);
            link3.setTarget(null);
        }
        HashMap superMap = new HashMap();
        HashMap subMap = new HashMap();
        Iterator iter3 = superClassList.iterator();
        while (iter3.hasNext()) {
            iter12 = ((CTNode)iter3.next()).allValuesFromByLinks.iterator();
            while (iter12.hasNext()) {
                link = (AllValueFromLink)iter12.next();
                key = new Integer(((AllValueFromLink)link).getPropertyID());
                if (!superMap.containsKey(key)) {
                    superMap.put(key, new ArrayList());
                }
                ((ArrayList)superMap.get(key)).add(link.getSource());
            }
        }
        iter3 = subClassList.iterator();
        while (iter3.hasNext()) {
            iter12 = ((CTNode)iter3.next()).allValuesFromByLinks.iterator();
            while (iter12.hasNext()) {
                link = (AllValueFromLink)iter12.next();
                key = new Integer(((AllValueFromLink)link).getPropertyID());
                if (!subMap.containsKey(key)) {
                    subMap.put(key, new ArrayList());
                }
                ((ArrayList)subMap.get(key)).add(link.getSource());
            }
        }
        Iterator superIter = superMap.entrySet().iterator();
        while (superIter.hasNext()) {
            superEntry = superIter.next();
            subIter = subMap.entrySet().iterator();
            while (subIter.hasNext()) {
                subEntry = subIter.next();
                if (!this.rbox.isSubPropertyOf((Integer)superEntry.getKey(), (Integer)subEntry.getKey())) continue;
                iter = ((ArrayList)superEntry.getValue()).iterator();
                while (iter.hasNext()) {
                    superV = (CTNode)iter.next();
                    iter1 = ((ArrayList)subEntry.getValue()).iterator();
                    while (iter1.hasNext()) {
                        subV = (CTNode)iter1.next();
                        this.addNodeContainment(superV, subV);
                    }
                }
            }
        }
        superMap.clear();
        subMap.clear();
        iter3 = superClassList.iterator();
        while (iter3.hasNext()) {
            iter12 = ((CTNode)iter3.next()).someValuesFromByLinks.iterator();
            while (iter12.hasNext()) {
                link = (SomeValueFromLink)iter12.next();
                key = new Integer(((SomeValueFromLink)link).getPropertyID());
                if (!superMap.containsKey(key)) {
                    superMap.put(key, new ArrayList());
                }
                ((ArrayList)superMap.get(key)).add(link.getSource());
            }
        }
        iter3 = subClassList.iterator();
        while (iter3.hasNext()) {
            iter12 = ((CTNode)iter3.next()).someValuesFromByLinks.iterator();
            while (iter12.hasNext()) {
                link = (SomeValueFromLink)iter12.next();
                key = new Integer(((SomeValueFromLink)link).getPropertyID());
                if (!subMap.containsKey(key)) {
                    subMap.put(key, new ArrayList());
                }
                ((ArrayList)subMap.get(key)).add(link.getSource());
            }
        }
        superIter = superMap.entrySet().iterator();
        while (superIter.hasNext()) {
            superEntry = superIter.next();
            subIter = subMap.entrySet().iterator();
            while (subIter.hasNext()) {
                subEntry = subIter.next();
                if (!this.rbox.isSubPropertyOf((Integer)subEntry.getKey(), (Integer)superEntry.getKey())) continue;
                iter = ((ArrayList)superEntry.getValue()).iterator();
                while (iter.hasNext()) {
                    superV = (CTNode)iter.next();
                    iter1 = ((ArrayList)subEntry.getValue()).iterator();
                    while (iter1.hasNext()) {
                        subV = (CTNode)iter1.next();
                        this.addNodeContainment(superV, subV);
                    }
                }
            }
        }
        iter3 = superClassList.iterator();
        while (iter3.hasNext()) {
            v = (CTNode)iter3.next();
            vv = this.findNextSubClassDisjunction(v);
            if (vv == null) continue;
            this.addNodeContainment(v, vv);
        }
        iter3 = subClassList.iterator();
        while (iter3.hasNext()) {
            v = (CTNode)iter3.next();
            vv = this.findNextSuperClassConjunction(v);
            if (vv == null) continue;
            this.addNodeContainment(vv, v);
        }
    }

    private void combineNode(CTNode v1, CTNode v2) {
        if (v1.tbox != this || v2.tbox != this) {
            throw new IllegalArgumentException();
        }
        if ((v1 = v1.getAlternativeNode()) != (v2 = v2.getAlternativeNode())) {
            NodeLink link;
            Iterator it = v2.cIDSet.iterator();
            while (it.hasNext()) {
                Integer id = (Integer)it.next();
                v1.cIDSet.add(id);
                this.cid2NodeMap.put(id, v1);
            }
            v2.cIDSet.clear();
            it = v2.containmentLinks.iterator();
            while (it.hasNext()) {
                link = (ContainmentLink)it.next();
                v1.containmentLinks.add(link);
                link.source = v1;
            }
            it = v2.containmentByLinks.iterator();
            while (it.hasNext()) {
                link = (ContainmentLink)it.next();
                v1.containmentByLinks.add(link);
                link.target = v1;
            }
            it = v2.conjunctionLinks.iterator();
            while (it.hasNext()) {
                link = (ConjunctionLink)it.next();
                v1.conjunctionLinks.add(link);
                ((ConjunctionLink)link).source = v1;
            }
            it = v2.disjunctionLinks.iterator();
            while (it.hasNext()) {
                link = (DisjunctionLink)it.next();
                v1.disjunctionLinks.add(link);
                ((DisjunctionLink)link).source = v1;
            }
            it = v2.allValuesFromByLinks.iterator();
            while (it.hasNext()) {
                link = (AllValueFromLink)it.next();
                v1.allValuesFromByLinks.add(link);
                ((AllValueFromLink)link).target = v1;
            }
            it = v2.someValuesFromByLinks.iterator();
            while (it.hasNext()) {
                link = (SomeValueFromLink)it.next();
                v1.someValuesFromByLinks.add(link);
                ((SomeValueFromLink)link).target = v1;
            }
            v2.alternativeNode = v1;
            if (v2 == this.thingNode) {
                this.thingNode = v1;
            }
            if (v2 == this.nothingNode) {
                this.nothingNode = v1;
            }
        }
    }

    private void adjustNodeList(CTNode v1, CTNode v2) {
        int p;
        Iterator iter;
        int pa = v2.getAlternativeNode().topologicalPosition;
        int pb = v1.getAlternativeNode().topologicalPosition;
        if (pa >= pb) {
            return;
        }
        int i = pa;
        while (i <= pb) {
            this.flags[i] = 0;
            ++i;
        }
        this.flags[pa] = 1;
        i = pa;
        while (i <= pb) {
            if (this.flags[i] == 1) {
                iter = ((CTNode)this.nodeList.get((int)i)).containmentLinks.iterator();
                while (iter.hasNext()) {
                    p = ((ContainmentLink)iter.next()).getTarget().topologicalPosition;
                    if (p > pb) continue;
                    this.flags[p] = 1;
                }
            }
            ++i;
        }
        int n = pb;
        this.flags[n] = this.flags[n] | 2;
        i = pb;
        while (i >= pa) {
            if ((this.flags[i] & 2) == 2) {
                iter = ((CTNode)this.nodeList.get((int)i)).containmentByLinks.iterator();
                while (iter.hasNext()) {
                    p = ((ContainmentLink)iter.next()).getSource().topologicalPosition;
                    if (p < pa) continue;
                    int n2 = p;
                    this.flags[n2] = this.flags[n2] | 2;
                }
            }
            --i;
        }
        CTNode[] tempArray = new CTNode[pb - pa + 1];
        int index = 0;
        int i2 = pa;
        while (i2 <= pb) {
            if (this.flags[i2] == 2) {
                tempArray[index++] = (CTNode)this.nodeList.get(i2);
            }
            ++i2;
        }
        if (this.flags[pa] == 3) {
            CTNode v = (CTNode)this.nodeList.get(pa);
            int i3 = pa + 1;
            while (i3 <= pb) {
                if (this.flags[i3] == 3) {
                    this.combineNode(v, (CTNode)this.nodeList.get(i3));
                }
                ++i3;
            }
            tempArray[index++] = v;
        }
        i = pa;
        while (i <= pb) {
            if (this.flags[i] <= 1) {
                tempArray[index++] = (CTNode)this.nodeList.get(i);
            }
            ++i;
        }
        i = 0;
        while (i < index) {
            this.nodeList.set(i + pa, tempArray[i]);
            tempArray[i].topologicalPosition = i + pa;
            ++i;
        }
        if (index < pb - pa + 1) {
            this.nodeList.subList(pa + index, pb + 1).clear();
            i = this.nodeList.size() - 1;
            while (i >= pa + index) {
                ((CTNode)this.nodeList.get((int)i)).topologicalPosition = i;
                --i;
            }
        }
    }

    boolean isSubNodeOf(CTNode n1, CTNode n2) {
        if (n1 == this.nothingNode || n2 == this.thingNode) {
            return true;
        }
        int pa = n2.getAlternativeNode().topologicalPosition;
        int pb = n1.getAlternativeNode().topologicalPosition;
        if (pa > pb) {
            return false;
        }
        int i = pa;
        while (i <= pb) {
            this.flags[i] = 0;
            ++i;
        }
        this.flags[pa] = 1;
        i = pa;
        while (i < pb) {
            if (this.flags[i] == 1) {
                Iterator iter = ((CTNode)this.nodeList.get((int)i)).containmentLinks.iterator();
                while (iter.hasNext()) {
                    this.flags[((ContainmentLink)iter.next()).getTarget().topologicalPosition] = 1;
                }
            }
            ++i;
        }
        return this.flags[pb] == 1;
    }

    CTNode getNodeByConcept(Concept c, boolean doNormalizationFirst) {
        int cid = this.getConceptID(c, doNormalizationFirst, false);
        return this.getNodeByID(cid);
    }

    CTNode getNodeByID(int cID) {
        return (CTNode)this.cid2NodeMap.get(new Integer(cID));
    }

    void addNode(CTNode n) {
        n.topologicalPosition = this.nodeList.size();
        this.nodeList.add(n);
        if (this.nodeList.size() > this.flags.length) {
            this.flags = new int[this.nodeList.size() * 3 / 2];
        }
    }

    synchronized int getConceptID(Concept c, boolean doNormalizationFirst, boolean create) {
        String idStr;
        Integer index;
        Concept term = c;
        if (doNormalizationFirst) {
            term = ReasonerUtil.toMinimalDNF(c, this.rbox);
        }
        if ((index = (Integer)this.idString2IDMap.get(idStr = ReasonerUtil.toString(term))) != null) {
            return index;
        }
        if (create) {
            this.idString2IDMap.put(idStr, new Integer(this.conceptList.size()));
            this.conceptList.add(ReasonerUtil.cloneConcept(c));
            return this.conceptList.size() - 1;
        }
        return -1;
    }

    synchronized Concept getConceptByID(int id) {
        if (id < 0 || id >= this.conceptList.size()) {
            return null;
        }
        return (Concept)this.conceptList.get(id);
    }

    public synchronized int getConceptNum() {
        return this.conceptList.size();
    }

    private synchronized int getNextTargetID() {
        if (this.nextTargetID >= this.targetValue.length) {
            int newLength = this.nextTargetID * 3 / 2;
            int[] newArray = new int[newLength];
            System.arraycopy(this.targetValue, 0, newArray, 0, this.targetValue.length);
            this.targetValue = newArray;
            this.targetCounter = new int[newLength];
        }
        return this.nextTargetID++;
    }
}

