/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.owl.resource;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.eodm.exceptions.UnsupportedViewTypeException;
import org.eclipse.eodm.owl.resource.OWLXMLSaverImpl;
import org.eclipse.eodm.rdf.rdfweb.Document;
import org.eclipse.eodm.rdf.rdfweb.NamespaceDefinition;
import org.eclipse.eodm.rdf.resource.parser.impl.RDFNamespaceMap;

public class OWLXMLSaver {
    public static void saveToFile(Document document, String fileName) throws IOException, UnsupportedViewTypeException {
        OWLXMLSaver.saveToStream(document, new FileOutputStream(fileName));
    }

    public static void saveToFile(Document document, String fileName, String charsetName) throws IOException, UnsupportedViewTypeException {
        OWLXMLSaver.saveToStream(document, new FileOutputStream(fileName), charsetName);
    }

    public static void saveToStream(Document document, OutputStream os) throws IOException, UnsupportedViewTypeException {
        OutputStreamWriter osWriter = new OutputStreamWriter(os);
        OWLXMLSaver.saveToStream(document, new BufferedWriter(osWriter), osWriter.getEncoding());
    }

    public static void saveToStream(Document document, OutputStream os, String charsetName) throws IOException, UnsupportedViewTypeException {
        OWLXMLSaver.saveToStream(document, new BufferedWriter(new OutputStreamWriter(os, charsetName)), charsetName);
    }

    protected static void saveToStream(Document document, Writer writer, String encoding) throws IOException, UnsupportedViewTypeException {
        OWLXMLSaver.writeRDFXMLHeader(document, writer, encoding);
        OWLXMLSaverImpl saverImpl = new OWLXMLSaverImpl(writer, document);
        saverImpl.save();
        OWLXMLSaver.writeRDFXMLEnding(writer);
        writer.flush();
    }

    protected static void writeRDFXMLEnding(Writer writer) throws IOException {
        writer.write("</rdf:RDF>\n");
    }

    protected static void writeRDFXMLHeader(Document document, Writer writer, String encoding) throws IOException {
        NamespaceDefinition ns;
        EList list = document.getNamespaceDefinition();
        RDFNamespaceMap nsMap = new RDFNamespaceMap();
        int i = 0;
        while (i < list.size() - 1) {
            int j = i + 1;
            while (j < list.size()) {
                if (((NamespaceDefinition)list.get(i)).getNamespacePrefix().equals(((NamespaceDefinition)list.get(j)).getNamespacePrefix())) {
                    ((NamespaceDefinition)list.get(j)).setNamespacePrefix(nsMap.getKey());
                }
                ++j;
            }
            ++i;
        }
        boolean foundRDFNamespace = false;
        boolean foundRDFSNamespace = false;
        boolean foundOWLNamespace = false;
        boolean foundXSDNamespace = false;
        writer.write("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\n");
        writer.write("<!DOCTYPE rdf:RDF [\n");
        Iterator iterator = document.getNamespaceDefinition().iterator();
        while (iterator.hasNext()) {
            ns = (NamespaceDefinition)iterator.next();
            String nsURI = ns.getNamespace().getNamespaceURIRef().getURIString();
            if (nsURI.equals("http://bnode.ibm.com#")) continue;
            writer.write("\t<!ENTITY " + ns.getNamespacePrefix() + " \"" + OWLXMLSaverImpl.replaceKeywords(nsURI) + "\">\n");
            if (nsURI.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
                foundRDFNamespace = true;
            }
            if (nsURI.equals("http://www.w3.org/2000/01/rdf-schema#")) {
                foundRDFSNamespace = true;
            }
            if (nsURI.equals("http://www.w3.org/2002/07/owl#")) {
                foundOWLNamespace = true;
            }
            if (!nsURI.equals("http://www.w3.org/2001/XMLSchema#")) continue;
            foundXSDNamespace = true;
        }
        if (!foundRDFNamespace) {
            writer.write("\t<!ENTITY rdf \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">\n");
        }
        if (!foundRDFSNamespace) {
            writer.write("\t<!ENTITY rdfs \"http://www.w3.org/2000/01/rdf-schema#\">\n");
        }
        if (!foundOWLNamespace) {
            writer.write("\t<!ENTITY owl \"http://www.w3.org/2002/07/owl#\">\n");
        }
        if (!foundXSDNamespace) {
            writer.write("\t<!ENTITY xsd \"http://www.w3.org/2001/XMLSchema#\">\n");
        }
        writer.write("]>\n");
        writer.write("<rdf:RDF\n");
        iterator = document.getNamespaceDefinition().iterator();
        while (iterator.hasNext()) {
            ns = (NamespaceDefinition)iterator.next();
            if (ns.getNamespace().getNamespaceURIRef().getURIString().equals("http://bnode.ibm.com#")) continue;
            writer.write("         xmlns:" + ns.getNamespacePrefix() + "=\"&" + ns.getNamespacePrefix() + ";\"\n");
        }
        if (!foundRDFNamespace) {
            writer.write("         xmlns:rdf=\"&rdf;\"\n");
        }
        if (!foundRDFSNamespace) {
            writer.write("         xmlns:rdfs=\"&rdfs;\"\n");
        }
        if (!foundOWLNamespace) {
            writer.write("         xmlns:owl=\"&owl;\"\n");
        }
        if (!foundXSDNamespace) {
            writer.write("         xmlns:xsd=\"&xsd;\"\n");
        }
        writer.write(">\n");
    }
}

