/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: InternalCoreImpl.java,v 1.1 2007/03/18 08:10:11 lzhang Exp $
 */
package org.eclipse.eodm.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;


import org.eclipse.eodm.RDFFactory;
import org.eclipse.eodm.exceptions.UnsupportedViewTypeException;
import org.eclipse.eodm.owl.owlbase.*;
import org.eclipse.eodm.owl.owlbase.util.OWLBasePackage;
import org.eclipse.eodm.rdf.rdfbase.*;
import org.eclipse.eodm.rdf.rdfbase.impl.BlankNodeImpl;
import org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage;
import org.eclipse.eodm.rdf.rdfs.*;
import org.eclipse.eodm.rdf.rdfs.util.RDFSPackage;
import org.eclipse.eodm.rdf.rdfweb.*;
import org.eclipse.eodm.rdf.rdfweb.util.RDFWebPackage;
import org.eclipse.eodm.util.*;
import org.eclipse.eodm.vocabulary.RDF;






/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Internal Core</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getLexicalForm <em>Lexical Form</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getLanguage <em>Language</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getRDFSsubClassOf <em>RDF Ssub Class Of</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getSubClass <em>Sub Class</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getPropertyForDomain <em>Property For Domain</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getPropertyForRange <em>Property For Range</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getOntology <em>Ontology</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#isIsDeprecated <em>Is Deprecated</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getIsClassKind <em>Is Class Kind</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getHasRestrictionKind <em>Has Restriction Kind</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getEquivalentClass <em>Equivalent Class</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getOWLdisjointWith <em>OW Ldisjoint With</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getOWLcomplementOf <em>OW Lcomplement Of</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getDatatypeURI <em>Datatype URI</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getOWLdistinctMembers <em>OW Ldistinct Members</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getOWLonProperty <em>OW Lon Property</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getOWLcardinality <em>OW Lcardinality</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getOWLminCardinality <em>OW Lmin Cardinality</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getSomeValuesFromClass <em>Some Values From Class</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getSomeValuesFromDataRange <em>Some Values From Data Range</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getOWLdifferentFrom <em>OW Ldifferent From</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getOWLsameAs <em>OW Lsame As</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getRDFfirst <em>RD Ffirst</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getRDFrest <em>RD Frest</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getRDFSdomain <em>RDF Sdomain</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getRDFSrange <em>RDF Srange</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getRDFSsubPropertyOf <em>RDF Ssub Property Of</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getSubProperty <em>Sub Property</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#isIsPropertyDeprecated <em>Is Property Deprecated</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#isIsFunctional <em>Is Functional</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#isIsObjectProperty <em>Is Object Property</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#isIsDatatypeProperty <em>Is Datatype Property</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getOWLequivalentProperty <em>OW Lequivalent Property</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getOWLbackwardCompatibleWith <em>OW Lbackward Compatible With</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getOWLimports <em>OW Limports</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getOWLversionInfo <em>OW Lversion Info</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getOWLpriorVersion <em>OW Lprior Version</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getOWLincompatibleWith <em>OW Lincompatible With</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getOwlGraph <em>Owl RDFGraph</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getOwlStatement <em>Owl Statement</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getOwlUniverse <em>Owl Universe</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getGraphstatement <em>Graphstatement</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getGraphName <em>RDFGraph Name</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getGraphontology <em>Graphontology</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getOwlGraphStatement <em>Owl RDFGraph Statement</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getHasIndividualValue <em>Has Individual Value</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getHasLiteralValue <em>Has Literal Value</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getAllValuesFromClass <em>All Values From Class</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getAllValuesFromDataRange <em>All Values From Data Range</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getOWLmaxCardinality <em>OW Lmax Cardinality</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getOWLintersectionOf <em>OW Lintersection Of</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getOWLoneOf <em>OW Lone Of</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getOWLunionOf <em>OW Lunion Of</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getOWLDataRangeoneOf <em>OWL Data Rangeone Of</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getDatatype <em>Datatype</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getDocument <em>Document</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#isIsReifiedOnly <em>Is Reified Only</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#isIsReified <em>Is Reified</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getRDFsubject <em>RD Fsubject</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getRDFobject <em>RD Fobject</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getRDFpredicate <em>RD Fpredicate</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getNameForReification <em>Name For Reification</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#isIsInverseFunctional <em>Is Inverse Functional</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#isIsSymmetric <em>Is Symmetric</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#isIsTransitive <em>Is Transitive</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getOWLinverseOf <em>OW Linverse Of</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getStatement <em>Statement</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getLocalName <em>Local Name</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getXmlBase <em>Xml Base</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.InternalCoreImpl#getNamespaceDefinition <em>Namespace Definition</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class InternalCoreImpl extends BlankNodeImpl implements InternalCore {
	protected ArrayList proxyList;
	protected RDFList   dataRangeOneOfList	= null ;
	protected RDFList   enumClsOneOfList 	= null ;
	protected RDFList   intersectionList 	= null ;
	protected RDFList   unionList 			= null ;
	protected RDFList   distinctMembersList = null ;
	
	public void setDataRangeOneOfList(RDFList list)
	{
		dataRangeOneOfList = list ;
	}
	
	public void setEnumClsOneOfList(RDFList list)
	{
		enumClsOneOfList = list ;
	}
	
	public void setIntersectionList(RDFList list)
	{
		intersectionList = list ;
	}
	
	public void setUnionList(RDFList list)
	{
		unionList = list ;
	}
	
	public void setDistinctMembersList(RDFList list)
	{
		distinctMembersList = list ;
	}
	
	/**
	 * The cached value of the '{@link #getRDFSsubClassOf() <em>RDF Ssub Class Of</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRDFSsubClassOf()
	 * @generated
	 * @ordered
	 */
	protected EList rdfSsubClassOf = null;

	/**
	 * The cached value of the '{@link #getSubClass() <em>Sub Class</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSubClass()
	 * @generated
	 * @ordered
	 */
	protected EList subClass = null;

	protected EList typedResource = null ;
	
	/**
	 * The cached value of the '{@link #getPropertyForDomain() <em>Property For Domain</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPropertyForDomain()
	 * @generated
	 * @ordered
	 */
	protected EList propertyForDomain = null;

	/**
	 * The cached value of the '{@link #getPropertyForRange() <em>Property For Range</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPropertyForRange()
	 * @generated
	 * @ordered
	 */
	protected EList propertyForRange = null;

	/**
	 * The cached value of the '{@link #getOntology() <em>Ontology</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOntology()
	 * @generated
	 * @ordered
	 */
	protected OWLOntology ontology = null;

	/**
	 * The default value of the '{@link #isIsDeprecated() <em>Is Deprecated</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsDeprecated()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_DEPRECATED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIsDeprecated() <em>Is Deprecated</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsDeprecated()
	 * @generated
	 * @ordered
	 */
	protected boolean isDeprecated = IS_DEPRECATED_EDEFAULT;

	/**
	 * The cached value of the '{@link #getIsClassKind() <em>Is Class Kind</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIsClassKind()
	 * @generated
	 * @ordered
	 */
	protected EObject isClassKind = null;

	/**
	 * The cached value of the '{@link #getHasRestrictionKind() <em>Has Restriction Kind</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHasRestrictionKind()
	 * @generated
	 * @ordered
	 */
	protected EObject hasRestrictionKind = null;

	/**
	 * The cached value of the '{@link #getEquivalentClass() <em>Equivalent Class</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEquivalentClass()
	 * @generated
	 * @ordered
	 */
	protected EList owLequivalentClass = null;

	/**
	 * The cached value of the '{@link #getOWLdisjointWith() <em>OWL disjoint With</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOWLdisjointWith()
	 * @generated
	 * @ordered
	 */
	protected EList owLdisjointWith = null;
	
	/**
	 * The cached value of the '{@link #getIntersectionClass() <em>Intersection Class</em>' reference list.
	 * @see #getIntersectionClass()
	 * @eodmext This is not part of ODM 2006-04-03 specification. It is added by EODM for convenient access.
	 */
	protected EList intersectionClass = null ;
	
	/**
	 * The cached value of the '{@link #getUnionClass() <em>Union Class</em>' reference list.
	 * @see #getUnionClass()
	 * @eodmext This is not part of ODM 2006-04-03 specification. It is added by EODM for convenient access.
	 */
	protected EList unionClass = null ;
	
	/**
	 * The cached value of the '{@link #getDisjointClass() <em>Disjoint Class</em>' reference list.
	 * @see #getDisjointClass()
	 * @eodmext This is not part of ODM 2006-04-03 specification. It is added by EODM for convenient access.
	 */
	protected EList disjointClass = null ;
	
	/**
	 * The cached value of the '{@link #getEquivalentClass() <em>Equivalent Class</em>' reference list.
	 * @see #getEquivalentClass()
	 * @eodmext This is not part of ODM 2006-04-03 specification. It is added by EODM for convenient access.
	 */
	protected EList equivalentClass = null ;
	
	/**
	 * The cached value of the '{@link #getOWLcomplementOf() <em>OW Lcomplement Of</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOWLcomplementOf()
	 * @generated
	 * @ordered
	 */
	protected OWLClass owLcomplementOf = null;

	/**
	 * The cached value of the '{@link #getComplementClass() <em>Complement Class</em>}' reference list.
	 * @see #getComplementClass()
	 * @eodmext This is an EODM extension of ODM
	 */
	protected EList complementClass = null ;
	
	/**
	 * The cached value of the '{@link #getOWLdistinctMembers() <em>OW Ldistinct Members</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOWLdistinctMembers()
	 * @generated
	 * @ordered
	 */
	protected EList owLdistinctMembers = null;

	/**
	 * The cached value of the '{@link #getOWLonProperty() <em>OW Lon Property</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOWLonProperty()
	 * @generated
	 * @ordered
	 */
	protected RDFProperty owLonProperty = null;

	/**
	 * The cached value of the '{@link #getOWLcardinality() <em>OW Lcardinality</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOWLcardinality()
	 * @generated
	 * @ordered
	 */
	protected TypedLiteral owLcardinality = null;

	/**
	 * The cached value of the '{@link #getOWLminCardinality() <em>OW Lmin Cardinality</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOWLminCardinality()
	 * @generated
	 * @ordered
	 */
	protected TypedLiteral owLminCardinality = null;

	/**
	 * The cached value of the '{@link #getSomeValuesFromClass() <em>Some Values From Class</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSomeValuesFromClass()
	 * @generated
	 * @ordered
	 */
	protected OWLClass someValuesFromClass = null;

	/**
	 * The cached value of the '{@link #getSomeValuesFromDataRange() <em>Some Values From Data Range</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSomeValuesFromDataRange()
	 * @generated
	 * @ordered
	 */
	protected OWLDataRange someValuesFromDataRange = null;

	/**
	 * The cached value of the '{@link #getOWLdifferentFrom() <em>OW Ldifferent From</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOWLdifferentFrom()
	 * @generated
	 * @ordered
	 */
	protected EList owLdifferentFrom = null;

	/**
	 * The cached value of the '{@link #getOWLsameAs() <em>OW Lsame As</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOWLsameAs()
	 * @generated
	 * @ordered
	 */
	protected EList owLsameAs = null;

	/**
	 * The cached value of the '{@link #getRDFfirst() <em>RD Ffirst</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRDFfirst()
	 * @generated
	 * @ordered
	 */
	protected RDFSResource rdFfirst = null;

	/**
	 * The cached value of the '{@link #getRDFrest() <em>RD Frest</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRDFrest()
	 * @generated
	 * @ordered
	 */
	protected RDFList rdFrest = null;

	/**
	 * The cached value of the '{@link #getRDFSdomain() <em>RDF Sdomain</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRDFSdomain()
	 * @generated
	 * @ordered
	 */
	protected EList rdfSdomain = null;

	/**
	 * The cached value of the '{@link #getRDFSrange() <em>RDF Srange</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRDFSrange()
	 * @generated
	 * @ordered
	 */
	protected EList rdfSrange = null;

	/**
	 * The cached value of the '{@link #getRDFSsubPropertyOf() <em>RDF Ssub Property Of</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRDFSsubPropertyOf()
	 * @generated
	 * @ordered
	 */
	protected EList rdfSsubPropertyOf = null;

	/**
	 * The cached value of the '{@link #getSubProperty() <em>Sub Property</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSubProperty()
	 * @generated
	 * @ordered
	 */
	protected EList subProperty = null;

	/**
	 * The default value of the ' {@link #isIsInverseFunctional()  <em>Is Inverse Functional</em>} ' attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isIsInverseFunctional()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_INVERSE_FUNCTIONAL_EDEFAULT = false;
	/**
	 * The default value of the '{@link #isIsPropertyDeprecated() <em>Is Property Deprecated</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsPropertyDeprecated()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_PROPERTY_DEPRECATED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIsPropertyDeprecated() <em>Is Property Deprecated</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsPropertyDeprecated()
	 * @generated
	 * @ordered
	 */
	protected boolean isPropertyDeprecated = IS_PROPERTY_DEPRECATED_EDEFAULT;

	/**
	 * The default value of the '{@link #isIsFunctional() <em>Is Functional</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsFunctional()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_FUNCTIONAL_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIsFunctional() <em>Is Functional</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsFunctional()
	 * @generated
	 * @ordered
	 */
	protected boolean isFunctional = IS_FUNCTIONAL_EDEFAULT;

	/**
	 * The default value of the '{@link #isIsObjectProperty() <em>Is Object Property</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsObjectProperty()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_OBJECT_PROPERTY_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIsObjectProperty() <em>Is Object Property</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsObjectProperty()
	 * @generated
	 * @ordered
	 */
	protected boolean isObjectProperty = IS_OBJECT_PROPERTY_EDEFAULT;

	/**
	 * The default value of the '{@link #isIsDatatypeProperty() <em>Is Datatype Property</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsDatatypeProperty()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_DATATYPE_PROPERTY_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIsDatatypeProperty() <em>Is Datatype Property</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsDatatypeProperty()
	 * @generated
	 * @ordered
	 */
	protected boolean isDatatypeProperty = IS_DATATYPE_PROPERTY_EDEFAULT;

	/**
	 * The cached value of the '{@link #getOWLequivalentProperty() <em>OW Lequivalent Property</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOWLequivalentProperty()
	 * @generated
	 * @ordered
	 */
	protected EList owLequivalentProperty = null;

	/**
	 * The cached value of the '{@link #getOWLbackwardCompatibleWith() <em>OW Lbackward Compatible With</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOWLbackwardCompatibleWith()
	 * @generated
	 * @ordered
	 */
	protected EList owLbackwardCompatibleWith = null;

	/**
	 * The cached value of the '{@link #getOWLimports() <em>OW Limports</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOWLimports()
	 * @generated
	 * @ordered
	 */
	protected EList owLimports = null;

	/**
	 * The cached value of the '{@link #getOWLversionInfo() <em>OW Lversion Info</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOWLversionInfo()
	 * @generated
	 * @ordered
	 */
	protected EList owLversionInfo = null;

	/**
	 * The cached value of the '{@link #getOWLpriorVersion() <em>OW Lprior Version</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOWLpriorVersion()
	 * @generated
	 * @ordered
	 */
	protected EList owLpriorVersion = null;

	/**
	 * The cached value of the '{@link #getOWLincompatibleWith() <em>OW Lincompatible With</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOWLincompatibleWith()
	 * @generated
	 * @ordered
	 */
	protected EList owLincompatibleWith = null;

	/**
	 * The cached value of the '{@link #getOwlGraph() <em>Owl RDFGraph</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwlGraph()
	 * @generated
	 * @ordered
	 */
	protected EList owlGraph = null;

	/**
	 * The cached value of the '{@link #getOwlStatement() <em>Owl Statement</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwlStatement()
	 * @generated
	 * @ordered
	 */
	protected EList owlStatement = null;

	/**
	 * The cached value of the '{@link #getOwlUniverse() <em>Owl Universe</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwlUniverse()
	 * @generated
	 * @ordered
	 */
	protected Universe owlUniverse = null;

	/**
	 * The cached value of the '{@link #getGraphstatement() <em>Graphstatement</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGraphstatement()
	 * @generated
	 * @ordered
	 */
	protected EList graphstatement = null;

	/**
	 * The cached value of the '{@link #getGraphName() <em>RDFGraph Name</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGraphName()
	 * @generated
	 * @ordered
	 */
	protected URIReference graphName = null;

	/**
	 * The cached value of the '{@link #getGraphontology() <em>Graphontology</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGraphontology()
	 * @generated
	 * @ordered
	 */
	protected EList graphontology = null;

	/**
	 * The cached value of the '{@link #getOwlGraphStatement() <em>Owl RDFGraph Statement</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwlGraphStatement()
	 * @generated
	 * @ordered
	 */
	protected EList owlGraphStatement = null;

	/**
	 * The cached value of the '{@link #getHasIndividualValue() <em>Has Individual Value</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHasIndividualValue()
	 * @generated
	 * @ordered
	 */
	protected Individual hasIndividualValue = null;

	/**
	 * The cached value of the '{@link #getHasLiteralValue() <em>Has Literal Value</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHasLiteralValue()
	 * @generated
	 * @ordered
	 */
	protected RDFSLiteral hasLiteralValue = null;

	/**
	 * The cached value of the '{@link #getAllValuesFromClass() <em>All Values From Class</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAllValuesFromClass()
	 * @generated
	 * @ordered
	 */
	protected OWLClass allValuesFromClass = null;

	/**
	 * The cached value of the '{@link #getAllValuesFromDataRange() <em>All Values From Data Range</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAllValuesFromDataRange()
	 * @generated
	 * @ordered
	 */
	protected OWLDataRange allValuesFromDataRange = null;

	/**
	 * The cached value of the '{@link #getOWLmaxCardinality() <em>OW Lmax Cardinality</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOWLmaxCardinality()
	 * @generated
	 * @ordered
	 */
	protected TypedLiteral owLmaxCardinality = null;

	/**
	 * The cached value of the '{@link #getOWLintersectionOf() <em>OW Lintersection Of</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOWLintersectionOf()
	 * @generated
	 * @ordered
	 */
	protected EList owLintersectionOf = null;

	/**
	 * The cached value of the '{@link #getOWLoneOf() <em>OW Lone Of</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOWLoneOf()
	 * @generated
	 * @ordered
	 */
	protected EList owLoneOf = null;

	/**
	 * The cached value of the '{@link #getOWLunionOf() <em>OW Lunion Of</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOWLunionOf()
	 * @generated
	 * @ordered
	 */
	protected EList owLunionOf = null;

	/**
	 * The cached value of the '{@link #getOWLDataRangeOneOf() <em>OWL Data Rangeone Of</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOWLDataRangeOneOf()
	 * @generated
	 * @ordered
	 */
	protected EList owlDataRangeoneOf = null;

	/**
	 * The cached value of the '{@link #getDatatype() <em>Datatype</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDatatype()
	 * @generated
	 * @ordered
	 */
	protected RDFSDatatype datatype = null;

	/**
	 * The cached value of the '{@link #getDocument() <em>Document</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDocument()
	 * @generated
	 * @ordered
	 */
	protected EList document = null;

	/**
	 * The default value of the '{@link #isIsReifiedOnly() <em>Is Reified Only</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsReifiedOnly()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_REIFIED_ONLY_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIsReifiedOnly() <em>Is Reified Only</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsReifiedOnly()
	 * @generated
	 * @ordered
	 */
	protected boolean isReifiedOnly = IS_REIFIED_ONLY_EDEFAULT;

	/**
	 * The default value of the '{@link #isIsReified() <em>Is Reified</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsReified()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_REIFIED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIsReified() <em>Is Reified</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsReified()
	 * @generated
	 * @ordered
	 */
	protected boolean isReified = IS_REIFIED_EDEFAULT;

	/**
	 * The cached value of the '{@link #getRDFsubject() <em>RD Fsubject</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRDFsubject()
	 * @generated
	 * @ordered
	 */
	protected RDFSResource rdFsubject = null;

	/**
	 * The cached value of the '{@link #getRDFobject() <em>RD Fobject</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRDFobject()
	 * @generated
	 * @ordered
	 */
	protected RDFSResource rdFobject = null;

	/**
	 * The cached value of the '{@link #getRDFpredicate() <em>RD Fpredicate</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRDFpredicate()
	 * @generated
	 * @ordered
	 */
	protected RDFProperty rdFpredicate = null;

	/**
	 * The cached value of the '{@link #getNameForReification() <em>Name For Reification</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNameForReification()
	 * @generated
	 * @ordered
	 */
	protected EList nameForReification = null;

	/**
	 * The cached value of the '{@link #isIsInverseFunctional() <em>Is Inverse Functional</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsInverseFunctional()
	 * @generated
	 * @ordered
	 */
	protected boolean isInverseFunctional = IS_INVERSE_FUNCTIONAL_EDEFAULT;

	/**
	 * The default value of the '{@link #isIsSymmetric() <em>Is Symmetric</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsSymmetric()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_SYMMETRIC_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIsSymmetric() <em>Is Symmetric</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsSymmetric()
	 * @generated
	 * @ordered
	 */
	protected boolean isSymmetric = IS_SYMMETRIC_EDEFAULT;

	/**
	 * The default value of the '{@link #isIsTransitive() <em>Is Transitive</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsTransitive()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_TRANSITIVE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIsTransitive() <em>Is Transitive</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsTransitive()
	 * @generated
	 * @ordered
	 */
	protected boolean isTransitive = IS_TRANSITIVE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getOWLinverseOf() <em>OW Linverse Of</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOWLinverseOf()
	 * @generated
	 * @ordered
	 */
	protected EList owLinverseOf = null;

	/**
	 * The cached value of the '{@link #getStatement() <em>Statement</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStatement()
	 * @generated
	 * @ordered
	 */
	protected EList statement = null;

	/**
	 * The cached value of the '{@link #getLocalName() <em>Local Name</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocalName()
	 * @generated
	 * @ordered
	 */
	protected EList localName = null;

	/**
	 * The cached value of the '{@link #getXmlBase() <em>Xml Base</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getXmlBase()
	 * @generated
	 * @ordered
	 */
	protected EList xmlBase = null;

	/**
	 * The cached value of the '{@link #getNamespaceDefinition() <em>Namespace Definition</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNamespaceDefinition()
	 * @generated
	 * @ordered
	 */
	protected EList namespaceDefinition = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InternalCoreImpl() {
		super();
		this.proxyList = new ArrayList();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return EODMImplPackage.eINSTANCE.getInternalCore();
	}
	
	public boolean equals(Object obj) {
		if ( Proxy.isProxyClass( obj.getClass() ) ) 
		{
			InvocationHandler h = Proxy.getInvocationHandler( obj );
			if ( h instanceof EODMInvocationHandler )
			{
				obj = ((EODMInvocationHandler)h).getDelegatedObject() ;
			}
		}
		
		return (this == obj) ; 
	}
	
	public ArrayList getProxyList()
	{
		return this.proxyList;
	}

	public EList getSubjectStatement() {
		
		if (subjectStatement == null) {
			try{
			subjectStatement = new EObjectWithInverseResolvingEList(RDFStatement.class, (InternalEObject)this.asType(RDFSResource.class), RDFBasePackage.RDFS_RESOURCE__SUBJECT_STATEMENT, RDFBasePackage.RDF_STATEMENT__RD_FSUBJECT);
			}catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return subjectStatement;
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getRDFSsubClassOf() {
		if (rdfSsubClassOf == null) {
			try{
				rdfSsubClassOf = new EObjectWithInverseResolvingEList.ManyInverse(RDFSClass.class, (InternalEObject)this.asType(RDFSClass.class), EODMImplPackage.INTERNAL_CORE__RDF_SSUB_CLASS_OF, RDFSPackage.RDFS_CLASS__SUB_CLASS);
			}catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return rdfSsubClassOf;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getSubClass() {
		if (subClass == null) {
			try{
			subClass = new EObjectWithInverseResolvingEList.ManyInverse(RDFSClass.class, (InternalEObject)this.asType(RDFSClass.class), EODMImplPackage.INTERNAL_CORE__SUB_CLASS, RDFSPackage.RDFS_CLASS__RDF_SSUB_CLASS_OF);
			}catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return subClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getPropertyForDomain() {
		if (propertyForDomain == null) {
			try
			{
				propertyForDomain = new EObjectWithInverseResolvingEList.ManyInverse(RDFProperty.class, (InternalEObject)this.asType(RDFSClass.class), EODMImplPackage.INTERNAL_CORE__PROPERTY_FOR_DOMAIN, RDFBasePackage.RDF_PROPERTY__RDF_SDOMAIN);
			}catch(Exception e){e.printStackTrace();}
		}
		return propertyForDomain;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getPropertyForRange() {
		if (propertyForRange == null) {
			try{
				propertyForRange = new EObjectWithInverseResolvingEList.ManyInverse(RDFProperty.class, (InternalEObject)this.asType(RDFSClass.class), EODMImplPackage.INTERNAL_CORE__PROPERTY_FOR_RANGE, RDFBasePackage.RDF_PROPERTY__RDF_SRANGE);
			}catch(Exception e){e.printStackTrace();}
		}
		return propertyForRange;
	}

	public EList getTypedResource() {
		if ( typedResource == null ) {
			try {
				typedResource = new EObjectWithInverseResolvingEList.ManyInverse(RDFSResource.class, (InternalEObject)this.asType(RDFSClass.class), EODMImplPackage.INTERNAL_CORE__TYPED_RESOURCE, RDFBasePackage.RDFS_RESOURCE__RD_FTYPE);
			} catch (UnsupportedViewTypeException e) {
				e.printStackTrace();
			}
		}
		return typedResource ;
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OWLOntology getOntology() {
		if (ontology != null && ontology.eIsProxy()) {
			OWLOntology oldOntology = ontology;
			ontology = (OWLOntology)eResolveProxy((InternalEObject)ontology);
			if (ontology != oldOntology) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, EODMImplPackage.INTERNAL_CORE__ONTOLOGY, oldOntology, ontology));
			}
		}
		return ontology;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OWLOntology basicGetOntology() {
		return ontology;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetOntology(OWLOntology newOntology, NotificationChain msgs) {
		OWLOntology oldOntology = ontology;
		ontology = newOntology;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__ONTOLOGY, oldOntology, newOntology);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOntology(OWLOntology newOntology) {
		if (newOntology != ontology) {
			try{
			NotificationChain msgs = null;
			if (ontology != null)
				msgs = ((InternalEObject)ontology).eInverseRemove((InternalEObject)this.asType(Universe.class), OWLBasePackage.OWL_ONTOLOGY__OWL_UNIVERSE, OWLOntology.class, msgs);
			if (newOntology != null)
				msgs = ((InternalEObject)newOntology).eInverseAdd((InternalEObject)this.asType(Universe.class), OWLBasePackage.OWL_ONTOLOGY__OWL_UNIVERSE, OWLOntology.class, msgs);
			
			msgs = basicSetOntology(newOntology, msgs);
			if (msgs != null) msgs.dispatch();
			}catch(Exception e){e.printStackTrace();}
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__ONTOLOGY, newOntology, newOntology));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIsDeprecated() {
		return isDeprecated;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIsDeprecated(boolean newIsDeprecated) {
		boolean oldIsDeprecated = isDeprecated;
		isDeprecated = newIsDeprecated;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__IS_DEPRECATED, oldIsDeprecated, isDeprecated));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject getIsClassKind() {
		return isClassKind;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetIsClassKind(EObject newIsClassKind, NotificationChain msgs) {
		EObject oldIsClassKind = isClassKind;
		isClassKind = newIsClassKind;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__IS_CLASS_KIND, oldIsClassKind, newIsClassKind);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIsClassKind(EObject newIsClassKind) {
		if (newIsClassKind != isClassKind) {
			NotificationChain msgs = null;
			if (isClassKind != null)
				msgs = ((InternalEObject)isClassKind).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - EODMImplPackage.INTERNAL_CORE__IS_CLASS_KIND, null, msgs);
			if (newIsClassKind != null)
				msgs = ((InternalEObject)newIsClassKind).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - EODMImplPackage.INTERNAL_CORE__IS_CLASS_KIND, null, msgs);
			msgs = basicSetIsClassKind(newIsClassKind, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__IS_CLASS_KIND, newIsClassKind, newIsClassKind));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject getHasRestrictionKind() {
		return hasRestrictionKind;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetHasRestrictionKind(EObject newHasRestrictionKind, NotificationChain msgs) {
		EObject oldHasRestrictionKind = hasRestrictionKind;
		hasRestrictionKind = newHasRestrictionKind;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__HAS_RESTRICTION_KIND, oldHasRestrictionKind, newHasRestrictionKind);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setHasRestrictionKind(EObject newHasRestrictionKind) {
		if (newHasRestrictionKind != hasRestrictionKind) {
			NotificationChain msgs = null;
			if (hasRestrictionKind != null)
				msgs = ((InternalEObject)hasRestrictionKind).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - EODMImplPackage.INTERNAL_CORE__HAS_RESTRICTION_KIND, null, msgs);
			if (newHasRestrictionKind != null)
				msgs = ((InternalEObject)newHasRestrictionKind).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - EODMImplPackage.INTERNAL_CORE__HAS_RESTRICTION_KIND, null, msgs);
			msgs = basicSetHasRestrictionKind(newHasRestrictionKind, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__HAS_RESTRICTION_KIND, newHasRestrictionKind, newHasRestrictionKind));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @eodmext It is extended by EODM to a reverse association of {@link #getE
	 */
	public EList getOWLEquivalentClass() {
		if (owLequivalentClass == null) {
			try {
				owLequivalentClass = new EObjectWithInverseResolvingEList.ManyInverse(OWLClass.class, (InternalEObject)this.asType(OWLClass.class), EODMImplPackage.INTERNAL_CORE__OW_LEQUIVALENT_CLASS, OWLBasePackage.OWL_CLASS__EQUIVALENT_CLASS);
			}
			catch (UnsupportedViewTypeException e) 
			{
				e.printStackTrace();
			}
		}
		return owLequivalentClass;
	}

	/**
	 * {@inheritDoc}
	 */
	public EList getEquivalentClass() {
		if ( equivalentClass == null ) {
			try {
				equivalentClass = new EObjectWithInverseResolvingEList.ManyInverse(OWLClass.class, (InternalEObject)this.asType(OWLClass.class), EODMImplPackage.INTERNAL_CORE__EQUIVALENT_CLASS, OWLBasePackage.OWL_CLASS__OWL_EQUIVALENT_CLASS);
			} 
			catch (UnsupportedViewTypeException e) 
			{
				e.printStackTrace();
			}
		}
		return equivalentClass;
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @eodmext It is extended by EODM as a reverse association of {@link #getDisjointClass() Disjoint Class}.
	 */
	public EList getOWLdisjointWith() {
		if (owLdisjointWith == null) {
			try {
				owLdisjointWith = new EObjectWithInverseResolvingEList.ManyInverse(OWLClass.class, (InternalEObject)this.asType(OWLClass.class), EODMImplPackage.INTERNAL_CORE__OW_LDISJOINT_WITH, OWLBasePackage.OWL_CLASS__DISJOINT_CLASS);
			} 
			catch (UnsupportedViewTypeException e) 
			{
				e.printStackTrace();
			}
		}
		return owLdisjointWith;
	}

	/**
	 * {@inheritDoc}
	 */
	public EList getDisjointClass() {
		if ( disjointClass == null ) {
			try {
				disjointClass = new EObjectWithInverseResolvingEList.ManyInverse(OWLClass.class, (InternalEObject)this.asType(OWLClass.class), EODMImplPackage.INTERNAL_CORE__DISJOINT_CLASS, OWLBasePackage.OWL_CLASS__OW_LDISJOINT_WITH);
			}
			catch (UnsupportedViewTypeException e) 
			{
				e.printStackTrace();
			}
		}
		return disjointClass ;
	}
	
	
	/**
	 * {@inheritDoc}
	 */
	public EList getComplementClass() {
		if ( complementClass == null ) {
			try {
				complementClass = new EObjectWithInverseResolvingEList.ManyInverse(ComplementClass.class, (InternalEObject)this.asType(OWLClass.class), EODMImplPackage.INTERNAL_CORE__COMPLEMENT_CLASS, OWLBasePackage.COMPLEMENT_CLASS__OW_LCOMPLEMENT_OF);
			} catch (UnsupportedViewTypeException e) {
				e.printStackTrace();
			}
		}
		return complementClass;
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OWLClass getOWLcomplementOf() {
		if (owLcomplementOf != null && owLcomplementOf.eIsProxy()) {
			OWLClass oldOWLcomplementOf = owLcomplementOf;
			owLcomplementOf = (OWLClass)eResolveProxy((InternalEObject)owLcomplementOf);
			if (owLcomplementOf != oldOWLcomplementOf) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, EODMImplPackage.INTERNAL_CORE__OW_LCOMPLEMENT_OF, oldOWLcomplementOf, owLcomplementOf));
			}
		}
		return owLcomplementOf;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OWLClass basicGetOWLcomplementOf() {
		return owLcomplementOf;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOWLcomplementOf(OWLClass newOWLcomplementOf) {
		if (newOWLcomplementOf != owLcomplementOf) {
			try{
			NotificationChain msgs = null;
			if (owLcomplementOf != null)
				msgs = ((InternalEObject)owLcomplementOf).eInverseRemove((InternalEObject)this.asType(ComplementClass.class), OWLBasePackage.OWL_CLASS__COMPLEMENT_CLASS, OWLClass.class, msgs);
			if (newOWLcomplementOf!= null)
				msgs = ((InternalEObject)newOWLcomplementOf).eInverseAdd((InternalEObject)this.asType(ComplementClass.class), OWLBasePackage.OWL_CLASS__COMPLEMENT_CLASS, OWLClass.class, msgs);
			msgs = basicSetOWLcomplementOf(newOWLcomplementOf, msgs);
			if (msgs != null) msgs.dispatch();
			}catch(Exception e){e.printStackTrace();}
		}
		else	if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__OW_LCOMPLEMENT_OF, newOWLcomplementOf, newOWLcomplementOf));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getOWLdistinctMembers() {
		if (owLdistinctMembers == null) {
			owLdistinctMembers = new EObjectResolvingEList(Individual.class, this, EODMImplPackage.INTERNAL_CORE__OW_LDISTINCT_MEMBERS);
			if ( distinctMembersList != null )
				expandList(distinctMembersList, owLdistinctMembers, Individual.class);
		}
		return owLdistinctMembers;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFProperty getOWLonProperty() {
		if (owLonProperty != null && owLonProperty.eIsProxy()) {
			RDFProperty oldOWLonProperty = owLonProperty;
			owLonProperty = (RDFProperty)eResolveProxy((InternalEObject)owLonProperty);
			if (owLonProperty != oldOWLonProperty) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, EODMImplPackage.INTERNAL_CORE__OW_LON_PROPERTY, oldOWLonProperty, owLonProperty));
			}
		}
		return owLonProperty;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFProperty basicGetOWLonProperty() {
		return owLonProperty;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOWLonProperty(RDFProperty newOWLonProperty) {
		RDFProperty oldOWLonProperty = owLonProperty;
		owLonProperty = newOWLonProperty;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__OW_LON_PROPERTY, oldOWLonProperty, owLonProperty));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypedLiteral getOWLcardinality() {
		if (owLcardinality != null && owLcardinality.eIsProxy()) {
			TypedLiteral oldOWLcardinality = owLcardinality;
			owLcardinality = (TypedLiteral)eResolveProxy((InternalEObject)owLcardinality);
			if (owLcardinality != oldOWLcardinality) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, EODMImplPackage.INTERNAL_CORE__OW_LCARDINALITY, oldOWLcardinality, owLcardinality));
			}
		}
		return owLcardinality;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypedLiteral basicGetOWLcardinality() {
		return owLcardinality;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOWLcardinality(TypedLiteral newOWLcardinality) {
		TypedLiteral oldOWLcardinality = owLcardinality;
		owLcardinality = newOWLcardinality;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__OW_LCARDINALITY, oldOWLcardinality, owLcardinality));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypedLiteral getOWLminCardinality() {
		if (owLminCardinality != null && owLminCardinality.eIsProxy()) {
			TypedLiteral oldOWLminCardinality = owLminCardinality;
			owLminCardinality = (TypedLiteral)eResolveProxy((InternalEObject)owLminCardinality);
			if (owLminCardinality != oldOWLminCardinality) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, EODMImplPackage.INTERNAL_CORE__OW_LMIN_CARDINALITY, oldOWLminCardinality, owLminCardinality));
			}
		}
		return owLminCardinality;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypedLiteral basicGetOWLminCardinality() {
		return owLminCardinality;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOWLminCardinality(TypedLiteral newOWLminCardinality) {
		TypedLiteral oldOWLminCardinality = owLminCardinality;
		owLminCardinality = newOWLminCardinality;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__OW_LMIN_CARDINALITY, oldOWLminCardinality, owLminCardinality));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OWLClass getSomeValuesFromClass() {
		if (someValuesFromClass != null && someValuesFromClass.eIsProxy()) {
			OWLClass oldSomeValuesFromClass = someValuesFromClass;
			someValuesFromClass = (OWLClass)eResolveProxy((InternalEObject)someValuesFromClass);
			if (someValuesFromClass != oldSomeValuesFromClass) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, EODMImplPackage.INTERNAL_CORE__SOME_VALUES_FROM_CLASS, oldSomeValuesFromClass, someValuesFromClass));
			}
		}
		return someValuesFromClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OWLClass basicGetSomeValuesFromClass() {
		return someValuesFromClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSomeValuesFromClass(OWLClass newSomeValuesFromClass) {
		OWLClass oldSomeValuesFromClass = someValuesFromClass;
		someValuesFromClass = newSomeValuesFromClass;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__SOME_VALUES_FROM_CLASS, oldSomeValuesFromClass, someValuesFromClass));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OWLDataRange getSomeValuesFromDataRange() {
		if (someValuesFromDataRange != null && someValuesFromDataRange.eIsProxy()) {
			OWLDataRange oldSomeValuesFromDataRange = someValuesFromDataRange;
			someValuesFromDataRange = (OWLDataRange)eResolveProxy((InternalEObject)someValuesFromDataRange);
			if (someValuesFromDataRange != oldSomeValuesFromDataRange) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, EODMImplPackage.INTERNAL_CORE__SOME_VALUES_FROM_DATA_RANGE, oldSomeValuesFromDataRange, someValuesFromDataRange));
			}
		}
		return someValuesFromDataRange;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OWLDataRange basicGetSomeValuesFromDataRange() {
		return someValuesFromDataRange;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSomeValuesFromDataRange(OWLDataRange newSomeValuesFromDataRange) {
		OWLDataRange oldSomeValuesFromDataRange = someValuesFromDataRange;
		someValuesFromDataRange = newSomeValuesFromDataRange;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__SOME_VALUES_FROM_DATA_RANGE, oldSomeValuesFromDataRange, someValuesFromDataRange));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getOWLdifferentFrom() {
		if (owLdifferentFrom == null) {
			owLdifferentFrom = new EObjectResolvingEList(Individual.class, this, EODMImplPackage.INTERNAL_CORE__OW_LDIFFERENT_FROM);
		}
		return owLdifferentFrom;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getOWLsameAs() {
		if (owLsameAs == null) {
			owLsameAs = new EObjectResolvingEList(Individual.class, this, EODMImplPackage.INTERNAL_CORE__OW_LSAME_AS);
		}
		return owLsameAs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFSResource getRDFfirst() {
		if (rdFfirst != null && rdFfirst.eIsProxy()) {
			RDFSResource oldRDFfirst = rdFfirst;
			rdFfirst = (RDFSResource)eResolveProxy((InternalEObject)rdFfirst);
			if (rdFfirst != oldRDFfirst) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, EODMImplPackage.INTERNAL_CORE__RD_FFIRST, oldRDFfirst, rdFfirst));
			}
		}
		return rdFfirst;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFSResource basicGetRDFfirst() {
		return rdFfirst;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRDFfirst(RDFSResource newRDFfirst) {
		RDFSResource oldRDFfirst = rdFfirst;
		rdFfirst = newRDFfirst;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__RD_FFIRST, oldRDFfirst, rdFfirst));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFList getRDFrest() {
		if (rdFrest != null && rdFrest.eIsProxy()) {
			RDFList oldRDFrest = rdFrest;
			rdFrest = (RDFList)eResolveProxy((InternalEObject)rdFrest);
			if (rdFrest != oldRDFrest) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, EODMImplPackage.INTERNAL_CORE__RD_FREST, oldRDFrest, rdFrest));
			}
		}
		return rdFrest;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFList basicGetRDFrest() {
		return rdFrest;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRDFrest(RDFList newRDFrest) {
		RDFList oldRDFrest = rdFrest;
		rdFrest = newRDFrest;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__RD_FREST, oldRDFrest, rdFrest));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getRDFSdomain() {
		if (rdfSdomain == null) {
			try{
				rdfSdomain = new EObjectWithInverseResolvingEList.ManyInverse(RDFSClass.class, (InternalEObject)this.asType(RDFProperty.class), EODMImplPackage.INTERNAL_CORE__RDF_SDOMAIN, RDFSPackage.RDFS_CLASS__PROPERTY_FOR_DOMAIN);
			}catch(Exception e){e.printStackTrace();}
		}
		return rdfSdomain;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getRDFSrange() {
		if (rdfSrange == null) {
			try{
				rdfSrange = new EObjectWithInverseResolvingEList.ManyInverse(RDFSClass.class, (InternalEObject)this.asType(RDFProperty.class), EODMImplPackage.INTERNAL_CORE__RDF_SRANGE, RDFSPackage.RDFS_CLASS__PROPERTY_FOR_RANGE);
			}catch(Exception e){e.printStackTrace();}
		}
		return rdfSrange;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getRDFSsubPropertyOf() {
		if (rdfSsubPropertyOf == null) {
			try{
				rdfSsubPropertyOf = new EObjectWithInverseResolvingEList.ManyInverse(RDFProperty.class, (InternalEObject)this.asType(RDFProperty.class), EODMImplPackage.INTERNAL_CORE__RDF_SSUB_PROPERTY_OF, RDFBasePackage.RDF_PROPERTY__SUB_PROPERTY);
			}catch(Exception e){e.printStackTrace();}
		}
		return rdfSsubPropertyOf;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getSubProperty() {
		if (subProperty == null) {
			try{
				subProperty = new EObjectWithInverseResolvingEList.ManyInverse(RDFProperty.class, (InternalEObject)this.asType(RDFProperty.class), EODMImplPackage.INTERNAL_CORE__SUB_PROPERTY, RDFBasePackage.RDF_PROPERTY__RDF_SSUB_PROPERTY_OF);
			}catch(Exception e){e.printStackTrace();}
		}
		return subProperty;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIsPropertyDeprecated() {
		return isPropertyDeprecated;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIsPropertyDeprecated(boolean newIsPropertyDeprecated) {
		boolean oldIsPropertyDeprecated = isPropertyDeprecated;
		isPropertyDeprecated = newIsPropertyDeprecated;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__IS_PROPERTY_DEPRECATED, oldIsPropertyDeprecated, isPropertyDeprecated));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIsFunctional() {
		return isFunctional;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIsFunctional(boolean newIsFunctional) {
		boolean oldIsFunctional = isFunctional;
		isFunctional = newIsFunctional;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__IS_FUNCTIONAL, oldIsFunctional, isFunctional));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIsObjectProperty() {
		return isObjectProperty;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIsObjectProperty(boolean newIsObjectProperty) {
		boolean oldIsObjectProperty = isObjectProperty;
		isObjectProperty = newIsObjectProperty;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__IS_OBJECT_PROPERTY, oldIsObjectProperty, isObjectProperty));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIsDatatypeProperty() {
		return isDatatypeProperty;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIsDatatypeProperty(boolean newIsDatatypeProperty) {
		boolean oldIsDatatypeProperty = isDatatypeProperty;
		isDatatypeProperty = newIsDatatypeProperty;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__IS_DATATYPE_PROPERTY, oldIsDatatypeProperty, isDatatypeProperty));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getOWLequivalentProperty() {
		if (owLequivalentProperty == null) {
			owLequivalentProperty = new EObjectResolvingEList(Property.class, this, EODMImplPackage.INTERNAL_CORE__OW_LEQUIVALENT_PROPERTY);
		}
		return owLequivalentProperty;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getOWLbackwardCompatibleWith() {
		if (owLbackwardCompatibleWith == null) {
			owLbackwardCompatibleWith = new EObjectResolvingEList(OWLOntology.class, this, EODMImplPackage.INTERNAL_CORE__OW_LBACKWARD_COMPATIBLE_WITH);
		}
		return owLbackwardCompatibleWith;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getOWLimports() {
		if (owLimports == null) {
			try{
			owLimports = new EObjectResolvingEList(OWLOntology.class, (InternalEObject)this.forceAsType(OWLOntology.class), EODMImplPackage.INTERNAL_CORE__OW_LIMPORTS);
			}catch(Exception e){e.printStackTrace();}
		}
		return owLimports;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getOWLversionInfo() {
		if (owLversionInfo == null) {
			owLversionInfo = new EObjectContainmentEList(RDFSLiteral.class, this, EODMImplPackage.INTERNAL_CORE__OW_LVERSION_INFO);
		}
		return owLversionInfo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getOWLpriorVersion() {
		if (owLpriorVersion == null) {
			try{
				owLpriorVersion = new EObjectResolvingEList(OWLOntology.class, (InternalEObject)this.forceAsType(OWLOntology.class), EODMImplPackage.INTERNAL_CORE__OW_LPRIOR_VERSION);
			}catch(Exception e){e.printStackTrace();}
		}
		return owLpriorVersion;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getOWLincompatibleWith() {
		if (owLincompatibleWith == null) {
			owLincompatibleWith = new EObjectResolvingEList(OWLOntology.class, this, EODMImplPackage.INTERNAL_CORE__OW_LINCOMPATIBLE_WITH);
		}
		return owLincompatibleWith;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getOwlGraph() {
		if (owlGraph == null) {
			owlGraph = new EObjectWithInverseResolvingEList.ManyInverse(OWLGraph.class, this, EODMImplPackage.INTERNAL_CORE__OWL_GRAPH, OWLBasePackage.OWL_GRAPH__GRAPHONTOLOGY);
		}
		return owlGraph;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getOwlStatement() {
		if (owlStatement == null) {
			owlStatement = new EObjectResolvingEList(Statement.class, this, EODMImplPackage.INTERNAL_CORE__OWL_STATEMENT);
		}
		return owlStatement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Universe getOwlUniverse() {
		if (owlUniverse != null && owlUniverse.eIsProxy()) {
			Universe oldOwlUniverse = owlUniverse;
			owlUniverse = (Universe)eResolveProxy((InternalEObject)owlUniverse);
			if (owlUniverse != oldOwlUniverse) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, EODMImplPackage.INTERNAL_CORE__OWL_UNIVERSE, oldOwlUniverse, owlUniverse));
			}
		}
		return owlUniverse;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Universe basicGetOwlUniverse() {
		return owlUniverse;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetOwlUniverse(Universe newOwlUniverse, NotificationChain msgs) {
		Universe oldOwlUniverse = owlUniverse;
		owlUniverse = newOwlUniverse;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__OWL_UNIVERSE, oldOwlUniverse, newOwlUniverse);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	public NotificationChain basicSetOWLcomplementOf(OWLClass newOWLcomplementOf, NotificationChain msgs) {
		OWLClass oldOWLcomplementOf = owLcomplementOf ;
		owLcomplementOf = newOWLcomplementOf ;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__OW_LCOMPLEMENT_OF, oldOWLcomplementOf, newOWLcomplementOf);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;		
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOwlUniverse(Universe newOwlUniverse) {
		if (newOwlUniverse != owlUniverse) {
			try{
			NotificationChain msgs = null;
			if (owlUniverse != null)
				msgs = ((InternalEObject)owlUniverse).eInverseRemove((InternalEObject)this.asType(OWLOntology.class), OWLBasePackage.UNIVERSE__ONTOLOGY, Universe.class, msgs);
			if (newOwlUniverse != null)
				msgs = ((InternalEObject)newOwlUniverse).eInverseAdd((InternalEObject)this.asType(OWLOntology.class), OWLBasePackage.UNIVERSE__ONTOLOGY, Universe.class, msgs);
			msgs = basicSetOwlUniverse(newOwlUniverse, msgs);
			if (msgs != null) msgs.dispatch();
			}catch(Exception e){e.printStackTrace();}
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__OWL_UNIVERSE, newOwlUniverse, newOwlUniverse));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getGraphstatement() {
		if (graphstatement == null) {
			graphstatement = new EObjectResolvingEList(RDFStatement.class, this, EODMImplPackage.INTERNAL_CORE__GRAPHSTATEMENT);
		}
		return graphstatement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public URIReference getGraphName() {
		return graphName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetGraphName(URIReference newGraphName, NotificationChain msgs) {
		URIReference oldGraphName = graphName;
		graphName = newGraphName;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__GRAPH_NAME, oldGraphName, newGraphName);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setGraphName(URIReference newGraphName) {
		if (newGraphName != graphName) {
			NotificationChain msgs = null;
			if (graphName != null)
				msgs = ((InternalEObject)graphName).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - EODMImplPackage.INTERNAL_CORE__GRAPH_NAME, null, msgs);
			if (newGraphName != null)
				msgs = ((InternalEObject)newGraphName).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - EODMImplPackage.INTERNAL_CORE__GRAPH_NAME, null, msgs);
			msgs = basicSetGraphName(newGraphName, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__GRAPH_NAME, newGraphName, newGraphName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getGraphontology() {
		if (graphontology == null) {
			graphontology = new EObjectWithInverseResolvingEList.ManyInverse(OWLOntology.class, this, EODMImplPackage.INTERNAL_CORE__GRAPHONTOLOGY, OWLBasePackage.OWL_ONTOLOGY__OWL_GRAPH);
		}
		return graphontology;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getOwlGraphStatement() {
		if (owlGraphStatement == null) {
			owlGraphStatement = new EObjectResolvingEList(Statement.class, this, EODMImplPackage.INTERNAL_CORE__OWL_GRAPH_STATEMENT);
		}
		return owlGraphStatement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Individual getHasIndividualValue() {
		if (hasIndividualValue != null && hasIndividualValue.eIsProxy()) {
			Individual oldHasIndividualValue = hasIndividualValue;
			hasIndividualValue = (Individual)eResolveProxy((InternalEObject)hasIndividualValue);
			if (hasIndividualValue != oldHasIndividualValue) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, EODMImplPackage.INTERNAL_CORE__HAS_INDIVIDUAL_VALUE, oldHasIndividualValue, hasIndividualValue));
			}
		}
		return hasIndividualValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Individual basicGetHasIndividualValue() {
		return hasIndividualValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setHasIndividualValue(Individual newHasIndividualValue) {
		Individual oldHasIndividualValue = hasIndividualValue;
		hasIndividualValue = newHasIndividualValue;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__HAS_INDIVIDUAL_VALUE, oldHasIndividualValue, hasIndividualValue));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFSLiteral getHasLiteralValue() {
		if (hasLiteralValue != null && hasLiteralValue.eIsProxy()) {
			RDFSLiteral oldHasLiteralValue = hasLiteralValue;
			hasLiteralValue = (RDFSLiteral)eResolveProxy((InternalEObject)hasLiteralValue);
			if (hasLiteralValue != oldHasLiteralValue) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, EODMImplPackage.INTERNAL_CORE__HAS_LITERAL_VALUE, oldHasLiteralValue, hasLiteralValue));
			}
		}
		return hasLiteralValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFSLiteral basicGetHasLiteralValue() {
		return hasLiteralValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setHasLiteralValue(RDFSLiteral newHasLiteralValue) {
		RDFSLiteral oldHasLiteralValue = hasLiteralValue;
		hasLiteralValue = newHasLiteralValue;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__HAS_LITERAL_VALUE, oldHasLiteralValue, hasLiteralValue));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OWLClass getAllValuesFromClass() {
		if (allValuesFromClass != null && allValuesFromClass.eIsProxy()) {
			OWLClass oldAllValuesFromClass = allValuesFromClass;
			allValuesFromClass = (OWLClass)eResolveProxy((InternalEObject)allValuesFromClass);
			if (allValuesFromClass != oldAllValuesFromClass) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, EODMImplPackage.INTERNAL_CORE__ALL_VALUES_FROM_CLASS, oldAllValuesFromClass, allValuesFromClass));
			}
		}
		return allValuesFromClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OWLClass basicGetAllValuesFromClass() {
		return allValuesFromClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAllValuesFromClass(OWLClass newAllValuesFromClass) {
		OWLClass oldAllValuesFromClass = allValuesFromClass;
		allValuesFromClass = newAllValuesFromClass;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__ALL_VALUES_FROM_CLASS, oldAllValuesFromClass, allValuesFromClass));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OWLDataRange getAllValuesFromDataRange() {
		if (allValuesFromDataRange != null && allValuesFromDataRange.eIsProxy()) {
			OWLDataRange oldAllValuesFromDataRange = allValuesFromDataRange;
			allValuesFromDataRange = (OWLDataRange)eResolveProxy((InternalEObject)allValuesFromDataRange);
			if (allValuesFromDataRange != oldAllValuesFromDataRange) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, EODMImplPackage.INTERNAL_CORE__ALL_VALUES_FROM_DATA_RANGE, oldAllValuesFromDataRange, allValuesFromDataRange));
			}
		}
		return allValuesFromDataRange;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OWLDataRange basicGetAllValuesFromDataRange() {
		return allValuesFromDataRange;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAllValuesFromDataRange(OWLDataRange newAllValuesFromDataRange) {
		OWLDataRange oldAllValuesFromDataRange = allValuesFromDataRange;
		allValuesFromDataRange = newAllValuesFromDataRange;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__ALL_VALUES_FROM_DATA_RANGE, oldAllValuesFromDataRange, allValuesFromDataRange));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypedLiteral getOWLmaxCardinality() {
		if (owLmaxCardinality != null && owLmaxCardinality.eIsProxy()) {
			TypedLiteral oldOWLmaxCardinality = owLmaxCardinality;
			owLmaxCardinality = (TypedLiteral)eResolveProxy((InternalEObject)owLmaxCardinality);
			if (owLmaxCardinality != oldOWLmaxCardinality) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, EODMImplPackage.INTERNAL_CORE__OW_LMAX_CARDINALITY, oldOWLmaxCardinality, owLmaxCardinality));
			}
		}
		return owLmaxCardinality;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypedLiteral basicGetOWLmaxCardinality() {
		return owLmaxCardinality;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOWLmaxCardinality(TypedLiteral newOWLmaxCardinality) {
		TypedLiteral oldOWLmaxCardinality = owLmaxCardinality;
		owLmaxCardinality = newOWLmaxCardinality;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__OW_LMAX_CARDINALITY, oldOWLmaxCardinality, owLmaxCardinality));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @eodmext OWLintersectionOf is extended to be a reverse association of {@link #getIntersectionClass() intersectionClass}.
	 */
	public EList getOWLintersectionOf() {
		if (owLintersectionOf == null) {
			
			try {
				owLintersectionOf = new EObjectWithInverseResolvingEList.ManyInverse(OWLClass.class, (InternalEObject)this.asType(IntersectionClass.class), EODMImplPackage.INTERNAL_CORE__OW_LINTERSECTION_OF, OWLBasePackage.OWL_CLASS__INTERSECTION_CLASS);
			} 
			catch (UnsupportedViewTypeException e) 
			{
				e.printStackTrace();
			}
			
			if ( intersectionList != null )
				expandList(intersectionList, owLintersectionOf, OWLClass.class);
		}
		return owLintersectionOf;
	}
	
	/**
	 * {@inheritDoc}
	 */
	public EList getIntersectionClass() {
		if ( intersectionClass == null ) {
			try {
				intersectionClass = new EObjectWithInverseResolvingEList.ManyInverse(IntersectionClass.class, (InternalEObject)this.asType(OWLClass.class), EODMImplPackage.INTERNAL_CORE__INTERSECTION_CLASS, OWLBasePackage.INTERSECTION_CLASS__OW_LINTERSECTION_OF);
			} 
			catch (UnsupportedViewTypeException e) 
			{
				e.printStackTrace();
			}
		}
		return intersectionClass ;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getOWLoneOf() {
		if (owLoneOf == null) {
			owLoneOf = new EObjectResolvingEList(Individual.class, this, EODMImplPackage.INTERNAL_CORE__OW_LONE_OF);
			if ( enumClsOneOfList != null )
				expandList( enumClsOneOfList, owLoneOf, Individual.class );
		}
		return owLoneOf;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @eodmext It is extended by EODM to be an reverse association of {@link #getUnionClass() unionClass}.
	 */
	public EList getOWLunionOf() {
		if (owLunionOf == null) {
			try {
				owLunionOf = new EObjectWithInverseResolvingEList.ManyInverse(OWLClass.class, (InternalEObject)this.asType(UnionClass.class), EODMImplPackage.INTERNAL_CORE__OW_LUNION_OF, OWLBasePackage.OWL_CLASS__UNION_CLASS);
			} 
			catch (UnsupportedViewTypeException e) 
			{
				e.printStackTrace();
			}
			
			if ( unionList != null )
				expandList(unionList, owLunionOf, OWLClass.class);
		}
		return owLunionOf;
	}

	/**
	 * {@inheritDoc}
	 */
	public EList getUnionClass() {
		if ( unionClass == null ) {
			try {
				unionClass = new EObjectWithInverseResolvingEList.ManyInverse(UnionClass.class, (InternalEObject)this.asType(OWLClass.class), EODMImplPackage.INTERNAL_CORE__UNION_CLASS, OWLBasePackage.UNION_CLASS__OW_LUNION_OF);
			} 
			catch (UnsupportedViewTypeException e) 
			{
				e.printStackTrace();
			}
		}
		return unionClass ;
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getOWLDataRangeOneOf() {
		if (owlDataRangeoneOf == null) {
			owlDataRangeoneOf = new EObjectResolvingEList(RDFSLiteral.class, this, EODMImplPackage.INTERNAL_CORE__OWL_DATA_RANGEONE_OF);
			if ( dataRangeOneOfList != null )
				expandList( dataRangeOneOfList, owlDataRangeoneOf, RDFSLiteral.class);
		}
		return owlDataRangeoneOf;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFSDatatype getDatatype() {
		if (datatype != null && datatype.eIsProxy()) {
			RDFSDatatype oldDatatype = datatype;
			datatype = (RDFSDatatype)eResolveProxy((InternalEObject)datatype);
			if (datatype != oldDatatype) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, EODMImplPackage.INTERNAL_CORE__DATATYPE, oldDatatype, datatype));
			}
		}
		return datatype;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFSDatatype basicGetDatatype() {
		return datatype;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDatatype(RDFSDatatype newDatatype) {
		RDFSDatatype oldDatatype = datatype;
		datatype = newDatatype;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__DATATYPE, oldDatatype, datatype));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getDocument() {
		if (document == null) {
			document = new EObjectWithInverseResolvingEList.ManyInverse(Document.class, this, EODMImplPackage.INTERNAL_CORE__DOCUMENT, RDFWebPackage.DOCUMENT__STATEMENT);
		}
		return document;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIsReifiedOnly() {
		return isReifiedOnly;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIsReifiedOnly(boolean newIsReifiedOnly) {
		boolean oldIsReifiedOnly = isReifiedOnly;
		isReifiedOnly = newIsReifiedOnly;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__IS_REIFIED_ONLY, oldIsReifiedOnly, isReifiedOnly));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIsReified() {
		return isReified;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIsReified(boolean newIsReified) {
		boolean oldIsReified = isReified;
		isReified = newIsReified;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__IS_REIFIED, oldIsReified, isReified));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFSResource getRDFsubject() {
		if (rdFsubject != null && rdFsubject.eIsProxy()) {
			RDFSResource oldRDFsubject = rdFsubject;
			rdFsubject = (RDFSResource)eResolveProxy((InternalEObject)rdFsubject);
			if (rdFsubject != oldRDFsubject) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, EODMImplPackage.INTERNAL_CORE__RD_FSUBJECT, oldRDFsubject, rdFsubject));
			}
		}
		return rdFsubject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFSResource basicGetRDFsubject() {
		return rdFsubject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetRDFsubject(RDFSResource newRDFsubject, NotificationChain msgs) {
		RDFSResource oldRDFsubject = rdFsubject;
		rdFsubject = newRDFsubject;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__RD_FSUBJECT, oldRDFsubject, newRDFsubject);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRDFsubject(RDFSResource newRDFsubject) {
		if (newRDFsubject != rdFsubject) {
			try{
			NotificationChain msgs = null;
			if (rdFsubject != null)
				msgs = ((InternalEObject)rdFsubject).eInverseRemove((InternalEObject)this.asType(RDFStatement.class), RDFBasePackage.RDFS_RESOURCE__SUBJECT_STATEMENT, RDFSResource.class, msgs);
			if (newRDFsubject != null)
				msgs = ((InternalEObject)newRDFsubject).eInverseAdd((InternalEObject)this.asType(RDFStatement.class), RDFBasePackage.RDFS_RESOURCE__SUBJECT_STATEMENT, RDFSResource.class, msgs);
			msgs = basicSetRDFsubject(newRDFsubject, msgs);
			if (msgs != null) msgs.dispatch();}catch(Exception e){e.printStackTrace();}
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__RD_FSUBJECT, newRDFsubject, newRDFsubject));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFSResource getRDFobject() {
		if (rdFobject != null && rdFobject.eIsProxy()) {
			RDFSResource oldRDFobject = rdFobject;
			rdFobject = (RDFSResource)eResolveProxy((InternalEObject)rdFobject);
			if (rdFobject != oldRDFobject) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, EODMImplPackage.INTERNAL_CORE__RD_FOBJECT, oldRDFobject, rdFobject));
			}
		}
		return rdFobject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFSResource basicGetRDFobject() {
		return rdFobject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRDFobject(RDFSResource newRDFobject) {
		RDFSResource oldRDFobject = rdFobject;
		rdFobject = newRDFobject;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__RD_FOBJECT, oldRDFobject, rdFobject));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFProperty getRDFpredicate() {
		if (rdFpredicate != null && rdFpredicate.eIsProxy()) {
			RDFProperty oldRDFpredicate = rdFpredicate;
			rdFpredicate = (RDFProperty)eResolveProxy((InternalEObject)rdFpredicate);
			if (rdFpredicate != oldRDFpredicate) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, EODMImplPackage.INTERNAL_CORE__RD_FPREDICATE, oldRDFpredicate, rdFpredicate));
			}
		}
		return rdFpredicate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFProperty basicGetRDFpredicate() {
		return rdFpredicate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRDFpredicate(RDFProperty newRDFpredicate) {
		RDFProperty oldRDFpredicate = rdFpredicate;
		rdFpredicate = newRDFpredicate;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__RD_FPREDICATE, oldRDFpredicate, rdFpredicate));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getNameForReification() {
		if (nameForReification == null) {
			nameForReification = new EObjectWithInverseResolvingEList.ManyInverse(URIReference.class, this, EODMImplPackage.INTERNAL_CORE__NAME_FOR_REIFICATION, RDFBasePackage.URI_REFERENCE__REIFIED_STATEMENT);
		}
		return nameForReification;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIsInverseFunctional() {
		return isInverseFunctional;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIsInverseFunctional(boolean newIsInverseFunctional) {
		boolean oldIsInverseFunctional = isInverseFunctional;
		isInverseFunctional = newIsInverseFunctional;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__IS_INVERSE_FUNCTIONAL, oldIsInverseFunctional, isInverseFunctional));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIsSymmetric() {
		return isSymmetric;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIsSymmetric(boolean newIsSymmetric) {
		boolean oldIsSymmetric = isSymmetric;
		isSymmetric = newIsSymmetric;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__IS_SYMMETRIC, oldIsSymmetric, isSymmetric));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIsTransitive() {
		return isTransitive;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIsTransitive(boolean newIsTransitive) {
		boolean oldIsTransitive = isTransitive;
		isTransitive = newIsTransitive;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, EODMImplPackage.INTERNAL_CORE__IS_TRANSITIVE, oldIsTransitive, isTransitive));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getOWLinverseOf() {
		if (owLinverseOf == null) {
			owLinverseOf = new EObjectResolvingEList(OWLObjectProperty.class, this, EODMImplPackage.INTERNAL_CORE__OW_LINVERSE_OF);
		}
		return owLinverseOf;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getStatement() {
		if (statement == null) {
			statement = new EObjectWithInverseResolvingEList.ManyInverse(RDFStatement.class, this, EODMImplPackage.INTERNAL_CORE__STATEMENT, RDFBasePackage.RDF_STATEMENT__DOCUMENT);
		}
		return statement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getLocalName() {
		if (localName == null) {
			localName = new EObjectContainmentEList(LocalName.class, this, EODMImplPackage.INTERNAL_CORE__LOCAL_NAME);
		}
		return localName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getXmlBase() {
		if (xmlBase == null) {
			xmlBase = new EObjectResolvingEList(Namespace.class, this, EODMImplPackage.INTERNAL_CORE__XML_BASE);
		}
		return xmlBase;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getNamespaceDefinition() {
		if (namespaceDefinition == null) {
			namespaceDefinition = new EObjectContainmentEList(NamespaceDefinition.class, this, EODMImplPackage.INTERNAL_CORE__NAMESPACE_DEFINITION);
		}
		return namespaceDefinition;
	}
	/**
	 * The value of the '<em><b>Graphs</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfbase.RDFGraph}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * The Graphs EList of the Document can be operated to add, delete or retrieve RDFGraph.  
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Graphs</em>' containment reference list.
	 * @generated
	 */
	public ArrayList getGraphs()
	{
		return null;
	}
	/**
	 * The resources excluded from EList returned by {@link #getGraphs() getGraphs()}
	 * are included the complemental graph.
	 * @return the value of complemental graph
	 */
	
	
	public RDFGraph getComplementalGraph()
	{
		return null;
	}
	public void setComplementalGraph(RDFGraph graph)
	{
	}
	/**
	 * Return the Elist of the given type of Resources in current 
	 * @param classType the class type of the resources in current graph required 
	 * @return
	 */
	public ArrayList getTypeResources(String uri)
	{
		return null;
	}
	public ArrayList getTypeResources(String uri,boolean withSpec)
	{
		return null;
	}
	/**
	 * Add a triple into the RDFGraph, and the OO based memory model changed correspondly
	 * @param triple 
	 */
	public void addTriple(Triple triple)
	{
		
	}
	/**
	 * Return the ArrayList of {@link org.eclipse.eodm.util.Triple <em>Triple</em>}
	 * Export all triples contained in current graph
	 * @return
	 */
	public ArrayList exportTriples()
	{
		return null;
	}
	/**
     * Delete a triple into the RDFGraph, and the OO based memory model changed correspondly
	 * @param triple the triple to be deleted
	 */
	public void deleteTriple(Triple triple)
	{
		
	}
	/**
	 * Return the Iterator of current graph.
	 * @return 
	 */
	public Iterator getTriples()
	{
		return null;
	}
	public RDFSResource getRDFSResource(String uri)
	{
		return null;
	}
	
    public void setURI(String uri)
    {
    	this.uri = uri;
    }

    /**
     * Add all items in a RDF list to a EList. 
     */
    protected void expandList(RDFList list, EList refList, Class type)
    {
    	while ( list != null )
    	{
    		if ( ! list.canAsType( BlankNode.class ))
    			if ( list.getURI().equals( RDF.S_NIL_STR ))
    				break ;
    		RDFSResource item = list.getRDFfirst() ;
    		if ( item != null )
    		{
	    		if ( type != RDFSLiteral.class )
					try {
						item = item.forceAsType( type );
					} catch (UnsupportedViewTypeException e) {
						e.printStackTrace();
					}
				refList.add( item ) ;
    		}
    		list = list.getRDFrest() ;
    	}
    }
    
    /**
     * Explicitly check whether we can obtain a new type view of this object.
     *  
     * Explicitly check whether the <a href="#threeconditions">three conditions 
     * documented above</a> are met for obtaining a new type view of this object
     * for the same resource this object represents. Especially, check whether 
     * the statements in the context graph of this object support viewing 
     * this object as the <code>newType</code>. Implementation of this method
     * should clarify the semantics of "support" clearly.
     * 
     * @param newType the Java class object representing the new type
     * @return whether the new type is supported.
     * 
     * @see #asType(Class)
     * @see #forceAsType(Class)
     * 
     * @eodmext This method is added by EODM to support dynamic typing capability.
     */
    public boolean canAsType(Class newType)
    {
       
    	EClass eclassType=EJClassMapping.jclass2eclass(newType);
    	if(eclassType!=null)
    	{
    		for(Iterator iterator = this.getProxyList().iterator();iterator.hasNext();)
    	    {
    			ProxyEntity pe = (ProxyEntity)iterator.next();
    	    	if(eclassType.isSuperTypeOf(pe.getEClass()))
    	    	{
    	    		return true;
    	    	}
    	    }
    		for(Iterator iterator = this.getRDFtype().iterator();iterator.hasNext();)
        	{
        		RDFSResource rdfsResource = (RDFSResource)iterator.next();
        		EClass rdftype = (EClass)OWLUtility.getEClass().get(rdfsResource.getURI());
        		if(rdftype!=null&&eclassType.isSuperTypeOf(rdftype))
        		{
        			return true;
        		}
        	}
    		return false;
    	}
    	else
    	{
    		return false;
    	}
    }

    public RDFSResource addProxy(EClass eclassType,Class classType)
    {
    	RDFSResource rdfsresource = (RDFSResource)EODMInvocationHandler.implement(eclassType.getInstanceClass(),eclassType, this);
		ProxyEntity pe = new ProxyEntity(eclassType,rdfsresource);
		this.getProxyList().add(pe);
		return rdfsresource;
    }
    public void addType(RDFGraph graph,URIReference uriRef)
    {
    	String uriRefString  = uriRef.getURIString();
    	for(int i=0;i<getRDFtype().size();i++)
    	{
    		RDFSResource rdfsresource = (RDFSResource)this.getRDFtype().get(i);
    		String existinguri = ((URIReference)(rdfsresource.getUriRef().get(0))).getURIString();
    		if(existinguri.equals(uriRefString))
    		{
    			return;
    		}
    	}
    	RDFSClass rdfsclass = (RDFSClass) ((RDFFactoryImpl)RDFFactory.eINSTANCE).internalCreate(graph, RDFSClass.class, uriRef);

    	this.getRDFtype().add(rdfsclass);
    }
    

    /**
     * Get a Java object of type <code>newType</code> that represents the same
     * resource as this object. 
     * 
     * <p>This method is almost identical to the 
     * {@link #asType(Class) asType(Class)} method except that it does not 
     * require the statements in the context graph of this object support viewing
     * this object as the <code>newType</code>. However, this method still
     * requires the top two conditions of the <a href="#threeconditions">three 
     * conditions documented above</a>.
     * 
     * @param newType the Java class object representing the new type
     * @return a Java object of type <code>newType</code> and represents the same
     *         resource as this object. 
     * @throws UnsupportedViewTypeException if the top two conditions of the
     *         <a href="#threeconditions">three conditions documented above</a> 
     *         are not met.
     *         
     * @see #asType(Class)
     * @see #canAsType(Class)
     * 
     * @eodmext This method is added by EODM to support dynamic typing capability.
     */
    
    public RDFSResource forceAsType(Class newType) throws UnsupportedViewTypeException
    {
    	EClass eclassType=EJClassMapping.jclass2eclass( newType );
    	if(eclassType!=null)
    	{
    		if(this.canAsType(newType))
    		{
       			return this.asType(newType);
    		}
        	else
        	{
        		
        		return this.addProxy(eclassType,eclassType.getInstanceClass());
        	}
    	}
    	else
    	{
    		throw new UnsupportedViewTypeException();
    	}
    }
    /**
     * Get a Java object of type <code>newType</code> that represents the same
     * resource as this object. 
     * 
     * <p>This method is added to support dynamic typing in RDF/OWL. It obtains 
     * another view of the same resource that this object represents. For example,
     * if, in a RDF graph, a resource is declared to be both a class and a property,
     * you can use the following code to access the resource as both a class
     * and a property:<p>
     * <pre>
     *     RDFFactory rdfFactory = ... // obtain a factory from implementation
     *     
     *     // get the class
     *     RDFSClass c = rdfFactory.createRDFSClass( "urn:example.com:poly" );
     *     
     *     // get the the same resource as a property
     *     RDFProperty p = (RDFProperty) c.asType( RDFProperty.class );
     *     
     *     // let's assume that the class c has no label yet
     *     assert( c.getRDFSLabel().size() == 0 );
     *     
     *     // if we add a label to the property
     *     p.getRDFSLabel().add( rdfFactory.createPlainLiteral("poly") );
     *     
     *     // since p and c represent the same resource, the label will also
     *     // appear in the class c
     *     assert( c.getRDFSLabel().size() == 1 );
     * </pre> 
     * <p>When you access the same resource using different types of Java objects, 
     * the implementation will automatically maintain the consisitency among the 
     * different Java objects.</p>
     * 
     * <a name="threeconditions"></a>
     * <p><strong>Three conditions must be met for this method to return successfully.</strong>
     * <ul>
     *   <li> This object itself can not be an instance of {@link org.eclipse.eodm.RDF.RDFWeb.Document Document},
     *   {@link org.eclipse.eodm.RDF.RDFS.RDFBase.RDFGraph RDFGraph} or 
     *   {@link org.eclipse.eodm.OWL.OWLBase.OWLGraph OWLGraph}. An alternative
     *   way to do this is shown at the bottom of this method documentation.<p>
     *   
     *   <li> The new type must be a subinterface of <code>RDFSResource</code>. 
     *   That is, the assertion <code>RDFSResource.class.isAssignableFrom( newType )</code> 
     *   must hold. This is obvious since RDFResource is the superinterface of
     *   all model resources in RDF/OWL models. In addition, the <code>newType</code>
     *   can not be any of the three: {@link org.eclipse.eodm.RDF.RDFWeb.Document Document},
     *   {@link org.eclipse.eodm.RDF.RDFS.RDFBase.RDFGraph RDFGraph} and 
     *   {@link org.eclipse.eodm.OWL.OWLBase.OWLGraph OWLGraph}. <p>
     *   
     *   <li> The statements in the context graph of this object support viewing
     *   this object as the <code>newType</code>. The semantics of "support" is
     *   delegated to the implementations of this method to clarify. For example,
     *   The new type is supported if there is a rdf:type statement in the graph for this
     *   resource and the new type. However, you can force the conversion of 
     *   a new type using the {@link RDFSResource#forceAsType(Class) forceAsType(newType)}
     *   method. You can also use the {@link #canAsType(Class)} method to check
     *   whether the new type is supported by the statements in the context graph.
     * </ul>
     *  
     * <p>After you obtained the new type object, you can safely cast the object to 
     * the new type as: 
     * <pre>NewType o2 = (NewType) o1.asType( NewType.class )</pre>
     *         
     * @param newType the Java class object representing the new type. 
     * @return a Java object of type <code>newType</code> and represents the same
     *         resource as this object. 
     * @throws UnsupportedViewTypeException if the <a href="#threeconditions">three 
     *         conditions documented above</a> are not met.
     *         
     * @see #canAsType(Class)
     * @see #forceAsType(Class)
     * 
     * @eodmext This method is added by EODM to support dynamic typing capability.         
     */
    public RDFSResource asType(Class newType) throws UnsupportedViewTypeException
    {
    	EClass eclassType=EJClassMapping.jclass2eclass(newType);
    	if(eclassType!=null)
    	{
    		for(Iterator iterator = this.proxyList.iterator();iterator.hasNext();)
            {
            	ProxyEntity pe = (ProxyEntity)iterator.next();
            	if(eclassType.isSuperTypeOf(pe.getEClass()))
            	{
            		return (RDFSResource)pe.getProxyObject();
            	}
            }
        	for(Iterator iterator = this.getRDFtype().iterator();iterator.hasNext();)
        	{
        		RDFSResource rdfsResource = (RDFSResource)iterator.next();
        		if ( ! rdfsResource.getUriRef().isEmpty() )
        		{
	        		EClass rdftype = (EClass)OWLUtility.getEClass().get(rdfsResource.getURI());
	        		if(rdftype!=null&&eclassType.isSuperTypeOf(rdftype))
	        		{
	    	    		return this.addProxy(eclassType,eclassType.getInstanceClass());
	    	        }
        		}
        	}
        	throw new UnsupportedViewTypeException();
    	}
    	else
    	{
    		throw new UnsupportedViewTypeException();
    	}	
    }


	/**
	 * Add proxies for rdf:type declarations
	 *
	 */
	public void addProxiesForTypes() {
		EList types = this.getRDFtype();
		int s = types.size();
		for (int i=0; i<s; i++)
		{
			RDFSResource r = (RDFSResource) types.get(i);
			if ( ! r.getUriRef().isEmpty() )
			{
				EClass tclass = (EClass) OWLUtility.getEClass().get( r.getURI() );
				if ( tclass == null ) continue ;
				int psize = this.getProxyList().size();
				boolean covered = false ;
				for (int j=0; j<psize; j++)
				{
					ProxyEntity pr = (ProxyEntity) this.getProxyList().get(j);
					if ( tclass.isSuperTypeOf( pr.getEClass() ) )
						covered = true ;
				}
				if ( ! covered )
					this.addProxy( tclass, tclass.getInstanceClass() );
			}
		}
	}    
    
    public RDFSResource[] getAllTypeViews()
    {
    	int size = this.getProxyList().size();
    	RDFSResource[] proxies = new RDFSResource[ size ];
    	for ( int i=0; i<size; i++)
    		proxies[i] = (RDFSResource) ((ProxyEntity)this.getProxyList().get(i)).getProxyObject();
    	return proxies ;
    }
    
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case EODMImplPackage.INTERNAL_CORE__URI_REF:
					return ((InternalEList)getUriRef()).basicAdd(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__SUBJECT_STATEMENT:
					return ((InternalEList)getSubjectStatement()).basicAdd(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__RDF_SSUB_CLASS_OF:
					return ((InternalEList)getRDFSsubClassOf()).basicAdd(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__SUB_CLASS:
					return ((InternalEList)getSubClass()).basicAdd(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__PROPERTY_FOR_DOMAIN:
					return ((InternalEList)getPropertyForDomain()).basicAdd(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__PROPERTY_FOR_RANGE:
					return ((InternalEList)getPropertyForRange()).basicAdd(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__ONTOLOGY:
					if (ontology != null)
						msgs = ((InternalEObject)ontology).eInverseRemove(this, OWLBasePackage.OWL_ONTOLOGY__OWL_UNIVERSE, OWLOntology.class, msgs);
					return basicSetOntology((OWLOntology)otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__RDF_SDOMAIN:
					return ((InternalEList)getRDFSdomain()).basicAdd(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__RDF_SRANGE:
					return ((InternalEList)getRDFSrange()).basicAdd(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__RDF_SSUB_PROPERTY_OF:
					return ((InternalEList)getRDFSsubPropertyOf()).basicAdd(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__SUB_PROPERTY:
					return ((InternalEList)getSubProperty()).basicAdd(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__OWL_GRAPH:
					return ((InternalEList)getOwlGraph()).basicAdd(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__OWL_UNIVERSE:
					if (owlUniverse != null)
						msgs = ((InternalEObject)owlUniverse).eInverseRemove(this, OWLBasePackage.UNIVERSE__ONTOLOGY, Universe.class, msgs);
					return basicSetOwlUniverse((Universe)otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__GRAPHONTOLOGY:
					return ((InternalEList)getGraphontology()).basicAdd(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__DOCUMENT:
					return ((InternalEList)getDocument()).basicAdd(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__RD_FSUBJECT:
					if (rdFsubject != null)
						msgs = ((InternalEObject)rdFsubject).eInverseRemove(this, RDFBasePackage.RDFS_RESOURCE__SUBJECT_STATEMENT, RDFSResource.class, msgs);
					return basicSetRDFsubject((RDFSResource)otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__NAME_FOR_REIFICATION:
					return ((InternalEList)getNameForReification()).basicAdd(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__STATEMENT:
					return ((InternalEList)getStatement()).basicAdd(otherEnd, msgs);
				// added by EODM
				case EODMImplPackage.INTERNAL_CORE__TYPED_RESOURCE:
					return ((InternalEList)getTypedResource()).basicAdd(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__RD_FTYPE:
					return ((InternalEList)getRDFtype()).basicAdd(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__COMPLEMENT_CLASS:
					return ((InternalEList)getComplementClass()).basicAdd(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__OW_LCOMPLEMENT_OF:
					if (owLcomplementOf != null )
						msgs = ((InternalEObject)owLcomplementOf).eInverseRemove(this, OWLBasePackage.OWL_CLASS__COMPLEMENT_CLASS, OWLClass.class, msgs);
					return basicSetOWLcomplementOf((OWLClass)otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__INTERSECTION_CLASS:
					return ((InternalEList)getIntersectionClass()).basicAdd(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__OW_LINTERSECTION_OF:
					return ((InternalEList)getOWLintersectionOf()).basicAdd(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__UNION_CLASS:
					return ((InternalEList)getUnionClass()).basicAdd(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__OW_LUNION_OF:
					return ((InternalEList)getOWLunionOf()).basicAdd(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__DISJOINT_CLASS:
					return ((InternalEList)getDisjointClass()).basicAdd(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__OW_LDISJOINT_WITH:
					return ((InternalEList)getOWLdisjointWith()).basicAdd(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__EQUIVALENT_CLASS:
					return ((InternalEList)getEquivalentClass()).basicAdd(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__OW_LEQUIVALENT_CLASS:
					return ((InternalEList)getOWLEquivalentClass()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case EODMImplPackage.INTERNAL_CORE__RDF_SCOMMENT:
					return ((InternalEList)getRDFScomment()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__RDF_SLABEL:
					return ((InternalEList)getRDFSlabel()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__URI_REF:
					return ((InternalEList)getUriRef()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__SUBJECT_STATEMENT:
					return ((InternalEList)getSubjectStatement()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__RDF_SSUB_CLASS_OF:
					return ((InternalEList)getRDFSsubClassOf()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__SUB_CLASS:
					return ((InternalEList)getSubClass()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__PROPERTY_FOR_DOMAIN:
					return ((InternalEList)getPropertyForDomain()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__PROPERTY_FOR_RANGE:
					return ((InternalEList)getPropertyForRange()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__ONTOLOGY:
					return basicSetOntology(null, msgs);
				case EODMImplPackage.INTERNAL_CORE__IS_CLASS_KIND:
					return basicSetIsClassKind(null, msgs);
				case EODMImplPackage.INTERNAL_CORE__HAS_RESTRICTION_KIND:
					return basicSetHasRestrictionKind(null, msgs);
				case EODMImplPackage.INTERNAL_CORE__RDF_SDOMAIN:
					return ((InternalEList)getRDFSdomain()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__RDF_SRANGE:
					return ((InternalEList)getRDFSrange()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__RDF_SSUB_PROPERTY_OF:
					return ((InternalEList)getRDFSsubPropertyOf()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__SUB_PROPERTY:
					return ((InternalEList)getSubProperty()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__OW_LVERSION_INFO:
					return ((InternalEList)getOWLversionInfo()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__OWL_GRAPH:
					return ((InternalEList)getOwlGraph()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__OWL_UNIVERSE:
					return basicSetOwlUniverse(null, msgs);
				case EODMImplPackage.INTERNAL_CORE__GRAPH_NAME:
					return basicSetGraphName(null, msgs);
				case EODMImplPackage.INTERNAL_CORE__GRAPHONTOLOGY:
					return ((InternalEList)getGraphontology()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__DOCUMENT:
					return ((InternalEList)getDocument()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__RD_FSUBJECT:
					return basicSetRDFsubject(null, msgs);
				case EODMImplPackage.INTERNAL_CORE__NAME_FOR_REIFICATION:
					return ((InternalEList)getNameForReification()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__STATEMENT:
					return ((InternalEList)getStatement()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__LOCAL_NAME:
					return ((InternalEList)getLocalName()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__NAMESPACE_DEFINITION:
					return ((InternalEList)getNamespaceDefinition()).basicRemove(otherEnd, msgs);
				// added by EODM
				case EODMImplPackage.INTERNAL_CORE__TYPED_RESOURCE:
					return ((InternalEList)getTypedResource()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__RD_FTYPE:
					return ((InternalEList)getRDFtype()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__COMPLEMENT_CLASS:
					return ((InternalEList)getComplementClass()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__OW_LCOMPLEMENT_OF:
					return basicSetOWLcomplementOf(null, msgs);
				case EODMImplPackage.INTERNAL_CORE__INTERSECTION_CLASS:
					return ((InternalEList)getIntersectionClass()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__OW_LINTERSECTION_OF:
					return ((InternalEList)getOWLintersectionOf()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__UNION_CLASS:
					return ((InternalEList)getUnionClass()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__OW_LUNION_OF:
					return ((InternalEList)getOWLunionOf()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__DISJOINT_CLASS:
					return ((InternalEList)getDisjointClass()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__OW_LDISJOINT_WITH:
					return ((InternalEList)getOWLdisjointWith()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__EQUIVALENT_CLASS:
					return ((InternalEList)getEquivalentClass()).basicRemove(otherEnd, msgs);
				case EODMImplPackage.INTERNAL_CORE__OW_LEQUIVALENT_CLASS:
					return ((InternalEList)getOWLEquivalentClass()).basicRemove(otherEnd, msgs);					
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case EODMImplPackage.INTERNAL_CORE__RDF_SIS_DEFINED_BY:
				return getRDFSisDefinedBy();
			case EODMImplPackage.INTERNAL_CORE__RDF_SSEE_ALSO:
				return getRDFSseeAlso();
			case EODMImplPackage.INTERNAL_CORE__RD_FTYPE:
				return getRDFtype();
			case EODMImplPackage.INTERNAL_CORE__RDF_SMEMBER:
				return getRDFSmember();
			case EODMImplPackage.INTERNAL_CORE__NODE_ID:
				return getNodeID();
			case EODMImplPackage.INTERNAL_CORE__RDF_SCOMMENT:
				return getRDFScomment();
			case EODMImplPackage.INTERNAL_CORE__RDF_SLABEL:
				return getRDFSlabel();
			case EODMImplPackage.INTERNAL_CORE__URI_REF:
				return getUriRef();
			case EODMImplPackage.INTERNAL_CORE__SUBJECT_STATEMENT:
				return getSubjectStatement();
//			case EODMImplPackage.INTERNAL_CORE__LEXICAL_FORM:
//				return getLexicalForm();
//			case EODMImplPackage.INTERNAL_CORE__LANGUAGE:
//				return getLanguage();
			case EODMImplPackage.INTERNAL_CORE__RDF_SSUB_CLASS_OF:
				return getRDFSsubClassOf();
			case EODMImplPackage.INTERNAL_CORE__SUB_CLASS:
				return getSubClass();
			case EODMImplPackage.INTERNAL_CORE__PROPERTY_FOR_DOMAIN:
				return getPropertyForDomain();
			case EODMImplPackage.INTERNAL_CORE__PROPERTY_FOR_RANGE:
				return getPropertyForRange();
			case EODMImplPackage.INTERNAL_CORE__ONTOLOGY:
				if (resolve) return getOntology();
				return basicGetOntology();
			case EODMImplPackage.INTERNAL_CORE__IS_DEPRECATED:
				return isIsDeprecated() ? Boolean.TRUE : Boolean.FALSE;
			case EODMImplPackage.INTERNAL_CORE__IS_CLASS_KIND:
				return getIsClassKind();
			case EODMImplPackage.INTERNAL_CORE__HAS_RESTRICTION_KIND:
				return getHasRestrictionKind();
			case EODMImplPackage.INTERNAL_CORE__OW_LEQUIVALENT_CLASS:
				return getOWLEquivalentClass();
			case EODMImplPackage.INTERNAL_CORE__OW_LDISJOINT_WITH:
				return getOWLdisjointWith();
			case EODMImplPackage.INTERNAL_CORE__OW_LCOMPLEMENT_OF:
				if (resolve) return getOWLcomplementOf();
				return basicGetOWLcomplementOf();
//			case EODMImplPackage.INTERNAL_CORE__DATATYPE_URI:
//				if (resolve) return getDatatypeURI();
//				return basicGetDatatypeURI();
			case EODMImplPackage.INTERNAL_CORE__OW_LDISTINCT_MEMBERS:
				return getOWLdistinctMembers();
			case EODMImplPackage.INTERNAL_CORE__OW_LON_PROPERTY:
				if (resolve) return getOWLonProperty();
				return basicGetOWLonProperty();
			case EODMImplPackage.INTERNAL_CORE__OW_LCARDINALITY:
				if (resolve) return getOWLcardinality();
				return basicGetOWLcardinality();
			case EODMImplPackage.INTERNAL_CORE__OW_LMIN_CARDINALITY:
				if (resolve) return getOWLminCardinality();
				return basicGetOWLminCardinality();
			case EODMImplPackage.INTERNAL_CORE__SOME_VALUES_FROM_CLASS:
				if (resolve) return getSomeValuesFromClass();
				return basicGetSomeValuesFromClass();
			case EODMImplPackage.INTERNAL_CORE__SOME_VALUES_FROM_DATA_RANGE:
				if (resolve) return getSomeValuesFromDataRange();
				return basicGetSomeValuesFromDataRange();
			case EODMImplPackage.INTERNAL_CORE__OW_LDIFFERENT_FROM:
				return getOWLdifferentFrom();
			case EODMImplPackage.INTERNAL_CORE__OW_LSAME_AS:
				return getOWLsameAs();
			case EODMImplPackage.INTERNAL_CORE__RD_FFIRST:
				if (resolve) return getRDFfirst();
				return basicGetRDFfirst();
			case EODMImplPackage.INTERNAL_CORE__RD_FREST:
				if (resolve) return getRDFrest();
				return basicGetRDFrest();
			case EODMImplPackage.INTERNAL_CORE__RDF_SDOMAIN:
				return getRDFSdomain();
			case EODMImplPackage.INTERNAL_CORE__RDF_SRANGE:
				return getRDFSrange();
			case EODMImplPackage.INTERNAL_CORE__RDF_SSUB_PROPERTY_OF:
				return getRDFSsubPropertyOf();
			case EODMImplPackage.INTERNAL_CORE__SUB_PROPERTY:
				return getSubProperty();
			case EODMImplPackage.INTERNAL_CORE__IS_PROPERTY_DEPRECATED:
				return isIsPropertyDeprecated() ? Boolean.TRUE : Boolean.FALSE;
			case EODMImplPackage.INTERNAL_CORE__IS_FUNCTIONAL:
				return isIsFunctional() ? Boolean.TRUE : Boolean.FALSE;
			case EODMImplPackage.INTERNAL_CORE__IS_OBJECT_PROPERTY:
				return isIsObjectProperty() ? Boolean.TRUE : Boolean.FALSE;
			case EODMImplPackage.INTERNAL_CORE__IS_DATATYPE_PROPERTY:
				return isIsDatatypeProperty() ? Boolean.TRUE : Boolean.FALSE;
			case EODMImplPackage.INTERNAL_CORE__OW_LEQUIVALENT_PROPERTY:
				return getOWLequivalentProperty();
			case EODMImplPackage.INTERNAL_CORE__OW_LBACKWARD_COMPATIBLE_WITH:
				return getOWLbackwardCompatibleWith();
			case EODMImplPackage.INTERNAL_CORE__OW_LIMPORTS:
				return getOWLimports();
			case EODMImplPackage.INTERNAL_CORE__OW_LVERSION_INFO:
				return getOWLversionInfo();
			case EODMImplPackage.INTERNAL_CORE__OW_LPRIOR_VERSION:
				return getOWLpriorVersion();
			case EODMImplPackage.INTERNAL_CORE__OW_LINCOMPATIBLE_WITH:
				return getOWLincompatibleWith();
			case EODMImplPackage.INTERNAL_CORE__OWL_GRAPH:
				return getOwlGraph();
			case EODMImplPackage.INTERNAL_CORE__OWL_STATEMENT:
				return getOwlStatement();
			case EODMImplPackage.INTERNAL_CORE__OWL_UNIVERSE:
				if (resolve) return getOwlUniverse();
				return basicGetOwlUniverse();
			case EODMImplPackage.INTERNAL_CORE__GRAPHSTATEMENT:
				return getGraphstatement();
			case EODMImplPackage.INTERNAL_CORE__GRAPH_NAME:
				return getGraphName();
			case EODMImplPackage.INTERNAL_CORE__GRAPHONTOLOGY:
				return getGraphontology();
			case EODMImplPackage.INTERNAL_CORE__OWL_GRAPH_STATEMENT:
				return getOwlGraphStatement();
			case EODMImplPackage.INTERNAL_CORE__HAS_INDIVIDUAL_VALUE:
				if (resolve) return getHasIndividualValue();
				return basicGetHasIndividualValue();
			case EODMImplPackage.INTERNAL_CORE__HAS_LITERAL_VALUE:
				if (resolve) return getHasLiteralValue();
				return basicGetHasLiteralValue();
			case EODMImplPackage.INTERNAL_CORE__ALL_VALUES_FROM_CLASS:
				if (resolve) return getAllValuesFromClass();
				return basicGetAllValuesFromClass();
			case EODMImplPackage.INTERNAL_CORE__ALL_VALUES_FROM_DATA_RANGE:
				if (resolve) return getAllValuesFromDataRange();
				return basicGetAllValuesFromDataRange();
			case EODMImplPackage.INTERNAL_CORE__OW_LMAX_CARDINALITY:
				if (resolve) return getOWLmaxCardinality();
				return basicGetOWLmaxCardinality();
			case EODMImplPackage.INTERNAL_CORE__OW_LINTERSECTION_OF:
				return getOWLintersectionOf();
			case EODMImplPackage.INTERNAL_CORE__OW_LONE_OF:
				return getOWLoneOf();
			case EODMImplPackage.INTERNAL_CORE__OW_LUNION_OF:
				return getOWLunionOf();
			case EODMImplPackage.INTERNAL_CORE__OWL_DATA_RANGEONE_OF:
				return getOWLDataRangeOneOf();
			case EODMImplPackage.INTERNAL_CORE__DATATYPE:
				if (resolve) return getDatatype();
				return basicGetDatatype();
			case EODMImplPackage.INTERNAL_CORE__DOCUMENT:
				return getDocument();
			case EODMImplPackage.INTERNAL_CORE__IS_REIFIED_ONLY:
				return isIsReifiedOnly() ? Boolean.TRUE : Boolean.FALSE;
			case EODMImplPackage.INTERNAL_CORE__IS_REIFIED:
				return isIsReified() ? Boolean.TRUE : Boolean.FALSE;
			case EODMImplPackage.INTERNAL_CORE__RD_FSUBJECT:
				if (resolve) return getRDFsubject();
				return basicGetRDFsubject();
			case EODMImplPackage.INTERNAL_CORE__RD_FOBJECT:
				if (resolve) return getRDFobject();
				return basicGetRDFobject();
			case EODMImplPackage.INTERNAL_CORE__RD_FPREDICATE:
				if (resolve) return getRDFpredicate();
				return basicGetRDFpredicate();
			case EODMImplPackage.INTERNAL_CORE__NAME_FOR_REIFICATION:
				return getNameForReification();
			case EODMImplPackage.INTERNAL_CORE__IS_INVERSE_FUNCTIONAL:
				return isIsInverseFunctional() ? Boolean.TRUE : Boolean.FALSE;
			case EODMImplPackage.INTERNAL_CORE__IS_SYMMETRIC:
				return isIsSymmetric() ? Boolean.TRUE : Boolean.FALSE;
			case EODMImplPackage.INTERNAL_CORE__IS_TRANSITIVE:
				return isIsTransitive() ? Boolean.TRUE : Boolean.FALSE;
			case EODMImplPackage.INTERNAL_CORE__OW_LINVERSE_OF:
				return getOWLinverseOf();
			case EODMImplPackage.INTERNAL_CORE__STATEMENT:
				return getStatement();
			case EODMImplPackage.INTERNAL_CORE__LOCAL_NAME:
				return getLocalName();
			case EODMImplPackage.INTERNAL_CORE__XML_BASE:
				return getXmlBase();
			case EODMImplPackage.INTERNAL_CORE__NAMESPACE_DEFINITION:
				return getNamespaceDefinition();
			// added features by EODM
			case EODMImplPackage.INTERNAL_CORE__TYPED_RESOURCE:
				return getTypedResource();
			case EODMImplPackage.INTERNAL_CORE__COMPLEMENT_CLASS:
				return getComplementClass();
			case EODMImplPackage.INTERNAL_CORE__INTERSECTION_CLASS:
				return getIntersectionClass();
			case EODMImplPackage.INTERNAL_CORE__UNION_CLASS:
				return getUnionClass();
			case EODMImplPackage.INTERNAL_CORE__DISJOINT_CLASS:
				return getDisjointClass();
			case EODMImplPackage.INTERNAL_CORE__EQUIVALENT_CLASS:
				return getEquivalentClass();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		try {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case EODMImplPackage.INTERNAL_CORE__RDF_SIS_DEFINED_BY:
				getRDFSisDefinedBy().clear();
				getRDFSisDefinedBy().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__RDF_SSEE_ALSO:
				getRDFSseeAlso().clear();
				getRDFSseeAlso().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__RD_FTYPE:
				getRDFtype().clear();
				getRDFtype().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__RDF_SMEMBER:
				getRDFSmember().clear();
				getRDFSmember().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__NODE_ID:
				setNodeID((String)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__RDF_SCOMMENT:
				getRDFScomment().clear();
				getRDFScomment().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__RDF_SLABEL:
				getRDFSlabel().clear();
				getRDFSlabel().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__URI_REF:
				getUriRef().clear();
				getUriRef().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__SUBJECT_STATEMENT:
				getSubjectStatement().clear();
				getSubjectStatement().addAll((Collection)newValue);
				return;
//			case EODMImplPackage.INTERNAL_CORE__LEXICAL_FORM:
//				setLexicalForm((String)newValue);
//				return;
//			case EODMImplPackage.INTERNAL_CORE__LANGUAGE:
//				setLanguage((String)newValue);
//				return;
			case EODMImplPackage.INTERNAL_CORE__RDF_SSUB_CLASS_OF:
				getRDFSsubClassOf().clear();
				getRDFSsubClassOf().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__SUB_CLASS:
				getSubClass().clear();
				getSubClass().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__PROPERTY_FOR_DOMAIN:
				getPropertyForDomain().clear();
				getPropertyForDomain().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__PROPERTY_FOR_RANGE:
				getPropertyForRange().clear();
				getPropertyForRange().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__ONTOLOGY:
				setOntology((OWLOntology)((RDFSResource)newValue).forceAsType(OWLOntology.class));
				return;
			case EODMImplPackage.INTERNAL_CORE__IS_DEPRECATED:
				setIsDeprecated(((Boolean)newValue).booleanValue());
				return;
			case EODMImplPackage.INTERNAL_CORE__IS_CLASS_KIND:
				setIsClassKind((EObject)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__HAS_RESTRICTION_KIND:
				setHasRestrictionKind((EObject)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LEQUIVALENT_CLASS:
				getOWLEquivalentClass().clear();
				getOWLEquivalentClass().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LDISJOINT_WITH:
				getOWLdisjointWith().clear();
				getOWLdisjointWith().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LCOMPLEMENT_OF:
				setOWLcomplementOf((OWLClass)((RDFSResource)newValue).forceAsType(OWLClass.class));
				return;
//			case EODMImplPackage.INTERNAL_CORE__DATATYPE_URI:
//				setDatatypeURI((URIReference)newValue);
//				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LDISTINCT_MEMBERS:
				getOWLdistinctMembers().clear();
				getOWLdistinctMembers().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LON_PROPERTY:
				setOWLonProperty((RDFProperty)((RDFSResource)newValue).forceAsType(RDFProperty.class));
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LCARDINALITY:
				setOWLcardinality((TypedLiteral)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LMIN_CARDINALITY:
				setOWLminCardinality((TypedLiteral)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__SOME_VALUES_FROM_CLASS:
				setSomeValuesFromClass((OWLClass)((RDFSResource)newValue).forceAsType(OWLClass.class));
				return;
			case EODMImplPackage.INTERNAL_CORE__SOME_VALUES_FROM_DATA_RANGE:
				setSomeValuesFromDataRange((OWLDataRange)((RDFSResource)newValue).forceAsType(OWLDataRange.class));
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LDIFFERENT_FROM:
				getOWLdifferentFrom().clear();
				getOWLdifferentFrom().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LSAME_AS:
				getOWLsameAs().clear();
				getOWLsameAs().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__RD_FFIRST:
				setRDFfirst((RDFSResource)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__RD_FREST:
				setRDFrest((RDFList)((RDFSResource)newValue).forceAsType(RDFList.class));
				return;
			case EODMImplPackage.INTERNAL_CORE__RDF_SDOMAIN:
				getRDFSdomain().clear();
				getRDFSdomain().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__RDF_SRANGE:
				getRDFSrange().clear();
				getRDFSrange().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__RDF_SSUB_PROPERTY_OF:
				getRDFSsubPropertyOf().clear();
				getRDFSsubPropertyOf().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__SUB_PROPERTY:
				getSubProperty().clear();
				getSubProperty().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__IS_PROPERTY_DEPRECATED:
				setIsPropertyDeprecated(((Boolean)newValue).booleanValue());
				return;
			case EODMImplPackage.INTERNAL_CORE__IS_FUNCTIONAL:
				setIsFunctional(((Boolean)newValue).booleanValue());
				return;
			case EODMImplPackage.INTERNAL_CORE__IS_OBJECT_PROPERTY:
				setIsObjectProperty(((Boolean)newValue).booleanValue());
				return;
			case EODMImplPackage.INTERNAL_CORE__IS_DATATYPE_PROPERTY:
				setIsDatatypeProperty(((Boolean)newValue).booleanValue());
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LEQUIVALENT_PROPERTY:
				getOWLequivalentProperty().clear();
				getOWLequivalentProperty().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LBACKWARD_COMPATIBLE_WITH:
				getOWLbackwardCompatibleWith().clear();
				getOWLbackwardCompatibleWith().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LIMPORTS:
				getOWLimports().clear();
				getOWLimports().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LVERSION_INFO:
				getOWLversionInfo().clear();
				getOWLversionInfo().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LPRIOR_VERSION:
				getOWLpriorVersion().clear();
				getOWLpriorVersion().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LINCOMPATIBLE_WITH:
				getOWLincompatibleWith().clear();
				getOWLincompatibleWith().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__OWL_GRAPH:
				getOwlGraph().clear();
				getOwlGraph().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__OWL_STATEMENT:
				getOwlStatement().clear();
				getOwlStatement().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__OWL_UNIVERSE:
				setOwlUniverse((Universe)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__GRAPHSTATEMENT:
				getGraphstatement().clear();
				getGraphstatement().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__GRAPH_NAME:
				setGraphName((URIReference)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__GRAPHONTOLOGY:
				getGraphontology().clear();
				getGraphontology().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__OWL_GRAPH_STATEMENT:
				getOwlGraphStatement().clear();
				getOwlGraphStatement().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__HAS_INDIVIDUAL_VALUE:
				setHasIndividualValue((Individual)((RDFSResource)newValue).forceAsType(Individual.class));
				return;
			case EODMImplPackage.INTERNAL_CORE__HAS_LITERAL_VALUE:
				setHasLiteralValue((RDFSLiteral)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__ALL_VALUES_FROM_CLASS:
				setAllValuesFromClass((OWLClass)((RDFSResource)newValue).forceAsType(OWLClass.class));
				return;
			case EODMImplPackage.INTERNAL_CORE__ALL_VALUES_FROM_DATA_RANGE:
				setAllValuesFromDataRange((OWLDataRange)((RDFSResource)newValue).forceAsType(OWLDataRange.class));
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LMAX_CARDINALITY:
				setOWLmaxCardinality((TypedLiteral)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LINTERSECTION_OF:
				getOWLintersectionOf().clear();
				getOWLintersectionOf().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LONE_OF:
				getOWLoneOf().clear();
				getOWLoneOf().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LUNION_OF:
				getOWLunionOf().clear();
				getOWLunionOf().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__OWL_DATA_RANGEONE_OF:
				getOWLDataRangeOneOf().clear();
				getOWLDataRangeOneOf().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__DATATYPE:
				setDatatype((RDFSDatatype)((RDFSResource)newValue).forceAsType(RDFSDatatype.class));
				return;
			case EODMImplPackage.INTERNAL_CORE__DOCUMENT:
				getDocument().clear();
				getDocument().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__IS_REIFIED_ONLY:
				setIsReifiedOnly(((Boolean)newValue).booleanValue());
				return;
			case EODMImplPackage.INTERNAL_CORE__IS_REIFIED:
				setIsReified(((Boolean)newValue).booleanValue());
				return;
			case EODMImplPackage.INTERNAL_CORE__RD_FSUBJECT:
				setRDFsubject((RDFSResource)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__RD_FOBJECT:
				setRDFobject((RDFSResource)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__RD_FPREDICATE:
				setRDFpredicate((RDFProperty)((RDFSResource)newValue).forceAsType(RDFProperty.class));
				return;
			case EODMImplPackage.INTERNAL_CORE__NAME_FOR_REIFICATION:
				getNameForReification().clear();
				getNameForReification().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__IS_INVERSE_FUNCTIONAL:
				setIsInverseFunctional(((Boolean)newValue).booleanValue());
				return;
			case EODMImplPackage.INTERNAL_CORE__IS_SYMMETRIC:
				setIsSymmetric(((Boolean)newValue).booleanValue());
				return;
			case EODMImplPackage.INTERNAL_CORE__IS_TRANSITIVE:
				setIsTransitive(((Boolean)newValue).booleanValue());
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LINVERSE_OF:
				getOWLinverseOf().clear();
				getOWLinverseOf().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__STATEMENT:
				getStatement().clear();
				getStatement().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__LOCAL_NAME:
				getLocalName().clear();
				getLocalName().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__XML_BASE:
				getXmlBase().clear();
				getXmlBase().addAll((Collection)newValue);
				return;
			case EODMImplPackage.INTERNAL_CORE__NAMESPACE_DEFINITION:
				getNamespaceDefinition().clear();
				getNamespaceDefinition().addAll((Collection)newValue);
				return;
			// added by EODM
			case EODMImplPackage.INTERNAL_CORE__TYPED_RESOURCE:
				getTypedResource().clear();
				getTypedResource().addAll((Collection)newValue);
				return ;
			case EODMImplPackage.INTERNAL_CORE__COMPLEMENT_CLASS:
				getComplementClass().clear();
				getComplementClass().addAll((Collection)newValue);
				return ;
			case EODMImplPackage.INTERNAL_CORE__INTERSECTION_CLASS:
				getIntersectionClass().clear();
				getIntersectionClass().addAll((Collection)newValue);
				return ;
			case EODMImplPackage.INTERNAL_CORE__UNION_CLASS:
				getUnionClass().clear();
				getUnionClass().addAll((Collection)newValue);
				return ;
			case EODMImplPackage.INTERNAL_CORE__DISJOINT_CLASS:
				getDisjointClass().clear();
				getDisjointClass().addAll((Collection)newValue);
				return ;
			case EODMImplPackage.INTERNAL_CORE__EQUIVALENT_CLASS:
				getEquivalentClass().clear();
				getEquivalentClass().addAll((Collection)newValue);
				return ;
		}
		} catch (UnsupportedViewTypeException ue) {
			ue.printStackTrace();
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case EODMImplPackage.INTERNAL_CORE__RDF_SIS_DEFINED_BY:
				getRDFSisDefinedBy().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__RDF_SSEE_ALSO:
				getRDFSseeAlso().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__RD_FTYPE:
				getRDFtype().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__RDF_SMEMBER:
				getRDFSmember().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__NODE_ID:
				setNodeID(NODE_ID_EDEFAULT);
				return;
			case EODMImplPackage.INTERNAL_CORE__RDF_SCOMMENT:
				getRDFScomment().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__RDF_SLABEL:
				getRDFSlabel().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__URI_REF:
				getUriRef().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__SUBJECT_STATEMENT:
				getSubjectStatement().clear();
				return;
//			case EODMImplPackage.INTERNAL_CORE__LEXICAL_FORM:
//				setLexicalForm(LEXICAL_FORM_EDEFAULT);
//				return;
//			case EODMImplPackage.INTERNAL_CORE__LANGUAGE:
//				setLanguage(LANGUAGE_EDEFAULT);
//				return;
			case EODMImplPackage.INTERNAL_CORE__RDF_SSUB_CLASS_OF:
				getRDFSsubClassOf().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__SUB_CLASS:
				getSubClass().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__PROPERTY_FOR_DOMAIN:
				getPropertyForDomain().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__PROPERTY_FOR_RANGE:
				getPropertyForRange().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__ONTOLOGY:
				setOntology((OWLOntology)null);
				return;
			case EODMImplPackage.INTERNAL_CORE__IS_DEPRECATED:
				setIsDeprecated(IS_DEPRECATED_EDEFAULT);
				return;
			case EODMImplPackage.INTERNAL_CORE__IS_CLASS_KIND:
				setIsClassKind((EObject)null);
				return;
			case EODMImplPackage.INTERNAL_CORE__HAS_RESTRICTION_KIND:
				setHasRestrictionKind((EObject)null);
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LEQUIVALENT_CLASS:
				getOWLEquivalentClass().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LDISJOINT_WITH:
				getOWLdisjointWith().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LCOMPLEMENT_OF:
				setOWLcomplementOf((OWLClass)null);
				return;
//			case EODMImplPackage.INTERNAL_CORE__DATATYPE_URI:
//				setDatatypeURI((URIReference)null);
//				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LDISTINCT_MEMBERS:
				getOWLdistinctMembers().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LON_PROPERTY:
				setOWLonProperty((RDFProperty)null);
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LCARDINALITY:
				setOWLcardinality((TypedLiteral)null);
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LMIN_CARDINALITY:
				setOWLminCardinality((TypedLiteral)null);
				return;
			case EODMImplPackage.INTERNAL_CORE__SOME_VALUES_FROM_CLASS:
				setSomeValuesFromClass((OWLClass)null);
				return;
			case EODMImplPackage.INTERNAL_CORE__SOME_VALUES_FROM_DATA_RANGE:
				setSomeValuesFromDataRange((OWLDataRange)null);
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LDIFFERENT_FROM:
				getOWLdifferentFrom().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LSAME_AS:
				getOWLsameAs().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__RD_FFIRST:
				setRDFfirst((RDFSResource)null);
				return;
			case EODMImplPackage.INTERNAL_CORE__RD_FREST:
				setRDFrest((RDFList)null);
				return;
			case EODMImplPackage.INTERNAL_CORE__RDF_SDOMAIN:
				getRDFSdomain().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__RDF_SRANGE:
				getRDFSrange().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__RDF_SSUB_PROPERTY_OF:
				getRDFSsubPropertyOf().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__SUB_PROPERTY:
				getSubProperty().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__IS_PROPERTY_DEPRECATED:
				setIsPropertyDeprecated(IS_PROPERTY_DEPRECATED_EDEFAULT);
				return;
			case EODMImplPackage.INTERNAL_CORE__IS_FUNCTIONAL:
				setIsFunctional(IS_FUNCTIONAL_EDEFAULT);
				return;
			case EODMImplPackage.INTERNAL_CORE__IS_OBJECT_PROPERTY:
				setIsObjectProperty(IS_OBJECT_PROPERTY_EDEFAULT);
				return;
			case EODMImplPackage.INTERNAL_CORE__IS_DATATYPE_PROPERTY:
				setIsDatatypeProperty(IS_DATATYPE_PROPERTY_EDEFAULT);
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LEQUIVALENT_PROPERTY:
				getOWLequivalentProperty().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LBACKWARD_COMPATIBLE_WITH:
				getOWLbackwardCompatibleWith().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LIMPORTS:
				getOWLimports().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LVERSION_INFO:
				getOWLversionInfo().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LPRIOR_VERSION:
				getOWLpriorVersion().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LINCOMPATIBLE_WITH:
				getOWLincompatibleWith().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__OWL_GRAPH:
				getOwlGraph().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__OWL_STATEMENT:
				getOwlStatement().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__OWL_UNIVERSE:
				setOwlUniverse((Universe)null);
				return;
			case EODMImplPackage.INTERNAL_CORE__GRAPHSTATEMENT:
				getGraphstatement().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__GRAPH_NAME:
				setGraphName((URIReference)null);
				return;
			case EODMImplPackage.INTERNAL_CORE__GRAPHONTOLOGY:
				getGraphontology().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__OWL_GRAPH_STATEMENT:
				getOwlGraphStatement().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__HAS_INDIVIDUAL_VALUE:
				setHasIndividualValue((Individual)null);
				return;
			case EODMImplPackage.INTERNAL_CORE__HAS_LITERAL_VALUE:
				setHasLiteralValue((RDFSLiteral)null);
				return;
			case EODMImplPackage.INTERNAL_CORE__ALL_VALUES_FROM_CLASS:
				setAllValuesFromClass((OWLClass)null);
				return;
			case EODMImplPackage.INTERNAL_CORE__ALL_VALUES_FROM_DATA_RANGE:
				setAllValuesFromDataRange((OWLDataRange)null);
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LMAX_CARDINALITY:
				setOWLmaxCardinality((TypedLiteral)null);
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LINTERSECTION_OF:
				getOWLintersectionOf().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LONE_OF:
				getOWLoneOf().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LUNION_OF:
				getOWLunionOf().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__OWL_DATA_RANGEONE_OF:
				getOWLDataRangeOneOf().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__DATATYPE:
				setDatatype((RDFSDatatype)null);
				return;
			case EODMImplPackage.INTERNAL_CORE__DOCUMENT:
				getDocument().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__IS_REIFIED_ONLY:
				setIsReifiedOnly(IS_REIFIED_ONLY_EDEFAULT);
				return;
			case EODMImplPackage.INTERNAL_CORE__IS_REIFIED:
				setIsReified(IS_REIFIED_EDEFAULT);
				return;
			case EODMImplPackage.INTERNAL_CORE__RD_FSUBJECT:
				setRDFsubject((RDFSResource)null);
				return;
			case EODMImplPackage.INTERNAL_CORE__RD_FOBJECT:
				setRDFobject((RDFSResource)null);
				return;
			case EODMImplPackage.INTERNAL_CORE__RD_FPREDICATE:
				setRDFpredicate((RDFProperty)null);
				return;
			case EODMImplPackage.INTERNAL_CORE__NAME_FOR_REIFICATION:
				getNameForReification().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__IS_INVERSE_FUNCTIONAL:
				setIsInverseFunctional(IS_INVERSE_FUNCTIONAL_EDEFAULT);
				return;
			case EODMImplPackage.INTERNAL_CORE__IS_SYMMETRIC:
				setIsSymmetric(IS_SYMMETRIC_EDEFAULT);
				return;
			case EODMImplPackage.INTERNAL_CORE__IS_TRANSITIVE:
				setIsTransitive(IS_TRANSITIVE_EDEFAULT);
				return;
			case EODMImplPackage.INTERNAL_CORE__OW_LINVERSE_OF:
				getOWLinverseOf().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__STATEMENT:
				getStatement().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__LOCAL_NAME:
				getLocalName().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__XML_BASE:
				getXmlBase().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__NAMESPACE_DEFINITION:
				getNamespaceDefinition().clear();
				return;
			// added by EODM
			case EODMImplPackage.INTERNAL_CORE__TYPED_RESOURCE:
				getTypedResource().clear();
				return;
			case EODMImplPackage.INTERNAL_CORE__COMPLEMENT_CLASS:
				getComplementClass().clear();
				return ;
			case EODMImplPackage.INTERNAL_CORE__INTERSECTION_CLASS:
				getIntersectionClass().clear();
				return ;
			case EODMImplPackage.INTERNAL_CORE__UNION_CLASS:
				getUnionClass().clear();
				return ;
			case EODMImplPackage.INTERNAL_CORE__DISJOINT_CLASS:
				getDisjointClass().clear();
				return ;
			case EODMImplPackage.INTERNAL_CORE__EQUIVALENT_CLASS:
				getEquivalentClass().clear();
				return ;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case EODMImplPackage.INTERNAL_CORE__RDF_SIS_DEFINED_BY:
				return rdfSisDefinedBy != null && !rdfSisDefinedBy.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__RDF_SSEE_ALSO:
				return rdfSseeAlso != null && !rdfSseeAlso.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__RD_FTYPE:
				return rdFtype != null && !rdFtype.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__RDF_SMEMBER:
				return rdfSmember != null && !rdfSmember.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__NODE_ID:
				return NODE_ID_EDEFAULT == null ? nodeID != null : !NODE_ID_EDEFAULT.equals(nodeID);
			case EODMImplPackage.INTERNAL_CORE__RDF_SCOMMENT:
				return rdfScomment != null && !rdfScomment.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__RDF_SLABEL:
				return rdfSlabel != null && !rdfSlabel.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__URI_REF:
				return uriRef != null && !uriRef.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__SUBJECT_STATEMENT:
				return subjectStatement != null && !subjectStatement.isEmpty();
//			case EODMImplPackage.INTERNAL_CORE__LEXICAL_FORM:
//				return LEXICAL_FORM_EDEFAULT == null ? lexicalForm != null : !LEXICAL_FORM_EDEFAULT.equals(lexicalForm);
//			case EODMImplPackage.INTERNAL_CORE__LANGUAGE:
//				return LANGUAGE_EDEFAULT == null ? language != null : !LANGUAGE_EDEFAULT.equals(language);
			case EODMImplPackage.INTERNAL_CORE__RDF_SSUB_CLASS_OF:
				return rdfSsubClassOf != null && !rdfSsubClassOf.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__SUB_CLASS:
				return subClass != null && !subClass.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__PROPERTY_FOR_DOMAIN:
				return propertyForDomain != null && !propertyForDomain.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__PROPERTY_FOR_RANGE:
				return propertyForRange != null && !propertyForRange.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__ONTOLOGY:
				return ontology != null;
			case EODMImplPackage.INTERNAL_CORE__IS_DEPRECATED:
				return isDeprecated != IS_DEPRECATED_EDEFAULT;
			case EODMImplPackage.INTERNAL_CORE__IS_CLASS_KIND:
				return isClassKind != null;
			case EODMImplPackage.INTERNAL_CORE__HAS_RESTRICTION_KIND:
				return hasRestrictionKind != null;
			case EODMImplPackage.INTERNAL_CORE__OW_LEQUIVALENT_CLASS:
				return owLequivalentClass != null && !owLequivalentClass.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__OW_LDISJOINT_WITH:
				return owLdisjointWith != null && !owLdisjointWith.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__OW_LCOMPLEMENT_OF:
				return owLcomplementOf != null;
//			case EODMImplPackage.INTERNAL_CORE__DATATYPE_URI:
//				return datatypeURI != null;
			case EODMImplPackage.INTERNAL_CORE__OW_LDISTINCT_MEMBERS:
				return owLdistinctMembers != null && !owLdistinctMembers.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__OW_LON_PROPERTY:
				return owLonProperty != null;
			case EODMImplPackage.INTERNAL_CORE__OW_LCARDINALITY:
				return owLcardinality != null;
			case EODMImplPackage.INTERNAL_CORE__OW_LMIN_CARDINALITY:
				return owLminCardinality != null;
			case EODMImplPackage.INTERNAL_CORE__SOME_VALUES_FROM_CLASS:
				return someValuesFromClass != null;
			case EODMImplPackage.INTERNAL_CORE__SOME_VALUES_FROM_DATA_RANGE:
				return someValuesFromDataRange != null;
			case EODMImplPackage.INTERNAL_CORE__OW_LDIFFERENT_FROM:
				return owLdifferentFrom != null && !owLdifferentFrom.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__OW_LSAME_AS:
				return owLsameAs != null && !owLsameAs.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__RD_FFIRST:
				return rdFfirst != null;
			case EODMImplPackage.INTERNAL_CORE__RD_FREST:
				return rdFrest != null;
			case EODMImplPackage.INTERNAL_CORE__RDF_SDOMAIN:
				return rdfSdomain != null && !rdfSdomain.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__RDF_SRANGE:
				return rdfSrange != null && !rdfSrange.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__RDF_SSUB_PROPERTY_OF:
				return rdfSsubPropertyOf != null && !rdfSsubPropertyOf.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__SUB_PROPERTY:
				return subProperty != null && !subProperty.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__IS_PROPERTY_DEPRECATED:
				return isPropertyDeprecated != IS_PROPERTY_DEPRECATED_EDEFAULT;
			case EODMImplPackage.INTERNAL_CORE__IS_FUNCTIONAL:
				return isFunctional != IS_FUNCTIONAL_EDEFAULT;
			case EODMImplPackage.INTERNAL_CORE__IS_OBJECT_PROPERTY:
				return isObjectProperty != IS_OBJECT_PROPERTY_EDEFAULT;
			case EODMImplPackage.INTERNAL_CORE__IS_DATATYPE_PROPERTY:
				return isDatatypeProperty != IS_DATATYPE_PROPERTY_EDEFAULT;
			case EODMImplPackage.INTERNAL_CORE__OW_LEQUIVALENT_PROPERTY:
				return owLequivalentProperty != null && !owLequivalentProperty.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__OW_LBACKWARD_COMPATIBLE_WITH:
				return owLbackwardCompatibleWith != null && !owLbackwardCompatibleWith.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__OW_LIMPORTS:
				return owLimports != null && !owLimports.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__OW_LVERSION_INFO:
				return owLversionInfo != null && !owLversionInfo.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__OW_LPRIOR_VERSION:
				return owLpriorVersion != null && !owLpriorVersion.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__OW_LINCOMPATIBLE_WITH:
				return owLincompatibleWith != null && !owLincompatibleWith.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__OWL_GRAPH:
				return owlGraph != null && !owlGraph.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__OWL_STATEMENT:
				return owlStatement != null && !owlStatement.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__OWL_UNIVERSE:
				return owlUniverse != null;
			case EODMImplPackage.INTERNAL_CORE__GRAPHSTATEMENT:
				return graphstatement != null && !graphstatement.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__GRAPH_NAME:
				return graphName != null;
			case EODMImplPackage.INTERNAL_CORE__GRAPHONTOLOGY:
				return graphontology != null && !graphontology.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__OWL_GRAPH_STATEMENT:
				return owlGraphStatement != null && !owlGraphStatement.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__HAS_INDIVIDUAL_VALUE:
				return hasIndividualValue != null;
			case EODMImplPackage.INTERNAL_CORE__HAS_LITERAL_VALUE:
				return hasLiteralValue != null;
			case EODMImplPackage.INTERNAL_CORE__ALL_VALUES_FROM_CLASS:
				return allValuesFromClass != null;
			case EODMImplPackage.INTERNAL_CORE__ALL_VALUES_FROM_DATA_RANGE:
				return allValuesFromDataRange != null;
			case EODMImplPackage.INTERNAL_CORE__OW_LMAX_CARDINALITY:
				return owLmaxCardinality != null;
			case EODMImplPackage.INTERNAL_CORE__OW_LINTERSECTION_OF:
				return owLintersectionOf != null && !owLintersectionOf.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__OW_LONE_OF:
				return owLoneOf != null && !owLoneOf.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__OW_LUNION_OF:
				return owLunionOf != null && !owLunionOf.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__OWL_DATA_RANGEONE_OF:
				return owlDataRangeoneOf != null && !owlDataRangeoneOf.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__DATATYPE:
				return datatype != null;
			case EODMImplPackage.INTERNAL_CORE__DOCUMENT:
				return document != null && !document.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__IS_REIFIED_ONLY:
				return isReifiedOnly != IS_REIFIED_ONLY_EDEFAULT;
			case EODMImplPackage.INTERNAL_CORE__IS_REIFIED:
				return isReified != IS_REIFIED_EDEFAULT;
			case EODMImplPackage.INTERNAL_CORE__RD_FSUBJECT:
				return rdFsubject != null;
			case EODMImplPackage.INTERNAL_CORE__RD_FOBJECT:
				return rdFobject != null;
			case EODMImplPackage.INTERNAL_CORE__RD_FPREDICATE:
				return rdFpredicate != null;
			case EODMImplPackage.INTERNAL_CORE__NAME_FOR_REIFICATION:
				return nameForReification != null && !nameForReification.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__IS_INVERSE_FUNCTIONAL:
				return isInverseFunctional != IS_INVERSE_FUNCTIONAL_EDEFAULT;
			case EODMImplPackage.INTERNAL_CORE__IS_SYMMETRIC:
				return isSymmetric != IS_SYMMETRIC_EDEFAULT;
			case EODMImplPackage.INTERNAL_CORE__IS_TRANSITIVE:
				return isTransitive != IS_TRANSITIVE_EDEFAULT;
			case EODMImplPackage.INTERNAL_CORE__OW_LINVERSE_OF:
				return owLinverseOf != null && !owLinverseOf.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__STATEMENT:
				return statement != null && !statement.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__LOCAL_NAME:
				return localName != null && !localName.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__XML_BASE:
				return xmlBase != null && !xmlBase.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__NAMESPACE_DEFINITION:
				return namespaceDefinition != null && !namespaceDefinition.isEmpty();
			// added by EODM
			case EODMImplPackage.INTERNAL_CORE__TYPED_RESOURCE:
				return typedResource != null && !typedResource.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__COMPLEMENT_CLASS:
				return complementClass != null && !complementClass.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__INTERSECTION_CLASS:
				return intersectionClass != null && !intersectionClass.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__UNION_CLASS:
				return unionClass != null && !unionClass.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__DISJOINT_CLASS:
				return disjointClass != null && !disjointClass.isEmpty();
			case EODMImplPackage.INTERNAL_CORE__EQUIVALENT_CLASS:
				return equivalentClass != null && !equivalentClass.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class baseClass) {
//		if (baseClass == RDFSLiteral.class) {
//			switch (derivedFeatureID) {
//				case EODMImplPackage.INTERNAL_CORE__LEXICAL_FORM: return RDFBasePackage.RDFS_LITERAL__LEXICAL_FORM;
//				default: return -1;
//			}
//		}
//		if (baseClass == PlainLiteral.class) {
//			switch (derivedFeatureID) {
//				case EODMImplPackage.INTERNAL_CORE__LANGUAGE: return RDFBasePackage.PLAIN_LITERAL__LANGUAGE;
//				default: return -1;
//			}
//		}
		if (baseClass == RDFSClass.class) {
			switch (derivedFeatureID) {
				case EODMImplPackage.INTERNAL_CORE__RDF_SSUB_CLASS_OF: return RDFSPackage.RDFS_CLASS__RDF_SSUB_CLASS_OF;
				case EODMImplPackage.INTERNAL_CORE__SUB_CLASS: return RDFSPackage.RDFS_CLASS__SUB_CLASS;
				case EODMImplPackage.INTERNAL_CORE__PROPERTY_FOR_DOMAIN: return RDFSPackage.RDFS_CLASS__PROPERTY_FOR_DOMAIN;
				case EODMImplPackage.INTERNAL_CORE__PROPERTY_FOR_RANGE: return RDFSPackage.RDFS_CLASS__PROPERTY_FOR_RANGE;
				case EODMImplPackage.INTERNAL_CORE__TYPED_RESOURCE: return RDFSPackage.RDFS_CLASS__TYPED_RESOURCE;
				default: return -1;
			}
		}
		if (baseClass == Universe.class) {
			switch (derivedFeatureID) {
				case EODMImplPackage.INTERNAL_CORE__ONTOLOGY: return OWLBasePackage.UNIVERSE__ONTOLOGY;
				default: return -1;
			}
		}
		if (baseClass == OWLClass.class) {
			switch (derivedFeatureID) {
				case EODMImplPackage.INTERNAL_CORE__IS_DEPRECATED: return OWLBasePackage.OWL_CLASS__IS_DEPRECATED;
				case EODMImplPackage.INTERNAL_CORE__IS_CLASS_KIND: return OWLBasePackage.OWL_CLASS__IS_CLASS_KIND;
				case EODMImplPackage.INTERNAL_CORE__HAS_RESTRICTION_KIND: return OWLBasePackage.OWL_CLASS__HAS_RESTRICTION_KIND;
				case EODMImplPackage.INTERNAL_CORE__OW_LEQUIVALENT_CLASS: return OWLBasePackage.OWL_CLASS__OWL_EQUIVALENT_CLASS;
				case EODMImplPackage.INTERNAL_CORE__OW_LDISJOINT_WITH: return OWLBasePackage.OWL_CLASS__OW_LDISJOINT_WITH;
				// added features
				case EODMImplPackage.INTERNAL_CORE__COMPLEMENT_CLASS: return OWLBasePackage.OWL_CLASS__COMPLEMENT_CLASS;
				case EODMImplPackage.INTERNAL_CORE__INTERSECTION_CLASS: return OWLBasePackage.OWL_CLASS__INTERSECTION_CLASS;
				case EODMImplPackage.INTERNAL_CORE__UNION_CLASS: return OWLBasePackage.OWL_CLASS__UNION_CLASS;
				case EODMImplPackage.INTERNAL_CORE__DISJOINT_CLASS: return OWLBasePackage.OWL_CLASS__DISJOINT_CLASS;
				case EODMImplPackage.INTERNAL_CORE__EQUIVALENT_CLASS: return OWLBasePackage.OWL_CLASS__EQUIVALENT_CLASS;
				default: return -1;
			}
		}
		if (baseClass == ComplementClass.class) {
			switch (derivedFeatureID) {
				case EODMImplPackage.INTERNAL_CORE__OW_LCOMPLEMENT_OF: return OWLBasePackage.COMPLEMENT_CLASS__OW_LCOMPLEMENT_OF;
				default: return -1;
			}
		}
//		if (baseClass == TypedLiteral.class) {
//			switch (derivedFeatureID) {
//				case EODMImplPackage.INTERNAL_CORE__DATATYPE_URI: return RDFBasePackage.TYPED_LITERAL__DATATYPE_URI;
//				default: return -1;
//			}
//		}
//		if (baseClass == RDFXMLLiteral.class) {
//			switch (derivedFeatureID) {
//				default: return -1;
//			}
//		}
		if (baseClass == OWLAllDifferent.class) {
			switch (derivedFeatureID) {
				case EODMImplPackage.INTERNAL_CORE__OW_LDISTINCT_MEMBERS: return OWLBasePackage.OWL_ALL_DIFFERENT__OW_LDISTINCT_MEMBERS;
				default: return -1;
			}
		}
		if (baseClass == OWLRestriction.class) {
			switch (derivedFeatureID) {
				case EODMImplPackage.INTERNAL_CORE__OW_LON_PROPERTY: return OWLBasePackage.OWL_RESTRICTION__OW_LON_PROPERTY;
				default: return -1;
			}
		}
		if (baseClass == CardinalityRestriction.class) {
			switch (derivedFeatureID) {
				case EODMImplPackage.INTERNAL_CORE__OW_LCARDINALITY: return OWLBasePackage.CARDINALITY_RESTRICTION__OW_LCARDINALITY;
				default: return -1;
			}
		}
		if (baseClass == MinCardinalityRestriction.class) {
			switch (derivedFeatureID) {
				case EODMImplPackage.INTERNAL_CORE__OW_LMIN_CARDINALITY: return OWLBasePackage.MIN_CARDINALITY_RESTRICTION__OW_LMIN_CARDINALITY;
				default: return -1;
			}
		}
		if (baseClass == SomeValuesFromRestriction.class) {
			switch (derivedFeatureID) {
				case EODMImplPackage.INTERNAL_CORE__SOME_VALUES_FROM_CLASS: return OWLBasePackage.SOME_VALUES_FROM_RESTRICTION__SOME_VALUES_FROM_CLASS;
				case EODMImplPackage.INTERNAL_CORE__SOME_VALUES_FROM_DATA_RANGE: return OWLBasePackage.SOME_VALUES_FROM_RESTRICTION__SOME_VALUES_FROM_DATA_RANGE;
				default: return -1;
			}
		}
		if (baseClass == Individual.class) {
			switch (derivedFeatureID) {
				case EODMImplPackage.INTERNAL_CORE__OW_LDIFFERENT_FROM: return OWLBasePackage.INDIVIDUAL__OW_LDIFFERENT_FROM;
				case EODMImplPackage.INTERNAL_CORE__OW_LSAME_AS: return OWLBasePackage.INDIVIDUAL__OW_LSAME_AS;
				default: return -1;
			}
		}
		if (baseClass == RDFSContainer.class) {
			switch (derivedFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == RDFAlt.class) {
			switch (derivedFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == RDFSeq.class) {
			switch (derivedFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == RDFList.class) {
			switch (derivedFeatureID) {
				case EODMImplPackage.INTERNAL_CORE__RD_FFIRST: return RDFSPackage.RDF_LIST__RD_FFIRST;
				case EODMImplPackage.INTERNAL_CORE__RD_FREST: return RDFSPackage.RDF_LIST__RD_FREST;
				default: return -1;
			}
		}
		if (baseClass == RDFProperty.class) {
			switch (derivedFeatureID) {
				case EODMImplPackage.INTERNAL_CORE__RDF_SDOMAIN: return RDFBasePackage.RDF_PROPERTY__RDF_SDOMAIN;
				case EODMImplPackage.INTERNAL_CORE__RDF_SRANGE: return RDFBasePackage.RDF_PROPERTY__RDF_SRANGE;
				case EODMImplPackage.INTERNAL_CORE__RDF_SSUB_PROPERTY_OF: return RDFBasePackage.RDF_PROPERTY__RDF_SSUB_PROPERTY_OF;
				case EODMImplPackage.INTERNAL_CORE__SUB_PROPERTY: return RDFBasePackage.RDF_PROPERTY__SUB_PROPERTY;
				default: return -1;
			}
		}
		if (baseClass == OWLAnnotationProperty.class) {
			switch (derivedFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == Property.class) {
			switch (derivedFeatureID) {
				case EODMImplPackage.INTERNAL_CORE__IS_PROPERTY_DEPRECATED: return OWLBasePackage.PROPERTY__IS_PROPERTY_DEPRECATED;
				case EODMImplPackage.INTERNAL_CORE__IS_FUNCTIONAL: return OWLBasePackage.PROPERTY__IS_FUNCTIONAL;
				case EODMImplPackage.INTERNAL_CORE__IS_OBJECT_PROPERTY: return OWLBasePackage.PROPERTY__IS_OBJECT_PROPERTY;
				case EODMImplPackage.INTERNAL_CORE__IS_DATATYPE_PROPERTY: return OWLBasePackage.PROPERTY__IS_DATATYPE_PROPERTY;
				case EODMImplPackage.INTERNAL_CORE__OW_LEQUIVALENT_PROPERTY: return OWLBasePackage.PROPERTY__OW_LEQUIVALENT_PROPERTY;
				default: return -1;
			}
		}
		if (baseClass == OWLDatatypeProperty.class) {
			switch (derivedFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == OWLOntology.class) {
			switch (derivedFeatureID) {
				case EODMImplPackage.INTERNAL_CORE__OW_LBACKWARD_COMPATIBLE_WITH: return OWLBasePackage.OWL_ONTOLOGY__OW_LBACKWARD_COMPATIBLE_WITH;
				case EODMImplPackage.INTERNAL_CORE__OW_LIMPORTS: return OWLBasePackage.OWL_ONTOLOGY__OW_LIMPORTS;
				case EODMImplPackage.INTERNAL_CORE__OW_LVERSION_INFO: return OWLBasePackage.OWL_ONTOLOGY__OW_LVERSION_INFO;
				case EODMImplPackage.INTERNAL_CORE__OW_LPRIOR_VERSION: return OWLBasePackage.OWL_ONTOLOGY__OW_LPRIOR_VERSION;
				case EODMImplPackage.INTERNAL_CORE__OW_LINCOMPATIBLE_WITH: return OWLBasePackage.OWL_ONTOLOGY__OW_LINCOMPATIBLE_WITH;
				case EODMImplPackage.INTERNAL_CORE__OWL_GRAPH: return OWLBasePackage.OWL_ONTOLOGY__OWL_GRAPH;
				case EODMImplPackage.INTERNAL_CORE__OWL_STATEMENT: return OWLBasePackage.OWL_ONTOLOGY__OWL_STATEMENT;
				case EODMImplPackage.INTERNAL_CORE__OWL_UNIVERSE: return OWLBasePackage.OWL_ONTOLOGY__OWL_UNIVERSE;
				default: return -1;
			}
		}
		if (baseClass == RDFGraph.class) {
			switch (derivedFeatureID) {
				case EODMImplPackage.INTERNAL_CORE__GRAPHSTATEMENT: return RDFBasePackage.RDF_GRAPH__GRAPHSTATEMENT;
				case EODMImplPackage.INTERNAL_CORE__GRAPH_NAME: return RDFBasePackage.RDF_GRAPH__GRAPH_NAME;
				default: return -1;
			}
		}
		if (baseClass == OWLGraph.class) {
			switch (derivedFeatureID) {
				case EODMImplPackage.INTERNAL_CORE__GRAPHONTOLOGY: return OWLBasePackage.OWL_GRAPH__GRAPHONTOLOGY;
				case EODMImplPackage.INTERNAL_CORE__OWL_GRAPH_STATEMENT: return OWLBasePackage.OWL_GRAPH__OWL_GRAPH_STATEMENT;
				default: return -1;
			}
		}
		if (baseClass == HasValueRestriction.class) {
			switch (derivedFeatureID) {
				case EODMImplPackage.INTERNAL_CORE__HAS_INDIVIDUAL_VALUE: return OWLBasePackage.HAS_VALUE_RESTRICTION__HAS_INDIVIDUAL_VALUE;
				case EODMImplPackage.INTERNAL_CORE__HAS_LITERAL_VALUE: return OWLBasePackage.HAS_VALUE_RESTRICTION__HAS_LITERAL_VALUE;
				default: return -1;
			}
		}
		if (baseClass == AllValuesFromRestriction.class) {
			switch (derivedFeatureID) {
				case EODMImplPackage.INTERNAL_CORE__ALL_VALUES_FROM_CLASS: return OWLBasePackage.ALL_VALUES_FROM_RESTRICTION__ALL_VALUES_FROM_CLASS;
				case EODMImplPackage.INTERNAL_CORE__ALL_VALUES_FROM_DATA_RANGE: return OWLBasePackage.ALL_VALUES_FROM_RESTRICTION__ALL_VALUES_FROM_DATA_RANGE;
				default: return -1;
			}
		}
		if (baseClass == MaxCardinalityRestriction.class) {
			switch (derivedFeatureID) {
				case EODMImplPackage.INTERNAL_CORE__OW_LMAX_CARDINALITY: return OWLBasePackage.MAX_CARDINALITY_RESTRICTION__OW_LMAX_CARDINALITY;
				default: return -1;
			}
		}
		if (baseClass == IntersectionClass.class) {
			switch (derivedFeatureID) {
				case EODMImplPackage.INTERNAL_CORE__OW_LINTERSECTION_OF: return OWLBasePackage.INTERSECTION_CLASS__OW_LINTERSECTION_OF;
				default: return -1;
			}
		}
		if (baseClass == EnumeratedClass.class) {
			switch (derivedFeatureID) {
				case EODMImplPackage.INTERNAL_CORE__OW_LONE_OF: return OWLBasePackage.ENUMERATED_CLASS__OW_LONE_OF;
				default: return -1;
			}
		}
		if (baseClass == UnionClass.class) {
			switch (derivedFeatureID) {
				case EODMImplPackage.INTERNAL_CORE__OW_LUNION_OF: return OWLBasePackage.UNION_CLASS__OW_LUNION_OF;
				default: return -1;
			}
		}
		if (baseClass == RDFSDatatype.class) {
			switch (derivedFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == OWLDataRange.class) {
			switch (derivedFeatureID) {
				case EODMImplPackage.INTERNAL_CORE__OWL_DATA_RANGEONE_OF: return OWLBasePackage.OWL_DATA_RANGE__OWL_DATA_RANGEONE_OF;
				case EODMImplPackage.INTERNAL_CORE__DATATYPE: return OWLBasePackage.OWL_DATA_RANGE__DATATYPE;
				default: return -1;
			}
		}
		if (baseClass == RDFStatement.class) {
			switch (derivedFeatureID) {
				case EODMImplPackage.INTERNAL_CORE__DOCUMENT: return RDFBasePackage.RDF_STATEMENT__DOCUMENT;
				case EODMImplPackage.INTERNAL_CORE__IS_REIFIED_ONLY: return RDFBasePackage.RDF_STATEMENT__IS_REIFIED_ONLY;
				case EODMImplPackage.INTERNAL_CORE__IS_REIFIED: return RDFBasePackage.RDF_STATEMENT__IS_REIFIED;
				case EODMImplPackage.INTERNAL_CORE__RD_FSUBJECT: return RDFBasePackage.RDF_STATEMENT__RD_FSUBJECT;
				case EODMImplPackage.INTERNAL_CORE__RD_FOBJECT: return RDFBasePackage.RDF_STATEMENT__RD_FOBJECT;
				case EODMImplPackage.INTERNAL_CORE__RD_FPREDICATE: return RDFBasePackage.RDF_STATEMENT__RD_FPREDICATE;
				case EODMImplPackage.INTERNAL_CORE__NAME_FOR_REIFICATION: return RDFBasePackage.RDF_STATEMENT__NAME_FOR_REIFICATION;
				default: return -1;
			}
		}
		if (baseClass == Statement.class) {
			switch (derivedFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == RDFBag.class) {
			switch (derivedFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == URIReferenceNode.class) {
			switch (derivedFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == OWLOntologyProperty.class) {
			switch (derivedFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == RDFSContainerMembershipProperty.class) {
			switch (derivedFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == OWLObjectProperty.class) {
			switch (derivedFeatureID) {
				case EODMImplPackage.INTERNAL_CORE__IS_INVERSE_FUNCTIONAL: return OWLBasePackage.OWL_OBJECT_PROPERTY__IS_INVERSE_FUNCTIONAL;
				case EODMImplPackage.INTERNAL_CORE__IS_SYMMETRIC: return OWLBasePackage.OWL_OBJECT_PROPERTY__IS_SYMMETRIC;
				case EODMImplPackage.INTERNAL_CORE__IS_TRANSITIVE: return OWLBasePackage.OWL_OBJECT_PROPERTY__IS_TRANSITIVE;
				case EODMImplPackage.INTERNAL_CORE__OW_LINVERSE_OF: return OWLBasePackage.OWL_OBJECT_PROPERTY__OW_LINVERSE_OF;
				default: return -1;
			}
		}
		if (baseClass == Document.class) {
			switch (derivedFeatureID) {
				case EODMImplPackage.INTERNAL_CORE__STATEMENT: return RDFWebPackage.DOCUMENT__STATEMENT;
				case EODMImplPackage.INTERNAL_CORE__LOCAL_NAME: return RDFWebPackage.DOCUMENT__LOCAL_NAME;
				case EODMImplPackage.INTERNAL_CORE__XML_BASE: return RDFWebPackage.DOCUMENT__XML_BASE;
				case EODMImplPackage.INTERNAL_CORE__NAMESPACE_DEFINITION: return RDFWebPackage.DOCUMENT__NAMESPACE_DEFINITION;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class baseClass) {
//		if (baseClass == RDFSLiteral.class) {
//			switch (baseFeatureID) {
//				case RDFBasePackage.RDFS_LITERAL__LEXICAL_FORM: return EODMImplPackage.INTERNAL_CORE__LEXICAL_FORM;
//				default: return -1;
//			}
//		}
//		if (baseClass == PlainLiteral.class) {
//			switch (baseFeatureID) {
//				case RDFBasePackage.PLAIN_LITERAL__LANGUAGE: return EODMImplPackage.INTERNAL_CORE__LANGUAGE;
//				default: return -1;
//			}
//		}
		if (baseClass == RDFSClass.class) {
			switch (baseFeatureID) {
				case RDFSPackage.RDFS_CLASS__RDF_SSUB_CLASS_OF: return EODMImplPackage.INTERNAL_CORE__RDF_SSUB_CLASS_OF;
				case RDFSPackage.RDFS_CLASS__SUB_CLASS: return EODMImplPackage.INTERNAL_CORE__SUB_CLASS;
				case RDFSPackage.RDFS_CLASS__PROPERTY_FOR_DOMAIN: return EODMImplPackage.INTERNAL_CORE__PROPERTY_FOR_DOMAIN;
				case RDFSPackage.RDFS_CLASS__PROPERTY_FOR_RANGE: return EODMImplPackage.INTERNAL_CORE__PROPERTY_FOR_RANGE;
				case RDFSPackage.RDFS_CLASS__TYPED_RESOURCE: return EODMImplPackage.INTERNAL_CORE__TYPED_RESOURCE;
				default: return -1;
			}
		}
		if (baseClass == Universe.class) {
			switch (baseFeatureID) {
				case OWLBasePackage.UNIVERSE__ONTOLOGY: return EODMImplPackage.INTERNAL_CORE__ONTOLOGY;
				default: return -1;
			}
		}
		if (baseClass == OWLClass.class) {
			switch (baseFeatureID) {
				case OWLBasePackage.OWL_CLASS__IS_DEPRECATED: return EODMImplPackage.INTERNAL_CORE__IS_DEPRECATED;
				case OWLBasePackage.OWL_CLASS__IS_CLASS_KIND: return EODMImplPackage.INTERNAL_CORE__IS_CLASS_KIND;
				case OWLBasePackage.OWL_CLASS__HAS_RESTRICTION_KIND: return EODMImplPackage.INTERNAL_CORE__HAS_RESTRICTION_KIND;
				case OWLBasePackage.OWL_CLASS__OWL_EQUIVALENT_CLASS: return EODMImplPackage.INTERNAL_CORE__OW_LEQUIVALENT_CLASS;
				case OWLBasePackage.OWL_CLASS__OW_LDISJOINT_WITH: return EODMImplPackage.INTERNAL_CORE__OW_LDISJOINT_WITH;
				// added features
				case OWLBasePackage.OWL_CLASS__COMPLEMENT_CLASS: return EODMImplPackage.INTERNAL_CORE__COMPLEMENT_CLASS;
				case OWLBasePackage.OWL_CLASS__INTERSECTION_CLASS: return EODMImplPackage.INTERNAL_CORE__INTERSECTION_CLASS;
				case OWLBasePackage.OWL_CLASS__UNION_CLASS: return EODMImplPackage.INTERNAL_CORE__UNION_CLASS;
				case OWLBasePackage.OWL_CLASS__DISJOINT_CLASS: return EODMImplPackage.INTERNAL_CORE__DISJOINT_CLASS;
				case OWLBasePackage.OWL_CLASS__EQUIVALENT_CLASS: return EODMImplPackage.INTERNAL_CORE__EQUIVALENT_CLASS;
				default: return -1;
			}
		}
		if (baseClass == ComplementClass.class) {
			switch (baseFeatureID) {
				case OWLBasePackage.COMPLEMENT_CLASS__OW_LCOMPLEMENT_OF: return EODMImplPackage.INTERNAL_CORE__OW_LCOMPLEMENT_OF;
				default: return -1;
			}
		}
//		if (baseClass == TypedLiteral.class) {
//			switch (baseFeatureID) {
//				case RDFBasePackage.TYPED_LITERAL__DATATYPE_URI: return EODMImplPackage.INTERNAL_CORE__DATATYPE_URI;
//				default: return -1;
//			}
//		}
//		if (baseClass == RDFXMLLiteral.class) {
//			switch (baseFeatureID) {
//				default: return -1;
//			}
//		}
		if (baseClass == OWLAllDifferent.class) {
			switch (baseFeatureID) {
				case OWLBasePackage.OWL_ALL_DIFFERENT__OW_LDISTINCT_MEMBERS: return EODMImplPackage.INTERNAL_CORE__OW_LDISTINCT_MEMBERS;
				default: return -1;
			}
		}
		if (baseClass == OWLRestriction.class) {
			switch (baseFeatureID) {
				case OWLBasePackage.OWL_RESTRICTION__OW_LON_PROPERTY: return EODMImplPackage.INTERNAL_CORE__OW_LON_PROPERTY;
				default: return -1;
			}
		}
		if (baseClass == CardinalityRestriction.class) {
			switch (baseFeatureID) {
				case OWLBasePackage.CARDINALITY_RESTRICTION__OW_LCARDINALITY: return EODMImplPackage.INTERNAL_CORE__OW_LCARDINALITY;
				default: return -1;
			}
		}
		if (baseClass == MinCardinalityRestriction.class) {
			switch (baseFeatureID) {
				case OWLBasePackage.MIN_CARDINALITY_RESTRICTION__OW_LMIN_CARDINALITY: return EODMImplPackage.INTERNAL_CORE__OW_LMIN_CARDINALITY;
				default: return -1;
			}
		}
		if (baseClass == SomeValuesFromRestriction.class) {
			switch (baseFeatureID) {
				case OWLBasePackage.SOME_VALUES_FROM_RESTRICTION__SOME_VALUES_FROM_CLASS: return EODMImplPackage.INTERNAL_CORE__SOME_VALUES_FROM_CLASS;
				case OWLBasePackage.SOME_VALUES_FROM_RESTRICTION__SOME_VALUES_FROM_DATA_RANGE: return EODMImplPackage.INTERNAL_CORE__SOME_VALUES_FROM_DATA_RANGE;
				default: return -1;
			}
		}
		if (baseClass == Individual.class) {
			switch (baseFeatureID) {
				case OWLBasePackage.INDIVIDUAL__OW_LDIFFERENT_FROM: return EODMImplPackage.INTERNAL_CORE__OW_LDIFFERENT_FROM;
				case OWLBasePackage.INDIVIDUAL__OW_LSAME_AS: return EODMImplPackage.INTERNAL_CORE__OW_LSAME_AS;
				default: return -1;
			}
		}
		if (baseClass == RDFSContainer.class) {
			switch (baseFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == RDFAlt.class) {
			switch (baseFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == RDFSeq.class) {
			switch (baseFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == RDFList.class) {
			switch (baseFeatureID) {
				case RDFSPackage.RDF_LIST__RD_FFIRST: return EODMImplPackage.INTERNAL_CORE__RD_FFIRST;
				case RDFSPackage.RDF_LIST__RD_FREST: return EODMImplPackage.INTERNAL_CORE__RD_FREST;
				default: return -1;
			}
		}
		if (baseClass == RDFProperty.class) {
			switch (baseFeatureID) {
				case RDFBasePackage.RDF_PROPERTY__RDF_SDOMAIN: return EODMImplPackage.INTERNAL_CORE__RDF_SDOMAIN;
				case RDFBasePackage.RDF_PROPERTY__RDF_SRANGE: return EODMImplPackage.INTERNAL_CORE__RDF_SRANGE;
				case RDFBasePackage.RDF_PROPERTY__RDF_SSUB_PROPERTY_OF: return EODMImplPackage.INTERNAL_CORE__RDF_SSUB_PROPERTY_OF;
				case RDFBasePackage.RDF_PROPERTY__SUB_PROPERTY: return EODMImplPackage.INTERNAL_CORE__SUB_PROPERTY;
				default: return -1;
			}
		}
		if (baseClass == OWLAnnotationProperty.class) {
			switch (baseFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == Property.class) {
			switch (baseFeatureID) {
				case OWLBasePackage.PROPERTY__IS_PROPERTY_DEPRECATED: return EODMImplPackage.INTERNAL_CORE__IS_PROPERTY_DEPRECATED;
				case OWLBasePackage.PROPERTY__IS_FUNCTIONAL: return EODMImplPackage.INTERNAL_CORE__IS_FUNCTIONAL;
				case OWLBasePackage.PROPERTY__IS_OBJECT_PROPERTY: return EODMImplPackage.INTERNAL_CORE__IS_OBJECT_PROPERTY;
				case OWLBasePackage.PROPERTY__IS_DATATYPE_PROPERTY: return EODMImplPackage.INTERNAL_CORE__IS_DATATYPE_PROPERTY;
				case OWLBasePackage.PROPERTY__OW_LEQUIVALENT_PROPERTY: return EODMImplPackage.INTERNAL_CORE__OW_LEQUIVALENT_PROPERTY;
				default: return -1;
			}
		}
		if (baseClass == OWLDatatypeProperty.class) {
			switch (baseFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == OWLOntology.class) {
			switch (baseFeatureID) {
				case OWLBasePackage.OWL_ONTOLOGY__OW_LBACKWARD_COMPATIBLE_WITH: return EODMImplPackage.INTERNAL_CORE__OW_LBACKWARD_COMPATIBLE_WITH;
				case OWLBasePackage.OWL_ONTOLOGY__OW_LIMPORTS: return EODMImplPackage.INTERNAL_CORE__OW_LIMPORTS;
				case OWLBasePackage.OWL_ONTOLOGY__OW_LVERSION_INFO: return EODMImplPackage.INTERNAL_CORE__OW_LVERSION_INFO;
				case OWLBasePackage.OWL_ONTOLOGY__OW_LPRIOR_VERSION: return EODMImplPackage.INTERNAL_CORE__OW_LPRIOR_VERSION;
				case OWLBasePackage.OWL_ONTOLOGY__OW_LINCOMPATIBLE_WITH: return EODMImplPackage.INTERNAL_CORE__OW_LINCOMPATIBLE_WITH;
				case OWLBasePackage.OWL_ONTOLOGY__OWL_GRAPH: return EODMImplPackage.INTERNAL_CORE__OWL_GRAPH;
				case OWLBasePackage.OWL_ONTOLOGY__OWL_STATEMENT: return EODMImplPackage.INTERNAL_CORE__OWL_STATEMENT;
				case OWLBasePackage.OWL_ONTOLOGY__OWL_UNIVERSE: return EODMImplPackage.INTERNAL_CORE__OWL_UNIVERSE;
				default: return -1;
			}
		}
		if (baseClass == RDFGraph.class) {
			switch (baseFeatureID) {
				case RDFBasePackage.RDF_GRAPH__GRAPHSTATEMENT: return EODMImplPackage.INTERNAL_CORE__GRAPHSTATEMENT;
				case RDFBasePackage.RDF_GRAPH__GRAPH_NAME: return EODMImplPackage.INTERNAL_CORE__GRAPH_NAME;
				default: return -1;
			}
		}
		if (baseClass == OWLGraph.class) {
			switch (baseFeatureID) {
				case OWLBasePackage.OWL_GRAPH__GRAPHONTOLOGY: return EODMImplPackage.INTERNAL_CORE__GRAPHONTOLOGY;
				case OWLBasePackage.OWL_GRAPH__OWL_GRAPH_STATEMENT: return EODMImplPackage.INTERNAL_CORE__OWL_GRAPH_STATEMENT;
				default: return -1;
			}
		}
		if (baseClass == HasValueRestriction.class) {
			switch (baseFeatureID) {
				case OWLBasePackage.HAS_VALUE_RESTRICTION__HAS_INDIVIDUAL_VALUE: return EODMImplPackage.INTERNAL_CORE__HAS_INDIVIDUAL_VALUE;
				case OWLBasePackage.HAS_VALUE_RESTRICTION__HAS_LITERAL_VALUE: return EODMImplPackage.INTERNAL_CORE__HAS_LITERAL_VALUE;
				default: return -1;
			}
		}
		if (baseClass == AllValuesFromRestriction.class) {
			switch (baseFeatureID) {
				case OWLBasePackage.ALL_VALUES_FROM_RESTRICTION__ALL_VALUES_FROM_CLASS: return EODMImplPackage.INTERNAL_CORE__ALL_VALUES_FROM_CLASS;
				case OWLBasePackage.ALL_VALUES_FROM_RESTRICTION__ALL_VALUES_FROM_DATA_RANGE: return EODMImplPackage.INTERNAL_CORE__ALL_VALUES_FROM_DATA_RANGE;
				default: return -1;
			}
		}
		if (baseClass == MaxCardinalityRestriction.class) {
			switch (baseFeatureID) {
				case OWLBasePackage.MAX_CARDINALITY_RESTRICTION__OW_LMAX_CARDINALITY: return EODMImplPackage.INTERNAL_CORE__OW_LMAX_CARDINALITY;
				default: return -1;
			}
		}
		if (baseClass == IntersectionClass.class) {
			switch (baseFeatureID) {
				case OWLBasePackage.INTERSECTION_CLASS__OW_LINTERSECTION_OF: return EODMImplPackage.INTERNAL_CORE__OW_LINTERSECTION_OF;
				default: return -1;
			}
		}
		if (baseClass == EnumeratedClass.class) {
			switch (baseFeatureID) {
				case OWLBasePackage.ENUMERATED_CLASS__OW_LONE_OF: return EODMImplPackage.INTERNAL_CORE__OW_LONE_OF;
				default: return -1;
			}
		}
		if (baseClass == UnionClass.class) {
			switch (baseFeatureID) {
				case OWLBasePackage.UNION_CLASS__OW_LUNION_OF: return EODMImplPackage.INTERNAL_CORE__OW_LUNION_OF;
				default: return -1;
			}
		}
		if (baseClass == RDFSDatatype.class) {
			switch (baseFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == OWLDataRange.class) {
			switch (baseFeatureID) {
				case OWLBasePackage.OWL_DATA_RANGE__OWL_DATA_RANGEONE_OF: return EODMImplPackage.INTERNAL_CORE__OWL_DATA_RANGEONE_OF;
				case OWLBasePackage.OWL_DATA_RANGE__DATATYPE: return EODMImplPackage.INTERNAL_CORE__DATATYPE;
				default: return -1;
			}
		}
		if (baseClass == RDFStatement.class) {
			switch (baseFeatureID) {
				case RDFBasePackage.RDF_STATEMENT__DOCUMENT: return EODMImplPackage.INTERNAL_CORE__DOCUMENT;
				case RDFBasePackage.RDF_STATEMENT__IS_REIFIED_ONLY: return EODMImplPackage.INTERNAL_CORE__IS_REIFIED_ONLY;
				case RDFBasePackage.RDF_STATEMENT__IS_REIFIED: return EODMImplPackage.INTERNAL_CORE__IS_REIFIED;
				case RDFBasePackage.RDF_STATEMENT__RD_FSUBJECT: return EODMImplPackage.INTERNAL_CORE__RD_FSUBJECT;
				case RDFBasePackage.RDF_STATEMENT__RD_FOBJECT: return EODMImplPackage.INTERNAL_CORE__RD_FOBJECT;
				case RDFBasePackage.RDF_STATEMENT__RD_FPREDICATE: return EODMImplPackage.INTERNAL_CORE__RD_FPREDICATE;
				case RDFBasePackage.RDF_STATEMENT__NAME_FOR_REIFICATION: return EODMImplPackage.INTERNAL_CORE__NAME_FOR_REIFICATION;
				default: return -1;
			}
		}
		if (baseClass == Statement.class) {
			switch (baseFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == RDFBag.class) {
			switch (baseFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == URIReferenceNode.class) {
			switch (baseFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == OWLOntologyProperty.class) {
			switch (baseFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == RDFSContainerMembershipProperty.class) {
			switch (baseFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == OWLObjectProperty.class) {
			switch (baseFeatureID) {
				case OWLBasePackage.OWL_OBJECT_PROPERTY__IS_INVERSE_FUNCTIONAL: return EODMImplPackage.INTERNAL_CORE__IS_INVERSE_FUNCTIONAL;
				case OWLBasePackage.OWL_OBJECT_PROPERTY__IS_SYMMETRIC: return EODMImplPackage.INTERNAL_CORE__IS_SYMMETRIC;
				case OWLBasePackage.OWL_OBJECT_PROPERTY__IS_TRANSITIVE: return EODMImplPackage.INTERNAL_CORE__IS_TRANSITIVE;
				case OWLBasePackage.OWL_OBJECT_PROPERTY__OW_LINVERSE_OF: return EODMImplPackage.INTERNAL_CORE__OW_LINVERSE_OF;
				default: return -1;
			}
		}
		if (baseClass == Document.class) {
			switch (baseFeatureID) {
				case RDFWebPackage.DOCUMENT__STATEMENT: return EODMImplPackage.INTERNAL_CORE__STATEMENT;
				case RDFWebPackage.DOCUMENT__LOCAL_NAME: return EODMImplPackage.INTERNAL_CORE__LOCAL_NAME;
				case RDFWebPackage.DOCUMENT__XML_BASE: return EODMImplPackage.INTERNAL_CORE__XML_BASE;
				case RDFWebPackage.DOCUMENT__NAMESPACE_DEFINITION: return EODMImplPackage.INTERNAL_CORE__NAMESPACE_DEFINITION;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
//		result.append(" (lexicalForm: ");
//		result.append(lexicalForm);
//		result.append(", language: ");
//		result.append(language);
		result.append(" (isDeprecated: ");
		result.append(isDeprecated);
		result.append(", isPropertyDeprecated: ");
		result.append(isPropertyDeprecated);
		result.append(", isFunctional: ");
		result.append(isFunctional);
		result.append(", isObjectProperty: ");
		result.append(isObjectProperty);
		result.append(", isDatatypeProperty: ");
		result.append(isDatatypeProperty);
		result.append(", isReifiedOnly: ");
		result.append(isReifiedOnly);
		result.append(", isReified: ");
		result.append(isReified);
		result.append(", isInverseFunctional: ");
		result.append(isInverseFunctional);
		result.append(", isSymmetric: ");
		result.append(isSymmetric);
		result.append(", isTransitive: ");
		result.append(isTransitive);
		result.append(')');
		return result.toString();
	}


} //InternalCoreImpl
