/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: RDFSPackageImpl.java,v 1.1 2007/03/18 08:10:11 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfs.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;


import org.eclipse.eodm.impl.EODMImplPackage;
import org.eclipse.eodm.impl.EODMImplPackageImpl;
import org.eclipse.eodm.owl.owlbase.impl.OWLBasePackageImpl;
import org.eclipse.eodm.owl.owlbase.util.OWLBasePackage;
import org.eclipse.eodm.rdf.rdfbase.impl.RDFBasePackageImpl;
import org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage;
import org.eclipse.eodm.rdf.rdfs.RDFAlt;
import org.eclipse.eodm.rdf.rdfs.RDFBag;
import org.eclipse.eodm.rdf.rdfs.RDFList;
import org.eclipse.eodm.rdf.rdfs.RDFSClass;
import org.eclipse.eodm.rdf.rdfs.RDFSContainer;
import org.eclipse.eodm.rdf.rdfs.RDFSContainerMembershipProperty;
import org.eclipse.eodm.rdf.rdfs.RDFSDatatype;
import org.eclipse.eodm.rdf.rdfs.RDFSeq;
import org.eclipse.eodm.rdf.rdfs.util.RDFSFactory;
import org.eclipse.eodm.rdf.rdfs.util.RDFSPackage;
import org.eclipse.eodm.rdf.rdfweb.impl.RDFWebPackageImpl;
import org.eclipse.eodm.rdf.rdfweb.util.RDFWebPackage;








/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class RDFSPackageImpl extends EPackageImpl implements RDFSPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rdfsClassEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rdfsDatatypeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rdfListEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rdfsContainerEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rdfAltEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rdfBagEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rdfSeqEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rdfsContainerMembershipPropertyEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.eodm.rdf.rdfs.util.RDFSPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private RDFSPackageImpl() {
		super(eNS_URI, RDFSFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this
	 * model, and for any others upon which it depends.  Simple
	 * dependencies are satisfied by calling this method on all
	 * dependent packages before doing anything else.  This method drives
	 * initialization for interdependent packages directly, in parallel
	 * with this package, itself.
	 * <p>Of this package and its interdependencies, all packages which
	 * have not yet been registered by their URI values are first created
	 * and registered.  The packages are then initialized in two steps:
	 * meta-model objects for all of the packages are created before any
	 * are initialized, since one package's meta-model objects may refer to
	 * those of another.
	 * <p>Invocation of this method will not affect any packages that have
	 * already been initialized.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static RDFSPackage init() {
		if (isInited) return (RDFSPackage)EPackage.Registry.INSTANCE.getEPackage(RDFSPackage.eNS_URI);

		// Obtain or create and register package
		RDFSPackageImpl therdfsPackage = (RDFSPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(eNS_URI) instanceof RDFSPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(eNS_URI) : new RDFSPackageImpl());

		isInited = true;

		// Obtain or create and register interdependencies
		EODMImplPackageImpl theeodm2Package = (EODMImplPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(EODMImplPackage.eNS_URI) instanceof EODMImplPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(EODMImplPackage.eNS_URI) : EODMImplPackage.eINSTANCE);
		RDFWebPackageImpl therdfwebPackage = (RDFWebPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(RDFWebPackage.eNS_URI) instanceof RDFWebPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(RDFWebPackage.eNS_URI) : RDFWebPackage.eINSTANCE);
		RDFBasePackageImpl therdfbasePackage = (RDFBasePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(RDFBasePackage.eNS_URI) instanceof RDFBasePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(RDFBasePackage.eNS_URI) : RDFBasePackage.eINSTANCE);
		OWLBasePackageImpl theowlbasePackage = (OWLBasePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(OWLBasePackage.eNS_URI) instanceof OWLBasePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(OWLBasePackage.eNS_URI) : OWLBasePackage.eINSTANCE);

		// Create package meta-data objects
		therdfsPackage.createPackageContents();
		theeodm2Package.createPackageContents();
		therdfwebPackage.createPackageContents();
		therdfbasePackage.createPackageContents();
		theowlbasePackage.createPackageContents();

		// Initialize created meta-data
		therdfsPackage.initializePackageContents();
		theeodm2Package.initializePackageContents();
		therdfwebPackage.initializePackageContents();
		therdfbasePackage.initializePackageContents();
		theowlbasePackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		therdfsPackage.freeze();

		return therdfsPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getRDFSClass() {
		return rdfsClassEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRDFSClass_RDFSsubClassOf() {
		return (EReference)rdfsClassEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRDFSClass_SubClass() {
		return (EReference)rdfsClassEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRDFSClass_PropertyForDomain() {
		return (EReference)rdfsClassEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRDFSClass_PropertyForRange() {
		return (EReference)rdfsClassEClass.getEStructuralFeatures().get(3);
	}

	public EReference getRDFSClass_TypedResource() {
		return (EReference)rdfsClassEClass.getEStructuralFeatures().get(4);
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getRDFSDatatype() {
		return rdfsDatatypeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getRDFList() {
		return rdfListEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRDFList_RDFfirst() {
		return (EReference)rdfListEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRDFList_RDFrest() {
		return (EReference)rdfListEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getRDFSContainer() {
		return rdfsContainerEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getRDFAlt() {
		return rdfAltEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getRDFBag() {
		return rdfBagEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getRDFSeq() {
		return rdfSeqEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getRDFSContainerMembershipProperty() {
		return rdfsContainerMembershipPropertyEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFSFactory getrdfsFactory() {
		return (RDFSFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		rdfsClassEClass = createEClass(RDFS_CLASS);
		createEReference(rdfsClassEClass, RDFS_CLASS__RDF_SSUB_CLASS_OF);
		createEReference(rdfsClassEClass, RDFS_CLASS__SUB_CLASS);
		createEReference(rdfsClassEClass, RDFS_CLASS__PROPERTY_FOR_DOMAIN);
		createEReference(rdfsClassEClass, RDFS_CLASS__PROPERTY_FOR_RANGE);
		createEReference(rdfsClassEClass, RDFS_CLASS__TYPED_RESOURCE);

		rdfsDatatypeEClass = createEClass(RDFS_DATATYPE);

		rdfListEClass = createEClass(RDF_LIST);
		createEReference(rdfListEClass, RDF_LIST__RD_FFIRST);
		createEReference(rdfListEClass, RDF_LIST__RD_FREST);

		rdfsContainerEClass = createEClass(RDFS_CONTAINER);

		rdfAltEClass = createEClass(RDF_ALT);

		rdfBagEClass = createEClass(RDF_BAG);

		rdfSeqEClass = createEClass(RDF_SEQ);

		rdfsContainerMembershipPropertyEClass = createEClass(RDFS_CONTAINER_MEMBERSHIP_PROPERTY);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		RDFBasePackageImpl therdfbasePackage = (RDFBasePackageImpl)EPackage.Registry.INSTANCE.getEPackage(RDFBasePackage.eNS_URI);

		// Add supertypes to classes
		rdfsClassEClass.getESuperTypes().add(therdfbasePackage.getRDFSResource());
		rdfsDatatypeEClass.getESuperTypes().add(this.getRDFSClass());
		rdfListEClass.getESuperTypes().add(therdfbasePackage.getRDFSResource());
		rdfsContainerEClass.getESuperTypes().add(therdfbasePackage.getRDFSResource());
		rdfAltEClass.getESuperTypes().add(this.getRDFSContainer());
		rdfBagEClass.getESuperTypes().add(this.getRDFSContainer());
		rdfSeqEClass.getESuperTypes().add(this.getRDFSContainer());
		rdfsContainerMembershipPropertyEClass.getESuperTypes().add(therdfbasePackage.getRDFProperty());

		// Initialize classes and features; add operations and parameters
		initEClass(rdfsClassEClass, RDFSClass.class, "RDFSClass", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getRDFSClass_RDFSsubClassOf(), this.getRDFSClass(), this.getRDFSClass_SubClass(), "RDFSsubClassOf", null, 0, -1, RDFSClass.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRDFSClass_SubClass(), this.getRDFSClass(), this.getRDFSClass_RDFSsubClassOf(), "subClass", null, 0, -1, RDFSClass.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRDFSClass_PropertyForDomain(), therdfbasePackage.getRDFProperty(), therdfbasePackage.getRDFProperty_RDFSdomain(), "propertyForDomain", null, 0, -1, RDFSClass.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRDFSClass_PropertyForRange(), therdfbasePackage.getRDFProperty(), therdfbasePackage.getRDFProperty_RDFSrange(), "propertyForRange", null, 0, -1, RDFSClass.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRDFSClass_TypedResource(), therdfbasePackage.getRDFSResource(), therdfbasePackage.getRDFSResource_RDFtype(), "typedResource", null, 0, -1, RDFSClass.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(rdfsDatatypeEClass, RDFSDatatype.class, "RDFSDatatype", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(rdfListEClass, RDFList.class, "RDFList", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getRDFList_RDFfirst(), therdfbasePackage.getRDFSResource(), null, "RDFfirst", null, 0, 1, RDFList.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRDFList_RDFrest(), this.getRDFList(), null, "RDFrest", null, 0, 1, RDFList.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(rdfsContainerEClass, RDFSContainer.class, "RDFSContainer", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(rdfAltEClass, RDFAlt.class, "RDFAlt", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(rdfBagEClass, RDFBag.class, "RDFBag", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(rdfSeqEClass, RDFSeq.class, "RDFSeq", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(rdfsContainerMembershipPropertyEClass, RDFSContainerMembershipProperty.class, "RDFSContainerMembershipProperty", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		// Create annotations
		// keywords
		createKeywordsAnnotations();
	}

	/**
	 * Initializes the annotations for <b>keywords</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createKeywordsAnnotations() {
		String source = "keywords";		
		addAnnotation
		  (this, 
		   source, 
		   new String[] {
			 "metamodel", null
		   });
	}

} //RDFSPackageImpl
