/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.util;

import org.eclipse.eodm.RDFFactory;
import org.eclipse.eodm.rdf.rdfbase.RDFSLiteral;
import org.eclipse.eodm.rdf.rdfbase.URIReference;
import org.eclipse.eodm.rdf.rdfweb.Namespace;
import org.eclipse.eodm.rdf.rdfweb.NamespaceDefinition;

public class Triple {
    URIReference subjectUriRef;
    String subjectURI;
    String subjectNodeID;
    URIReference predicateUriRef;
    String predicate;
    URIReference objectUriRef;
    String objectURI;
    String objectNodeID;
    RDFSLiteral objectLiteral;

    public RDFSLiteral getObjectLiteral() {
        return this.objectLiteral;
    }

    public void setObjectLiteral(RDFSLiteral objectLiteral) {
        this.objectLiteral = objectLiteral;
    }

    public String getObjectNodeID() {
        return this.objectNodeID;
    }

    public void setObjectNodeID(String objectNodeID) {
        this.objectNodeID = objectNodeID;
    }

    public String getObjectURI() {
        return this.objectURI;
    }

    public void setObjectURI(String objectURI) {
        try {
            this.objectURI = objectURI;
            this.objectUriRef = RDFFactory.eINSTANCE.createURIReference(objectURI);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setObjectURI(Namespace namespace, String localName) {
        this.objectURI = String.valueOf(namespace.getNamespaceURIRef().getURIString()) + localName;
        this.objectUriRef = RDFFactory.eINSTANCE.createURIReference(namespace, localName);
    }

    public URIReference getObjectUriRef() {
        return this.objectUriRef;
    }

    public void setObjectUriRef(URIReference objectUriRef) {
        try {
            this.objectUriRef = objectUriRef.getNamespace() != null ? RDFFactory.eINSTANCE.createURIReference(objectUriRef.getNamespace(), objectUriRef.getFragmentIdentifier().getName()) : RDFFactory.eINSTANCE.createURIReference(objectUriRef.getURIString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.objectURI = this.objectUriRef.getURIString();
    }

    public String getPredicate() {
        return this.predicate;
    }

    public void setPredicate(String predicate) {
        this.predicate = predicate;
        try {
            this.predicateUriRef = RDFFactory.eINSTANCE.createURIReference(predicate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public URIReference getPredicateUriRef() {
        return this.predicateUriRef;
    }

    public void setPredicateUriRef(URIReference predicateUriRef) {
        this.predicateUriRef = predicateUriRef;
        this.predicate = this.predicateUriRef.getURIString();
    }

    public void setPredicateUriRef(Namespace namespace, String localName) {
        this.predicateUriRef = RDFFactory.eINSTANCE.createURIReference(namespace, localName);
        this.predicate = String.valueOf(namespace.getNamespaceURIRef().getURIString()) + localName;
    }

    public String getSubjectNodeID() {
        return this.subjectNodeID;
    }

    public void setSubjectNodeID(String subjectNodeID) {
        this.subjectNodeID = subjectNodeID;
    }

    public String getSubjectURI() {
        return this.subjectURI;
    }

    public void setSubjectURI(String subjectURI) {
        this.subjectURI = subjectURI;
        try {
            this.subjectUriRef = RDFFactory.eINSTANCE.createURIReference(subjectURI);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSubjectURI(Namespace namespace, String localName) {
        this.subjectUriRef = RDFFactory.eINSTANCE.createURIReference(namespace, localName);
        this.subjectURI = String.valueOf(namespace.getNamespaceURIRef().getURIString()) + localName;
    }

    public URIReference getSubjectUriRef() {
        return this.subjectUriRef;
    }

    public void setSubjectUriRef(URIReference subjectUriRef) {
        try {
            this.subjectUriRef = subjectUriRef.getNamespace() != null ? RDFFactory.eINSTANCE.createURIReference(subjectUriRef.getNamespace(), subjectUriRef.getFragmentIdentifier().getName()) : RDFFactory.eINSTANCE.createURIReference(subjectUriRef.getURIString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.subjectURI = this.subjectUriRef.getURIString();
    }

    public boolean isSubjectURI() {
        return this.getSubjectURI() != null && !this.getSubjectURI().equals("");
    }

    public boolean isObjectURI() {
        return this.getObjectURI() != null && !this.getObjectURI().equals("");
    }

    public boolean isObjectLiteral() {
        return this.getObjectLiteral() != null;
    }

    public boolean isObjectBlankNode() {
        return this.getObjectNodeID() != null;
    }

    public void print() {
        this.print(null);
    }

    protected void appendAbbrev(StringBuffer buf, String uri, NamespaceDefinition[] nss) {
        if (nss != null) {
            int i = 0;
            while (i < nss.length) {
                String nsUri = nss[i].getNamespace().getNamespaceURIRef().getURIString();
                if (uri.startsWith(nsUri)) {
                    buf.append(nss[i].getNamespacePrefix());
                    buf.append(":");
                    buf.append(uri.substring(nsUri.length()));
                    return;
                }
                ++i;
            }
        }
        buf.append(uri);
    }

    public void print(NamespaceDefinition[] nss) {
        StringBuffer output = new StringBuffer(64);
        output.append("(");
        String subjStr = this.getSubjectURI();
        if (subjStr.length() == 0) {
            subjStr = this.getSubjectNodeID();
        }
        this.appendAbbrev(output, subjStr, nss);
        output.append(",\t");
        this.appendAbbrev(output, this.getPredicate(), nss);
        output.append(",\t");
        String objStr = null;
        if (this.isObjectURI()) {
            objStr = this.getObjectURI();
        }
        if (this.isObjectBlankNode()) {
            objStr = this.getObjectNodeID();
        }
        if (this.isObjectLiteral()) {
            objStr = this.getObjectLiteral().getLexicalForm();
        }
        this.appendAbbrev(output, objStr, nss);
        output.append(")");
        System.out.println(output.toString());
    }

    public Triple cloneTriple() {
        Triple triple = new Triple();
        if (this.isSubjectURI()) {
            triple.setSubjectUriRef(this.subjectUriRef);
        } else {
            triple.setSubjectNodeID(this.subjectNodeID);
        }
        triple.setPredicateUriRef(this.predicateUriRef);
        if (this.isObjectURI()) {
            triple.setObjectUriRef(this.objectUriRef);
        } else if (this.isObjectBlankNode()) {
            triple.setObjectNodeID(this.objectNodeID);
        } else {
            triple.setObjectLiteral(this.objectLiteral);
        }
        return triple;
    }
}

