/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.ocl.AbstractEnvironment;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.EvaluationVisitor;
import org.eclipse.ocl.EvaluationVisitorImpl;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.internal.evaluation.TracingEvaluationVisitor;
import org.eclipse.ocl.util.Adaptable;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.OCLFactory;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEnvironmentFactory<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>
implements EnvironmentFactory<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>,
Adaptable {
    private boolean traceEvaluation;

    protected AbstractEnvironmentFactory() {
    }

    protected Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> createPackageContext(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parent, PK context) {
        Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> result = this.createEnvironment(parent);
        if (result instanceof AbstractEnvironment) {
            ((AbstractEnvironment)result).setContextPackage(context);
        }
        return result;
    }

    @Override
    public Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> createPackageContext(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parent, List<String> pathname) {
        PK contextPackage = this.lookupPackage(pathname);
        return contextPackage == null ? null : this.createPackageContext(parent, contextPackage);
    }

    protected abstract PK lookupPackage(List<String> var1);

    @Override
    public Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> createClassifierContext(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parent, C context) {
        Environment result = this.createEnvironment(parent);
        UMLReflection<PK, C, O, P, EL, PM, S, COA, SSA, CT> uml = parent.getUMLReflection();
        context = uml.asOCLType(context);
        Variable self = parent.getOCLFactory().createVariable();
        uml.setName(self, "self");
        uml.setType(self, context);
        result.addElement(self.getName(), self, true);
        result.setSelfVariable(self);
        return result;
    }

    @Override
    public Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> createInstanceContext(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parent, Object context) {
        return this.createClassifierContext(parent, this.getClassifier(context));
    }

    @Override
    public Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> createOperationContext(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parent, O operation) {
        Environment result = this.createEnvironment(parent);
        if (result instanceof AbstractEnvironment) {
            ((AbstractEnvironment)result).setContextOperation(operation);
        }
        UMLReflection<PK, C, O, P, EL, PM, S, COA, SSA, CT> uml = parent.getUMLReflection();
        OCLFactory oclFactory = parent.getOCLFactory();
        for (PM next : parent.getUMLReflection().getParameters(operation)) {
            Variable var = oclFactory.createVariable();
            uml.setName(var, uml.getName(next));
            uml.setType(var, TypeUtil.resolveType(result, uml.getOCLType(next)));
            var.setRepresentedParameter(next);
            result.addElement(var.getName(), var, true);
        }
        return result;
    }

    @Override
    public Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> createAttributeContext(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parent, P property) {
        Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> result = this.createEnvironment(parent);
        if (result instanceof AbstractEnvironment) {
            ((AbstractEnvironment)result).setContextProperty(property);
        }
        return result;
    }

    @Override
    public EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> createEvaluationVisitor(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, EvaluationEnvironment<C, O, P, CLS, E> evalEnv, Map<? extends CLS, ? extends Set<? extends E>> extentMap) {
        EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, ? extends CLS, E> result = new EvaluationVisitorImpl<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>(env, evalEnv, extentMap);
        if (this.isEvaluationTracingEnabled()) {
            result = new TracingEvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>(result);
        }
        return result;
    }

    protected abstract C getClassifier(Object var1);

    protected boolean isEvaluationTracingEnabled() {
        return this.traceEvaluation;
    }

    protected void setEvaluationTracingEnabled(boolean b) {
        this.traceEvaluation = b;
    }

    @Override
    public <T> T getAdapter(Class<T> adapterType) {
        AbstractEnvironmentFactory<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> result = adapterType.isAssignableFrom(this.getClass()) ? this : null;
        return (T)result;
    }
}

