/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.csd.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.uml2.diagram.csd.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Realization;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public class PortProvidedCreateCommand
extends EditElementCommand {
    private final EObject source;
    private final EObject target;

    public PortProvidedCreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.source = source;
        this.target = target;
    }

    public boolean canExecute() {
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !(this.source instanceof Port)) {
            return false;
        }
        if (this.target != null && !(this.target instanceof Interface)) {
            return false;
        }
        if (this.getSource() == null) {
            return true;
        }
        return UMLBaseItemSemanticEditPolicy.LinkConstraints.canCreatePortProvided_4010(this.getSource(), this.getTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in create link command");
        }
        Port port = this.getSource();
        Interface targetInterface = this.getTarget();
        if (port != null && targetInterface != null) {
            Type portType = port.getType();
            if (portType == null) {
                port.setType((Type)targetInterface);
            } else if (portType instanceof Classifier) {
                this.createRealization(port, targetInterface, (Classifier)portType);
            }
        }
        return CommandResult.newOKCommandResult();
    }

    private void createRealization(Port port, Interface targetInterface, Classifier portType) {
        Package realizationContainer = null;
        EObject element = this.source;
        while (element != null) {
            if (element instanceof Package) {
                realizationContainer = (Package)element;
                break;
            }
            element = element.eContainer();
        }
        if (realizationContainer == null) {
            return;
        }
        Realization realization = UMLFactory.eINSTANCE.createRealization();
        realizationContainer.getPackagedElements().add((Object)realization);
        realization.getClients().add((Object)portType);
        realization.getSuppliers().add((Object)targetInterface);
    }

    protected Port getSource() {
        return (Port)this.source;
    }

    protected Interface getTarget() {
        return (Interface)this.target;
    }
}

