/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.internal.operations.ClassOperations;
import org.eclipse.uml2.uml.internal.operations.ParameterOperations;

public class BehaviorOperations
extends ClassOperations {
    protected BehaviorOperations() {
    }

    public static boolean validateParametersMatch(Behavior behavior, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        BehavioralFeature specification = behavior.getSpecification();
        if (specification != null) {
            EList behaviorOwnedParameters = behavior.getOwnedParameters();
            EList specificationOwnedParameters = specification.getOwnedParameters();
            if (behaviorOwnedParameters.size() != specificationOwnedParameters.size()) {
                result = false;
            } else {
                Iterator bop = behaviorOwnedParameters.iterator();
                Iterator sop = specificationOwnedParameters.iterator();
                while (bop.hasNext() && sop.hasNext()) {
                    if (ParameterOperations.matches((Parameter)bop.next(), (Parameter)sop.next())) continue;
                    result = false;
                    break;
                }
            }
            if (!result && diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 65, UMLPlugin.INSTANCE.getString("_UI_Behavior_ParametersMatch_diagnostic", BehaviorOperations.getMessageSubstitutions((Map)context, (Object)behavior)), new Object[]{behavior}));
            }
        }
        return result;
    }

    public static boolean validateFeatureOfContextClassifier(Behavior behavior, DiagnosticChain diagnostics, Map context) {
        BehavioredClassifier contextClassifier;
        BehavioralFeature specification = behavior.getSpecification();
        if (!(specification == null || (contextClassifier = behavior.getContext()) != null && contextClassifier.allFeatures().contains((Object)specification))) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 66, UMLPlugin.INSTANCE.getString("_UI_Behavior_FeatureOfContextClassifier_diagnostic", BehaviorOperations.getMessageSubstitutions((Map)context, (Object)behavior)), new Object[]{behavior}));
            }
            return false;
        }
        return true;
    }

    public static boolean validateMustRealize(Behavior behavior, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean validateMostOneBehaviour(Behavior behavior, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static BehavioredClassifier getContext(Behavior behavior) {
        return (BehavioredClassifier)BehaviorOperations.getOwningElement(behavior, UMLPackage.Literals.BEHAVIORED_CLASSIFIER, false);
    }
}

