/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: RDFStatementImpl.java,v 1.1 2007/03/18 08:10:12 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfbase.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.eodm.rdf.rdfbase.RDFProperty;
import org.eclipse.eodm.rdf.rdfbase.RDFSResource;
import org.eclipse.eodm.rdf.rdfbase.RDFStatement;
import org.eclipse.eodm.rdf.rdfbase.URIReference;
import org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage;
import org.eclipse.eodm.rdf.rdfweb.Document;
import org.eclipse.eodm.rdf.rdfweb.util.RDFWebPackage;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>RDF Statement</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.impl.RDFStatementImpl#getDocument <em>Document</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.impl.RDFStatementImpl#isIsReifiedOnly <em>Is Reified Only</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.impl.RDFStatementImpl#isIsReified <em>Is Reified</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.impl.RDFStatementImpl#getRDFsubject <em>RD Fsubject</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.impl.RDFStatementImpl#getRDFobject <em>RD Fobject</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.impl.RDFStatementImpl#getRDFpredicate <em>RD Fpredicate</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.impl.RDFStatementImpl#getNameForReification <em>Name For Reification</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class RDFStatementImpl extends RDFSResourceImpl implements RDFStatement {
	/**
	 * The cached value of the '{@link #getDocument() <em>Document</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDocument()
	 * @generated
	 * @ordered
	 */
	protected EList document = null;

	/**
	 * The default value of the '{@link #isIsReifiedOnly() <em>Is Reified Only</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsReifiedOnly()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_REIFIED_ONLY_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIsReifiedOnly() <em>Is Reified Only</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsReifiedOnly()
	 * @generated
	 * @ordered
	 */
	protected boolean isReifiedOnly = IS_REIFIED_ONLY_EDEFAULT;

	/**
	 * The default value of the '{@link #isIsReified() <em>Is Reified</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsReified()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_REIFIED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIsReified() <em>Is Reified</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsReified()
	 * @generated
	 * @ordered
	 */
	protected boolean isReified = IS_REIFIED_EDEFAULT;

	/**
	 * The cached value of the '{@link #getRDFsubject() <em>RD Fsubject</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRDFsubject()
	 * @generated
	 * @ordered
	 */
	protected RDFSResource rdFsubject = null;

	/**
	 * The cached value of the '{@link #getRDFobject() <em>RD Fobject</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRDFobject()
	 * @generated
	 * @ordered
	 */
	protected RDFSResource rdFobject = null;

	/**
	 * The cached value of the '{@link #getRDFpredicate() <em>RD Fpredicate</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRDFpredicate()
	 * @generated
	 * @ordered
	 */
	protected RDFProperty rdFpredicate = null;

	/**
	 * The cached value of the '{@link #getNameForReification() <em>Name For Reification</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNameForReification()
	 * @generated
	 * @ordered
	 */
	protected EList nameForReification = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RDFStatementImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return RDFBasePackage.eINSTANCE.getRDFStatement();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getDocument() {
		if (document == null) {
			document = new EObjectWithInverseResolvingEList.ManyInverse(Document.class, this, RDFBasePackage.RDF_STATEMENT__DOCUMENT, RDFWebPackage.DOCUMENT__STATEMENT);
		}
		return document;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIsReifiedOnly() {
		return isReifiedOnly;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIsReifiedOnly(boolean newIsReifiedOnly) {
		boolean oldIsReifiedOnly = isReifiedOnly;
		isReifiedOnly = newIsReifiedOnly;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RDFBasePackage.RDF_STATEMENT__IS_REIFIED_ONLY, oldIsReifiedOnly, isReifiedOnly));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIsReified() {
		return isReified;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIsReified(boolean newIsReified) {
		boolean oldIsReified = isReified;
		isReified = newIsReified;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RDFBasePackage.RDF_STATEMENT__IS_REIFIED, oldIsReified, isReified));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFSResource getRDFsubject() {
		if (rdFsubject != null && rdFsubject.eIsProxy()) {
			RDFSResource oldRDFsubject = rdFsubject;
			rdFsubject = (RDFSResource)eResolveProxy((InternalEObject)rdFsubject);
			if (rdFsubject != oldRDFsubject) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, RDFBasePackage.RDF_STATEMENT__RD_FSUBJECT, oldRDFsubject, rdFsubject));
			}
		}
		return rdFsubject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFSResource basicGetRDFsubject() {
		return rdFsubject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetRDFsubject(RDFSResource newRDFsubject, NotificationChain msgs) {
		RDFSResource oldRDFsubject = rdFsubject;
		rdFsubject = newRDFsubject;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, RDFBasePackage.RDF_STATEMENT__RD_FSUBJECT, oldRDFsubject, newRDFsubject);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRDFsubject(RDFSResource newRDFsubject) {
		if (newRDFsubject != rdFsubject) {
			NotificationChain msgs = null;
			if (rdFsubject != null)
				msgs = ((InternalEObject)rdFsubject).eInverseRemove(this, RDFBasePackage.RDFS_RESOURCE__SUBJECT_STATEMENT, RDFSResource.class, msgs);
			if (newRDFsubject != null)
				msgs = ((InternalEObject)newRDFsubject).eInverseAdd(this, RDFBasePackage.RDFS_RESOURCE__SUBJECT_STATEMENT, RDFSResource.class, msgs);
			msgs = basicSetRDFsubject(newRDFsubject, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RDFBasePackage.RDF_STATEMENT__RD_FSUBJECT, newRDFsubject, newRDFsubject));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFSResource getRDFobject() {
		if (rdFobject != null && rdFobject.eIsProxy()) {
			RDFSResource oldRDFobject = rdFobject;
			rdFobject = (RDFSResource)eResolveProxy((InternalEObject)rdFobject);
			if (rdFobject != oldRDFobject) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, RDFBasePackage.RDF_STATEMENT__RD_FOBJECT, oldRDFobject, rdFobject));
			}
		}
		return rdFobject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFSResource basicGetRDFobject() {
		return rdFobject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRDFobject(RDFSResource newRDFobject) {
		RDFSResource oldRDFobject = rdFobject;
		rdFobject = newRDFobject;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RDFBasePackage.RDF_STATEMENT__RD_FOBJECT, oldRDFobject, rdFobject));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFProperty getRDFpredicate() {
		if (rdFpredicate != null && rdFpredicate.eIsProxy()) {
			RDFProperty oldRDFpredicate = rdFpredicate;
			rdFpredicate = (RDFProperty)eResolveProxy((InternalEObject)rdFpredicate);
			if (rdFpredicate != oldRDFpredicate) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, RDFBasePackage.RDF_STATEMENT__RD_FPREDICATE, oldRDFpredicate, rdFpredicate));
			}
		}
		return rdFpredicate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFProperty basicGetRDFpredicate() {
		return rdFpredicate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRDFpredicate(RDFProperty newRDFpredicate) {
		RDFProperty oldRDFpredicate = rdFpredicate;
		rdFpredicate = newRDFpredicate;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RDFBasePackage.RDF_STATEMENT__RD_FPREDICATE, oldRDFpredicate, rdFpredicate));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getNameForReification() {
		if (nameForReification == null) {
			nameForReification = new EObjectWithInverseResolvingEList.ManyInverse(URIReference.class, this, RDFBasePackage.RDF_STATEMENT__NAME_FOR_REIFICATION, RDFBasePackage.URI_REFERENCE__REIFIED_STATEMENT);
		}
		return nameForReification;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case RDFBasePackage.RDF_STATEMENT__URI_REF:
					return ((InternalEList)getUriRef()).basicAdd(otherEnd, msgs);
				case RDFBasePackage.RDF_STATEMENT__SUBJECT_STATEMENT:
					return ((InternalEList)getSubjectStatement()).basicAdd(otherEnd, msgs);
				case RDFBasePackage.RDF_STATEMENT__DOCUMENT:
					return ((InternalEList)getDocument()).basicAdd(otherEnd, msgs);
				case RDFBasePackage.RDF_STATEMENT__RD_FSUBJECT:
					if (rdFsubject != null)
						msgs = ((InternalEObject)rdFsubject).eInverseRemove(this, RDFBasePackage.RDFS_RESOURCE__SUBJECT_STATEMENT, RDFSResource.class, msgs);
					return basicSetRDFsubject((RDFSResource)otherEnd, msgs);
				case RDFBasePackage.RDF_STATEMENT__NAME_FOR_REIFICATION:
					return ((InternalEList)getNameForReification()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case RDFBasePackage.RDF_STATEMENT__RDF_SCOMMENT:
					return ((InternalEList)getRDFScomment()).basicRemove(otherEnd, msgs);
				case RDFBasePackage.RDF_STATEMENT__RDF_SLABEL:
					return ((InternalEList)getRDFSlabel()).basicRemove(otherEnd, msgs);
				case RDFBasePackage.RDF_STATEMENT__URI_REF:
					return ((InternalEList)getUriRef()).basicRemove(otherEnd, msgs);
				case RDFBasePackage.RDF_STATEMENT__SUBJECT_STATEMENT:
					return ((InternalEList)getSubjectStatement()).basicRemove(otherEnd, msgs);
				case RDFBasePackage.RDF_STATEMENT__DOCUMENT:
					return ((InternalEList)getDocument()).basicRemove(otherEnd, msgs);
				case RDFBasePackage.RDF_STATEMENT__RD_FSUBJECT:
					return basicSetRDFsubject(null, msgs);
				case RDFBasePackage.RDF_STATEMENT__NAME_FOR_REIFICATION:
					return ((InternalEList)getNameForReification()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.RDF_STATEMENT__RDF_SIS_DEFINED_BY:
				return getRDFSisDefinedBy();
			case RDFBasePackage.RDF_STATEMENT__RDF_SSEE_ALSO:
				return getRDFSseeAlso();
			case RDFBasePackage.RDF_STATEMENT__RD_FTYPE:
				return getRDFtype();
			case RDFBasePackage.RDF_STATEMENT__RDF_SMEMBER:
				return getRDFSmember();
			case RDFBasePackage.RDF_STATEMENT__NODE_ID:
				return getNodeID();
			case RDFBasePackage.RDF_STATEMENT__RDF_SCOMMENT:
				return getRDFScomment();
			case RDFBasePackage.RDF_STATEMENT__RDF_SLABEL:
				return getRDFSlabel();
			case RDFBasePackage.RDF_STATEMENT__URI_REF:
				return getUriRef();
			case RDFBasePackage.RDF_STATEMENT__SUBJECT_STATEMENT:
				return getSubjectStatement();
			case RDFBasePackage.RDF_STATEMENT__DOCUMENT:
				return getDocument();
			case RDFBasePackage.RDF_STATEMENT__IS_REIFIED_ONLY:
				return isIsReifiedOnly() ? Boolean.TRUE : Boolean.FALSE;
			case RDFBasePackage.RDF_STATEMENT__IS_REIFIED:
				return isIsReified() ? Boolean.TRUE : Boolean.FALSE;
			case RDFBasePackage.RDF_STATEMENT__RD_FSUBJECT:
				if (resolve) return getRDFsubject();
				return basicGetRDFsubject();
			case RDFBasePackage.RDF_STATEMENT__RD_FOBJECT:
				if (resolve) return getRDFobject();
				return basicGetRDFobject();
			case RDFBasePackage.RDF_STATEMENT__RD_FPREDICATE:
				if (resolve) return getRDFpredicate();
				return basicGetRDFpredicate();
			case RDFBasePackage.RDF_STATEMENT__NAME_FOR_REIFICATION:
				return getNameForReification();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.RDF_STATEMENT__RDF_SIS_DEFINED_BY:
				getRDFSisDefinedBy().clear();
				getRDFSisDefinedBy().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDF_STATEMENT__RDF_SSEE_ALSO:
				getRDFSseeAlso().clear();
				getRDFSseeAlso().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDF_STATEMENT__RD_FTYPE:
				getRDFtype().clear();
				getRDFtype().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDF_STATEMENT__RDF_SMEMBER:
				getRDFSmember().clear();
				getRDFSmember().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDF_STATEMENT__NODE_ID:
				setNodeID((String)newValue);
				return;
			case RDFBasePackage.RDF_STATEMENT__RDF_SCOMMENT:
				getRDFScomment().clear();
				getRDFScomment().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDF_STATEMENT__RDF_SLABEL:
				getRDFSlabel().clear();
				getRDFSlabel().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDF_STATEMENT__URI_REF:
				getUriRef().clear();
				getUriRef().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDF_STATEMENT__SUBJECT_STATEMENT:
				getSubjectStatement().clear();
				getSubjectStatement().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDF_STATEMENT__DOCUMENT:
				getDocument().clear();
				getDocument().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDF_STATEMENT__IS_REIFIED_ONLY:
				setIsReifiedOnly(((Boolean)newValue).booleanValue());
				return;
			case RDFBasePackage.RDF_STATEMENT__IS_REIFIED:
				setIsReified(((Boolean)newValue).booleanValue());
				return;
			case RDFBasePackage.RDF_STATEMENT__RD_FSUBJECT:
				setRDFsubject((RDFSResource)newValue);
				return;
			case RDFBasePackage.RDF_STATEMENT__RD_FOBJECT:
				setRDFobject((RDFSResource)newValue);
				return;
			case RDFBasePackage.RDF_STATEMENT__RD_FPREDICATE:
				setRDFpredicate((RDFProperty)newValue);
				return;
			case RDFBasePackage.RDF_STATEMENT__NAME_FOR_REIFICATION:
				getNameForReification().clear();
				getNameForReification().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.RDF_STATEMENT__RDF_SIS_DEFINED_BY:
				getRDFSisDefinedBy().clear();
				return;
			case RDFBasePackage.RDF_STATEMENT__RDF_SSEE_ALSO:
				getRDFSseeAlso().clear();
				return;
			case RDFBasePackage.RDF_STATEMENT__RD_FTYPE:
				getRDFtype().clear();
				return;
			case RDFBasePackage.RDF_STATEMENT__RDF_SMEMBER:
				getRDFSmember().clear();
				return;
			case RDFBasePackage.RDF_STATEMENT__NODE_ID:
				setNodeID(NODE_ID_EDEFAULT);
				return;
			case RDFBasePackage.RDF_STATEMENT__RDF_SCOMMENT:
				getRDFScomment().clear();
				return;
			case RDFBasePackage.RDF_STATEMENT__RDF_SLABEL:
				getRDFSlabel().clear();
				return;
			case RDFBasePackage.RDF_STATEMENT__URI_REF:
				getUriRef().clear();
				return;
			case RDFBasePackage.RDF_STATEMENT__SUBJECT_STATEMENT:
				getSubjectStatement().clear();
				return;
			case RDFBasePackage.RDF_STATEMENT__DOCUMENT:
				getDocument().clear();
				return;
			case RDFBasePackage.RDF_STATEMENT__IS_REIFIED_ONLY:
				setIsReifiedOnly(IS_REIFIED_ONLY_EDEFAULT);
				return;
			case RDFBasePackage.RDF_STATEMENT__IS_REIFIED:
				setIsReified(IS_REIFIED_EDEFAULT);
				return;
			case RDFBasePackage.RDF_STATEMENT__RD_FSUBJECT:
				setRDFsubject((RDFSResource)null);
				return;
			case RDFBasePackage.RDF_STATEMENT__RD_FOBJECT:
				setRDFobject((RDFSResource)null);
				return;
			case RDFBasePackage.RDF_STATEMENT__RD_FPREDICATE:
				setRDFpredicate((RDFProperty)null);
				return;
			case RDFBasePackage.RDF_STATEMENT__NAME_FOR_REIFICATION:
				getNameForReification().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.RDF_STATEMENT__RDF_SIS_DEFINED_BY:
				return rdfSisDefinedBy != null && !rdfSisDefinedBy.isEmpty();
			case RDFBasePackage.RDF_STATEMENT__RDF_SSEE_ALSO:
				return rdfSseeAlso != null && !rdfSseeAlso.isEmpty();
			case RDFBasePackage.RDF_STATEMENT__RD_FTYPE:
				return rdFtype != null && !rdFtype.isEmpty();
			case RDFBasePackage.RDF_STATEMENT__RDF_SMEMBER:
				return rdfSmember != null && !rdfSmember.isEmpty();
			case RDFBasePackage.RDF_STATEMENT__NODE_ID:
				return NODE_ID_EDEFAULT == null ? nodeID != null : !NODE_ID_EDEFAULT.equals(nodeID);
			case RDFBasePackage.RDF_STATEMENT__RDF_SCOMMENT:
				return rdfScomment != null && !rdfScomment.isEmpty();
			case RDFBasePackage.RDF_STATEMENT__RDF_SLABEL:
				return rdfSlabel != null && !rdfSlabel.isEmpty();
			case RDFBasePackage.RDF_STATEMENT__URI_REF:
				return uriRef != null && !uriRef.isEmpty();
			case RDFBasePackage.RDF_STATEMENT__SUBJECT_STATEMENT:
				return subjectStatement != null && !subjectStatement.isEmpty();
			case RDFBasePackage.RDF_STATEMENT__DOCUMENT:
				return document != null && !document.isEmpty();
			case RDFBasePackage.RDF_STATEMENT__IS_REIFIED_ONLY:
				return isReifiedOnly != IS_REIFIED_ONLY_EDEFAULT;
			case RDFBasePackage.RDF_STATEMENT__IS_REIFIED:
				return isReified != IS_REIFIED_EDEFAULT;
			case RDFBasePackage.RDF_STATEMENT__RD_FSUBJECT:
				return rdFsubject != null;
			case RDFBasePackage.RDF_STATEMENT__RD_FOBJECT:
				return rdFobject != null;
			case RDFBasePackage.RDF_STATEMENT__RD_FPREDICATE:
				return rdFpredicate != null;
			case RDFBasePackage.RDF_STATEMENT__NAME_FOR_REIFICATION:
				return nameForReification != null && !nameForReification.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (isReifiedOnly: ");
		result.append(isReifiedOnly);
		result.append(", isReified: ");
		result.append(isReified);
		result.append(')');
		return result.toString();
	}

} //RDFStatementImpl
