/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ElementOperations
extends UMLUtil {
    protected ElementOperations() {
    }

    public static boolean validateNotOwnSelf(Element element, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        if (EcoreUtil.isAncestor((EObject)element, (EObject)element.getOwner())) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 1, UMLPlugin.INSTANCE.getString("_UI_Element_NotOwnSelf_diagnostic", ElementOperations.getMessageSubstitutions((Map)context, (Object)element)), new Object[]{element}));
            }
        }
        return result;
    }

    public static boolean validateHasOwner(Element element, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        if (element.mustBeOwned() && element.getOwner() == null) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 2, UMLPlugin.INSTANCE.getString("_UI_Element_HasOwner_diagnostic", ElementOperations.getMessageSubstitutions((Map)context, (Object)element)), new Object[]{element}));
            }
        }
        return result;
    }

    public static EList getStereotypeApplications(Element element) {
        UniqueEList.FastCompare stereotypeApplications = new UniqueEList.FastCompare();
        Iterator nonNavigableInverseReferences = ElementOperations.getNonNavigableInverseReferences((EObject)element).iterator();
        while (nonNavigableInverseReferences.hasNext()) {
            EObject eObject;
            EStructuralFeature.Setting setting = (EStructuralFeature.Setting)nonNavigableInverseReferences.next();
            if (!setting.getEStructuralFeature().getName().startsWith("base_") || ElementOperations.getStereotype(eObject = setting.getEObject()) == null) continue;
            stereotypeApplications.add((Object)eObject);
        }
        return ECollections.unmodifiableEList((EList)stereotypeApplications);
    }

    public static EObject getStereotypeApplication(Element element, Stereotype stereotype) {
        Iterator stereotypeApplications = element.getStereotypeApplications().iterator();
        while (stereotypeApplications.hasNext()) {
            EObject stereotypeApplication = (EObject)stereotypeApplications.next();
            if (ElementOperations.getStereotype(stereotypeApplication) != stereotype) continue;
            return stereotypeApplication;
        }
        return null;
    }

    public static EList getRequiredStereotypes(Element element) {
        Package package_ = element.getNearestPackage();
        if (package_ != null) {
            UniqueEList.FastCompare requiredStereotypes = new UniqueEList.FastCompare();
            Iterator allProfileApplications = package_.getAllProfileApplications().iterator();
            while (allProfileApplications.hasNext()) {
                ProfileApplication profileApplication = (ProfileApplication)allProfileApplications.next();
                Profile appliedProfile = profileApplication.getAppliedProfile();
                if (appliedProfile == null) continue;
                Iterator ownedStereotypes = appliedProfile.getOwnedStereotypes().iterator();
                while (ownedStereotypes.hasNext()) {
                    Extension extension;
                    Stereotype stereotype = (Stereotype)ownedStereotypes.next();
                    ENamedElement appliedDefinition = profileApplication.getAppliedDefinition(stereotype);
                    if (!(appliedDefinition instanceof EClass) || ((EClass)appliedDefinition).isAbstract() || (extension = ElementOperations.getExtension(element, stereotype)) == null || !extension.isRequired()) continue;
                    requiredStereotypes.add((Object)stereotype);
                }
            }
            return ECollections.unmodifiableEList((EList)requiredStereotypes);
        }
        return ECollections.EMPTY_ELIST;
    }

    public static Stereotype getRequiredStereotype(Element element, String qualifiedName) {
        Iterator requiredStereotypes = element.getRequiredStereotypes().iterator();
        while (requiredStereotypes.hasNext()) {
            Stereotype requiredStereotype = (Stereotype)requiredStereotypes.next();
            if (!ElementOperations.safeEquals((Object)requiredStereotype.getQualifiedName(), (Object)qualifiedName)) continue;
            return requiredStereotype;
        }
        return null;
    }

    public static EList getAppliedStereotypes(Element element) {
        UniqueEList.FastCompare appliedStereotypes = new UniqueEList.FastCompare();
        Iterator nonNavigableInverseReferences = ElementOperations.getNonNavigableInverseReferences((EObject)element).iterator();
        while (nonNavigableInverseReferences.hasNext()) {
            Stereotype stereotype;
            EStructuralFeature.Setting setting = (EStructuralFeature.Setting)nonNavigableInverseReferences.next();
            if (!setting.getEStructuralFeature().getName().startsWith("base_") || (stereotype = ElementOperations.getStereotype(setting.getEObject())) == null) continue;
            appliedStereotypes.add((Object)stereotype);
        }
        return ECollections.unmodifiableEList((EList)appliedStereotypes);
    }

    public static Stereotype getAppliedStereotype(Element element, String qualifiedName) {
        Iterator appliedStereotypes = element.getAppliedStereotypes().iterator();
        while (appliedStereotypes.hasNext()) {
            Stereotype appliedStereotype = (Stereotype)appliedStereotypes.next();
            if (!ElementOperations.safeEquals((Object)appliedStereotype.getQualifiedName(), (Object)qualifiedName)) continue;
            return appliedStereotype;
        }
        return null;
    }

    public static EList getAppliedSubstereotypes(Element element, Stereotype stereotype) {
        UniqueEList.FastCompare appliedSubstereotypes = new UniqueEList.FastCompare();
        Iterator appliedStereotypes = element.getAppliedStereotypes().iterator();
        while (appliedStereotypes.hasNext()) {
            Stereotype appliedStereotype = (Stereotype)appliedStereotypes.next();
            if (!appliedStereotype.allParents().contains((Object)stereotype)) continue;
            appliedSubstereotypes.add((Object)appliedStereotype);
        }
        return ECollections.unmodifiableEList((EList)appliedSubstereotypes);
    }

    public static Stereotype getAppliedSubstereotype(Element element, Stereotype stereotype, String qualifiedName) {
        Iterator appliedSubstereotypes = element.getAppliedSubstereotypes(stereotype).iterator();
        while (appliedSubstereotypes.hasNext()) {
            Stereotype appliedSubstereotype = (Stereotype)appliedSubstereotypes.next();
            if (!ElementOperations.safeEquals((Object)appliedSubstereotype.getQualifiedName(), (Object)qualifiedName)) continue;
            return appliedSubstereotype;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasValue(Element element, Stereotype stereotype, String propertyName) {
        EObject eObject = element.getStereotypeApplication(stereotype);
        if (eObject == null) return false;
        if (ElementOperations.isEmpty((String)propertyName)) return false;
        EClass eClass = eObject.eClass();
        String[] segments = propertyName.split("::");
        int i = 0;
        int length = segments.length;
        while (i < length) {
            String segment = segments[i];
            EStructuralFeature eStructuralFeature = null;
            int index = -1;
            if (segment.indexOf(91) == -1) {
                eStructuralFeature = eClass.getEStructuralFeature(ElementOperations.getValidJavaIdentifier((String)segment));
            } else {
                eStructuralFeature = eClass.getEStructuralFeature(ElementOperations.getValidJavaIdentifier((String)segment.substring(0, segment.indexOf(91))));
                try {
                    index = Integer.parseInt(segment.substring(segment.indexOf(91) + 1, segment.indexOf(93)));
                }
                catch (Exception exception) {
                    return false;
                }
            }
            if (eStructuralFeature != null) {
                if (length > i + 1) {
                    if (eObject == null) return false;
                    EClassifier eType = eStructuralFeature.getEType();
                    if (eType instanceof EClass) {
                        eClass = (EClass)eType;
                        eObject = (EObject)(eStructuralFeature.isMany() ? ((List)eObject.eGet(eStructuralFeature)).get(index) : eObject.eGet(eStructuralFeature));
                    }
                } else {
                    if (eStructuralFeature.isMany()) {
                        List list;
                        List list2 = list = eObject == null ? Collections.EMPTY_LIST : (List)eObject.eGet(eStructuralFeature);
                        if (index == -1) {
                            if (!list.isEmpty()) return true;
                            return false;
                        }
                        if (!ElementOperations.safeEquals((Object)eStructuralFeature.getDefaultValue(), list.get(index))) return true;
                        return false;
                    }
                    if (eObject == null) {
                        return false;
                    }
                    if (!ElementOperations.safeEquals((Object)eStructuralFeature.getDefaultValue(), (Object)eObject.eGet(eStructuralFeature))) return true;
                    return false;
                }
            }
            ++i;
        }
        return false;
    }

    public static Object getValue(Element element, Stereotype stereotype, String propertyName) {
        if (stereotype == null || !element.isStereotypeApplied(stereotype)) {
            throw new IllegalArgumentException(String.valueOf(stereotype));
        }
        if (ElementOperations.isEmpty((String)propertyName)) {
            throw new IllegalArgumentException(String.valueOf(propertyName));
        }
        EObject eObject = element.getStereotypeApplication(stereotype);
        if (eObject == null) {
            throw new IllegalArgumentException(String.valueOf(stereotype));
        }
        EClass eClass = eObject.eClass();
        String[] segments = propertyName.split("::");
        int i = 0;
        int length = segments.length;
        while (i < length) {
            String segment = segments[i];
            EStructuralFeature eStructuralFeature = null;
            int index = -1;
            if (segment.indexOf(91) == -1) {
                eStructuralFeature = eClass.getEStructuralFeature(ElementOperations.getValidJavaIdentifier((String)segment));
            } else {
                eStructuralFeature = eClass.getEStructuralFeature(ElementOperations.getValidJavaIdentifier((String)segment.substring(0, segment.indexOf(91))));
                try {
                    index = Integer.parseInt(segment.substring(segment.indexOf(91) + 1, segment.indexOf(93)));
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(String.valueOf(propertyName));
                }
            }
            if (eStructuralFeature == null) {
                throw new IllegalArgumentException(String.valueOf(propertyName));
            }
            EClassifier eType = eStructuralFeature.getEType();
            if (i + 1 < length) {
                if (eObject == null || !(eType instanceof EClass)) {
                    throw new IllegalArgumentException(String.valueOf(propertyName));
                }
            } else {
                Object reference;
                EList references;
                EAnnotation eAnnotation;
                Object value = null;
                if (eStructuralFeature.isMany()) {
                    List list = eObject == null ? Collections.EMPTY_LIST : (List)eObject.eGet(eStructuralFeature);
                    value = index == -1 ? list : list.get(index);
                } else {
                    Object object = value = eObject == null ? eStructuralFeature.getDefaultValue() : eObject.eGet(eStructuralFeature);
                }
                if (eType instanceof EEnum && value instanceof EEnumLiteral && (eAnnotation = eType.getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML")) != null && (references = eAnnotation.getReferences()).size() > 0 && (reference = references.get(0)) instanceof Enumeration) {
                    value = ((Enumeration)reference).getOwnedLiteral(((EEnumLiteral)value).getName());
                }
                return value;
            }
            eClass = (EClass)eType;
            eObject = (EObject)(eStructuralFeature.isMany() ? ((List)eObject.eGet(eStructuralFeature)).get(index) : eObject.eGet(eStructuralFeature));
            ++i;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setValue(Element element, Stereotype stereotype, String propertyName, Object newValue) {
        if (stereotype == null) {
            throw new IllegalArgumentException(String.valueOf(stereotype));
        }
        if (ElementOperations.isEmpty((String)propertyName)) {
            throw new IllegalArgumentException(String.valueOf(propertyName));
        }
        EObject eObject = element.getStereotypeApplication(stereotype);
        if (eObject == null) {
            throw new IllegalArgumentException(String.valueOf(stereotype));
        }
        EClass eClass = eObject.eClass();
        String[] segments = propertyName.split("::");
        int i = 0;
        int length = segments.length;
        while (i < length) {
            List list;
            String segment = segments[i];
            EStructuralFeature eStructuralFeature = null;
            int index = -1;
            if (segment.indexOf(91) == -1) {
                eStructuralFeature = eClass.getEStructuralFeature(ElementOperations.getValidJavaIdentifier((String)segment));
            } else {
                eStructuralFeature = eClass.getEStructuralFeature(ElementOperations.getValidJavaIdentifier((String)segment.substring(0, segment.indexOf(91))));
                try {
                    index = Integer.parseInt(segment.substring(segment.indexOf(91) + 1, segment.indexOf(93)));
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(String.valueOf(propertyName));
                }
            }
            if (eStructuralFeature == null) {
                throw new IllegalArgumentException(String.valueOf(propertyName));
            }
            EClassifier eType = eStructuralFeature.getEType();
            if (i + 1 < length) {
                if (!(eType instanceof EClass)) {
                    throw new IllegalArgumentException(String.valueOf(propertyName));
                }
                eClass = (EClass)eType;
                if (eStructuralFeature.isMany()) {
                    list = (List)eObject.eGet(eStructuralFeature);
                    int size = list.size();
                    if (size <= index) {
                        if (!((EReference)eStructuralFeature).isContainment()) {
                            throw new IllegalArgumentException(String.valueOf(propertyName));
                        }
                        int j = size;
                        while (j <= index) {
                            list.add(j, EcoreUtil.create((EClass)eClass));
                            ++j;
                        }
                    }
                    eObject = (EObject)list.get(index);
                } else {
                    Object value = eObject.eGet(eStructuralFeature);
                    if (value == null) {
                        if (!((EReference)eStructuralFeature).isContainment()) {
                            throw new IllegalArgumentException(String.valueOf(propertyName));
                        }
                        value = EcoreUtil.create((EClass)eClass);
                        eObject.eSet(eStructuralFeature, value);
                    }
                    eObject = (EObject)value;
                }
            } else {
                if (newValue != null) {
                    if (eType instanceof EClass) {
                        EClass eClassType = (EClass)eType;
                        if (newValue instanceof List) {
                            Iterator j = ((List)newValue).iterator();
                            while (j.hasNext()) {
                                if (eClassType.isInstance(j.next())) continue;
                                throw new IllegalArgumentException(String.valueOf(newValue));
                            }
                        } else if (!eClassType.isInstance(newValue)) {
                            throw new IllegalArgumentException(String.valueOf(newValue));
                        }
                    } else if (eType instanceof EDataType) {
                        EDataType eDataType = (EDataType)eType;
                        EFactory eFactoryInstance = eDataType.getEPackage().getEFactoryInstance();
                        if (newValue instanceof List) {
                            newValue = new ArrayList((List)newValue);
                            if (eDataType instanceof EEnum) {
                                EEnum eEnum = (EEnum)eDataType;
                                ListIterator<Enumerator> li = ((List)newValue).listIterator();
                                while (li.hasNext()) {
                                    Object item = li.next();
                                    if (!(item instanceof EnumerationLiteral)) continue;
                                    li.set(eEnum.getEEnumLiteral(((EnumerationLiteral)item).getName()).getInstance());
                                }
                            }
                            ListIterator<Object> li = ((List)newValue).listIterator();
                            while (li.hasNext()) {
                                Object item = li.next();
                                if (!(item instanceof String)) continue;
                                try {
                                    li.set(eFactoryInstance.createFromString(eDataType, (String)item));
                                }
                                catch (Exception exception) {}
                            }
                        } else {
                            if (eDataType instanceof EEnum) {
                                EEnum eEnum = (EEnum)eDataType;
                                if (newValue instanceof EnumerationLiteral) {
                                    newValue = eEnum.getEEnumLiteral(((EnumerationLiteral)newValue).getName()).getInstance();
                                }
                            }
                            if (newValue instanceof String) {
                                try {
                                    newValue = eFactoryInstance.createFromString(eDataType, (String)newValue);
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                }
                if (newValue == null) {
                    newValue = eStructuralFeature.getDefaultValue();
                }
                if (eStructuralFeature.isMany()) {
                    if (index == -1) {
                        if (!(newValue instanceof List)) throw new IllegalArgumentException(String.valueOf(newValue));
                        eObject.eSet(eStructuralFeature, newValue);
                    } else {
                        list = (List)eObject.eGet(eStructuralFeature);
                        int j = list.size();
                        while (j < index) {
                            list.add(j, eStructuralFeature.getDefaultValue());
                            ++j;
                        }
                        if (index == list.size()) {
                            list.add(index, newValue);
                        } else {
                            list.set(index, newValue);
                        }
                    }
                } else {
                    eObject.eSet(eStructuralFeature, newValue);
                }
            }
            ++i;
        }
    }

    public static EAnnotation createEAnnotation(Element element, String source) {
        return ElementOperations.createEAnnotation((EModelElement)element, (String)source);
    }

    public static EList getRelationships(Element element) {
        return ElementOperations.getRelationships(element, UMLPackage.Literals.RELATIONSHIP);
    }

    public static EList getRelationships(Element element, EClass eClass) {
        UniqueEList.FastCompare relationships = new UniqueEList.FastCompare();
        Iterator nonNavigableInverseReferences = ElementOperations.getNonNavigableInverseReferences((EObject)element).iterator();
        while (nonNavigableInverseReferences.hasNext()) {
            Association association;
            EStructuralFeature.Setting setting = (EStructuralFeature.Setting)nonNavigableInverseReferences.next();
            EObject eObject = setting.getEObject();
            if (eClass.isInstance((Object)eObject)) {
                relationships.add((Object)eObject);
                continue;
            }
            if (!(eObject instanceof Property) || !eClass.isInstance((Object)(association = ((Property)eObject).getAssociation()))) continue;
            relationships.add((Object)association);
        }
        Iterator eAllReferences = element.eClass().getEAllReferences().iterator();
        while (eAllReferences.hasNext()) {
            EReference eReference = (EReference)eAllReferences.next();
            if (eReference.isDerived() || !element.eIsSet((EStructuralFeature)eReference)) continue;
            EClass eReferenceType = eReference.getEReferenceType();
            if (eClass.isSuperTypeOf(eReferenceType)) {
                if (eReference.isMany()) {
                    relationships.addAll((Collection)((List)element.eGet((EStructuralFeature)eReference)));
                    continue;
                }
                relationships.add(element.eGet((EStructuralFeature)eReference));
                continue;
            }
            if (!eReferenceType.isSuperTypeOf(eClass)) continue;
            Object value = element.eGet((EStructuralFeature)eReference);
            if (eReference.isMany()) {
                Iterator i = ((List)value).iterator();
                while (i.hasNext()) {
                    value = i.next();
                    if (!eClass.isInstance(value)) continue;
                    relationships.add(value);
                }
                continue;
            }
            if (!eClass.isInstance(value)) continue;
            relationships.add(value);
        }
        return ECollections.unmodifiableEList((EList)relationships);
    }

    public static EList getSourceDirectedRelationships(Element element) {
        return ElementOperations.getSourceDirectedRelationships(element, UMLPackage.Literals.DIRECTED_RELATIONSHIP);
    }

    public static EList getSourceDirectedRelationships(Element element, EClass eClass) {
        UniqueEList.FastCompare sourceDirectedRelationships = new UniqueEList.FastCompare();
        Iterator directedRelationships = ElementOperations.getRelationships(element, eClass).iterator();
        while (directedRelationships.hasNext()) {
            DirectedRelationship directedRelationship = (DirectedRelationship)directedRelationships.next();
            if (!directedRelationship.getSources().contains((Object)element)) continue;
            sourceDirectedRelationships.add((Object)directedRelationship);
        }
        return ECollections.unmodifiableEList((EList)sourceDirectedRelationships);
    }

    public static EList getTargetDirectedRelationships(Element element) {
        return ElementOperations.getTargetDirectedRelationships(element, UMLPackage.Literals.DIRECTED_RELATIONSHIP);
    }

    public static EList getTargetDirectedRelationships(Element element, EClass eClass) {
        UniqueEList.FastCompare targetDirectedRelationships = new UniqueEList.FastCompare();
        Iterator directedRelationships = ElementOperations.getRelationships(element, eClass).iterator();
        while (directedRelationships.hasNext()) {
            DirectedRelationship directedRelationship = (DirectedRelationship)directedRelationships.next();
            if (!directedRelationship.getTargets().contains((Object)element)) continue;
            targetDirectedRelationships.add((Object)directedRelationship);
        }
        return ECollections.unmodifiableEList((EList)targetDirectedRelationships);
    }

    public static EList getKeywords(Element element) {
        EMap details;
        EAnnotation eAnnotation = element.getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML");
        if (eAnnotation != null && !(details = eAnnotation.getDetails()).isEmpty()) {
            UniqueEList keywords = new UniqueEList();
            Iterator d = details.iterator();
            while (d.hasNext()) {
                keywords.add(((Map.Entry)d.next()).getKey());
            }
            return ECollections.unmodifiableEList((EList)keywords);
        }
        return ECollections.EMPTY_ELIST;
    }

    public static boolean addKeyword(Element element, String keyword) {
        EMap details = ElementOperations.getEAnnotation((EModelElement)element, (String)"http://www.eclipse.org/uml2/2.0.0/UML", (boolean)true).getDetails();
        if (!details.containsKey((Object)keyword)) {
            details.put((Object)keyword, null);
            return true;
        }
        return false;
    }

    public static boolean removeKeyword(Element element, String keyword) {
        EMap details;
        EAnnotation eAnnotation = element.getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML");
        if (eAnnotation != null && (details = eAnnotation.getDetails()).containsKey((Object)keyword)) {
            details.removeKey((Object)keyword);
            return true;
        }
        return false;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    protected static Element getOwningElement(Element element, EClass eClass, boolean resolve) {
        Element owningElement;
        block3: {
            Element owner;
            block2: {
                owningElement = null;
                owner = element;
                if (!true) break block2;
                owningElement = (Element)owner.eGet((EStructuralFeature)UMLPackage.Literals.ELEMENT__OWNER, resolve);
                if ((owningElement == null ? (owner = (owningElement = ElementOperations.getBaseElement(owner.eContainer()))) : owningElement) == null || eClass.isInstance((Object)owningElement)) break block3;
            }
            do {
                owner = owner.getOwner();
                owningElement = (Element)owner.eGet((EStructuralFeature)UMLPackage.Literals.ELEMENT__OWNER, resolve);
            } while ((owningElement == null ? (owner = (owningElement = ElementOperations.getBaseElement(owner.eContainer()))) : owningElement) != null && !eClass.isInstance((Object)owningElement));
        }
        return owningElement;
    }

    public static Package getNearestPackage(Element element) {
        return (Package)(element instanceof Package ? element : ElementOperations.getOwningElement(element, UMLPackage.Literals.PACKAGE, true));
    }

    public static Model getModel(Element element) {
        return (Model)(element instanceof Model ? element : ElementOperations.getOwningElement(element, UMLPackage.Literals.MODEL, true));
    }

    protected static Extension getExtension(Element element, Stereotype stereotype) {
        Iterator allAttributes = stereotype.getAllAttributes().iterator();
        while (allAttributes.hasNext()) {
            EClassifier eClassifier;
            Type type;
            String name;
            Property attribute = (Property)allAttributes.next();
            Association association = attribute.getAssociation();
            if (!(association instanceof Extension) || ElementOperations.isEmpty((String)(name = attribute.getName())) || !name.startsWith("base_") || !((type = attribute.getType()) instanceof Class) || (eClassifier = ElementOperations.getEClassifier((Class)type)) == null || !eClassifier.isInstance((Object)element)) continue;
            return (Extension)association;
        }
        return null;
    }

    protected static EClass getDefinition(Element element, Stereotype stereotype) {
        EClass eClass;
        ENamedElement appliedDefinition;
        ProfileApplication profileApplication;
        Package package_;
        Profile profile;
        if (stereotype != null && (profile = stereotype.getProfile()) != null && (package_ = element.getNearestPackage()) != null && (profileApplication = package_.getProfileApplication(profile, true)) != null && (appliedDefinition = profileApplication.getAppliedDefinition(stereotype)) instanceof EClass && !(eClass = (EClass)appliedDefinition).isAbstract()) {
            return eClass;
        }
        return null;
    }

    public static boolean isStereotypeApplicable(Element element, Stereotype stereotype) {
        return ElementOperations.getDefinition(element, stereotype) != null && ElementOperations.getExtension(element, stereotype) != null;
    }

    public static boolean isStereotypeRequired(Element element, Stereotype stereotype) {
        if (ElementOperations.getDefinition(element, stereotype) != null) {
            Extension extension = ElementOperations.getExtension(element, stereotype);
            return extension != null && extension.isRequired();
        }
        return false;
    }

    public static boolean isStereotypeApplied(Element element, Stereotype stereotype) {
        return element.getStereotypeApplication(stereotype) != null;
    }

    protected static EList applyAllStereotypes(Element element, Map definitions, EList stereotypeApplications) {
        if (!element.eIsProxy()) {
            Iterator stereotypeEntries = definitions.entrySet().iterator();
            while (stereotypeEntries.hasNext()) {
                Map.Entry stereotypeEntry = stereotypeEntries.next();
                if (!((EClassifier)stereotypeEntry.getKey()).isInstance((Object)element)) continue;
                Iterator definitionEntries = ((Map)stereotypeEntry.getValue()).entrySet().iterator();
                while (definitionEntries.hasNext()) {
                    Map.Entry definitionEntry = definitionEntries.next();
                    if (element.isStereotypeApplied((Stereotype)definitionEntry.getKey())) continue;
                    stereotypeApplications.add((Object)ElementOperations.applyStereotype(element, (EClass)definitionEntry.getValue()));
                }
            }
        }
        return stereotypeApplications;
    }

    protected static EList applyAllStereotypes(Element element, Map definitions, boolean resolve) {
        UniqueEList.FastCompare stereotypeApplications = new UniqueEList.FastCompare();
        ElementOperations.applyAllStereotypes(element, definitions, (EList)stereotypeApplications);
        if (!element.eContents().isEmpty()) {
            TreeIterator allContents = EcoreUtil.getAllContents((EObject)element, (boolean)resolve);
            while (allContents.hasNext()) {
                EObject eObject = (EObject)allContents.next();
                if (!(eObject instanceof Element)) continue;
                ElementOperations.applyAllStereotypes((Element)eObject, definitions, (EList)stereotypeApplications);
            }
        }
        return stereotypeApplications;
    }

    public static EList applyAllRequiredStereotypes(Element element) {
        return ElementOperations.applyAllRequiredStereotypes(element, true);
    }

    public static EList applyAllRequiredStereotypes(Element element, boolean resolve) {
        Package package_ = element.getNearestPackage();
        if (package_ != null) {
            HashMap<EClassifier, HashMap<Stereotype, ENamedElement>> definitions = new HashMap<EClassifier, HashMap<Stereotype, ENamedElement>>();
            Iterator allProfileApplications = package_.getAllProfileApplications().iterator();
            while (allProfileApplications.hasNext()) {
                ProfileApplication profileApplication = (ProfileApplication)allProfileApplications.next();
                Profile appliedProfile = profileApplication.getAppliedProfile();
                if (appliedProfile == null) continue;
                Iterator ownedExtensions = appliedProfile.getOwnedExtensions(true).iterator();
                while (ownedExtensions.hasNext()) {
                    ENamedElement appliedDefinition;
                    Stereotype stereotype;
                    EClassifier eClassifier;
                    Extension ownedExtension = (Extension)ownedExtensions.next();
                    Class metaclass = ownedExtension.getMetaclass();
                    if (metaclass == null || (eClassifier = ElementOperations.getEClassifier(metaclass)) == null || (stereotype = ownedExtension.getStereotype()) == null || !((appliedDefinition = profileApplication.getAppliedDefinition(stereotype)) instanceof EClass) || ((EClass)appliedDefinition).isAbstract()) continue;
                    HashMap<Stereotype, ENamedElement> stereotypes = (HashMap<Stereotype, ENamedElement>)definitions.get(eClassifier);
                    if (stereotypes == null) {
                        stereotypes = new HashMap<Stereotype, ENamedElement>();
                        definitions.put(eClassifier, stereotypes);
                    }
                    if (stereotypes.containsKey(stereotype)) continue;
                    stereotypes.put(stereotype, appliedDefinition);
                }
            }
            if (!definitions.isEmpty()) {
                return ElementOperations.applyAllStereotypes(element, definitions, resolve);
            }
        }
        return ECollections.EMPTY_ELIST;
    }

    public static EObject applyStereotype(Element element, Stereotype stereotype) {
        EClass definition = ElementOperations.getDefinition(element, stereotype);
        if (definition == null || ElementOperations.getExtension(element, stereotype) == null || element.getStereotypeApplication(stereotype) != null) {
            throw new IllegalArgumentException(String.valueOf(stereotype));
        }
        return ElementOperations.applyStereotype(element, definition);
    }

    protected static EList unapplyAllNonApplicableStereotypes(Element element, EList nonApplicableStereotypes) {
        if (!element.eIsProxy()) {
            Iterator sa = element.getStereotypeApplications().iterator();
            while (sa.hasNext()) {
                EObject stereotypeApplication = (EObject)sa.next();
                if (element.isStereotypeApplicable(ElementOperations.getStereotype(stereotypeApplication))) continue;
                nonApplicableStereotypes.add((Object)stereotypeApplication);
                ElementOperations.destroy(stereotypeApplication);
            }
        }
        return nonApplicableStereotypes;
    }

    public static EList unapplyAllNonApplicableStereotypes(Element element) {
        return ElementOperations.unapplyAllNonApplicableStereotypes(element, true);
    }

    public static EList unapplyAllNonApplicableStereotypes(Element element, boolean resolve) {
        UniqueEList.FastCompare nonApplicableStereotypes = new UniqueEList.FastCompare();
        ElementOperations.unapplyAllNonApplicableStereotypes(element, (EList)nonApplicableStereotypes);
        if (!element.eContents().isEmpty()) {
            TreeIterator allContents = EcoreUtil.getAllContents((EObject)element, (boolean)resolve);
            while (allContents.hasNext()) {
                EObject eObject = (EObject)allContents.next();
                if (!(eObject instanceof Element)) continue;
                ElementOperations.unapplyAllNonApplicableStereotypes((Element)eObject, (EList)nonApplicableStereotypes);
            }
        }
        return nonApplicableStereotypes;
    }

    public static EObject unapplyStereotype(Element element, Stereotype stereotype) {
        if (stereotype == null || element.isStereotypeRequired(stereotype)) {
            throw new IllegalArgumentException(String.valueOf(stereotype));
        }
        EObject stereotypeApplication = element.getStereotypeApplication(stereotype);
        if (stereotypeApplication == null) {
            throw new IllegalArgumentException(String.valueOf(stereotype));
        }
        ElementOperations.destroy(stereotypeApplication);
        return stereotypeApplication;
    }

    public static EList getApplicableStereotypes(Element element) {
        Package package_ = element.getNearestPackage();
        if (package_ != null) {
            UniqueEList.FastCompare applicableStereotypes = new UniqueEList.FastCompare();
            Iterator allProfileApplications = package_.getAllProfileApplications().iterator();
            while (allProfileApplications.hasNext()) {
                ProfileApplication profileApplication = (ProfileApplication)allProfileApplications.next();
                Profile appliedProfile = profileApplication.getAppliedProfile();
                if (appliedProfile == null) continue;
                Iterator ownedStereotypes = appliedProfile.getOwnedStereotypes().iterator();
                while (ownedStereotypes.hasNext()) {
                    Stereotype stereotype = (Stereotype)ownedStereotypes.next();
                    ENamedElement appliedDefinition = profileApplication.getAppliedDefinition(stereotype);
                    if (!(appliedDefinition instanceof EClass) || ((EClass)appliedDefinition).isAbstract() || ElementOperations.getExtension(element, stereotype) == null) continue;
                    applicableStereotypes.add((Object)stereotype);
                }
            }
            return ECollections.unmodifiableEList((EList)applicableStereotypes);
        }
        return ECollections.EMPTY_ELIST;
    }

    public static Stereotype getApplicableStereotype(Element element, String qualifiedName) {
        Iterator applicableStereotypes = element.getApplicableStereotypes().iterator();
        while (applicableStereotypes.hasNext()) {
            Stereotype applicableStereotype = (Stereotype)applicableStereotypes.next();
            if (!ElementOperations.safeEquals((Object)applicableStereotype.getQualifiedName(), (Object)qualifiedName)) continue;
            return applicableStereotype;
        }
        return null;
    }

    public static boolean hasKeyword(Element element, String keyword) {
        EAnnotation eAnnotation = element.getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML");
        return eAnnotation != null && eAnnotation.getDetails().containsKey((Object)keyword);
    }

    public static void destroy(Element element) {
        ElementOperations.destroy((EObject)element);
    }

    protected static void destroy(EObject ancestorEObject) {
        if (ancestorEObject.eContents().isEmpty()) {
            if (ancestorEObject instanceof Element) {
                ElementOperations.destroyAll((Collection)((Element)ancestorEObject).getStereotypeApplications());
                ElementOperations.removeReferences((EObject)ancestorEObject, (EObject)ancestorEObject);
                ancestorEObject.eAdapters().clear();
            } else {
                ElementOperations.removeReferences((EObject)ancestorEObject, null);
            }
        } else {
            Object object;
            TreeIterator allContents = ElementOperations.getAllContents((EObject)ancestorEObject, (boolean)true, (boolean)false);
            while (allContents.hasNext()) {
                object = allContents.next();
                if (!(object instanceof Element)) continue;
                ElementOperations.destroyAll((Collection)((Element)object).getStereotypeApplications());
            }
            allContents = ElementOperations.getAllContents((EObject)ancestorEObject, (boolean)true, (boolean)false);
            while (allContents.hasNext()) {
                EObject eObject = (EObject)allContents.next();
                if (eObject instanceof Element) {
                    ElementOperations.removeReferences((EObject)eObject, (EObject)ancestorEObject);
                    continue;
                }
                ElementOperations.removeReferences((EObject)eObject, null);
            }
            allContents = ElementOperations.getAllContents((EObject)ancestorEObject, (boolean)true, (boolean)false);
            while (allContents.hasNext()) {
                object = allContents.next();
                if (!(object instanceof Element)) continue;
                ((Element)object).eAdapters().clear();
            }
        }
        EcoreUtil.remove((EObject)ancestorEObject);
    }

    protected static void destroyAll(Collection eObjects) {
        Iterator o = eObjects.iterator();
        while (o.hasNext()) {
            ElementOperations.destroy((EObject)o.next());
        }
    }

    protected static EList allOwnedElements(Element element, EList allOwnedElements) {
        Iterator ownedElements = element.getOwnedElements().iterator();
        while (ownedElements.hasNext()) {
            Element ownedElement = (Element)ownedElements.next();
            if (!allOwnedElements.add((Object)ownedElement)) continue;
            ElementOperations.allOwnedElements(ownedElement, allOwnedElements);
        }
        return allOwnedElements;
    }

    public static EList allOwnedElements(Element element) {
        return ECollections.unmodifiableEList((EList)ElementOperations.allOwnedElements(element, (EList)new UniqueEList.FastCompare()));
    }

    public static boolean mustBeOwned(Element element) {
        return true;
    }
}

