/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.am3.ui.action;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.am3.core.AM3CorePlugin;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.m2m.atl.engine.vm.nativelib.AMN;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSequence;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;

public class ActionANTTransformationBasedOnRelation
extends Action {
    private ASMModelElement antTransformation;
    private String fileUri;
    private ASMModelElement relation;
    private Map mapProperties = new HashMap();

    public ActionANTTransformationBasedOnRelation(String text, ASMModelElement antTransformation, ASMModelElement relation, String fileUri) {
        super(text);
        this.antTransformation = antTransformation;
        this.fileUri = fileUri;
        this.relation = relation;
    }

    private void addPropertiesForThisArtifact(ASMModelElement currentArtifact, ASMModelElement antParameter) {
        Iterator it = AMN.getCol((ASMModelElement)antParameter, (String)"properties");
        while (it.hasNext()) {
            ASMModelElement property = AMN.nextME((Iterator)it);
            ASMString correspondingAttribute = (ASMString)property.get(null, "correspondingAttribute");
            ASMOclAny attributeValue = currentArtifact.get(null, correspondingAttribute.getSymbol());
            if (attributeValue instanceof ASMString) {
                this.mapProperties.put(AMN.getString((ASMModelElement)property, (String)"propertyName"), ((ASMString)attributeValue).getSymbol());
                continue;
            }
            System.err.println("Only string type is allowed for ANT property");
        }
    }

    public void run() {
        Job job = new Job("ANTTransformationBasedOnRelation"){

            public IStatus run(IProgressMonitor mon) {
                ASMModelElement currentArtifact;
                Status ret = null;
                mon.beginTask("ANT Transformation based on relation", -1);
                mon.subTask("Init ANT properties");
                HashMap<String, ASMModel> models = new HashMap<String, ASMModel>();
                models.put("AM3", AM3CorePlugin.getDefault().getHandler().getAsmModelAM3());
                models.put("mgm", AM3CorePlugin.getDefault().getHandler().getAsmModelMegamodel());
                HashMap<String, ASMModelElement> relationArtifacts = new HashMap<String, ASMModelElement>();
                Iterator it = AMN.getCol((ASMModelElement)ActionANTTransformationBasedOnRelation.this.relation, (String)"relationEnds");
                while (it.hasNext()) {
                    currentArtifact = AMN.getME((ASMModelElement)AMN.nextME((Iterator)it), (String)"artifact");
                    if (AMN.getString((ASMModelElement)currentArtifact, (String)"uri").equals(ActionANTTransformationBasedOnRelation.this.fileUri)) {
                        relationArtifacts.put("#context", currentArtifact);
                        continue;
                    }
                    relationArtifacts.put(AMN.getTypeName((ASMModelElement)currentArtifact), currentArtifact);
                }
                ASMModelElement context = AMN.getME((ASMModelElement)ActionANTTransformationBasedOnRelation.this.antTransformation, (String)"context");
                currentArtifact = (ASMModelElement)relationArtifacts.get("#context");
                ActionANTTransformationBasedOnRelation.this.addPropertiesForThisArtifact(currentArtifact, context);
                ASMSequence parameters = (ASMSequence)ActionANTTransformationBasedOnRelation.this.antTransformation.get(null, "parameters");
                Iterator it2 = parameters.iterator();
                while (it2.hasNext()) {
                    ASMModelElement me = (ASMModelElement)it2.next();
                    currentArtifact = (ASMModelElement)relationArtifacts.get(AMN.getString((ASMModelElement)me, (String)"type"));
                    ActionANTTransformationBasedOnRelation.this.addPropertiesForThisArtifact(currentArtifact, me);
                }
                AntRunner runner = new AntRunner();
                ASMString uriTransformation = (ASMString)ActionANTTransformationBasedOnRelation.this.antTransformation.get(null, "uri");
                IWorkspace wks = ResourcesPlugin.getWorkspace();
                IWorkspaceRoot wksroot = wks.getRoot();
                IFile currentAntFile = wksroot.getFile((IPath)new Path(uriTransformation.getSymbol()));
                runner.setBuildFileLocation(currentAntFile.getLocation().toOSString());
                runner.addUserProperties(ActionANTTransformationBasedOnRelation.this.mapProperties);
                runner.addBuildLogger("org.apache.tools.ant.DefaultLogger");
                try {
                    mon.subTask("ANT script execution");
                    runner.run(mon);
                    ret = new Status(0, "org.eclipse.am3.tools.ant", 0, "Execution terminated", null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return ret;
            }
        };
        job.setPriority(40);
        job.schedule();
    }
}

