/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.cs2as.compiler.tests;

import example1.source.SourcePackage;
import example1.target.TargetPackage;
import example2.classes.ClassesPackage;
import example2.classes.lookup.EnvironmentPackage;
import example2.classescs.ClassescsPackage;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.qvtd.compiler.AbstractCompilerChain;
import org.eclipse.qvtd.compiler.AbstractCompilerOptions;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.CompilerOptions;
import org.eclipse.qvtd.compiler.DefaultCompilerOptions;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.EarlyMerger;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.LateConsumerMerger;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TransformationPartitioner;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.cs2as.compiler.CS2ASJavaCompilerParameters;
import org.eclipse.qvtd.cs2as.compiler.internal.CS2ASJavaCompilerImpl;
import org.eclipse.qvtd.cs2as.compiler.internal.CS2ASJavaCompilerParametersImpl;
import org.eclipse.qvtd.cs2as.compiler.internal.OCL2QVTiCompilerChain;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbase;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiIncrementalExecutor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiTransformationExecutor;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperative;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduleModel;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduledRegion;
import org.eclipse.qvtd.pivot.qvtschedule.impl.MicroMappingRegionImpl;
import org.eclipse.qvtd.pivot.qvtschedule.impl.RuleRegionImpl;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;
import org.eclipse.qvtd.runtime.evaluation.Transformer;
import org.eclipse.qvtd.xtext.qvtbase.tests.LoadTestCase;
import org.eclipse.qvtd.xtext.qvtbase.tests.utilities.XtextCompilerUtil;
import org.eclipse.xtext.resource.XtextResource;
import org.junit.After;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class OCL2QVTiTestCases
extends LoadTestCase {
    private static boolean NO_MERGES = true;

    protected @NonNull CompilerOptions createCompilerOptions() {
        return new AbstractCompilerOptions(){};
    }

    private @NonNull CS2ASJavaCompilerParameters createParameters(@NonNull String lookupSolverClassName, @NonNull String lookupResultClassName) {
        CS2ASJavaCompilerParametersImpl cgParams = new CS2ASJavaCompilerParametersImpl(lookupSolverClassName, lookupResultClassName, this.getTestProject().getOutputFile("test-src").getFileString());
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            for (String projectName : CompilerUtil.createClasspathProjectNameList((String[])new String[]{this.getTestBundleName()})) {
                cgParams.addClassPathProjectName(projectName);
            }
        }
        cgParams.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        return cgParams;
    }

    private @NonNull MyQVT createQVT(@NonNull String modelTestName, @NonNull String modelSamples) throws Exception {
        return new MyQVT(this.getTestProjectManager(), modelTestName, modelSamples);
    }

    @Before
    public void setUp() throws Exception {
        QVTm2QVTs.DEBUG_GRAPHS.setState(true);
        super.setUp();
        XtextCompilerUtil.doQVTimperativeSetup();
        XtextCompilerUtil.doQVTcoreSetup();
        TestUtil.doCompleteOCLSetup();
    }

    @After
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testOCL2QVTi_Source2Target_CG() throws Exception {
        MyQVT myQVT = this.createQVT("Source2Target", "samples");
        myQVT.loadGenModels("SourceMM1.genmodel", "TargetMM1.genmodel");
        myQVT.loadEcoreFile("EnvExample1.ecore", (EPackage)example1.target.lookup.EnvironmentPackage.eINSTANCE);
        ImperativeTransformation qvtiTransf = myQVT.executeOCL2QVTi_CompilerChain("Source2Target.ocl", new String[0]);
        myQVT.assertRegionCount(RuleRegionImpl.class, NO_MERGES ? 23 : 19);
        myQVT.assertRegionCount(EarlyMerger.EarlyMergedMappingRegion.class, NO_MERGES ? 0 : 2);
        myQVT.assertRegionCount(LateConsumerMerger.LateMergedMappingRegion.class, NO_MERGES ? 0 : 0);
        myQVT.assertRegionCount(MicroMappingRegionImpl.class, 0);
        CS2ASJavaCompilerParameters cgParams = this.createParameters("example1.target.lookup.util.TargetLookupSolver", "example1.target.lookup.util.TargetLookupResult");
        java.lang.Class txClass = new CS2ASJavaCompilerImpl().compileTransformation((QVTimperative)myQVT, (Transformation)qvtiTransf, cgParams);
        myQVT.executeModelsTX_CG(txClass, "model1");
        myQVT.executeModelsTX_CG(txClass, "model2");
        myQVT.executeModelsTX_CG(txClass, "model3");
        myQVT.dispose();
        EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example1/sourceMM/1.0");
        EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example1/targetMM/1.0");
    }

    @Test
    public void testOCL2QVTi_Source2Target_Interpreted() throws Exception {
        testCaseAppender.uninstall();
        MyQVT myQVT = this.createQVT("Source2Target", "samples");
        try {
            myQVT.loadGenModels("SourceMM1.genmodel", "TargetMM1.genmodel");
            ImperativeTransformation qvtiTransf = myQVT.executeOCL2QVTi_CompilerChain("Source2Target.ocl", new String[0]);
            URI txURI = qvtiTransf.eResource().getURI();
            myQVT.dispose();
            myQVT = this.createQVT("Source2Target", "samples");
            myQVT.loadEcoreFile("SourceMM1.ecore", (EPackage)SourcePackage.eINSTANCE);
            myQVT.loadEcoreFile("TargetMM1.ecore", (EPackage)TargetPackage.eINSTANCE);
            ImperativeTransformation tx = this.getTransformation(myQVT.getMetamodelManager().getASResourceSet(), txURI);
            myQVT.executeModelsTX_Interpreted(tx, "model1");
            myQVT.executeModelsTX_Interpreted(tx, "model2");
            myQVT.executeModelsTX_Interpreted(tx, "model3");
        }
        finally {
            myQVT.dispose();
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example1/sourceMM/1.0");
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example1/targetMM/1.0");
        }
    }

    @Test
    public void testOCL2QVTi_Source2Target_OCL2QVTm() throws Exception {
        MyQVT myQVT = this.createQVT("Source2Target", "samples");
        URI oclDocURI = this.getModelsURI("Source2Target/Source2Target.ocl");
        URI qvtmFileURI = this.getTestURI("Source2Target.qvtm.qvtcas");
        OCL2QVTiCompilerChain mtc = new OCL2QVTiCompilerChain((QVTimperative)myQVT, this.createCompilerOptions(), oclDocURI, this.getTestURIWithExtension(oclDocURI, "tmp"), new URI[0]);
        mtc.ocl2qvtmCompilerStep.ocl2qvtm(oclDocURI.appendFileExtension("oclas"));
        OCL2QVTiTestCases.assertValidQVTiModel(qvtmFileURI);
        myQVT.dispose();
    }

    @Test
    public void testOCL2QVTi_SimpleClasses_CG() throws Exception {
        TransformationPartitioner.CYCLES.setState(true);
        MyQVT myQVT = this.createQVT("SimpleClasses", "samples");
        try {
            myQVT.loadGenModels("ClassesCS.genmodel", "Classes.genmodel");
            myQVT.loadEcoreFile("EnvExample2.ecore", (EPackage)EnvironmentPackage.eINSTANCE);
            ImperativeTransformation qvtiTransf = myQVT.executeOCL2QVTi_CompilerChain("classescs2as.ocl", new String[0]);
            myQVT.assertRegionCount(RuleRegionImpl.class, NO_MERGES ? 9 : 3);
            myQVT.assertRegionCount(EarlyMerger.EarlyMergedMappingRegion.class, NO_MERGES ? 0 : 2);
            myQVT.assertRegionCount(LateConsumerMerger.LateMergedMappingRegion.class, NO_MERGES ? 0 : 1);
            myQVT.assertRegionCount(MicroMappingRegionImpl.class, 0);
            CS2ASJavaCompilerParameters cgParams = this.createParameters("example2.classes.lookup.util.ClassesLookupSolver", "example2.classes.lookup.util.ClassesLookupResult");
            java.lang.Class txClass = new CS2ASJavaCompilerImpl().compileTransformation((QVTimperative)myQVT, (Transformation)qvtiTransf, cgParams);
            myQVT.executeModelsTX_CG(txClass, "model1");
            myQVT.executeModelsTX_CG(txClass, "model2");
            myQVT.executeModelsTX_CG(txClass, "model3");
            myQVT.executeModelsTX_CG(txClass, "model4");
            myQVT.executeModelsTX_CG(txClass, "model5");
            myQVT.executeModelsTX_CG(txClass, "model6");
            myQVT.executeModelsTX_CG(txClass, "model7");
        }
        finally {
            myQVT.dispose();
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example2/classes/1.0");
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example2/classescs/1.0");
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example2/classescs2as/1.0");
        }
    }

    @Test
    public void testOCL2QVTi_SimpleClasses_Interpreted() throws Exception {
        testCaseAppender.uninstall();
        MyQVT myQVT = this.createQVT("SimpleClasses", "samples");
        myQVT.loadGenModels("ClassesCS.genmodel", "Classes.genmodel");
        ImperativeTransformation qvtiTransf = myQVT.executeOCL2QVTi_CompilerChain("classescs2as.ocl", new String[0]);
        URI txURI = qvtiTransf.eResource().getURI();
        myQVT.dispose();
        myQVT = this.createQVT("SimpleClasses", "samples");
        myQVT.loadEcoreFile("ClassesCS.ecore", (EPackage)ClassescsPackage.eINSTANCE);
        myQVT.loadEcoreFile("Classes.ecore", (EPackage)ClassesPackage.eINSTANCE);
        ImperativeTransformation tx = this.getTransformation(myQVT.getMetamodelManager().getASResourceSet(), txURI);
        myQVT.executeModelsTX_Interpreted(tx, "model1");
        myQVT.executeModelsTX_Interpreted(tx, "model2");
        myQVT.executeModelsTX_Interpreted(tx, "model3");
        myQVT.dispose();
    }

    @Test
    public void testOCL2QVTi_StructuredClasses_CG() throws Exception {
        MyQVT myQVT = this.createQVT("StructuredClasses", "samples");
        try {
            myQVT.loadGenModels(this.getModelsURI("SimpleClasses/ClassesCS.genmodel"), this.getModelsURI("SimpleClasses/Classes.genmodel"));
            ImperativeTransformation qvtiTransf = myQVT.executeOCL2QVTi_CompilerChain("classescs2asV2.ocl", new String[0]);
            myQVT.assertRegionCount(RuleRegionImpl.class, NO_MERGES ? 30 : 15);
            myQVT.assertRegionCount(EarlyMerger.EarlyMergedMappingRegion.class, NO_MERGES ? 0 : 5);
            myQVT.assertRegionCount(LateConsumerMerger.LateMergedMappingRegion.class, NO_MERGES ? 0 : 2);
            myQVT.assertRegionCount(MicroMappingRegionImpl.class, 0);
            CS2ASJavaCompilerParameters cgParams = this.createParameters("example2.classes.lookup.util.ClassesLookupSolver", "example2.classes.lookup.util.ClassesLookupResult");
            java.lang.Class txClass = new CS2ASJavaCompilerImpl().compileTransformation((QVTimperative)myQVT, (Transformation)qvtiTransf, cgParams);
            myQVT.dispose();
            myQVT = this.createQVT("StructuredClasses", "samples");
            myQVT.loadEcoreFile(this.getModelsURI("SimpleClasses/ClassesCS.ecore"), (EPackage)ClassescsPackage.eINSTANCE);
            myQVT.loadEcoreFile(this.getModelsURI("SimpleClasses/Classes.ecore"), (EPackage)ClassesPackage.eINSTANCE);
            myQVT.executeModelsTX_CG(txClass, "model1V2");
            myQVT.executeModelsTX_CG(txClass, "model2V2");
            myQVT.executeModelsTX_CG(txClass, "model3V2");
            myQVT.executeModelsTX_CG(txClass, "model4V2");
        }
        finally {
            myQVT.dispose();
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example2/classes/1.0");
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example2/classescs/1.0");
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example2/classescs2as/1.0");
        }
    }

    @Test
    public void testOCL2QVTi_StructuredClasses_Interpreted() throws Exception {
        testCaseAppender.uninstall();
        MyQVT myQVT = this.createQVT("StructuredClasses", "samples");
        try {
            myQVT.loadGenModels(this.getModelsURI("SimpleClasses/ClassesCS.genmodel"), this.getModelsURI("SimpleClasses/Classes.genmodel"));
            ImperativeTransformation qvtiTransf = myQVT.executeOCL2QVTi_CompilerChain("classescs2asV2.ocl", new String[0]);
            URI txURI = qvtiTransf.eResource().getURI();
            myQVT.dispose();
            myQVT = this.createQVT("StructuredClasses", "samples");
            myQVT.loadEcoreFile(this.getModelsURI("SimpleClasses/ClassesCS.ecore"), (EPackage)ClassescsPackage.eINSTANCE);
            myQVT.loadEcoreFile(this.getModelsURI("SimpleClasses/Classes.ecore"), (EPackage)ClassesPackage.eINSTANCE);
            ImperativeTransformation tx = this.getTransformation(myQVT.getMetamodelManager().getASResourceSet(), txURI);
            myQVT.executeModelsTX_Interpreted(tx, "model1V2");
            myQVT.executeModelsTX_Interpreted(tx, "model2V2");
            myQVT.executeModelsTX_Interpreted(tx, "model3V2");
            myQVT.executeModelsTX_Interpreted(tx, "model4V2");
        }
        finally {
            myQVT.dispose();
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example2/classes/1.0");
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example2/classescs/1.0");
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example2/classescs2as/1.0");
        }
    }

    @Test
    public void testOCL2QVTi_SimpleClasses_OCL2QVTm_MiddleFolded() throws Exception {
        MyQVT myQVT = this.createQVT("SimpleClasses", "samples");
        URI oclDocURI = this.getModelsURI("SimpleClasses/classescs2as.ocl");
        URI qvtmFileURI = this.getTestURI("classescs2as.qvtm.qvtcas");
        OCL2QVTiCompilerChain mtc = new OCL2QVTiCompilerChain((QVTimperative)myQVT, this.createCompilerOptions(), oclDocURI, this.getTestURIWithExtension(oclDocURI, "tmp"), new URI[0]);
        mtc.ocl2qvtmCompilerStep.ocl2qvtm(oclDocURI.appendFileExtension("oclas"));
        OCL2QVTiTestCases.assertValidQVTiModel(qvtmFileURI);
        myQVT.dispose();
    }

    @Test
    public void testOCL2QVTi_KiamaRewrite_CG() throws Exception {
        TransformationPartitioner.CYCLES.setState(true);
        TransformationPartitioner.PREDECESSORS.setState(true);
        TransformationPartitioner.SUCCESSORS.setState(true);
        MyQVT myQVT = this.createQVT("KiamaRewrite", "samples");
        myQVT.loadGenModels("KiamaAS.genmodel", "KiamaCS.genmodel");
        ImperativeTransformation qvtiTransf = myQVT.executeOCL2QVTi_CompilerChain("KiamaRewrite.ocl", new String[0]);
        myQVT.assertRegionCount(RuleRegionImpl.class, NO_MERGES ? 11 : 6);
        myQVT.assertRegionCount(EarlyMerger.EarlyMergedMappingRegion.class, NO_MERGES ? 0 : 1);
        myQVT.assertRegionCount(LateConsumerMerger.LateMergedMappingRegion.class, NO_MERGES ? 0 : 1);
        myQVT.assertRegionCount(MicroMappingRegionImpl.class, 0);
        CS2ASJavaCompilerParameters cgParams = this.createParameters("", "");
        java.lang.Class txClass = new CS2ASJavaCompilerImpl().compileTransformation((QVTimperative)myQVT, (Transformation)qvtiTransf, cgParams);
        myQVT.executeModelsTX_CG(txClass, "model1");
        myQVT.dispose();
        EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example3/kiamaas/1.0");
        EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example3/kiamacs/1.0");
    }

    @Test
    public void testOCL2QVTi_KiamaRewrite_Interpreted() throws Exception {
        MyQVT myQVT = this.createQVT("KiamaRewrite", "samples");
        myQVT.loadGenModels("KiamaAS.genmodel", "KiamaCS.genmodel");
        ImperativeTransformation tx = myQVT.executeOCL2QVTi_CompilerChain("KiamaRewrite.ocl", new String[0]);
        myQVT.executeModelsTX_Interpreted(tx, "model1");
        myQVT.dispose();
    }

    @Test
    public void testOCL2QVTi_SimplerKiama_CG() throws Exception {
        MyQVT myQVT = this.createQVT("SimplerKiama", "samples");
        myQVT.loadGenModels("SimplerKiamaAS.genmodel", "SimplerKiamaCS.genmodel");
        ImperativeTransformation qvtiTransf = myQVT.executeOCL2QVTi_CompilerChain("SimplerKiama.ocl", new String[0]);
        myQVT.assertRegionCount(RuleRegionImpl.class, NO_MERGES ? 9 : 7);
        myQVT.assertRegionCount(EarlyMerger.EarlyMergedMappingRegion.class, NO_MERGES ? 0 : 1);
        myQVT.assertRegionCount(LateConsumerMerger.LateMergedMappingRegion.class, NO_MERGES ? 0 : 0);
        myQVT.assertRegionCount(MicroMappingRegionImpl.class, 0);
        CS2ASJavaCompilerParameters cgParams = this.createParameters("", "");
        java.lang.Class txClass = new CS2ASJavaCompilerImpl().compileTransformation((QVTimperative)myQVT, (Transformation)qvtiTransf, cgParams);
        myQVT.executeModelsTX_CG(txClass, "model1");
        myQVT.executeModelsTX_CG(txClass, "model2");
        myQVT.executeModelsTX_CG(txClass, "model3");
        myQVT.dispose();
        EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example4/simplerkiamacs/1.0");
        EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example4/simplerkiamaas/1.0");
    }

    @Test
    public void testOCL2QVTi_SimplerKiama_Interpreted() throws Exception {
        MyQVT myQVT = this.createQVT("SimplerKiama", "samples");
        myQVT.loadGenModels("SimplerKiamaAS.genmodel", "SimplerKiamaCS.genmodel");
        ImperativeTransformation qvtiTransf = myQVT.executeOCL2QVTi_CompilerChain("SimplerKiama.ocl", new String[0]);
        URI txURI = qvtiTransf.eResource().getURI();
        myQVT.dispose();
        myQVT = this.createQVT("SimplerKiama", "samples");
        ImperativeTransformation tx = this.getTransformation(myQVT.getMetamodelManager().getASResourceSet(), txURI);
        myQVT.executeModelsTX_Interpreted(tx, "model1");
        myQVT.executeModelsTX_Interpreted(tx, "model2");
        myQVT.executeModelsTX_Interpreted(tx, "model3");
        myQVT.dispose();
    }

    @Test
    public void testOCL2QVTi_BaseAndDerived_CG() throws Exception {
        MyQVT myQVT = this.createQVT("BaseAndDerived", "samples");
        myQVT.loadGenModels("SourceBaseMM.genmodel", "TargetBaseMM.genmodel");
        ImperativeTransformation qvtiTransf = myQVT.executeOCL2QVTi_CompilerChain("Source2TargetBase.ocl", new String[0]);
        myQVT.assertRegionCount(RuleRegionImpl.class, NO_MERGES ? 9 : 5);
        myQVT.assertRegionCount(EarlyMerger.EarlyMergedMappingRegion.class, NO_MERGES ? 0 : 2);
        myQVT.assertRegionCount(LateConsumerMerger.LateMergedMappingRegion.class, NO_MERGES ? 0 : 0);
        myQVT.assertRegionCount(MicroMappingRegionImpl.class, 0);
        CS2ASJavaCompilerParameters cgParams = this.createParameters("", "");
        java.lang.Class txClass = new CS2ASJavaCompilerImpl().compileTransformation((QVTimperative)myQVT, (Transformation)qvtiTransf, cgParams);
        myQVT.executeModelsTX_CG(txClass, "model1");
        myQVT.dispose();
        myQVT = this.createQVT("BaseAndDerived", "samples");
        myQVT.loadGenModels("SourceBaseMM.genmodel", "TargetBaseMM.genmodel", "SourceDerivedMM.genmodel", "TargetDerivedMM.genmodel");
        qvtiTransf = myQVT.executeOCL2QVTi_CompilerChain("Source2TargetDerived.ocl", "Source2TargetBase.ocl");
        txClass = new CS2ASJavaCompilerImpl().compileTransformation((QVTimperative)myQVT, (Transformation)qvtiTransf, cgParams);
        myQVT.executeModelsTX_CG(txClass, "model2");
        myQVT.dispose();
        EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example5/sourceBaseMM/1.0");
        EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example5/sourceDerivedMM/1.0");
        EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example5/targetBaseMM/1.0");
        EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example5/targetDerivedMM/1.0");
    }

    @Test
    public void testOCL2QVTi_BaseAndDerived_Interpreted() throws Exception {
        MyQVT myQVT = this.createQVT("BaseAndDerived", "samples");
        myQVT.loadGenModels("SourceBaseMM.genmodel", "TargetBaseMM.genmodel");
        ImperativeTransformation tx = myQVT.executeOCL2QVTi_CompilerChain("Source2TargetBase.ocl", new String[0]);
        myQVT.executeModelsTX_Interpreted(tx, "model1");
        myQVT.dispose();
        myQVT = this.createQVT("BaseAndDerived", "samples");
        myQVT.loadGenModels("SourceBaseMM.genmodel", "TargetBaseMM.genmodel", "SourceDerivedMM.genmodel", "TargetDerivedMM.genmodel");
        tx = myQVT.executeOCL2QVTi_CompilerChain("Source2TargetDerived.ocl", "Source2TargetBase.ocl");
        myQVT.executeModelsTX_Interpreted(tx, "model2");
        myQVT.dispose();
    }

    protected static void assertValidModel(URI asURI, ResourceSet rSet) {
        Resource resource = rSet.getResource(asURI, true);
        EcoreUtil.resolveAll((Resource)resource);
        String rUriString = resource.getURI().toString();
        OCL2QVTiTestCases.assertNoUnresolvedProxies((String)("Validating a resource: " + rUriString), (Resource)resource);
        OCL2QVTiTestCases.assertNoResourceErrors((String)("Loading a resource" + rUriString), (Resource)resource);
    }

    protected static void assertValidQVTiModel(@NonNull URI asURI) {
    }

    protected @NonNull ImperativeTransformation getTransformation(ResourceSet rSet, URI qvtiURI) {
        Resource resource = rSet.getResource(qvtiURI, true);
        for (EObject eObject : resource.getContents()) {
            if (!(eObject instanceof ImperativeModel)) continue;
            for (Package pPackage : ((ImperativeModel)eObject).getOwnedPackages()) {
                for (Class pClass : pPackage.getOwnedClasses()) {
                    if (!(pClass instanceof ImperativeTransformation)) continue;
                    return (ImperativeTransformation)pClass;
                }
            }
        }
        throw new IllegalStateException("No transformation");
    }

    protected static @NonNull XtextResource pivot2cs(@NonNull OCL ocl, @NonNull ResourceSet resourceSet, @NonNull ASResource asResource, @NonNull URI outputURI) throws IOException {
        XtextResource xtextResource = (XtextResource)ClassUtil.nonNullState((Object)((XtextResource)resourceSet.createResource(outputURI, "org.eclipse.qvtd.xtext.qvtimperative")));
        ocl.as2cs(asResource, (CSResource)xtextResource);
        OCL2QVTiTestCases.assertNoResourceErrors((String)"Conversion failed", (Resource)xtextResource);
        OCL2QVTiTestCases.assertNoDiagnosticErrors((String)"Concrete Syntax validation failed", (XtextResource)xtextResource);
        try {
            xtextResource.save(DefaultCompilerOptions.defaultSavingOptions);
        }
        catch (Exception e) {
            e.printStackTrace();
            URI xmiURI = outputURI.appendFileExtension(".xmi");
            Resource xmiResource = resourceSet.createResource(xmiURI);
            xmiResource.getContents().addAll((Collection)ClassUtil.nullFree((EList)xtextResource.getContents()));
            xmiResource.save(DefaultCompilerOptions.defaultSavingOptions);
            OCL2QVTiTestCases.fail((String)e.toString());
        }
        return xtextResource;
    }

    protected XtextResource doSerialize(@NonNull URI inputURI, @NonNull URI serializedURI) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        OCL ocl = QVTbase.newInstance((ProjectManager)this.getTestProjectManager());
        try {
            ASResource asResource = OCL2QVTiTestCases.loadQVTiAS(ocl, inputURI);
            OCL2QVTiTestCases.assertNoResourceErrors((String)"Normalisation failed", (Resource)asResource);
            OCL2QVTiTestCases.assertNoUnresolvedProxies((String)"Normalisation invalid", (Resource)asResource);
            OCL2QVTiTestCases.assertNoValidationErrors((String)"Normalisation invalid", (Resource)asResource);
            XtextResource xtextResource = OCL2QVTiTestCases.pivot2cs(ocl, (ResourceSet)resourceSet, asResource, serializedURI);
            resourceSet.getResources().clear();
            XtextResource xtextResource2 = xtextResource;
            return xtextResource2;
        }
        finally {
            ocl.dispose();
            ocl = null;
        }
    }

    protected static @NonNull ASResource loadQVTiAS(@NonNull OCL ocl, @NonNull URI inputURI) {
        Resource asResource = ocl.getMetamodelManager().getASResourceSet().getResource(inputURI, true);
        assert (asResource != null);
        OCL2QVTiTestCases.assertNoResourceErrors((String)"Load failed", (Resource)asResource);
        return (ASResource)asResource;
    }

    protected class MyQVT
    extends QVTimperative {
        private final @NonNull Map<@NonNull java.lang.Class<? extends Region>, @NonNull Integer> regionClass2count;
        protected final @NonNull String modelTestName;
        protected final @NonNull String modelSamples;

        public MyQVT(@NonNull ProjectManager projectManager, @NonNull String modelTestName, String modelSamples) {
            super(new QVTiEnvironmentFactory(projectManager, null));
            this.regionClass2count = new HashMap<java.lang.Class<? extends Region>, Integer>();
            this.modelTestName = modelTestName;
            this.modelSamples = modelSamples;
            URI ecoreURI = URI.createURI((String)"http://www.eclipse.org/emf/2002/Ecore");
            this.getProjectManager().getPackageDescriptor(ecoreURI).configure(this.getResourceSet(), StandaloneProjectMap.LoadFirstStrategy.INSTANCE, StandaloneProjectMap.MapToFirstConflictHandler.INSTANCE);
        }

        public void assertRegionCount(@NonNull java.lang.Class<? extends Region> regionClass, @NonNull Integer count) {
            OCL2QVTiTestCases.assertEquals((String)("Region " + regionClass.getSimpleName() + " count:"), (Object)(count != 0 ? count : null), (Object)this.regionClass2count.get(regionClass));
        }

        protected void executeModelsTX_CG(@NonNull java.lang.Class<? extends Transformer> txClass, @NonNull String modelName) throws Exception {
            QVTiTransformationExecutor evaluator = new QVTiTransformationExecutor(this.getEnvironmentFactory(), txClass);
            Transformer tx = evaluator.getTransformer();
            URI modelNamePrefix = OCL2QVTiTestCases.this.getModelsURI(String.valueOf(this.modelTestName) + "/" + this.modelSamples + "/");
            URI csModelURI = modelNamePrefix.appendSegment(String.valueOf(modelName) + "_input.xmi");
            URI asModelURI = OCL2QVTiTestCases.this.getTestURI(String.valueOf(modelName) + "_output_CG.xmi");
            URI expectedAsModelURI = modelNamePrefix.appendSegment(String.valueOf(modelName) + "_output_ref.xmi");
            this.saveEmptyModel(asModelURI);
            ResourceSet rSet = this.getResourceSet();
            Resource inputResource = rSet.getResource(csModelURI, true);
            tx.addRootObjects("leftCS", (Iterable)ClassUtil.nonNullState((Object)inputResource.getContents()));
            OCL2QVTiTestCases.assertTrue((boolean)tx.run());
            Resource outputResource = rSet.createResource(asModelURI);
            outputResource.getContents().addAll(tx.getRootEObjects("rightAS"));
            outputResource.save(DefaultCompilerOptions.defaultSavingOptions);
            Resource expected = rSet.getResource(expectedAsModelURI, true);
            Resource actual = rSet.getResource(asModelURI, true);
            assert (expected != null && actual != null);
            OCL2QVTiTestCases.assertSameModel((Resource)expected, (Resource)actual);
        }

        protected void executeModelsTX_Interpreted(@NonNull ImperativeTransformation tx, @NonNull String modelName) throws Exception {
            URI modelNamePrefix = OCL2QVTiTestCases.this.getModelsURI(String.valueOf(this.modelTestName) + "/" + this.modelSamples);
            URI csModelURI = modelNamePrefix.appendSegment(String.valueOf(modelName) + "_input.xmi");
            URI asModelURI = OCL2QVTiTestCases.this.getTestURI(String.valueOf(modelName) + "_output_Interpreted.xmi");
            URI expectedAsModelURI = modelNamePrefix.appendSegment(String.valueOf(modelName) + "_output_ref.xmi");
            this.saveEmptyModel(asModelURI);
            QVTiIncrementalExecutor testEvaluator = new QVTiIncrementalExecutor(this.getEnvironmentFactory(), tx, QVTiIncrementalExecutor.Mode.LAZY);
            testEvaluator.loadModel("leftCS", csModelURI);
            testEvaluator.createModel("rightAS", asModelURI, null);
            boolean success = testEvaluator.execute();
            testEvaluator.saveModels(DefaultCompilerOptions.defaultSavingOptions);
            testEvaluator.dispose();
            OCL2QVTiTestCases.assertTrue((boolean)success);
            ResourceSet rSet = this.getResourceSet();
            Resource expected = rSet.getResource(expectedAsModelURI, true);
            Resource actual = rSet.getResource(asModelURI, true);
            assert (expected != null && actual != null);
            OCL2QVTiTestCases.assertSameModel((Resource)expected, (Resource)actual);
        }

        protected @NonNull ImperativeTransformation executeOCL2QVTi_CompilerChain(@NonNull String mainOclDoc, String ... extendedOclDocs) throws IOException {
            URI mainOclDocURI = OCL2QVTiTestCases.this.getModelsURI(String.valueOf(this.modelTestName) + "/" + mainOclDoc);
            @NonNull URI[] oclDocURIs = new URI[extendedOclDocs.length];
            int i = 0;
            while (i < extendedOclDocs.length) {
                oclDocURIs[i] = OCL2QVTiTestCases.this.getModelsURI(String.valueOf(this.modelTestName) + "/" + extendedOclDocs[i]);
                ++i;
            }
            OCL2QVTiCompilerChain compiler = new OCL2QVTiCompilerChain(this, this.createTestCasesCompilerOptions(), mainOclDocURI, OCL2QVTiTestCases.this.getTestURIWithExtension(mainOclDocURI, null), oclDocURIs){

                protected // Could not load outer class - annotation placement on inner may be incorrect
                 @NonNull AbstractCompilerChain.QVTm2QVTsCompilerStep createQVTm2QVTsCompilerStep() {
                    return new AbstractCompilerChain.QVTm2QVTsCompilerStep((CompilerChain)this){

                        public @NonNull ScheduleManager execute(@NonNull Resource pResource) throws IOException {
                            ScheduleManager scheduleManager = super.execute(pResource);
                            MyQVT.this.instrumentRegion(scheduleManager);
                            return scheduleManager;
                        }
                    };
                }
            };
            ImperativeTransformation qvtiTransf = compiler.compile();
            URI txURI = qvtiTransf.eResource().getURI();
            if (txURI != null) {
                URI inputURI = txURI;
                URI serializedURI = OCL2QVTiTestCases.this.getTestURIWithExtension(inputURI, "serialized.qvti");
                OCL2QVTiTestCases.this.doSerialize(inputURI, serializedURI);
            }
            return qvtiTransf;
        }

        protected void instrumentRegion(@NonNull ScheduleManager scheduleManager) {
            ScheduleModel scheduleModel = scheduleManager.getScheduleModel();
            for (ScheduledRegion scheduledRegion : QVTscheduleUtil.getOwnedScheduledRegions((ScheduleModel)scheduleModel)) {
                this.instrumentRegion((Region)scheduledRegion);
            }
        }

        private void instrumentRegion(@NonNull Region parentRegion) {
            java.lang.Class<?> regionClass;
            Integer count = this.regionClass2count.get(regionClass = parentRegion.getClass());
            this.regionClass2count.put(regionClass, count == null ? 1 : count + 1);
            for (Region childRegion : parentRegion.getCallableChildren()) {
                this.instrumentRegion(childRegion);
            }
        }

        protected void loadEcoreFile(@NonNull String ecoreFileName, EPackage ePackage) {
            URI fileURI = OCL2QVTiTestCases.this.getModelsURI(String.valueOf(this.modelTestName) + "/" + ecoreFileName);
            this.loadEcoreFile(fileURI, ePackage);
        }

        public void loadEcoreFile(@NonNull URI fileURI, EPackage ePackage) {
            ResourceSet rSet = this.getResourceSet();
            rSet.getPackageRegistry().put((Object)fileURI.toString(), (Object)ePackage);
            rSet.getPackageRegistry().put((Object)ePackage.getNsURI(), (Object)ePackage);
        }

        protected void loadGenModel(@NonNull URI genModelURI) {
            ResourceSet resourceSet = this.getResourceSet();
            MetamodelManagerInternal metamodelManager = this.getMetamodelManager();
            Resource csGenResource = resourceSet.getResource(genModelURI, true);
            for (EObject eObject : csGenResource.getContents()) {
                if (!(eObject instanceof GenModel)) continue;
                GenModel genModel = (GenModel)eObject;
                genModel.reconcile();
                metamodelManager.addGenModel(genModel);
            }
        }

        protected void loadGenModels(URI ... genModelURIs) {
            if (genModelURIs != null) {
                URI[] uRIArray = genModelURIs;
                int n = genModelURIs.length;
                int n2 = 0;
                while (n2 < n) {
                    @NonNull URI genModelURI = uRIArray[n2];
                    this.loadGenModel(genModelURI);
                    ++n2;
                }
            }
        }

        protected void loadGenModels(String ... genModelNames) {
            if (genModelNames != null) {
                String[] stringArray = genModelNames;
                int n = genModelNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String genModelName = stringArray[n2];
                    this.loadGenModel(OCL2QVTiTestCases.this.getModelsURI(String.valueOf(this.modelTestName) + "/" + genModelName));
                    ++n2;
                }
            }
        }

        protected void saveEmptyModel(@NonNull URI modelURI) throws IOException {
            ResourceSetImpl rSet = new ResourceSetImpl();
            this.environmentFactory.getProjectManager().initializeResourceSet((ResourceSet)rSet);
            Resource r = rSet.createResource(modelURI);
            r.save(DefaultCompilerOptions.defaultSavingOptions);
        }

        protected @NonNull CompilerOptions createTestCasesCompilerOptions() {
            CompilerOptions options = OCL2QVTiTestCases.this.createCompilerOptions();
            options.setOption("default", OCL2QVTiCompilerChain.SAVE_OPTIONS_KEY, (Object)DefaultCompilerOptions.defaultSavingOptions);
            options.setOption("default", OCL2QVTiCompilerChain.DEBUG_KEY, (Object)true);
            options.setOption("QVTs", CompilerChain.SCHEDULER_NO_EARLY_MERGE, (Object)NO_MERGES);
            options.setOption("QVTs", CompilerChain.SCHEDULER_NO_LATE_CONSUMER_MERGE, (Object)NO_MERGES);
            return options;
        }
    }
}

