/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.internal.evaluation;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.ClassId;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.PackageId;
import org.eclipse.ocl.pivot.ids.PropertyId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.evaluation.EvaluationCache;
import org.eclipse.ocl.pivot.internal.values.SetValueImpl;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.SetValue;
import org.eclipse.qvtd.runtime.evaluation.AbstractObjectManager;
import org.eclipse.qvtd.runtime.evaluation.AbstractTransformer;
import org.eclipse.qvtd.runtime.evaluation.AbstractTypedModelInstance;
import org.eclipse.qvtd.runtime.evaluation.Connection;
import org.eclipse.qvtd.runtime.evaluation.DefaultInterval;
import org.eclipse.qvtd.runtime.evaluation.ExecutionVisitable;
import org.eclipse.qvtd.runtime.evaluation.ExecutionVisitor;
import org.eclipse.qvtd.runtime.evaluation.Interval;
import org.eclipse.qvtd.runtime.evaluation.InvalidEvaluationException;
import org.eclipse.qvtd.runtime.evaluation.InvocationFailedException;
import org.eclipse.qvtd.runtime.evaluation.InvocationManager;
import org.eclipse.qvtd.runtime.evaluation.ModeFactory;
import org.eclipse.qvtd.runtime.evaluation.ObjectManager;
import org.eclipse.qvtd.runtime.evaluation.TransformationExecutor;
import org.eclipse.qvtd.runtime.evaluation.Transformer;
import org.eclipse.qvtd.runtime.internal.evaluation.IncrementalInvocationManager;
import org.eclipse.qvtd.runtime.internal.evaluation.IncrementalObjectManager;
import org.eclipse.qvtd.runtime.internal.evaluation.LazyInvocationManager;
import org.eclipse.qvtd.runtime.internal.evaluation.LazyObjectManager;
import org.eclipse.qvtd.runtime.qvtruntimelibrary.Extent;
import org.eclipse.qvtd.runtime.qvtruntimelibrary.QVTruntimeLibraryFactory;

public abstract class AbstractTransformerInternal
implements Transformer,
ExecutionVisitable {
    private static final @NonNull List<@NonNull Integer> EMPTY_INDEX_LIST = Collections.emptyList();
    private static final @NonNull List<@NonNull Object> EMPTY_EOBJECT_LIST = Collections.emptyList();
    protected final @NonNull TransformationExecutor executor;
    @Deprecated
    protected final @NonNull Evaluator evaluator;
    protected final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IdResolver.IdResolverExtension idResolver;
    protected final @NonNull Model @NonNull [] models;
    protected final @NonNull Map<@NonNull String, @NonNull Integer> modelIndexes = new HashMap<String, Integer>();
    protected final boolean debugAssignments = AbstractTransformer.ASSIGNMENTS.isActive();
    protected final boolean debugCreations = AbstractTransformer.CREATIONS.isActive();
    protected final boolean debugExceptions = AbstractTransformer.EXCEPTIONS.isActive();
    protected final boolean debugGettings = AbstractTransformer.GETTINGS.isActive();
    protected final boolean debugInvocations = AbstractTransformer.INVOCATIONS.isActive();
    private @NonNull PropertyId @Nullable [] propertyIndex2propertyId;
    private @Nullable Map<PropertyId, Integer> propertyId2propertyIndex;
    private @Nullable EReference @Nullable [] propertyIndex2eReference;
    private @NonNull Map<@NonNull Object, @NonNull Object> @Nullable [] object2oppositeObject;
    protected final @NonNull InvocationManager invocationManager;
    protected final @NonNull ObjectManager objectManager;
    protected final @NonNull EvaluationCache evaluationCache;

    protected AbstractTransformerInternal(@NonNull TransformationExecutor executor, @NonNull String @NonNull [] modelNames, @NonNull PropertyId @Nullable [] propertyIndex2propertyId, @NonNull ClassId @NonNull [] classIndex2classId, int @Nullable [] @NonNull [] classIndex2allClassIndexes) {
        this(executor, modelNames.length);
        if (propertyIndex2propertyId != null) {
            this.initOpposites(propertyIndex2propertyId);
        }
        int i = 0;
        while (i < modelNames.length) {
            Model model = this.initModel(i, modelNames[i]);
            model.initClassIds(classIndex2classId, classIndex2allClassIndexes);
            ++i;
        }
        this.initConnections();
    }

    protected AbstractTransformerInternal(@NonNull TransformationExecutor executor, int models) {
        this.executor = executor;
        this.evaluator = executor;
        this.idResolver = (IdResolver.IdResolverExtension)executor.getIdResolver();
        this.invocationManager = this.createInvocationManager();
        this.objectManager = this.createObjectManager();
        this.evaluationCache = this.createEvaluationCache();
        this.models = new Model[models];
    }

    @Override
    public <R> R accept(@NonNull ExecutionVisitor<R> visitor) {
        return visitor.visitTransformer(this);
    }

    @Override
    public void addRootObjects(@NonNull String modelName, @NonNull Iterable<@NonNull ? extends Object> eRootObjects) {
        this.getTypedModelInstance(modelName).addRootObjects(eRootObjects);
    }

    @Deprecated
    protected @NonNull Connection createConnection(@NonNull String name, @NonNull TypeId typeId, boolean isStrict) {
        return this.createConnection(this.invocationManager.getRootInterval(), name, typeId, isStrict, this.getModeFactory());
    }

    protected @NonNull Connection createConnection(@NonNull Interval interval, @NonNull String name, @NonNull TypeId typeId, boolean isStrict, @NonNull ModeFactory modeFactory) {
        return interval.createConnection(name, typeId, isStrict, modeFactory);
    }

    protected @NonNull EvaluationCache createEvaluationCache() {
        return new EvaluationCache((Executor)this.executor);
    }

    protected @NonNull Interval createInterval(int intervalIndex) {
        return new DefaultInterval(this.getInvocationManager(), intervalIndex);
    }

    protected @NonNull InvocationManager createInvocationManager() {
        return new LazyInvocationManager(this.executor);
    }

    protected @NonNull Model createModel(@NonNull String modelName) {
        return new Model(this, modelName);
    }

    @Deprecated
    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SetValue.Accumulator createUnenforcedSetAccumulatorValue(@NonNull CollectionTypeId typeId) {
        return new UnenforcedSetAccumulator(typeId);
    }

    protected @NonNull ObjectManager createObjectManager() {
        return new LazyObjectManager((LazyInvocationManager)this.invocationManager);
    }

    protected @NonNull TreeIterator<? extends Object> eAllContents(@NonNull Object object) {
        return ((EObject)object).eAllContents();
    }

    protected @NonNull EClass eClass(@NonNull Object object) {
        return ((EObject)object).eClass();
    }

    protected @Nullable Object eContainer(@NonNull Object object) {
        return ((EObject)object).eContainer();
    }

    protected @Nullable Object eGet(@NonNull Object object, @NonNull EStructuralFeature eFeature) {
        return ((EObject)object).eGet(eFeature);
    }

    public @NonNull Iterable<@NonNull Object> get(@NonNull Class type) {
        return this.models[0].getObjectsOfKind(type);
    }

    @Override
    public @NonNull EvaluationCache getEvaluationCache() {
        return this.evaluationCache;
    }

    @Override
    public @NonNull TransformationExecutor getExecutor() {
        return this.executor;
    }

    @Override
    public @NonNull InvocationManager getInvocationManager() {
        return this.invocationManager;
    }

    public @NonNull ModeFactory getModeFactory() {
        return ModeFactory.NON_INCREMENTAL;
    }

    @Override
    public @NonNull ObjectManager getObjectManager() {
        return this.objectManager;
    }

    private @NonNull List<@NonNull Integer> getOppositePropertyIndexes(@NonNull Map<@NonNull EReference, @NonNull Integer> eReference2propertyIndex, @NonNull EClass eClass) {
        List<@NonNull Integer> propertyIndexes = null;
        for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
            if (!(eStructuralFeature instanceof EReference)) continue;
            EReference eReference = (EReference)eStructuralFeature;
            Integer propertyIndex = eReference2propertyIndex.get(eReference);
            if (propertyIndex == null) {
                if (!(eReference.getEOpposite() != null || eReference.isDerived() || eReference.isTransient() || eReference.isVolatile())) {
                    EClass eContainingClass = eReference.getEContainingClass();
                    EPackage ePackage = (EPackage)ClassUtil.nonNullEMF((Object)eContainingClass.getEPackage());
                    PackageId packageId = IdManager.getPackageId((EPackage)ePackage);
                    String className = (String)ClassUtil.nonNullEMF((Object)eContainingClass.getName());
                    ClassId classId = packageId.getClassId(className, eContainingClass.getETypeParameters().size());
                    String propertyName = (String)ClassUtil.nonNullEMF((Object)eReference.getName());
                    PropertyId propertyId = classId.getPropertyId(propertyName);
                    Map<PropertyId, Integer> propertyId2propertyIndex2 = this.propertyId2propertyIndex;
                    assert (propertyId2propertyIndex2 != null);
                    propertyIndex = propertyId2propertyIndex2.get(propertyId);
                }
                if (propertyIndex == null) {
                    propertyIndex = -1;
                }
                eReference2propertyIndex.put(eReference, propertyIndex);
            }
            if (propertyIndex < 0) continue;
            if (propertyIndexes == null) {
                propertyIndexes = new ArrayList<Integer>();
            }
            propertyIndexes.add(propertyIndex);
        }
        return propertyIndexes != null ? propertyIndexes : EMPTY_INDEX_LIST;
    }

    public @NonNull Collection<@NonNull EObject> getRootEObjects(@NonNull String modelName) {
        boolean hasExtent = false;
        Model model = this.getTypedModelInstance(modelName);
        ArrayList<@NonNull EObject> rootEObjects = new ArrayList<EObject>();
        for (Object rootObject : model.getRootObjects()) {
            if (!(rootObject instanceof Extent)) continue;
            hasExtent = true;
            for (Object object : ((Extent)((Object)rootObject)).getElements()) {
                if (object == null) continue;
                rootEObjects.add((EObject)object);
            }
        }
        if (!hasExtent) {
            for (Object rootObject : model.getRootObjects()) {
                if (!(rootObject instanceof EObject)) continue;
                rootEObjects.add((EObject)rootObject);
            }
        }
        return rootEObjects;
    }

    @Override
    public @NonNull Collection<@NonNull Object> getRootObjects(@NonNull String modelName) {
        return this.getTypedModelInstance(modelName).getRootObjects();
    }

    @Override
    public @NonNull Model getTypedModelInstance(@NonNull String modelName) {
        Integer modelIndex = this.modelIndexes.get(modelName);
        if (modelIndex == null) {
            throw new IllegalStateException("Unknown model name '" + modelName + "'");
        }
        return this.models[modelIndex];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean handleExecutionFailure(@NonNull String mappingName, @NonNull Throwable e) throws InvocationFailedException {
        if (e instanceof InvocationFailedException) {
            throw (InvocationFailedException)((Object)e);
        }
        if (e instanceof InvalidEvaluationException) {
            if (!this.debugExceptions) throw (InvalidEvaluationException)((Object)e);
            AbstractTransformer.EXCEPTIONS.println("Execution failure in '" + mappingName + "' : " + e);
            throw (InvalidEvaluationException)((Object)e);
        }
        if (e instanceof AssertionError) {
            if (!this.debugExceptions) throw (AssertionError)((Object)e);
            AbstractTransformer.EXCEPTIONS.println("Execution failure in '" + mappingName + "' : " + e);
        } else {
            if (e instanceof Error) {
                if (!this.debugExceptions) throw (Error)e;
                AbstractTransformer.EXCEPTIONS.println("Execution failure in '" + mappingName + "' : " + e);
                throw (Error)e;
            }
            if (e instanceof InvalidValueException) {
                if (this.debugExceptions) {
                    AbstractTransformer.EXCEPTIONS.println("Execution failure in '" + mappingName + "' : " + e);
                }
            } else if (e instanceof NullPointerException) {
                if (this.debugExceptions) {
                    AbstractTransformer.EXCEPTIONS.println("Execution failure in '" + mappingName + "' : " + e);
                }
            } else if (this.debugExceptions) {
                AbstractTransformer.EXCEPTIONS.println("Execution failure in '" + mappingName + "' : " + e);
            }
        }
        if (!(e instanceof Exception)) throw new InvalidEvaluationException(new RuntimeException(e));
        throw new InvalidEvaluationException((Exception)e);
    }

    protected void initConnections() {
        Interval rootInterval = this.lazyCreateInterval(0);
        Model[] modelArray = this.models;
        int n = this.models.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull Model model = modelArray[n2];
            model.initConnections(rootInterval);
            ++n2;
        }
    }

    protected @NonNull Model initModel(int i, @NonNull String modelName, @NonNull PropertyId @Nullable [] propertyIndex2propertyId, @NonNull ClassId @NonNull [] classIndex2classId, int @Nullable [] @NonNull [] classIndex2allClassIndexes, @NonNull Interval rootInterval) {
        Model model;
        this.models[i] = model = this.createModel(modelName);
        this.modelIndexes.put(modelName, i);
        return model;
    }

    protected @NonNull Model initModel(int i, @NonNull String modelName) {
        Model model;
        this.models[i] = model = this.createModel(modelName);
        this.modelIndexes.put(modelName, i);
        return model;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void initOpposites(@NonNull PropertyId @NonNull [] propertyIndex2propertyId) {
        int propertyIds = propertyIndex2propertyId.length;
        this.propertyIndex2propertyId = propertyIndex2propertyId;
        HashMap<@NonNull PropertyId, @NonNull Integer> propertyId2propertyIndex2 = new HashMap<PropertyId, Integer>(propertyIds);
        this.propertyId2propertyIndex = propertyId2propertyIndex2;
        this.propertyIndex2eReference = new EReference[propertyIds];
        int propertyIndex = 0;
        while (propertyIndex < propertyIds) {
            PropertyId propertyId = propertyIndex2propertyId[propertyIndex];
            propertyId2propertyIndex2.put(propertyId, propertyIndex);
            ++propertyIndex;
        }
        @NonNull @NonNull @NonNull Map @Nullable [] object2oppositeObject = new HashMap[propertyIds];
        this.object2oppositeObject = object2oppositeObject;
        int i = 0;
        while (i < propertyIds) {
            object2oppositeObject[i] = new HashMap();
            ++i;
        }
    }

    protected @NonNull Interval lazyCreateInterval(int intervalIndex) {
        if (intervalIndex < 0) {
            return this.invocationManager.createInterval();
        }
        int i = this.invocationManager.getIntervalsSize();
        while (i < intervalIndex) {
            this.createInterval(i);
            ++i;
        }
        Interval interval = this.invocationManager.basicGetInterval(intervalIndex);
        return interval != null ? interval : this.createInterval(intervalIndex);
    }

    @Override
    public void setExternalURI(@NonNull String modelName, @NonNull URI modelURI) {
        Model model = this.getTypedModelInstance(modelName);
        for (Object object : model.getRootObjects()) {
            if (!(object instanceof org.eclipse.ocl.pivot.Model)) continue;
            ((org.eclipse.ocl.pivot.Model)object).setExternalURI(modelURI.toString());
        }
    }

    public @NonNull Object throwInvalidEvaluationException(@NonNull String message, Object ... bindings) {
        throw new InvalidEvaluationException(message, bindings);
    }

    protected @NonNull String toDebugString(@Nullable Object object) {
        return AbstractObjectManager.toDebugString(object);
    }

    public static abstract class Incremental
    extends AbstractTransformerInternal {
        protected Incremental(@NonNull TransformationExecutor executor, @NonNull String @NonNull [] modelNames, @NonNull PropertyId @Nullable [] propertyIndex2propertyId, @NonNull ClassId @NonNull [] classIndex2classId, int @Nullable [] @NonNull [] classIndex2allClassIndexes) {
            super(executor, modelNames, propertyIndex2propertyId, classIndex2classId, classIndex2allClassIndexes);
        }

        protected Incremental(@NonNull TransformationExecutor executor, int models) {
            super(executor, models);
        }

        @Override
        @Deprecated
        protected @NonNull Connection createConnection(@NonNull String name, @NonNull TypeId typeId, boolean isStrict) {
            return this.createConnection(this.invocationManager.getRootInterval(), name, typeId, isStrict, ModeFactory.NON_INCREMENTAL);
        }

        @Override
        protected @NonNull Connection createConnection(@NonNull Interval interval, @NonNull String name, @NonNull TypeId typeId, boolean isStrict, @NonNull ModeFactory modeFactory) {
            return interval.createConnection(name, typeId, isStrict, modeFactory);
        }

        @Override
        protected @NonNull InvocationManager createInvocationManager() {
            return new IncrementalInvocationManager(this.executor);
        }

        @Override
        protected @NonNull Model createModel(@NonNull String modelName) {
            return new Model.Incremental(this, modelName);
        }

        @Override
        protected @NonNull ObjectManager createObjectManager() {
            return new IncrementalObjectManager((IncrementalInvocationManager)this.invocationManager);
        }

        @Override
        public @NonNull ModeFactory getModeFactory() {
            return ModeFactory.INCREMENTAL;
        }
    }

    public static class Model
    extends AbstractTypedModelInstance {
        protected final @NonNull AbstractTransformerInternal transformer;
        protected final @NonNull String name;
        protected final @NonNull List<@NonNull Object> rootObjects = new ArrayList<Object>();
        protected final @NonNull List<@NonNull Object> potentialOrphanObjects = new ArrayList<Object>();
        protected final @NonNull Map<@NonNull EClass, @NonNull Set<@NonNull Integer>> eClass2allClassIndexes = new HashMap<EClass, Set<Integer>>();
        protected @NonNull ClassId @Nullable [] classIndex2classId = null;
        protected @Nullable Map<@NonNull ClassId, @NonNull Integer> classId2classIndex = null;
        protected @Nullable Map<@NonNull ClassId, @NonNull Set<@NonNull Integer>> classId2classIndexes = null;
        protected @NonNull Connection[] classIndex2connection;
        private int extentClassIndex = -1;
        private @Nullable Map<Object, Object> extentOpposites = null;
        private int isContainedCount = 0;
        private int isNotContainedCount = 0;
        private @Nullable Boolean trackAdditions = null;

        public Model(@NonNull AbstractTransformerInternal transformer, @NonNull String name) {
            this.transformer = transformer;
            this.name = name;
        }

        private void accumulateEObject1(@NonNull Object eObject, @NonNull EClass eClass) {
            assert (this.classIndex2classId != null);
            assert (this.eClass2allClassIndexes != null);
            Set<@NonNull Integer> allClassIndexes = this.eClass2allClassIndexes.get(eClass);
            if (allClassIndexes == null) {
                allClassIndexes = this.getClassIndexes(eClass);
                this.eClass2allClassIndexes.put(eClass, allClassIndexes);
            }
            for (Integer classIndex : allClassIndexes) {
                this.classIndex2connection[classIndex].appendElement(eObject);
            }
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private void accumulateEObject2(@NonNull Object eObject, @NonNull EClass eClass, @NonNull Map<@NonNull EClass, @NonNull List<@NonNull Integer>> eClass2allPropertyIndexes, @Nullable Map<@NonNull EReference, @NonNull Integer> eReference2propertyIndex) {
            Map<@NonNull EReference, @NonNull Integer> eReference2propertyIndex2 = eReference2propertyIndex;
            assert (eReference2propertyIndex2 != null);
            @NonNull List allPropertyIndexes = eClass2allPropertyIndexes.get(eClass);
            if (allPropertyIndexes == null) {
                allPropertyIndexes = this.transformer.getOppositePropertyIndexes(eReference2propertyIndex2, eClass);
                eClass2allPropertyIndexes.put(eClass, allPropertyIndexes);
            }
            @NonNull @NonNull Map[] object2oppositeObject2 = this.transformer.object2oppositeObject;
            assert (object2oppositeObject2 != null);
            for (Integer propertyIndex : allPropertyIndexes) {
                EReference @Nullable [] propertyIndex2eReference2 = this.transformer.propertyIndex2eReference;
                assert (propertyIndex2eReference2 != null);
                EReference eReference = propertyIndex2eReference2[propertyIndex];
                if (eReference == null) {
                    PropertyId @Nullable [] propertyIndex2propertyId2 = this.transformer.propertyIndex2propertyId;
                    assert (propertyIndex2propertyId2 != null);
                    PropertyId propertyId = propertyIndex2propertyId2[propertyIndex];
                    assert (propertyId != null);
                    eReference = (EReference)NameUtil.getENamedElement((Iterable)eClass.getEAllStructuralFeatures(), (String)propertyId.getName());
                    assert (eReference != null);
                }
                Object object = this.transformer.eGet(eObject, (EStructuralFeature)eReference);
                assert (object != null);
                object2oppositeObject2[propertyIndex].put(object, eObject);
            }
        }

        @Deprecated
        public void add(@NonNull EObject eObject) {
            this.add(eObject, false);
        }

        public void add(@NonNull EObject eObject, boolean isContained) {
            if (this.trackAdditions == Boolean.FALSE || isContained && this.trackAdditions == null) {
                ++this.isContainedCount;
            } else {
                ++this.isNotContainedCount;
                assert (!this.potentialOrphanObjects.contains(eObject));
                this.potentialOrphanObjects.add(eObject);
            }
            if (this.classIndex2classId != null) {
                EClass eClass = this.transformer.eClass(eObject);
                this.accumulateEObject1(eObject, eClass);
            }
        }

        public void addRootObjects(@NonNull Iterable<@NonNull ? extends Object> eRootObjects) {
            HashMap<@NonNull EClass, @NonNull List<@NonNull Integer>> eClass2allPropertyIndexes = null;
            HashMap<@NonNull EReference, @NonNull Integer> eReference2propertyIndex = null;
            if (this.transformer.propertyIndex2propertyId != null) {
                eClass2allPropertyIndexes = new HashMap<EClass, List<Integer>>();
                eReference2propertyIndex = new HashMap<EReference, Integer>();
            }
            for (Object object : eRootObjects) {
                this.rootObjects.add(object);
                if (this.classIndex2classId == null) continue;
                EClass eRootClass = this.transformer.eClass(object);
                this.accumulateEObject1(object, eRootClass);
                if (eClass2allPropertyIndexes != null) {
                    this.accumulateEObject2(object, eRootClass, eClass2allPropertyIndexes, eReference2propertyIndex);
                }
                TreeIterator<? extends Object> tit = this.transformer.eAllContents(object);
                while (tit.hasNext()) {
                    Object eObject = tit.next();
                    if (eObject == null) continue;
                    EClass eClass = this.transformer.eClass(eObject);
                    this.accumulateEObject1(eObject, eClass);
                    if (eClass2allPropertyIndexes == null) continue;
                    this.accumulateEObject2(eObject, eClass, eClass2allPropertyIndexes, eReference2propertyIndex);
                }
            }
            if (this.extentClassIndex >= 0) {
                Extent extent = QVTruntimeLibraryFactory.eINSTANCE.createExtent();
                Iterables.addAll(extent.getElements(), eRootObjects);
                this.accumulateEObject1((Object)extent, extent.eClass());
                Map<Object, Object> extentOpposites2 = this.extentOpposites;
                if (extentOpposites2 != null) {
                    for (Object object : extent.getElements()) {
                        extentOpposites2.put(object, (Object)extent);
                    }
                }
            }
        }

        @Deprecated
        public @NonNull Collection<@NonNull Object> getAllObjects() {
            return this.potentialOrphanObjects;
        }

        private @NonNull Set<@NonNull Integer> getClassIndexes(@NonNull EClass eClass) {
            EPackage ePackage = (EPackage)ClassUtil.nonNullEMF((Object)eClass.getEPackage());
            PackageId packageId = IdManager.getPackageId((EPackage)ePackage);
            String className = (String)ClassUtil.nonNullEMF((Object)eClass.getName());
            ClassId classId = packageId.getClassId(className, eClass.getETypeParameters().size());
            Map<@NonNull ClassId, @NonNull Set<@NonNull Integer>> classId2classIndexes2 = this.classId2classIndexes;
            assert (classId2classIndexes2 != null);
            Set<@NonNull Integer> classIndexes = classId2classIndexes2.get(classId);
            if (classIndexes == null) {
                classIndexes = new HashSet<Integer>();
                for (EClass eSuperClass : ClassUtil.nullFree((EList)eClass.getESuperTypes())) {
                    Set<@NonNull Integer> partialResult = this.getClassIndexes(eSuperClass);
                    classIndexes.addAll(partialResult);
                }
                classId2classIndexes2.put(classId, classIndexes);
            }
            return classIndexes;
        }

        public @NonNull Connection getConnection(int classIndex) {
            assert (this.classIndex2connection != null);
            return this.classIndex2connection[classIndex];
        }

        public @NonNull Iterable<@NonNull Object> getObjectsOfKind(@NonNull Class type) {
            Integer classIndex;
            assert (this.classIndex2connection != null);
            TypeId classId = type.getTypeId();
            Integer n = classIndex = this.classId2classIndex != null ? this.classId2classIndex.get(classId) : null;
            if (classIndex != null) {
                Iterable<@NonNull Object> typedIterable = this.classIndex2connection[classIndex].typedIterable(Object.class);
                return typedIterable;
            }
            return EMPTY_EOBJECT_LIST;
        }

        @Deprecated
        public @NonNull Collection<@NonNull Object> getObjectsOfType(@NonNull Class type) {
            throw new UnsupportedOperationException();
        }

        public @NonNull Collection<@NonNull Object> getRootObjects() {
            if (this.rootObjects.size() > 0) {
                return this.rootObjects;
            }
            ArrayList<@NonNull Object> rootObjects2 = new ArrayList<Object>();
            for (Object eObject : this.potentialOrphanObjects) {
                if (this.transformer.eContainer(eObject) != null) continue;
                rootObjects2.add(eObject);
            }
            if (AbstractTransformer.CONTAINMENTS.isActive()) {
                AbstractTransformer.CONTAINMENTS.println(String.valueOf(this.name) + " " + this.isContainedCount + "/" + (this.isContainedCount + this.isNotContainedCount));
            }
            return rootObjects2;
        }

        public @NonNull Model initClassIds(@NonNull ClassId @NonNull [] classIndex2classId, int @Nullable [] @NonNull [] classIndex2allClassIndexes) {
            this.classIndex2classId = classIndex2classId;
            assert (classIndex2allClassIndexes != null);
            int classIds = classIndex2classId.length;
            this.classId2classIndex = new HashMap<ClassId, Integer>(classIds);
            HashMap<@NonNull ClassId, @NonNull Integer> classId2classIndex = this.classId2classIndex;
            this.classId2classIndexes = new HashMap<ClassId, Set<Integer>>(classIds);
            HashMap<@NonNull ClassId, @NonNull Set<@NonNull Integer>> classId2classIndexes = this.classId2classIndexes;
            int classIndex = 0;
            while (classIndex < classIds) {
                ClassId classId = classIndex2classId[classIndex];
                classId2classIndex.put(classId, classIndex);
                HashSet<@NonNull Integer> superClassIndexes = new HashSet<Integer>();
                int[] nArray = classIndex2allClassIndexes[classIndex];
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int allClassIndex = nArray[n2];
                    superClassIndexes.add(allClassIndex);
                    ++n2;
                }
                classId2classIndexes.put(classId, superClassIndexes);
                ++classIndex;
            }
            return this;
        }

        void initConnections(@NonNull Interval rootInterval) {
            @NonNull ClassId[] classIndex2classId2 = this.classIndex2classId;
            if (classIndex2classId2 != null) {
                this.classIndex2connection = new Connection[classIndex2classId2.length];
                @NonNull Connection[] classIndex2connection = this.classIndex2connection;
                int classIndex = 0;
                ClassId[] classIdArray = classIndex2classId2;
                int n = classIndex2classId2.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassId classId = classIdArray[n2];
                    String connectionName = String.valueOf(this.name) + "!" + classId.getName();
                    classIndex2connection[classIndex] = rootInterval.createConnection(connectionName, (TypeId)classId, false, this.transformer.getModeFactory());
                    ++classIndex;
                    ++n2;
                }
            }
        }

        public <K, V> void initExtent(int extentClassIndex, @Nullable Map<K, V> extentOpposites) {
            this.extentClassIndex = extentClassIndex;
            this.extentOpposites = extentOpposites;
        }

        public String toString() {
            return String.valueOf(this.name) + " " + this.rootObjects.size();
        }

        @Override
        public @NonNull String getName() {
            return this.name;
        }

        public void setTrackAdditions(@Nullable Boolean trackAdditions) {
            this.trackAdditions = trackAdditions;
        }

        public <T> Iterable<T> typedIterable(java.lang.Class<T> javaClass, @NonNull Class pivotType) {
            Integer classIndex;
            assert (this.classIndex2connection != null);
            TypeId typeId = pivotType.getTypeId();
            Integer n = classIndex = this.classId2classIndex != null ? this.classId2classIndex.get(typeId) : null;
            if (classIndex != null) {
                Connection connection = this.classIndex2connection[classIndex];
                return connection.typedIterable(javaClass);
            }
            return null;
        }

        public static class Incremental
        extends Model {
            public Incremental(@NonNull AbstractTransformerInternal transformer, @NonNull String name) {
                super(transformer, name);
            }

            public void remove(@NonNull EObject eObject) {
                this.rootObjects.remove(eObject);
                this.potentialOrphanObjects.remove(eObject);
                if (this.classIndex2connection != null) {
                    this.unaccumulateEObject(this.eClass2allClassIndexes, null, null, eObject);
                }
            }

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            private void unaccumulateEObject(@Nullable Map<@NonNull EClass, @NonNull Set<@NonNull Integer>> eClass2allClassIndexes, @Nullable Map<@NonNull EClass, @NonNull List<@NonNull Integer>> eClass2allPropertyIndexes, @Nullable Map<@NonNull EReference, @NonNull Integer> eReference2propertyIndex, @NonNull Object eObject) {
                Set<Integer> allClassIndexes;
                assert (this.classIndex2connection != null);
                EClass eClass = this.transformer.eClass(eObject);
                if (eClass2allClassIndexes != null && (allClassIndexes = eClass2allClassIndexes.get(eClass)) != null) {
                    for (Integer classIndex : allClassIndexes) {
                        Connection.Incremental connection = (Connection.Incremental)this.classIndex2connection[classIndex];
                        connection.removeElement(eObject);
                    }
                }
                if (eClass2allPropertyIndexes != null) {
                    Map<EReference, Integer> eReference2propertyIndex2 = eReference2propertyIndex;
                    assert (eReference2propertyIndex2 != null);
                    List<@NonNull Integer> allPropertyIndexes = eClass2allPropertyIndexes.get(eClass);
                    if (allPropertyIndexes != null) {
                        @NonNull @NonNull Map[] object2oppositeObject2 = this.transformer.object2oppositeObject;
                        assert (object2oppositeObject2 != null);
                        for (Integer propertyIndex : allPropertyIndexes) {
                            EReference @Nullable [] propertyIndex2eReference2 = this.transformer.propertyIndex2eReference;
                            assert (propertyIndex2eReference2 != null);
                            EReference eReference = propertyIndex2eReference2[propertyIndex];
                            if (eReference == null) continue;
                            Object object = this.transformer.eGet(eObject, (EStructuralFeature)eReference);
                            assert (object != null);
                            object2oppositeObject2[propertyIndex].remove(object);
                        }
                    }
                }
            }
        }
    }

    @Deprecated
    private static class UnenforcedSetAccumulator
    extends SetValueImpl
    implements SetValue.Accumulator {
        public UnenforcedSetAccumulator(@NonNull CollectionTypeId typeId) {
            super(typeId, new ArrayList());
        }

        public boolean add(@Nullable Object value) {
            assert (!this.elements.contains(value));
            return this.elements.add(value);
        }
    }
}

