/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.adapters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.qvt.declarative.ecore.adapters.NotAdapterException;
import org.eclipse.qvt.declarative.ecore.mappings.MappingMetaDataRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptingList<E extends EObject, A extends EObject, L extends List<E>>
implements List<A> {
    protected final MappingMetaDataRegistry mappingMetaDataRegistry;
    protected L ecoreList;

    public AdaptingList(MappingMetaDataRegistry mappingMetaDataRegistry, L ecoreList) {
        this.mappingMetaDataRegistry = mappingMetaDataRegistry;
        this.ecoreList = ecoreList;
    }

    @Override
    public boolean add(A o) {
        return this.ecoreList.add(this.getTarget(o));
    }

    @Override
    public void add(int index, A o) {
        this.ecoreList.add(index, this.getTarget(o));
    }

    @Override
    public boolean addAll(Collection<? extends A> c) {
        for (EObject o : c) {
            this.add((A)o);
        }
        return !c.isEmpty();
    }

    @Override
    public boolean addAll(int index, Collection<? extends A> c) {
        for (EObject o : c) {
            this.add(index++, (A)o);
        }
        return !c.isEmpty();
    }

    @Override
    public void clear() {
        this.ecoreList.clear();
    }

    @Override
    public boolean contains(Object object) {
        if (!(object instanceof Adapter)) {
            return false;
        }
        return this.ecoreList.contains(((Adapter)object).getTarget());
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public A get(int index) {
        return this.getAdapter((EObject)this.ecoreList.get(index));
    }

    protected A getAdapter(E ecoreObject) {
        return (A)this.mappingMetaDataRegistry.getAdapter((EObject)ecoreObject);
    }

    protected E getTarget(A adaptingObject) {
        if (!(adaptingObject instanceof Adapter)) {
            throw new NotAdapterException((EObject)adaptingObject);
        }
        return (E)((EObject)((Adapter)adaptingObject).getTarget());
    }

    public List<E> getTargets(Collection<?> collection) {
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<E> list = new ArrayList<E>(collection.size());
        for (Object adaptingObject : collection) {
            list.add(this.getTarget((EObject)adaptingObject));
        }
        return list;
    }

    @Override
    public int indexOf(Object object) {
        if (!(object instanceof Adapter)) {
            return -1;
        }
        return this.ecoreList.indexOf(((Adapter)object).getTarget());
    }

    @Override
    public boolean isEmpty() {
        return this.ecoreList.isEmpty();
    }

    @Override
    public Iterator<A> iterator() {
        return new AdaptingIterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        if (!(o instanceof Adapter)) {
            return -1;
        }
        return this.ecoreList.lastIndexOf(((Adapter)o).getTarget());
    }

    @Override
    public ListIterator<A> listIterator() {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".listIterator");
    }

    @Override
    public ListIterator<A> listIterator(int index) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".listIterator");
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Adapter)) {
            return false;
        }
        return this.ecoreList.remove(((Adapter)o).getTarget());
    }

    @Override
    public A remove(int index) {
        return this.getAdapter((EObject)this.ecoreList.remove(index));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean status = false;
        for (Object o : c) {
            if (!this.remove(o)) continue;
            status = true;
        }
        return status;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean status = false;
        EObject[] eObjectArray = this.ecoreList.toArray((EObject[])new EObject[this.ecoreList.size()]);
        int n = eObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            EObject e = eObjectArray[n2];
            if (!c.contains(this.getAdapter(e))) {
                this.ecoreList.remove(e);
                status = true;
            }
            ++n2;
        }
        return status;
    }

    @Override
    public A set(int index, A element) {
        return this.getAdapter((EObject)this.ecoreList.set(index, this.getTarget(element)));
    }

    @Override
    public int size() {
        return this.ecoreList.size();
    }

    @Override
    public List<A> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".subList");
    }

    @Override
    public Object[] toArray() {
        Object[] ecoreObjects = this.ecoreList.toArray();
        Object[] adaptingObjects = new Object[ecoreObjects.length];
        int i = 0;
        while (i < ecoreObjects.length) {
            adaptingObjects[i] = this.getAdapter((EObject)ecoreObjects[i]);
            ++i;
        }
        return adaptingObjects;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] ecoreObjects = this.ecoreList.toArray();
        int i = 0;
        while (i < ecoreObjects.length) {
            a[i] = this.getAdapter((EObject)ecoreObjects[i]);
            ++i;
        }
        return a;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AdaptingIterator
    implements Iterator<A> {
        private Iterator<E> ecoreIterator;

        protected AdaptingIterator() {
            this.ecoreIterator = AdaptingList.this.ecoreList.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.ecoreIterator.hasNext();
        }

        @Override
        public A next() {
            return AdaptingList.this.getAdapter((EObject)this.ecoreIterator.next());
        }

        @Override
        public void remove() {
            this.ecoreIterator.remove();
        }
    }
}

