/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.cs2as.compiler.tests;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.xtext.completeocl.CompleteOCLStandaloneSetup;
import org.eclipse.qvtd.compiler.DefaultCompilerOptions;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.BasicQVTiExecutor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiIncrementalExecutor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiTransformationExecutor;
import org.eclipse.qvtd.runtime.evaluation.TransformationExecutor;
import org.eclipse.qvtd.runtime.evaluation.Transformer;
import org.eclipse.qvtd.xtext.qvtbase.tests.LoadTestCase;
import org.eclipse.qvtd.xtext.qvtimperative.QVTimperativeStandaloneSetup;
import org.junit.Before;
import org.junit.Test;

public class ExecutionBenchmarks
extends LoadTestCase {
    private static URI TESTS_BASE_URI = URI.createPlatformResourceURI((String)"org.eclipse.qvtd.cs2as.compiler.tests/src/org/eclipse/qvtd/cs2as/compiler/tests/models", (boolean)true);
    private static int NUM_OF_EXECUTIONS = 10;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        QVTimperativeStandaloneSetup.doSetup();
        CompleteOCLStandaloneSetup.doSetup();
    }

    protected @NonNull MyQVT createQVT() throws Exception {
        return new MyQVT(new QVTiEnvironmentFactory(this.getTestProjectManager(), null));
    }

    @Test
    public void testExample2_Interpreted() throws Exception {
        LinkedHashMap<String, List<Integer>> results = new LinkedHashMap<String, List<Integer>>();
        int i = 0;
        while (i < NUM_OF_EXECUTIONS) {
            MyQVT myQVT = this.createQVT();
            ResourceSet resourceSet = myQVT.getResourceSet();
            resourceSet.getResource(URI.createURI((String)"http://cs2as/tests/example2/classes/1.0", (boolean)true), true);
            resourceSet.getResource(URI.createURI((String)"http://cs2as/tests/example2/classescs/1.0", (boolean)true), true);
            resourceSet.getResource(URI.createURI((String)"http://cs2as/tests/example2/env/1.0", (boolean)true), true);
            URI baseURI = TESTS_BASE_URI.appendSegment("example2");
            URI txURI = baseURI.appendSegment("classescs2as.qvtias");
            ImperativeTransformation qvtiTransf = this.getTransformation(myQVT.getMetamodelManager().getASResourceSet(), txURI);
            assert (qvtiTransf != null);
            this.trackExample_Interpreted(myQVT, qvtiTransf, baseURI, "model1", results);
            this.trackExample_Interpreted(myQVT, qvtiTransf, baseURI, "model2", results);
            this.trackExample_Interpreted(myQVT, qvtiTransf, baseURI, "model3", results);
            this.trackExample_Interpreted(myQVT, qvtiTransf, baseURI, "model4", results);
            this.trackExample_Interpreted(myQVT, qvtiTransf, baseURI, "model5", results);
            this.trackExample_Interpreted(myQVT, qvtiTransf, baseURI, "model6", results);
            this.trackExample_Interpreted(myQVT, qvtiTransf, baseURI, "model7", results);
            myQVT.dispose();
            ++i;
        }
        this.processResults("Example2_Interpreted.csv", results);
    }

    @Test
    public void testExample2_CG() throws Exception {
        LinkedHashMap<String, List<Integer>> results = new LinkedHashMap<String, List<Integer>>();
        int i = 0;
        while (i < NUM_OF_EXECUTIONS) {
            MyQVT myQVT = this.createQVT();
            URI baseURI = TESTS_BASE_URI.appendSegment("example2");
            java.lang.Class<?> txClass = java.lang.Class.forName("cg._classescs2as_qvtm_qvtcas.classescs2as_qvtm_qvtcas");
            assert (txClass != null);
            this.trackExample_CG(myQVT, txClass, baseURI, "model1", results);
            this.trackExample_CG(myQVT, txClass, baseURI, "model2", results);
            this.trackExample_CG(myQVT, txClass, baseURI, "model3", results);
            this.trackExample_CG(myQVT, txClass, baseURI, "model4", results);
            this.trackExample_CG(myQVT, txClass, baseURI, "model5", results);
            this.trackExample_CG(myQVT, txClass, baseURI, "model6", results);
            this.trackExample_CG(myQVT, txClass, baseURI, "model7", results);
            myQVT.dispose();
            ++i;
        }
        this.processResults("Example2_CG.csv", results);
    }

    private void trackExample_CG(MyQVT qvt, @NonNull java.lang.Class<? extends Transformer> txClass, URI baseURI, String modelName, Map<String, List<Integer>> results) throws Exception {
        long initStamp = System.currentTimeMillis();
        this.executeModelsTX_CG(qvt, txClass, baseURI, modelName);
        long finalStamp = System.currentTimeMillis();
        this.trackResults(results, modelName, initStamp, finalStamp);
        System.out.println("Iteration on " + modelName + ": " + (finalStamp - initStamp) + " ms");
    }

    private void trackExample_Interpreted(MyQVT qvt, @NonNull ImperativeTransformation tx, URI baseURI, String modelName, Map<String, List<Integer>> results) throws Exception {
        long initStamp = System.currentTimeMillis();
        this.executeModelsTX_Interpreted(qvt, tx, baseURI, modelName);
        long finalStamp = System.currentTimeMillis();
        this.trackResults(results, modelName, initStamp, finalStamp);
        System.out.println("Iteration on " + modelName + ": " + (finalStamp - initStamp) + " ms");
    }

    private void trackResults(Map<String, List<Integer>> allResults, String modelName, long initStamp, long finalStamp) {
        List<Integer> modelResults = allResults.get(modelName);
        if (modelResults == null) {
            modelResults = new ArrayList<Integer>();
            allResults.put(modelName, modelResults);
        }
        modelResults.add((int)(finalStamp - initStamp));
    }

    private void processResults(String fileName, Map<String, List<Integer>> allResults) throws Exception {
        File file = new File(fileName);
        FileWriter fWriter = new FileWriter(file);
        fWriter.write("Model Name,Execution Time,Model Mean\n");
        for (String modelName : allResults.keySet()) {
            List<Integer> modelResults = allResults.get(modelName);
            if (modelResults == null) continue;
            modelResults.remove(0);
            for (Integer time : modelResults) {
                fWriter.write(String.valueOf(modelName) + "," + time.toString() + ",\n");
            }
        }
        fWriter.close();
    }

    private static float mean(List<Integer> list) {
        int result = 0;
        for (Integer value : list) {
            result += value.intValue();
        }
        return result / list.size();
    }

    protected void executeModelsTX_CG(MyQVT qvt, @NonNull java.lang.Class<? extends Transformer> txClass, URI baseURI, String modelName) throws Exception {
        TransformationExecutor evaluator = qvt.createEvaluator(txClass);
        Transformer tx = evaluator.getTransformer();
        URI samplesBaseUri = baseURI.appendSegment("samples");
        URI csModelURI = samplesBaseUri.appendSegment(String.format("%s_input.xmi", modelName));
        URI asModelURI = samplesBaseUri.appendSegment(String.format("%s_output_CG.xmi", modelName));
        ResourceSet rSet = qvt.getResourceSet();
        Resource inputResource = rSet.getResource(csModelURI, true);
        tx.addRootObjects("leftCS", (Iterable)ClassUtil.nonNullState((Object)inputResource.getContents()));
        boolean success = tx.run();
        Resource outputResource = rSet.createResource(asModelURI);
        outputResource.getContents().addAll(tx.getRootEObjects("rightAS"));
        outputResource.save(DefaultCompilerOptions.defaultSavingOptions);
        ExecutionBenchmarks.assertTrue((boolean)success);
    }

    protected void executeModelsTX_Interpreted(MyQVT qvt, @NonNull ImperativeTransformation tx, URI baseURI, String modelName) throws Exception {
        URI samplesBaseUri = baseURI.appendSegment("samples");
        URI csModelURI = samplesBaseUri.appendSegment(String.format("%s_input.xmi", modelName));
        URI asModelURI = samplesBaseUri.appendSegment(String.format("%s_output_Interpreted.xmi", modelName));
        BasicQVTiExecutor testEvaluator = qvt.createEvaluator(tx);
        testEvaluator.saveTransformation(null, null);
        testEvaluator.loadModel("leftCS", csModelURI);
        testEvaluator.createModel("rightAS", asModelURI, null);
        boolean success = testEvaluator.execute();
        testEvaluator.saveModels(DefaultCompilerOptions.defaultSavingOptions);
        testEvaluator.dispose();
        ExecutionBenchmarks.assertTrue((boolean)success);
    }

    protected void saveEmptyModel(URI modelURI) throws IOException {
        ResourceSetImpl rSet = new ResourceSetImpl();
        StandaloneProjectMap.getAdapter((ResourceSet)rSet);
        Resource r = rSet.createResource(modelURI);
        r.save(DefaultCompilerOptions.defaultSavingOptions);
    }

    protected ImperativeTransformation getTransformation(ResourceSet rSet, URI qvtiURI) {
        Resource resource = rSet.getResource(qvtiURI, true);
        for (EObject eObject : resource.getContents()) {
            if (!(eObject instanceof ImperativeModel)) continue;
            for (Package pPackage : ((ImperativeModel)eObject).getOwnedPackages()) {
                for (Class pClass : pPackage.getOwnedClasses()) {
                    if (!(pClass instanceof ImperativeTransformation)) continue;
                    return (ImperativeTransformation)pClass;
                }
            }
        }
        return null;
    }

    protected class MyQVT
    extends OCL {
        public MyQVT(QVTiEnvironmentFactory environmentFactory) {
            super((EnvironmentFactoryInternal)environmentFactory);
        }

        public @NonNull BasicQVTiExecutor createEvaluator(@NonNull ImperativeTransformation transformation) {
            return new QVTiIncrementalExecutor(this.getEnvironmentFactory(), transformation, QVTiIncrementalExecutor.Mode.LAZY);
        }

        public @NonNull TransformationExecutor createEvaluator(@NonNull java.lang.Class<? extends Transformer> txClass) throws ReflectiveOperationException {
            return new QVTiTransformationExecutor(this.getEnvironmentFactory(), txClass);
        }

        public @NonNull QVTiEnvironmentFactory getEnvironmentFactory() {
            return (QVTiEnvironmentFactory)super.getEnvironmentFactory();
        }
    }
}

